// third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_HANDLE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_HANDLE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_info.mojom-blink.h"
#include "mojo/public/mojom/base/file.mojom-blink.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-blink.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_access_handle_host.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_modification_host.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_cloud_identifier.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_permission_mode.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class FileSystemAccessFileHandleProxy;

template <typename ImplRefTraits>
class FileSystemAccessFileHandleStub;

class FileSystemAccessFileHandleRequestValidator;
class FileSystemAccessFileHandleResponseValidator;


class PLATFORM_EXPORT FileSystemAccessFileHandle
    : public FileSystemAccessFileHandleInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.FileSystemAccessFileHandle";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FileSystemAccessFileHandleInterfaceBase;
  using Proxy_ = FileSystemAccessFileHandleProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileSystemAccessFileHandleStub<ImplRefTraits>;

  using RequestValidator_ = FileSystemAccessFileHandleRequestValidator;
  using ResponseValidator_ = FileSystemAccessFileHandleResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetPermissionStatusMinVersion = 0,
    kRequestPermissionMinVersion = 0,
    kAsBlobMinVersion = 0,
    kCreateFileWriterMinVersion = 0,
    kRenameMinVersion = 0,
    kMoveMinVersion = 0,
    kRemoveMinVersion = 0,
    kOpenAccessHandleMinVersion = 0,
    kIsSameEntryMinVersion = 0,
    kTransferMinVersion = 0,
    kGetUniqueIdMinVersion = 0,
    kGetCloudIdentifiersMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetPermissionStatus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestPermission_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AsBlob_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateFileWriter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Rename_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Move_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Remove_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenAccessHandle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsSameEntry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Transfer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUniqueId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCloudIdentifiers_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FileSystemAccessFileHandle() = default;

  using GetPermissionStatusCallback = base::OnceCallback<void(::blink::mojom::blink::PermissionStatus)>;
  using GetPermissionStatusMojoCallback = base::OnceCallback<void(::blink::mojom::blink::PermissionStatus)>;

  virtual void GetPermissionStatus(::blink::mojom::blink::FileSystemAccessPermissionMode mode, GetPermissionStatusCallback callback) = 0;

  using RequestPermissionCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, ::blink::mojom::blink::PermissionStatus)>;
  using RequestPermissionMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, ::blink::mojom::blink::PermissionStatus)>;

  virtual void RequestPermission(::blink::mojom::blink::FileSystemAccessPermissionMode mode, RequestPermissionCallback callback) = 0;

  using AsBlobCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, const ::base::File::Info&, const ::scoped_refptr<::blink::BlobDataHandle>&)>;
  using AsBlobMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, const ::base::File::Info&, const ::scoped_refptr<::blink::BlobDataHandle>&)>;

  virtual void AsBlob(AsBlobCallback callback) = 0;

  using CreateFileWriterCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessFileWriter>)>;
  using CreateFileWriterMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessFileWriter>)>;

  virtual void CreateFileWriter(bool keep_existing_data, bool auto_close, FileSystemAccessWritableFileStreamLockMode mode, CreateFileWriterCallback callback) = 0;

  using RenameCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr)>;
  using RenameMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr)>;

  virtual void Rename(const ::blink::String& new_entry_name, RenameCallback callback) = 0;

  using MoveCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr)>;
  using MoveMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr)>;

  virtual void Move(::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> destination_directory, const ::blink::String& new_entry_name, MoveCallback callback) = 0;

  using RemoveCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr)>;
  using RemoveMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr)>;

  virtual void Remove(RemoveCallback callback) = 0;

  using OpenAccessHandleCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, FileSystemAccessAccessHandleFilePtr, ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessAccessHandleHost>)>;
  using OpenAccessHandleMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, FileSystemAccessAccessHandleFilePtr, ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessAccessHandleHost>)>;

  virtual void OpenAccessHandle(FileSystemAccessAccessHandleLockMode mode, OpenAccessHandleCallback callback) = 0;

  using IsSameEntryCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, bool)>;
  using IsSameEntryMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, bool)>;

  virtual void IsSameEntry(::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> other, IsSameEntryCallback callback) = 0;

  virtual void Transfer(::mojo::PendingReceiver<::blink::mojom::blink::FileSystemAccessTransferToken> token) = 0;

  using GetUniqueIdCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, const ::blink::String&)>;
  using GetUniqueIdMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, const ::blink::String&)>;

  virtual void GetUniqueId(GetUniqueIdCallback callback) = 0;

  using GetCloudIdentifiersCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, ::blink::Vector<::blink::mojom::blink::FileSystemAccessCloudIdentifierPtr>)>;
  using GetCloudIdentifiersMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, ::blink::Vector<::blink::mojom::blink::FileSystemAccessCloudIdentifierPtr>)>;

  virtual void GetCloudIdentifiers(GetCloudIdentifiersCallback callback) = 0;
};



class PLATFORM_EXPORT FileSystemAccessFileHandleProxy
    : public FileSystemAccessFileHandle {
 public:
  using InterfaceType = FileSystemAccessFileHandle;

  explicit FileSystemAccessFileHandleProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetPermissionStatus(::blink::mojom::blink::FileSystemAccessPermissionMode mode, GetPermissionStatusCallback callback) final;
  
  void RequestPermission(::blink::mojom::blink::FileSystemAccessPermissionMode mode, RequestPermissionCallback callback) final;
  
  void AsBlob(AsBlobCallback callback) final;
  
  void CreateFileWriter(bool keep_existing_data, bool auto_close, FileSystemAccessWritableFileStreamLockMode mode, CreateFileWriterCallback callback) final;
  
  void Rename(const ::blink::String& new_entry_name, RenameCallback callback) final;
  
  void Move(::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> destination_directory, const ::blink::String& new_entry_name, MoveCallback callback) final;
  
  void Remove(RemoveCallback callback) final;
  
  void OpenAccessHandle(FileSystemAccessAccessHandleLockMode mode, OpenAccessHandleCallback callback) final;
  
  void IsSameEntry(::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> other, IsSameEntryCallback callback) final;
  
  void Transfer(::mojo::PendingReceiver<::blink::mojom::blink::FileSystemAccessTransferToken> token) final;
  
  void GetUniqueId(GetUniqueIdCallback callback) final;
  
  void GetCloudIdentifiers(GetCloudIdentifiersCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT FileSystemAccessFileHandleStubDispatch {
 public:
  static bool Accept(FileSystemAccessFileHandle* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileSystemAccessFileHandle* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileSystemAccessFileHandle>>
class FileSystemAccessFileHandleStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileSystemAccessFileHandleStub() = default;
  ~FileSystemAccessFileHandleStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessFileHandleStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessFileHandleStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT FileSystemAccessFileHandleRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT FileSystemAccessFileHandleResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class PLATFORM_EXPORT FileSystemAccessAccessHandleFile {
 public:
  using DataView = FileSystemAccessAccessHandleFileDataView;
  using Data_ = internal::FileSystemAccessAccessHandleFile_Data;
  using Tag = Data_::FileSystemAccessAccessHandleFile_Tag;

  template <typename... Args>
  static FileSystemAccessAccessHandleFilePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |regular_file|.
  static FileSystemAccessAccessHandleFilePtr NewRegularFile(
      FileSystemAccessRegularFilePtr value);
  // Construct an instance holding |incognito_file_delegate|.
  static FileSystemAccessAccessHandleFilePtr NewIncognitoFileDelegate(
      ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessFileDelegateHost> value);

  template <typename U>
  static FileSystemAccessAccessHandleFilePtr From(const U& u) {
    return mojo::TypeConverter<FileSystemAccessAccessHandleFilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemAccessAccessHandleFile>::Convert(*this);
  }
  ~FileSystemAccessAccessHandleFile();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  FileSystemAccessAccessHandleFile(const FileSystemAccessAccessHandleFile& other) = delete;
  FileSystemAccessAccessHandleFile& operator=(const FileSystemAccessAccessHandleFile& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = FileSystemAccessAccessHandleFilePtr>
  FileSystemAccessAccessHandleFilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, FileSystemAccessAccessHandleFile>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, FileSystemAccessAccessHandleFile>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_regular_file() const { return tag_ == Tag::kRegularFile; }
  const FileSystemAccessRegularFilePtr& get_regular_file() const {
    CHECK(tag_ == Tag::kRegularFile);
    return data_.regular_file;
  }
  FileSystemAccessRegularFilePtr& get_regular_file() {
    CHECK(tag_ == Tag::kRegularFile);
    return data_.regular_file;
  }
  void set_regular_file(FileSystemAccessRegularFilePtr regular_file);

  bool is_incognito_file_delegate() const { return tag_ == Tag::kIncognitoFileDelegate; }
  const ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessFileDelegateHost>& get_incognito_file_delegate() const {
    CHECK(tag_ == Tag::kIncognitoFileDelegate);
    return data_.incognito_file_delegate;
  }
  ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessFileDelegateHost>& get_incognito_file_delegate() {
    CHECK(tag_ == Tag::kIncognitoFileDelegate);
    return data_.incognito_file_delegate;
  }
  void set_incognito_file_delegate(::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessFileDelegateHost> incognito_file_delegate);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemAccessAccessHandleFile::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<FileSystemAccessAccessHandleFile::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRegularFile)>,
        FileSystemAccessRegularFilePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kIncognitoFileDelegate)>,
        ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessFileDelegateHost> value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    FileSystemAccessRegularFilePtr regular_file;
    ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessFileDelegateHost> incognito_file_delegate;
  };

  FileSystemAccessAccessHandleFile(
      std::in_place_index_t<static_cast<size_t>(Tag::kRegularFile)>,
      FileSystemAccessRegularFilePtr value);
  FileSystemAccessAccessHandleFile(
      std::in_place_index_t<static_cast<size_t>(Tag::kIncognitoFileDelegate)>,
      ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessFileDelegateHost> value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class PLATFORM_EXPORT FileSystemAccessRegularFile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemAccessRegularFile, T>::value>;
  using DataView = FileSystemAccessRegularFileDataView;
  using Data_ = internal::FileSystemAccessRegularFile_Data;

  template <typename... Args>
  static FileSystemAccessRegularFilePtr New(Args&&... args) {
    return FileSystemAccessRegularFilePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemAccessRegularFilePtr From(const U& u) {
    return mojo::TypeConverter<FileSystemAccessRegularFilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemAccessRegularFile>::Convert(*this);
  }


  FileSystemAccessRegularFile();

  FileSystemAccessRegularFile(
      ::base::File os_file,
      int64_t file_size,
      ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessFileModificationHost> file_modification_host);

FileSystemAccessRegularFile(const FileSystemAccessRegularFile&) = delete;
FileSystemAccessRegularFile& operator=(const FileSystemAccessRegularFile&) = delete;

  ~FileSystemAccessRegularFile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemAccessRegularFilePtr>
  FileSystemAccessRegularFilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemAccessRegularFile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemAccessRegularFile::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemAccessRegularFile::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemAccessRegularFile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemAccessRegularFile_UnserializedMessageContext<
            UserType, FileSystemAccessRegularFile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemAccessRegularFile::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemAccessRegularFile::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemAccessRegularFile_UnserializedMessageContext<
            UserType, FileSystemAccessRegularFile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemAccessRegularFile::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::File os_file;
  
  int64_t file_size;
  
  ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessFileModificationHost> file_modification_host;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemAccessRegularFile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemAccessRegularFile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemAccessRegularFile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemAccessRegularFile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
FileSystemAccessAccessHandleFilePtr FileSystemAccessAccessHandleFile::Clone() const {
  switch (tag_) {
    case Tag::kRegularFile:
      return NewRegularFile(
          mojo::Clone(data_.regular_file));
    case Tag::kIncognitoFileDelegate:
      return NewIncognitoFileDelegate(
          mojo::Clone(data_.incognito_file_delegate));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, FileSystemAccessAccessHandleFile>::value>::type*>
bool FileSystemAccessAccessHandleFile::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kRegularFile:
      return mojo::Equals(data_.regular_file, other.data_.regular_file);
    case Tag::kIncognitoFileDelegate:
      return mojo::Equals(data_.incognito_file_delegate, other.data_.incognito_file_delegate);
  }

  return false;
}
template <typename StructPtrType>
FileSystemAccessRegularFilePtr FileSystemAccessRegularFile::Clone() const {
  return New(
      mojo::Clone(os_file),
      mojo::Clone(file_size),
      mojo::Clone(file_modification_host)
  );
}

template <typename T, FileSystemAccessRegularFile::EnableIfSame<T>*>
bool FileSystemAccessRegularFile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->os_file, other_struct.os_file))
    return false;
  if (!mojo::Equals(this->file_size, other_struct.file_size))
    return false;
  if (!mojo::Equals(this->file_modification_host, other_struct.file_modification_host))
    return false;
  return true;
}

template <typename T, FileSystemAccessRegularFile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.os_file < rhs.os_file)
    return true;
  if (rhs.os_file < lhs.os_file)
    return false;
  if (lhs.file_size < rhs.file_size)
    return true;
  if (rhs.file_size < lhs.file_size)
    return false;
  if (lhs.file_modification_host < rhs.file_modification_host)
    return true;
  if (rhs.file_modification_host < lhs.file_modification_host)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FileSystemAccessRegularFile::DataView,
                                         ::blink::mojom::blink::FileSystemAccessRegularFilePtr> {
  static bool IsNull(const ::blink::mojom::blink::FileSystemAccessRegularFilePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FileSystemAccessRegularFilePtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::FileSystemAccessRegularFile::os_file)& os_file(
       ::blink::mojom::blink::FileSystemAccessRegularFilePtr& input) {
    return input->os_file;
  }

  static decltype(::blink::mojom::blink::FileSystemAccessRegularFile::file_size) file_size(
      const ::blink::mojom::blink::FileSystemAccessRegularFilePtr& input) {
    return input->file_size;
  }

  static  decltype(::blink::mojom::blink::FileSystemAccessRegularFile::file_modification_host)& file_modification_host(
       ::blink::mojom::blink::FileSystemAccessRegularFilePtr& input) {
    return input->file_modification_host;
  }

  static bool Read(::blink::mojom::blink::FileSystemAccessRegularFile::DataView input, ::blink::mojom::blink::FileSystemAccessRegularFilePtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::FileSystemAccessAccessHandleFile::DataView,
                                        ::blink::mojom::blink::FileSystemAccessAccessHandleFilePtr> {
  static bool IsNull(const ::blink::mojom::blink::FileSystemAccessAccessHandleFilePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FileSystemAccessAccessHandleFilePtr* output) { output->reset(); }

  static ::blink::mojom::blink::FileSystemAccessAccessHandleFile::Tag GetTag(const ::blink::mojom::blink::FileSystemAccessAccessHandleFilePtr& input) {
    return input->which();
  }

  static  ::blink::mojom::blink::FileSystemAccessRegularFilePtr& regular_file( ::blink::mojom::blink::FileSystemAccessAccessHandleFilePtr& input) {
    return input->get_regular_file();
  }

  static  ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessFileDelegateHost>& incognito_file_delegate( ::blink::mojom::blink::FileSystemAccessAccessHandleFilePtr& input) {
    return input->get_incognito_file_delegate();
  }

  static bool Read(::blink::mojom::blink::FileSystemAccessAccessHandleFile::DataView input, ::blink::mojom::blink::FileSystemAccessAccessHandleFilePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_HANDLE_MOJOM_BLINK_H_