// third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var big_buffer$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/big_buffer.mojom', '../../../../../mojo/public/mojom/base/big_buffer.mojom.js');
  }
  var file_error$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_error.mojom', '../../../../../mojo/public/mojom/base/file_error.mojom.js');
  }



  function FileSystemAccessFileDelegateHost_Read_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileDelegateHost_Read_Params.prototype.initDefaults_ = function() {
    this.offset = 0;
    this.bytesToRead = 0;
  };
  FileSystemAccessFileDelegateHost_Read_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileDelegateHost_Read_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  FileSystemAccessFileDelegateHost_Read_Params.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessFileDelegateHost_Read_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileDelegateHost_Read_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.offset =
        decoder.decodeStruct(codec.Int64);
    val.bytesToRead =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessFileDelegateHost_Read_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileDelegateHost_Read_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.offset);
    encoder.encodeStruct(codec.Int32, val.bytesToRead);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessFileDelegateHost_Read_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileDelegateHost_Read_ResponseParams.prototype.initDefaults_ = function() {
    this.data = null;
    this.error = 0;
    this.bytesRead = 0;
  };
  FileSystemAccessFileDelegateHost_Read_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileDelegateHost_Read_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileDelegateHost_Read_ResponseParams.data
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, big_buffer$.BigBuffer, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileDelegateHost_Read_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, file_error$.FileError);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FileSystemAccessFileDelegateHost_Read_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  FileSystemAccessFileDelegateHost_Read_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileDelegateHost_Read_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStruct(big_buffer$.BigBuffer);
    val.error =
        decoder.decodeStruct(new codec.Enum(file_error$.FileError));
    val.bytesRead =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  FileSystemAccessFileDelegateHost_Read_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileDelegateHost_Read_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(big_buffer$.BigBuffer, val.data);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.encodeStruct(codec.Int32, val.bytesRead);
  };
  function FileSystemAccessFileDelegateHost_Write_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileDelegateHost_Write_Params.prototype.initDefaults_ = function() {
    this.offset = 0;
    this.data = null;
  };
  FileSystemAccessFileDelegateHost_Write_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileDelegateHost_Write_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate FileSystemAccessFileDelegateHost_Write_Params.data
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileDelegateHost_Write_Params.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessFileDelegateHost_Write_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileDelegateHost_Write_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.offset =
        decoder.decodeStruct(codec.Int64);
    val.data =
        decoder.decodeStruct(codec.Handle);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessFileDelegateHost_Write_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileDelegateHost_Write_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.offset);
    encoder.encodeStruct(codec.Handle, val.data);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessFileDelegateHost_Write_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileDelegateHost_Write_ResponseParams.prototype.initDefaults_ = function() {
    this.error = 0;
    this.bytesWritten = 0;
  };
  FileSystemAccessFileDelegateHost_Write_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileDelegateHost_Write_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileDelegateHost_Write_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, file_error$.FileError);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FileSystemAccessFileDelegateHost_Write_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileDelegateHost_Write_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileDelegateHost_Write_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(file_error$.FileError));
    val.bytesWritten =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  FileSystemAccessFileDelegateHost_Write_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileDelegateHost_Write_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.encodeStruct(codec.Int32, val.bytesWritten);
  };
  function FileSystemAccessFileDelegateHost_GetLength_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileDelegateHost_GetLength_Params.prototype.initDefaults_ = function() {
  };
  FileSystemAccessFileDelegateHost_GetLength_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileDelegateHost_GetLength_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileDelegateHost_GetLength_Params.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessFileDelegateHost_GetLength_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileDelegateHost_GetLength_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessFileDelegateHost_GetLength_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileDelegateHost_GetLength_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessFileDelegateHost_GetLength_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileDelegateHost_GetLength_ResponseParams.prototype.initDefaults_ = function() {
    this.error = 0;
    this.length = 0;
  };
  FileSystemAccessFileDelegateHost_GetLength_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileDelegateHost_GetLength_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileDelegateHost_GetLength_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, file_error$.FileError);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FileSystemAccessFileDelegateHost_GetLength_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessFileDelegateHost_GetLength_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileDelegateHost_GetLength_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(file_error$.FileError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.length =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  FileSystemAccessFileDelegateHost_GetLength_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileDelegateHost_GetLength_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.length);
  };
  function FileSystemAccessFileDelegateHost_SetLength_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileDelegateHost_SetLength_Params.prototype.initDefaults_ = function() {
    this.length = 0;
  };
  FileSystemAccessFileDelegateHost_SetLength_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileDelegateHost_SetLength_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FileSystemAccessFileDelegateHost_SetLength_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileDelegateHost_SetLength_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileDelegateHost_SetLength_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.length =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  FileSystemAccessFileDelegateHost_SetLength_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileDelegateHost_SetLength_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.length);
  };
  function FileSystemAccessFileDelegateHost_SetLength_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileDelegateHost_SetLength_ResponseParams.prototype.initDefaults_ = function() {
    this.error = 0;
  };
  FileSystemAccessFileDelegateHost_SetLength_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileDelegateHost_SetLength_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileDelegateHost_SetLength_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, file_error$.FileError);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileDelegateHost_SetLength_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileDelegateHost_SetLength_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileDelegateHost_SetLength_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(file_error$.FileError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessFileDelegateHost_SetLength_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileDelegateHost_SetLength_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kFileSystemAccessFileDelegateHost_Read_Name = 0;
  var kFileSystemAccessFileDelegateHost_Write_Name = 1;
  var kFileSystemAccessFileDelegateHost_GetLength_Name = 2;
  var kFileSystemAccessFileDelegateHost_SetLength_Name = 3;

  function FileSystemAccessFileDelegateHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FileSystemAccessFileDelegateHost,
                                                   handleOrPtrInfo);
  }

  function FileSystemAccessFileDelegateHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FileSystemAccessFileDelegateHost, associatedInterfacePtrInfo);
  }

  FileSystemAccessFileDelegateHostAssociatedPtr.prototype =
      Object.create(FileSystemAccessFileDelegateHostPtr.prototype);
  FileSystemAccessFileDelegateHostAssociatedPtr.prototype.constructor =
      FileSystemAccessFileDelegateHostAssociatedPtr;

  function FileSystemAccessFileDelegateHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  FileSystemAccessFileDelegateHostPtr.prototype.read = function() {
    return FileSystemAccessFileDelegateHostProxy.prototype.read
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileDelegateHostProxy.prototype.read = function(offset, bytesToRead) {
    var params_ = new FileSystemAccessFileDelegateHost_Read_Params();
    params_.offset = offset;
    params_.bytesToRead = bytesToRead;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileDelegateHost_Read_Name,
          codec.align(FileSystemAccessFileDelegateHost_Read_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileDelegateHost_Read_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileDelegateHost_Read_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileDelegateHostPtr.prototype.write = function() {
    return FileSystemAccessFileDelegateHostProxy.prototype.write
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileDelegateHostProxy.prototype.write = function(offset, data) {
    var params_ = new FileSystemAccessFileDelegateHost_Write_Params();
    params_.offset = offset;
    params_.data = data;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileDelegateHost_Write_Name,
          codec.align(FileSystemAccessFileDelegateHost_Write_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileDelegateHost_Write_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileDelegateHost_Write_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileDelegateHostPtr.prototype.getLength = function() {
    return FileSystemAccessFileDelegateHostProxy.prototype.getLength
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileDelegateHostProxy.prototype.getLength = function() {
    var params_ = new FileSystemAccessFileDelegateHost_GetLength_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileDelegateHost_GetLength_Name,
          codec.align(FileSystemAccessFileDelegateHost_GetLength_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileDelegateHost_GetLength_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileDelegateHost_GetLength_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileDelegateHostPtr.prototype.setLength = function() {
    return FileSystemAccessFileDelegateHostProxy.prototype.setLength
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileDelegateHostProxy.prototype.setLength = function(length) {
    var params_ = new FileSystemAccessFileDelegateHost_SetLength_Params();
    params_.length = length;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileDelegateHost_SetLength_Name,
          codec.align(FileSystemAccessFileDelegateHost_SetLength_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileDelegateHost_SetLength_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileDelegateHost_SetLength_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function FileSystemAccessFileDelegateHostStub(delegate) {
    this.delegate_ = delegate;
  }
  FileSystemAccessFileDelegateHostStub.prototype.read = function(offset, bytesToRead) {
    return this.delegate_ && this.delegate_.read && this.delegate_.read(offset, bytesToRead);
  }
  FileSystemAccessFileDelegateHostStub.prototype.write = function(offset, data) {
    return this.delegate_ && this.delegate_.write && this.delegate_.write(offset, data);
  }
  FileSystemAccessFileDelegateHostStub.prototype.getLength = function() {
    return this.delegate_ && this.delegate_.getLength && this.delegate_.getLength();
  }
  FileSystemAccessFileDelegateHostStub.prototype.setLength = function(length) {
    return this.delegate_ && this.delegate_.setLength && this.delegate_.setLength(length);
  }

  FileSystemAccessFileDelegateHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  FileSystemAccessFileDelegateHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessFileDelegateHost_Read_Name:
      var params = reader.decodeStruct(FileSystemAccessFileDelegateHost_Read_Params);
      this.read(params.offset, params.bytesToRead).then(function(response) {
        var responseParams =
            new FileSystemAccessFileDelegateHost_Read_ResponseParams();
        responseParams.data = response.data;
        responseParams.error = response.error;
        responseParams.bytesRead = response.bytesRead;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileDelegateHost_Read_Name,
            codec.align(FileSystemAccessFileDelegateHost_Read_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileDelegateHost_Read_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileDelegateHost_Write_Name:
      var params = reader.decodeStruct(FileSystemAccessFileDelegateHost_Write_Params);
      this.write(params.offset, params.data).then(function(response) {
        var responseParams =
            new FileSystemAccessFileDelegateHost_Write_ResponseParams();
        responseParams.error = response.error;
        responseParams.bytesWritten = response.bytesWritten;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileDelegateHost_Write_Name,
            codec.align(FileSystemAccessFileDelegateHost_Write_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileDelegateHost_Write_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileDelegateHost_GetLength_Name:
      var params = reader.decodeStruct(FileSystemAccessFileDelegateHost_GetLength_Params);
      this.getLength().then(function(response) {
        var responseParams =
            new FileSystemAccessFileDelegateHost_GetLength_ResponseParams();
        responseParams.error = response.error;
        responseParams.length = response.length;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileDelegateHost_GetLength_Name,
            codec.align(FileSystemAccessFileDelegateHost_GetLength_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileDelegateHost_GetLength_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileDelegateHost_SetLength_Name:
      var params = reader.decodeStruct(FileSystemAccessFileDelegateHost_SetLength_Params);
      this.setLength(params.length).then(function(response) {
        var responseParams =
            new FileSystemAccessFileDelegateHost_SetLength_ResponseParams();
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileDelegateHost_SetLength_Name,
            codec.align(FileSystemAccessFileDelegateHost_SetLength_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileDelegateHost_SetLength_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateFileSystemAccessFileDelegateHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFileSystemAccessFileDelegateHost_Read_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileDelegateHost_Read_Params;
      break;
      case kFileSystemAccessFileDelegateHost_Write_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileDelegateHost_Write_Params;
      break;
      case kFileSystemAccessFileDelegateHost_GetLength_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileDelegateHost_GetLength_Params;
      break;
      case kFileSystemAccessFileDelegateHost_SetLength_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileDelegateHost_SetLength_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFileSystemAccessFileDelegateHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kFileSystemAccessFileDelegateHost_Read_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileDelegateHost_Read_ResponseParams;
        break;
      case kFileSystemAccessFileDelegateHost_Write_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileDelegateHost_Write_ResponseParams;
        break;
      case kFileSystemAccessFileDelegateHost_GetLength_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileDelegateHost_GetLength_ResponseParams;
        break;
      case kFileSystemAccessFileDelegateHost_SetLength_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileDelegateHost_SetLength_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var FileSystemAccessFileDelegateHost = {
    name: 'blink.mojom.FileSystemAccessFileDelegateHost',
    kVersion: 0,
    ptrClass: FileSystemAccessFileDelegateHostPtr,
    proxyClass: FileSystemAccessFileDelegateHostProxy,
    stubClass: FileSystemAccessFileDelegateHostStub,
    validateRequest: validateFileSystemAccessFileDelegateHostRequest,
    validateResponse: validateFileSystemAccessFileDelegateHostResponse,
  };
  FileSystemAccessFileDelegateHostStub.prototype.validator = validateFileSystemAccessFileDelegateHostRequest;
  FileSystemAccessFileDelegateHostProxy.prototype.validator = validateFileSystemAccessFileDelegateHostResponse;
  exports.FileSystemAccessFileDelegateHost = FileSystemAccessFileDelegateHost;
  exports.FileSystemAccessFileDelegateHostPtr = FileSystemAccessFileDelegateHostPtr;
  exports.FileSystemAccessFileDelegateHostAssociatedPtr = FileSystemAccessFileDelegateHostAssociatedPtr;
})();