// third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var file_error$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_error.mojom', '../../../../../mojo/public/mojom/base/file_error.mojom.js');
  }


  var FileSystemAccessStatus = {};
  FileSystemAccessStatus.kOk = 0;
  FileSystemAccessStatus.kPermissionDenied = 1;
  FileSystemAccessStatus.kSecurityError = 2;
  FileSystemAccessStatus.kNoModificationAllowedError = 3;
  FileSystemAccessStatus.kInvalidModificationError = 4;
  FileSystemAccessStatus.kNotSupportedError = 5;
  FileSystemAccessStatus.kInvalidState = 6;
  FileSystemAccessStatus.kInvalidArgument = 7;
  FileSystemAccessStatus.kOperationFailed = 8;
  FileSystemAccessStatus.kOperationAborted = 9;
  FileSystemAccessStatus.kFileError = 10;
  FileSystemAccessStatus.MIN_VALUE = 0;
  FileSystemAccessStatus.MAX_VALUE = 10;

  FileSystemAccessStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
      return true;
    }
    return false;
  };

  FileSystemAccessStatus.toKnownEnumValue = function(value) {
    return value;
  };

  FileSystemAccessStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function FileSystemAccessError(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessError.prototype.initDefaults_ = function() {
    this.status = 0;
    this.fileError = 0;
    this.message = null;
  };
  FileSystemAccessError.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessError.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessError.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, FileSystemAccessStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessError.fileError
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, file_error$.FileError);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessError.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessError.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessError.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessError();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(FileSystemAccessStatus));
    val.fileError =
        decoder.decodeStruct(new codec.Enum(file_error$.FileError));
    val.message =
        decoder.decodeStruct(codec.String);
    return val;
  };

  FileSystemAccessError.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessError.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.encodeStruct(codec.Int32, val.fileError);
    encoder.encodeStruct(codec.String, val.message);
  };
  exports.FileSystemAccessStatus = FileSystemAccessStatus;
  exports.FileSystemAccessError = FileSystemAccessError;
})();