// third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_ERROR_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_ERROR_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_error.mojom-shared.h"


namespace blink::mojom {
class FileSystemAccessErrorDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FileSystemAccessErrorDataView> {
  using Data = ::blink::mojom::internal::FileSystemAccessError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class FileSystemAccessStatus : int32_t {
  
  kOk = 0,
  
  kPermissionDenied = 1,
  
  kSecurityError = 2,
  
  kNoModificationAllowedError = 3,
  
  kInvalidModificationError = 4,
  
  kNotSupportedError = 5,
  
  kInvalidState = 6,
  
  kInvalidArgument = 7,
  
  kOperationFailed = 8,
  
  kOperationAborted = 9,
  
  kFileError = 10,
  kMinValue = 0,
  kMaxValue = 10,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FileSystemAccessStatus value);
inline bool IsKnownEnumValue(FileSystemAccessStatus value) {
  return internal::FileSystemAccessStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FileSystemAccessErrorDataView {
 public:
  FileSystemAccessErrorDataView() = default;

  FileSystemAccessErrorDataView(
      internal::FileSystemAccessError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::blink::mojom::FileSystemAccessStatus>(
        data_value, output);
  }
  FileSystemAccessStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FileSystemAccessStatus>(data_->status));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFileError(UserType* output) const {
    auto data_value = data_->file_error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError file_error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->file_error));
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileSystemAccessError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_ERROR_MOJOM_DATA_VIEW_H_