// third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  PermissionStatus as blink_mojom_PermissionStatus,
  PermissionStatusSpec as blink_mojom_PermissionStatusSpec
} from '../permissions/permission_status.mojom.m.js';

import {
  FileSystemAccessCloudIdentifier as blink_mojom_FileSystemAccessCloudIdentifier,
  FileSystemAccessCloudIdentifierSpec as blink_mojom_FileSystemAccessCloudIdentifierSpec
} from './file_system_access_cloud_identifier.mojom.m.js';

import {
  FileSystemAccessError as blink_mojom_FileSystemAccessError,
  FileSystemAccessErrorSpec as blink_mojom_FileSystemAccessErrorSpec
} from './file_system_access_error.mojom.m.js';

import {
  FileSystemAccessFileHandleRemote as blink_mojom_FileSystemAccessFileHandleRemote,
  FileSystemAccessFileHandlePendingReceiver as blink_mojom_FileSystemAccessFileHandlePendingReceiver
} from './file_system_access_file_handle.mojom.m.js';

import {
  FileSystemAccessPermissionMode as blink_mojom_FileSystemAccessPermissionMode,
  FileSystemAccessPermissionModeSpec as blink_mojom_FileSystemAccessPermissionModeSpec
} from './file_system_access_permission_mode.mojom.m.js';

import {
  FileSystemAccessTransferTokenRemote as blink_mojom_FileSystemAccessTransferTokenRemote,
  FileSystemAccessTransferTokenPendingReceiver as blink_mojom_FileSystemAccessTransferTokenPendingReceiver
} from './file_system_access_transfer_token.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileSystemAccessDirectoryEntriesListenerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FileSystemAccessDirectoryEntriesListener', scope);
  }
}

/** @interface */
export class FileSystemAccessDirectoryEntriesListenerInterface {
  
  /**
   * @param { !blink_mojom_FileSystemAccessError } result
   * @param { !Array<!FileSystemAccessEntry> } entries
   * @param { !boolean } hasMoreEntries
   */

  didReadDirectory(result, entries, hasMoreEntries) {}
}

/**
 * @implements { FileSystemAccessDirectoryEntriesListenerInterface }
 */
export class FileSystemAccessDirectoryEntriesListenerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileSystemAccessDirectoryEntriesListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileSystemAccessDirectoryEntriesListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileSystemAccessDirectoryEntriesListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessError } result
   * @param { !Array<!FileSystemAccessEntry> } entries
   * @param { !boolean } hasMoreEntries
   */

  didReadDirectory(
      result,
      entries,
      hasMoreEntries) {
    this.proxy.sendMessage(
        0,
        FileSystemAccessDirectoryEntriesListener_DidReadDirectory_ParamsSpec.$,
        null,
        [
          result,
          entries,
          hasMoreEntries
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileSystemAccessDirectoryEntriesListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileSystemAccessDirectoryEntriesListenerReceiver {
  /**
   * @param {!FileSystemAccessDirectoryEntriesListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileSystemAccessDirectoryEntriesListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileSystemAccessDirectoryEntriesListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessDirectoryEntriesListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessDirectoryEntriesListener_DidReadDirectory_ParamsSpec.$,
        null,
        impl.didReadDirectory.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileSystemAccessDirectoryEntriesListener {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessDirectoryEntriesListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileSystemAccessDirectoryEntriesListenerRemote}
   */
  static getRemote() {
    let remote = new FileSystemAccessDirectoryEntriesListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileSystemAccessDirectoryEntriesListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileSystemAccessDirectoryEntriesListenerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileSystemAccessDirectoryEntriesListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessDirectoryEntriesListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didReadDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessDirectoryEntriesListener_DidReadDirectory_ParamsSpec.$,
        null,
        this.didReadDirectory.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileSystemAccessDirectoryHandlePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FileSystemAccessDirectoryHandle', scope);
  }
}

/** @interface */
export class FileSystemAccessDirectoryHandleInterface {
  
  /**
   * @param { !blink_mojom_FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  getPermissionStatus(mode) {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  requestPermission(mode) {}
  
  /**
   * @param { !string } basename
   * @param { !boolean } create
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        file: ?blink_mojom_FileSystemAccessFileHandleRemote,
   *  }>}
   */

  getFile(basename, create) {}
  
  /**
   * @param { !string } basename
   * @param { !boolean } create
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        directory: ?FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getDirectory(basename, create) {}
  
  /**
   * @param { !FileSystemAccessDirectoryEntriesListenerRemote } listener
   */

  getEntries(listener) {}
  
  /**
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  rename(newEntryName) {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } destinationDirectory
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  move(destinationDirectory, newEntryName) {}
  
  /**
   * @param { !boolean } recurse
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  remove(recurse) {}
  
  /**
   * @param { !string } basename
   * @param { !boolean } recurse
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  removeEntry(basename, recurse) {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } possibleChild
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        path: ?Array<!string>,
   *  }>}
   */

  resolve(possibleChild) {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenPendingReceiver } token
   */

  transfer(token) {}
  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        id: !string,
   *  }>}
   */

  getUniqueId() {}
  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        cloudIdentifiers: !Array<!blink_mojom_FileSystemAccessCloudIdentifier>,
   *  }>}
   */

  getCloudIdentifiers() {}
}

/**
 * @implements { FileSystemAccessDirectoryHandleInterface }
 */
export class FileSystemAccessDirectoryHandleRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileSystemAccessDirectoryHandlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileSystemAccessDirectoryHandlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileSystemAccessDirectoryHandlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  getPermissionStatus(
      mode) {
    return this.proxy.sendMessage(
        0,
        FileSystemAccessDirectoryHandle_GetPermissionStatus_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParamsSpec.$,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  requestPermission(
      mode) {
    return this.proxy.sendMessage(
        1,
        FileSystemAccessDirectoryHandle_RequestPermission_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_RequestPermission_ResponseParamsSpec.$,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !string } basename
   * @param { !boolean } create
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        file: ?blink_mojom_FileSystemAccessFileHandleRemote,
   *  }>}
   */

  getFile(
      basename,
      create) {
    return this.proxy.sendMessage(
        2,
        FileSystemAccessDirectoryHandle_GetFile_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_GetFile_ResponseParamsSpec.$,
        [
          basename,
          create
        ],
        false);
  }

  
  /**
   * @param { !string } basename
   * @param { !boolean } create
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        directory: ?FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getDirectory(
      basename,
      create) {
    return this.proxy.sendMessage(
        3,
        FileSystemAccessDirectoryHandle_GetDirectory_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_GetDirectory_ResponseParamsSpec.$,
        [
          basename,
          create
        ],
        false);
  }

  
  /**
   * @param { !FileSystemAccessDirectoryEntriesListenerRemote } listener
   */

  getEntries(
      listener) {
    this.proxy.sendMessage(
        4,
        FileSystemAccessDirectoryHandle_GetEntries_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }

  
  /**
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  rename(
      newEntryName) {
    return this.proxy.sendMessage(
        5,
        FileSystemAccessDirectoryHandle_Rename_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_Rename_ResponseParamsSpec.$,
        [
          newEntryName
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } destinationDirectory
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  move(
      destinationDirectory,
      newEntryName) {
    return this.proxy.sendMessage(
        6,
        FileSystemAccessDirectoryHandle_Move_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_Move_ResponseParamsSpec.$,
        [
          destinationDirectory,
          newEntryName
        ],
        false);
  }

  
  /**
   * @param { !boolean } recurse
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  remove(
      recurse) {
    return this.proxy.sendMessage(
        7,
        FileSystemAccessDirectoryHandle_Remove_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_Remove_ResponseParamsSpec.$,
        [
          recurse
        ],
        false);
  }

  
  /**
   * @param { !string } basename
   * @param { !boolean } recurse
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  removeEntry(
      basename,
      recurse) {
    return this.proxy.sendMessage(
        8,
        FileSystemAccessDirectoryHandle_RemoveEntry_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParamsSpec.$,
        [
          basename,
          recurse
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } possibleChild
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        path: ?Array<!string>,
   *  }>}
   */

  resolve(
      possibleChild) {
    return this.proxy.sendMessage(
        9,
        FileSystemAccessDirectoryHandle_Resolve_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_Resolve_ResponseParamsSpec.$,
        [
          possibleChild
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenPendingReceiver } token
   */

  transfer(
      token) {
    this.proxy.sendMessage(
        10,
        FileSystemAccessDirectoryHandle_Transfer_ParamsSpec.$,
        null,
        [
          token
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        id: !string,
   *  }>}
   */

  getUniqueId() {
    return this.proxy.sendMessage(
        11,
        FileSystemAccessDirectoryHandle_GetUniqueId_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        cloudIdentifiers: !Array<!blink_mojom_FileSystemAccessCloudIdentifier>,
   *  }>}
   */

  getCloudIdentifiers() {
    return this.proxy.sendMessage(
        12,
        FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileSystemAccessDirectoryHandle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileSystemAccessDirectoryHandleReceiver {
  /**
   * @param {!FileSystemAccessDirectoryHandleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileSystemAccessDirectoryHandleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileSystemAccessDirectoryHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessDirectoryHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessDirectoryHandle_GetPermissionStatus_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParamsSpec.$,
        impl.getPermissionStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FileSystemAccessDirectoryHandle_RequestPermission_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_RequestPermission_ResponseParamsSpec.$,
        impl.requestPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        FileSystemAccessDirectoryHandle_GetFile_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_GetFile_ResponseParamsSpec.$,
        impl.getFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        FileSystemAccessDirectoryHandle_GetDirectory_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_GetDirectory_ResponseParamsSpec.$,
        impl.getDirectory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        FileSystemAccessDirectoryHandle_GetEntries_ParamsSpec.$,
        null,
        impl.getEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        FileSystemAccessDirectoryHandle_Rename_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_Rename_ResponseParamsSpec.$,
        impl.rename.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        FileSystemAccessDirectoryHandle_Move_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_Move_ResponseParamsSpec.$,
        impl.move.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        FileSystemAccessDirectoryHandle_Remove_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_Remove_ResponseParamsSpec.$,
        impl.remove.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        FileSystemAccessDirectoryHandle_RemoveEntry_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParamsSpec.$,
        impl.removeEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        FileSystemAccessDirectoryHandle_Resolve_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_Resolve_ResponseParamsSpec.$,
        impl.resolve.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        FileSystemAccessDirectoryHandle_Transfer_ParamsSpec.$,
        null,
        impl.transfer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        FileSystemAccessDirectoryHandle_GetUniqueId_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParamsSpec.$,
        impl.getUniqueId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
        impl.getCloudIdentifiers.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileSystemAccessDirectoryHandle {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessDirectoryHandle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileSystemAccessDirectoryHandleRemote}
   */
  static getRemote() {
    let remote = new FileSystemAccessDirectoryHandleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileSystemAccessDirectoryHandle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileSystemAccessDirectoryHandleCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileSystemAccessDirectoryHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessDirectoryHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPermissionStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessDirectoryHandle_GetPermissionStatus_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParamsSpec.$,
        this.getPermissionStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FileSystemAccessDirectoryHandle_RequestPermission_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_RequestPermission_ResponseParamsSpec.$,
        this.requestPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        FileSystemAccessDirectoryHandle_GetFile_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_GetFile_ResponseParamsSpec.$,
        this.getFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        FileSystemAccessDirectoryHandle_GetDirectory_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_GetDirectory_ResponseParamsSpec.$,
        this.getDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        FileSystemAccessDirectoryHandle_GetEntries_ParamsSpec.$,
        null,
        this.getEntries.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rename =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        FileSystemAccessDirectoryHandle_Rename_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_Rename_ResponseParamsSpec.$,
        this.rename.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.move =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        FileSystemAccessDirectoryHandle_Move_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_Move_ResponseParamsSpec.$,
        this.move.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.remove =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        FileSystemAccessDirectoryHandle_Remove_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_Remove_ResponseParamsSpec.$,
        this.remove.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        FileSystemAccessDirectoryHandle_RemoveEntry_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParamsSpec.$,
        this.removeEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolve =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        FileSystemAccessDirectoryHandle_Resolve_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_Resolve_ResponseParamsSpec.$,
        this.resolve.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.transfer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        FileSystemAccessDirectoryHandle_Transfer_ParamsSpec.$,
        null,
        this.transfer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUniqueId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        FileSystemAccessDirectoryHandle_GetUniqueId_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParamsSpec.$,
        this.getUniqueId.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCloudIdentifiers =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ParamsSpec.$,
        FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
        this.getCloudIdentifiers.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessEntrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryEntriesListener_DidReadDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_GetPermissionStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_RequestPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_RequestPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_GetFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_GetFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_GetDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_GetDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_GetEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_Rename_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_Rename_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_Move_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_Move_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_Remove_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_Remove_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_RemoveEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_Resolve_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_Resolve_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_Transfer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_GetUniqueId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const FileSystemAccessHandleSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FileSystemAccessEntrySpec.$,
    'FileSystemAccessEntry',
    [
      mojo.internal.StructField(
        'entryHandle', 0,
        0,
        FileSystemAccessHandleSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FileSystemAccessEntry {
  constructor() {
    /** @type { !FileSystemAccessHandle } */
    this.entryHandle;
    /** @type { !string } */
    this.name;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryEntriesListener_DidReadDirectory_ParamsSpec.$,
    'FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'entries', 8,
        0,
        mojo.internal.Array(FileSystemAccessEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasMoreEntries', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { !Array<!FileSystemAccessEntry> } */
    this.entries;
    /** @type { !boolean } */
    this.hasMoreEntries;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_GetPermissionStatus_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetPermissionStatus_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        blink_mojom_FileSystemAccessPermissionModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_GetPermissionStatus_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessPermissionMode } */
    this.mode;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_PermissionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_PermissionStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_RequestPermission_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_RequestPermission_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        blink_mojom_FileSystemAccessPermissionModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_RequestPermission_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessPermissionMode } */
    this.mode;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_RequestPermission_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        blink_mojom_PermissionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { !blink_mojom_PermissionStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_GetFile_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetFile_Params',
    [
      mojo.internal.StructField(
        'basename', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'create', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_GetFile_Params {
  constructor() {
    /** @type { !string } */
    this.basename;
    /** @type { !boolean } */
    this.create;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_GetFile_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetFile_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'file', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessFileHandleRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_GetFile_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { (blink_mojom_FileSystemAccessFileHandleRemote|undefined) } */
    this.file;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_GetDirectory_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetDirectory_Params',
    [
      mojo.internal.StructField(
        'basename', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'create', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_GetDirectory_Params {
  constructor() {
    /** @type { !string } */
    this.basename;
    /** @type { !boolean } */
    this.create;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_GetDirectory_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'directory', 8,
        0,
        mojo.internal.InterfaceProxy(FileSystemAccessDirectoryHandleRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { (FileSystemAccessDirectoryHandleRemote|undefined) } */
    this.directory;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_GetEntries_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetEntries_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceProxy(FileSystemAccessDirectoryEntriesListenerRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_GetEntries_Params {
  constructor() {
    /** @type { !FileSystemAccessDirectoryEntriesListenerRemote } */
    this.listener;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_Rename_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Rename_Params',
    [
      mojo.internal.StructField(
        'newEntryName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_Rename_Params {
  constructor() {
    /** @type { !string } */
    this.newEntryName;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_Rename_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Rename_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_Rename_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_Move_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Move_Params',
    [
      mojo.internal.StructField(
        'destinationDirectory', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessTransferTokenRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newEntryName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_Move_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessTransferTokenRemote } */
    this.destinationDirectory;
    /** @type { !string } */
    this.newEntryName;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_Move_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Move_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_Move_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_Remove_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Remove_Params',
    [
      mojo.internal.StructField(
        'recurse', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_Remove_Params {
  constructor() {
    /** @type { !boolean } */
    this.recurse;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_Remove_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Remove_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_Remove_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_RemoveEntry_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_RemoveEntry_Params',
    [
      mojo.internal.StructField(
        'basename', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'recurse', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_RemoveEntry_Params {
  constructor() {
    /** @type { !string } */
    this.basename;
    /** @type { !boolean } */
    this.recurse;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_Resolve_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Resolve_Params',
    [
      mojo.internal.StructField(
        'possibleChild', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessTransferTokenRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_Resolve_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessTransferTokenRemote } */
    this.possibleChild;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_Resolve_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Resolve_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'path', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_Resolve_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { (Array<!string>|undefined) } */
    this.path;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_Transfer_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Transfer_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_FileSystemAccessTransferTokenPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_Transfer_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessTransferTokenPendingReceiver } */
    this.token;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_GetUniqueId_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetUniqueId_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_GetUniqueId_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { !string } */
    this.id;
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cloudIdentifiers', 8,
        0,
        mojo.internal.Array(blink_mojom_FileSystemAccessCloudIdentifierSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { !Array<!blink_mojom_FileSystemAccessCloudIdentifier> } */
    this.cloudIdentifiers;
  }
}

mojo.internal.Union(
    FileSystemAccessHandleSpec.$, 'FileSystemAccessHandle',
    {
      'file': {
        'ordinal': 0,
        'type': mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessFileHandleRemote),
      },
      'directory': {
        'ordinal': 1,
        'type': mojo.internal.InterfaceProxy(FileSystemAccessDirectoryHandleRemote),
      },
    });

/**
 * @typedef { {
 *   file: (!blink_mojom_FileSystemAccessFileHandleRemote|undefined),
 *   directory: (!FileSystemAccessDirectoryHandleRemote|undefined),
 * } }
 */
export const FileSystemAccessHandle = {};
