// third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-import-headers.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-test-utils.h"


namespace blink::mojom {
FileSystemAccessEntry::FileSystemAccessEntry()
    : entry_handle(),
      name() {}

FileSystemAccessEntry::FileSystemAccessEntry(
    FileSystemAccessHandlePtr entry_handle_in,
    const std::string& name_in)
    : entry_handle(std::move(entry_handle_in)),
      name(std::move(name_in)) {}

FileSystemAccessEntry::~FileSystemAccessEntry() = default;

void FileSystemAccessEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "entry_handle"), this->entry_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FileSystemAccessHandlePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileSystemAccessEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileSystemAccessHandlePtr
FileSystemAccessHandle::NewFile(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> value) {
  return FileSystemAccessHandlePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFile)>,
      std::move(value));
}

FileSystemAccessHandlePtr
FileSystemAccessHandle::NewDirectory(
    ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> value) {
  return FileSystemAccessHandlePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDirectory)>,
      std::move(value));
}

FileSystemAccessHandle::FileSystemAccessHandle(
    std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> value)
    : tag_(Tag::kFile),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFile)>,
            std::move(value)) {}

FileSystemAccessHandle::FileSystemAccessHandle(
    std::in_place_index_t<static_cast<size_t>(Tag::kDirectory)>,
    ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> value)
    : tag_(Tag::kDirectory),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDirectory)>,
            std::move(value)) {}
FileSystemAccessHandle::~FileSystemAccessHandle() {
  DestroyActive();
}

void FileSystemAccessHandle::set_file(::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> file) {
  if (tag_ == Tag::kFile) {
    data_.file = std::move(file);
  } else {
    DestroyActive();
    tag_ = Tag::kFile;
    new (&data_.file) ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>(
        std::move(file));
  }
}

void FileSystemAccessHandle::set_directory(::mojo::PendingRemote<FileSystemAccessDirectoryHandle> directory) {
  if (tag_ == Tag::kDirectory) {
    data_.directory = std::move(directory);
  } else {
    DestroyActive();
    tag_ = Tag::kDirectory;
    new (&data_.directory) ::mojo::PendingRemote<FileSystemAccessDirectoryHandle>(
        std::move(directory));
  }
}


FileSystemAccessHandle::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> value)
    : file(std::move(value)) {}

FileSystemAccessHandle::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDirectory)>,
    ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> value)
    : directory(std::move(value)) {}

void FileSystemAccessHandle::DestroyActive() {
  switch (tag_) {

    case Tag::kFile:
      std::destroy_at(&data_.file);
      break;
    case Tag::kDirectory:
      std::destroy_at(&data_.directory);
      break;
  }
}

bool FileSystemAccessHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

FileSystemAccessDirectoryEntriesListener::IPCStableHashFunction FileSystemAccessDirectoryEntriesListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileSystemAccessDirectoryEntriesListener>(message.name())) {
    case messages::FileSystemAccessDirectoryEntriesListener::kDidReadDirectory: {
      return &FileSystemAccessDirectoryEntriesListener::DidReadDirectory_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileSystemAccessDirectoryEntriesListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileSystemAccessDirectoryEntriesListener>(message.name())) {
      case messages::FileSystemAccessDirectoryEntriesListener::kDidReadDirectory:
            return "Receive blink::mojom::FileSystemAccessDirectoryEntriesListener::DidReadDirectory";
    }
  } else {
    switch (static_cast<messages::FileSystemAccessDirectoryEntriesListener>(message.name())) {
      case messages::FileSystemAccessDirectoryEntriesListener::kDidReadDirectory:
            return "Receive reply blink::mojom::FileSystemAccessDirectoryEntriesListener::DidReadDirectory";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileSystemAccessDirectoryEntriesListener::DidReadDirectory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa5d655e5;  // IPCStableHash for blink::mojom::FileSystemAccessDirectoryEntriesListener::DidReadDirectory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FileSystemAccessDirectoryEntriesListenerProxy::FileSystemAccessDirectoryEntriesListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessDirectoryEntriesListenerProxy::DidReadDirectory(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, std::vector<FileSystemAccessEntryPtr> in_entries, bool in_has_more_entries) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessDirectoryEntriesListener::DidReadDirectory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries,
                        "<value of type std::vector<FileSystemAccessEntryPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_more_entries"), in_has_more_entries,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryEntriesListener::kDidReadDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in FileSystemAccessDirectoryEntriesListener.DidReadDirectory request");
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType>
      entries_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FileSystemAccessEntryDataView>>(
    in_entries,
    entries_fragment,
    &entries_validate_params);

  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entries.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entries in FileSystemAccessDirectoryEntriesListener.DidReadDirectory request");

  params->has_more_entries = in_has_more_entries;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryEntriesListener::Name_);
  message.set_method_name("DidReadDirectory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FileSystemAccessDirectoryEntriesListenerStubDispatch::Accept(
    FileSystemAccessDirectoryEntriesListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileSystemAccessDirectoryEntriesListener>(message->header()->name)) {
    case messages::FileSystemAccessDirectoryEntriesListener::kDidReadDirectory: {
      DCHECK(message->is_serialized());
      internal::FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemAccessDirectoryEntriesListener.0
      bool success = true;
      ::blink::mojom::FileSystemAccessErrorPtr p_result{};
      std::vector<FileSystemAccessEntryPtr> p_entries{};
      bool p_has_more_entries{};
      FileSystemAccessDirectoryEntriesListener_DidReadDirectory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (success && !input_data_view.ReadEntries(&p_entries))
        success = false;
      if (success)
        p_has_more_entries = input_data_view.has_more_entries();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryEntriesListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidReadDirectory(        
        std::move(p_result), 
        std::move(p_entries), 
        std::move(p_has_more_entries));
      return true;
    }
  }
  return false;
}

// static
bool FileSystemAccessDirectoryEntriesListenerStubDispatch::AcceptWithResponder(
    FileSystemAccessDirectoryEntriesListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileSystemAccessDirectoryEntriesListener>(message->header()->name)) {
    case messages::FileSystemAccessDirectoryEntriesListener::kDidReadDirectory: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileSystemAccessDirectoryEntriesListenerValidationInfo[] = {
    { &internal::FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params_Data::Validate,
     nullptr /* no response */},
};

bool FileSystemAccessDirectoryEntriesListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::FileSystemAccessDirectoryEntriesListener::Name_,
    kFileSystemAccessDirectoryEntriesListenerValidationInfo);
}

// The declaration includes the definition on other builds.

FileSystemAccessDirectoryHandle::IPCStableHashFunction FileSystemAccessDirectoryHandle::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileSystemAccessDirectoryHandle>(message.name())) {
    case messages::FileSystemAccessDirectoryHandle::kGetPermissionStatus: {
      return &FileSystemAccessDirectoryHandle::GetPermissionStatus_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessDirectoryHandle::kRequestPermission: {
      return &FileSystemAccessDirectoryHandle::RequestPermission_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessDirectoryHandle::kGetFile: {
      return &FileSystemAccessDirectoryHandle::GetFile_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessDirectoryHandle::kGetDirectory: {
      return &FileSystemAccessDirectoryHandle::GetDirectory_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessDirectoryHandle::kGetEntries: {
      return &FileSystemAccessDirectoryHandle::GetEntries_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessDirectoryHandle::kRename: {
      return &FileSystemAccessDirectoryHandle::Rename_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessDirectoryHandle::kMove: {
      return &FileSystemAccessDirectoryHandle::Move_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessDirectoryHandle::kRemove: {
      return &FileSystemAccessDirectoryHandle::Remove_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessDirectoryHandle::kRemoveEntry: {
      return &FileSystemAccessDirectoryHandle::RemoveEntry_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessDirectoryHandle::kResolve: {
      return &FileSystemAccessDirectoryHandle::Resolve_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessDirectoryHandle::kTransfer: {
      return &FileSystemAccessDirectoryHandle::Transfer_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessDirectoryHandle::kGetUniqueId: {
      return &FileSystemAccessDirectoryHandle::GetUniqueId_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessDirectoryHandle::kGetCloudIdentifiers: {
      return &FileSystemAccessDirectoryHandle::GetCloudIdentifiers_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileSystemAccessDirectoryHandle::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileSystemAccessDirectoryHandle>(message.name())) {
      case messages::FileSystemAccessDirectoryHandle::kGetPermissionStatus:
            return "Receive blink::mojom::FileSystemAccessDirectoryHandle::GetPermissionStatus";
      case messages::FileSystemAccessDirectoryHandle::kRequestPermission:
            return "Receive blink::mojom::FileSystemAccessDirectoryHandle::RequestPermission";
      case messages::FileSystemAccessDirectoryHandle::kGetFile:
            return "Receive blink::mojom::FileSystemAccessDirectoryHandle::GetFile";
      case messages::FileSystemAccessDirectoryHandle::kGetDirectory:
            return "Receive blink::mojom::FileSystemAccessDirectoryHandle::GetDirectory";
      case messages::FileSystemAccessDirectoryHandle::kGetEntries:
            return "Receive blink::mojom::FileSystemAccessDirectoryHandle::GetEntries";
      case messages::FileSystemAccessDirectoryHandle::kRename:
            return "Receive blink::mojom::FileSystemAccessDirectoryHandle::Rename";
      case messages::FileSystemAccessDirectoryHandle::kMove:
            return "Receive blink::mojom::FileSystemAccessDirectoryHandle::Move";
      case messages::FileSystemAccessDirectoryHandle::kRemove:
            return "Receive blink::mojom::FileSystemAccessDirectoryHandle::Remove";
      case messages::FileSystemAccessDirectoryHandle::kRemoveEntry:
            return "Receive blink::mojom::FileSystemAccessDirectoryHandle::RemoveEntry";
      case messages::FileSystemAccessDirectoryHandle::kResolve:
            return "Receive blink::mojom::FileSystemAccessDirectoryHandle::Resolve";
      case messages::FileSystemAccessDirectoryHandle::kTransfer:
            return "Receive blink::mojom::FileSystemAccessDirectoryHandle::Transfer";
      case messages::FileSystemAccessDirectoryHandle::kGetUniqueId:
            return "Receive blink::mojom::FileSystemAccessDirectoryHandle::GetUniqueId";
      case messages::FileSystemAccessDirectoryHandle::kGetCloudIdentifiers:
            return "Receive blink::mojom::FileSystemAccessDirectoryHandle::GetCloudIdentifiers";
    }
  } else {
    switch (static_cast<messages::FileSystemAccessDirectoryHandle>(message.name())) {
      case messages::FileSystemAccessDirectoryHandle::kGetPermissionStatus:
            return "Receive reply blink::mojom::FileSystemAccessDirectoryHandle::GetPermissionStatus";
      case messages::FileSystemAccessDirectoryHandle::kRequestPermission:
            return "Receive reply blink::mojom::FileSystemAccessDirectoryHandle::RequestPermission";
      case messages::FileSystemAccessDirectoryHandle::kGetFile:
            return "Receive reply blink::mojom::FileSystemAccessDirectoryHandle::GetFile";
      case messages::FileSystemAccessDirectoryHandle::kGetDirectory:
            return "Receive reply blink::mojom::FileSystemAccessDirectoryHandle::GetDirectory";
      case messages::FileSystemAccessDirectoryHandle::kGetEntries:
            return "Receive reply blink::mojom::FileSystemAccessDirectoryHandle::GetEntries";
      case messages::FileSystemAccessDirectoryHandle::kRename:
            return "Receive reply blink::mojom::FileSystemAccessDirectoryHandle::Rename";
      case messages::FileSystemAccessDirectoryHandle::kMove:
            return "Receive reply blink::mojom::FileSystemAccessDirectoryHandle::Move";
      case messages::FileSystemAccessDirectoryHandle::kRemove:
            return "Receive reply blink::mojom::FileSystemAccessDirectoryHandle::Remove";
      case messages::FileSystemAccessDirectoryHandle::kRemoveEntry:
            return "Receive reply blink::mojom::FileSystemAccessDirectoryHandle::RemoveEntry";
      case messages::FileSystemAccessDirectoryHandle::kResolve:
            return "Receive reply blink::mojom::FileSystemAccessDirectoryHandle::Resolve";
      case messages::FileSystemAccessDirectoryHandle::kTransfer:
            return "Receive reply blink::mojom::FileSystemAccessDirectoryHandle::Transfer";
      case messages::FileSystemAccessDirectoryHandle::kGetUniqueId:
            return "Receive reply blink::mojom::FileSystemAccessDirectoryHandle::GetUniqueId";
      case messages::FileSystemAccessDirectoryHandle::kGetCloudIdentifiers:
            return "Receive reply blink::mojom::FileSystemAccessDirectoryHandle::GetCloudIdentifiers";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileSystemAccessDirectoryHandle::GetPermissionStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed097c51;  // IPCStableHash for blink::mojom::FileSystemAccessDirectoryHandle::GetPermissionStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessDirectoryHandle::RequestPermission_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4cd573eb;  // IPCStableHash for blink::mojom::FileSystemAccessDirectoryHandle::RequestPermission
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessDirectoryHandle::GetFile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdac9b29f;  // IPCStableHash for blink::mojom::FileSystemAccessDirectoryHandle::GetFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessDirectoryHandle::GetDirectory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x20c1f616;  // IPCStableHash for blink::mojom::FileSystemAccessDirectoryHandle::GetDirectory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessDirectoryHandle::GetEntries_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb5306bc8;  // IPCStableHash for blink::mojom::FileSystemAccessDirectoryHandle::GetEntries
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessDirectoryHandle::Rename_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf3ea0f1d;  // IPCStableHash for blink::mojom::FileSystemAccessDirectoryHandle::Rename
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessDirectoryHandle::Move_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8be27b29;  // IPCStableHash for blink::mojom::FileSystemAccessDirectoryHandle::Move
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessDirectoryHandle::Remove_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb43e523b;  // IPCStableHash for blink::mojom::FileSystemAccessDirectoryHandle::Remove
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessDirectoryHandle::RemoveEntry_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xec65e638;  // IPCStableHash for blink::mojom::FileSystemAccessDirectoryHandle::RemoveEntry
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessDirectoryHandle::Resolve_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd4fc102b;  // IPCStableHash for blink::mojom::FileSystemAccessDirectoryHandle::Resolve
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessDirectoryHandle::Transfer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe4ca2b94;  // IPCStableHash for blink::mojom::FileSystemAccessDirectoryHandle::Transfer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessDirectoryHandle::GetUniqueId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x687ce06d;  // IPCStableHash for blink::mojom::FileSystemAccessDirectoryHandle::GetUniqueId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessDirectoryHandle::GetCloudIdentifiers_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9110f7cf;  // IPCStableHash for blink::mojom::FileSystemAccessDirectoryHandle::GetCloudIdentifiers
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FileSystemAccessDirectoryHandle_GetPermissionStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_GetPermissionStatus_ForwardToCallback(
      FileSystemAccessDirectoryHandle::GetPermissionStatusCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessDirectoryHandle_GetPermissionStatus_ForwardToCallback(const FileSystemAccessDirectoryHandle_GetPermissionStatus_ForwardToCallback&) = delete;
  FileSystemAccessDirectoryHandle_GetPermissionStatus_ForwardToCallback& operator=(const FileSystemAccessDirectoryHandle_GetPermissionStatus_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::GetPermissionStatusCallback callback_;
};

class FileSystemAccessDirectoryHandle_RequestPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_RequestPermission_ForwardToCallback(
      FileSystemAccessDirectoryHandle::RequestPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessDirectoryHandle_RequestPermission_ForwardToCallback(const FileSystemAccessDirectoryHandle_RequestPermission_ForwardToCallback&) = delete;
  FileSystemAccessDirectoryHandle_RequestPermission_ForwardToCallback& operator=(const FileSystemAccessDirectoryHandle_RequestPermission_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::RequestPermissionCallback callback_;
};

class FileSystemAccessDirectoryHandle_GetFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_GetFile_ForwardToCallback(
      FileSystemAccessDirectoryHandle::GetFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessDirectoryHandle_GetFile_ForwardToCallback(const FileSystemAccessDirectoryHandle_GetFile_ForwardToCallback&) = delete;
  FileSystemAccessDirectoryHandle_GetFile_ForwardToCallback& operator=(const FileSystemAccessDirectoryHandle_GetFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::GetFileCallback callback_;
};

class FileSystemAccessDirectoryHandle_GetDirectory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_GetDirectory_ForwardToCallback(
      FileSystemAccessDirectoryHandle::GetDirectoryCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessDirectoryHandle_GetDirectory_ForwardToCallback(const FileSystemAccessDirectoryHandle_GetDirectory_ForwardToCallback&) = delete;
  FileSystemAccessDirectoryHandle_GetDirectory_ForwardToCallback& operator=(const FileSystemAccessDirectoryHandle_GetDirectory_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::GetDirectoryCallback callback_;
};

class FileSystemAccessDirectoryHandle_Rename_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_Rename_ForwardToCallback(
      FileSystemAccessDirectoryHandle::RenameCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessDirectoryHandle_Rename_ForwardToCallback(const FileSystemAccessDirectoryHandle_Rename_ForwardToCallback&) = delete;
  FileSystemAccessDirectoryHandle_Rename_ForwardToCallback& operator=(const FileSystemAccessDirectoryHandle_Rename_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::RenameCallback callback_;
};

class FileSystemAccessDirectoryHandle_Move_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_Move_ForwardToCallback(
      FileSystemAccessDirectoryHandle::MoveCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessDirectoryHandle_Move_ForwardToCallback(const FileSystemAccessDirectoryHandle_Move_ForwardToCallback&) = delete;
  FileSystemAccessDirectoryHandle_Move_ForwardToCallback& operator=(const FileSystemAccessDirectoryHandle_Move_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::MoveCallback callback_;
};

class FileSystemAccessDirectoryHandle_Remove_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_Remove_ForwardToCallback(
      FileSystemAccessDirectoryHandle::RemoveCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessDirectoryHandle_Remove_ForwardToCallback(const FileSystemAccessDirectoryHandle_Remove_ForwardToCallback&) = delete;
  FileSystemAccessDirectoryHandle_Remove_ForwardToCallback& operator=(const FileSystemAccessDirectoryHandle_Remove_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::RemoveCallback callback_;
};

class FileSystemAccessDirectoryHandle_RemoveEntry_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_RemoveEntry_ForwardToCallback(
      FileSystemAccessDirectoryHandle::RemoveEntryCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessDirectoryHandle_RemoveEntry_ForwardToCallback(const FileSystemAccessDirectoryHandle_RemoveEntry_ForwardToCallback&) = delete;
  FileSystemAccessDirectoryHandle_RemoveEntry_ForwardToCallback& operator=(const FileSystemAccessDirectoryHandle_RemoveEntry_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::RemoveEntryCallback callback_;
};

class FileSystemAccessDirectoryHandle_Resolve_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_Resolve_ForwardToCallback(
      FileSystemAccessDirectoryHandle::ResolveCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessDirectoryHandle_Resolve_ForwardToCallback(const FileSystemAccessDirectoryHandle_Resolve_ForwardToCallback&) = delete;
  FileSystemAccessDirectoryHandle_Resolve_ForwardToCallback& operator=(const FileSystemAccessDirectoryHandle_Resolve_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::ResolveCallback callback_;
};

class FileSystemAccessDirectoryHandle_GetUniqueId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_GetUniqueId_ForwardToCallback(
      FileSystemAccessDirectoryHandle::GetUniqueIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessDirectoryHandle_GetUniqueId_ForwardToCallback(const FileSystemAccessDirectoryHandle_GetUniqueId_ForwardToCallback&) = delete;
  FileSystemAccessDirectoryHandle_GetUniqueId_ForwardToCallback& operator=(const FileSystemAccessDirectoryHandle_GetUniqueId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::GetUniqueIdCallback callback_;
};

class FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ForwardToCallback(
      FileSystemAccessDirectoryHandle::GetCloudIdentifiersCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ForwardToCallback(const FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ForwardToCallback&) = delete;
  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ForwardToCallback& operator=(const FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDirectoryHandle::GetCloudIdentifiersCallback callback_;
};

FileSystemAccessDirectoryHandleProxy::FileSystemAccessDirectoryHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessDirectoryHandleProxy::GetPermissionStatus(
    ::blink::mojom::FileSystemAccessPermissionMode in_mode, GetPermissionStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessDirectoryHandle::GetPermissionStatus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type ::blink::mojom::FileSystemAccessPermissionMode>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kGetPermissionStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessPermissionMode>(
    in_mode,
    &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetPermissionStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_GetPermissionStatus_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessDirectoryHandleProxy::RequestPermission(
    ::blink::mojom::FileSystemAccessPermissionMode in_mode, RequestPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessDirectoryHandle::RequestPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type ::blink::mojom::FileSystemAccessPermissionMode>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kRequestPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_RequestPermission_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessPermissionMode>(
    in_mode,
    &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("RequestPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_RequestPermission_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessDirectoryHandleProxy::GetFile(
    const std::string& in_basename, bool in_create, GetFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessDirectoryHandle::GetFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("basename"), in_basename,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("create"), in_create,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kGetFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->basename)::BaseType> basename_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_basename,
    basename_fragment);

  params->basename.Set(
      basename_fragment.is_null() ? nullptr : basename_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->basename.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null basename in FileSystemAccessDirectoryHandle.GetFile request");

  params->create = in_create;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_GetFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessDirectoryHandleProxy::GetDirectory(
    const std::string& in_basename, bool in_create, GetDirectoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessDirectoryHandle::GetDirectory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("basename"), in_basename,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("create"), in_create,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kGetDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetDirectory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->basename)::BaseType> basename_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_basename,
    basename_fragment);

  params->basename.Set(
      basename_fragment.is_null() ? nullptr : basename_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->basename.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null basename in FileSystemAccessDirectoryHandle.GetDirectory request");

  params->create = in_create;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetDirectory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_GetDirectory_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessDirectoryHandleProxy::GetEntries(
    ::mojo::PendingRemote<FileSystemAccessDirectoryEntriesListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessDirectoryHandle::GetEntries", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<FileSystemAccessDirectoryEntriesListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kGetEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetEntries_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessDirectoryEntriesListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in FileSystemAccessDirectoryHandle.GetEntries request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetEntries");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FileSystemAccessDirectoryHandleProxy::Rename(
    const std::string& in_new_entry_name, RenameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessDirectoryHandle::Rename", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_entry_name"), in_new_entry_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kRename), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_Rename_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->new_entry_name)::BaseType> new_entry_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_entry_name,
    new_entry_name_fragment);

  params->new_entry_name.Set(
      new_entry_name_fragment.is_null() ? nullptr : new_entry_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_entry_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_entry_name in FileSystemAccessDirectoryHandle.Rename request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("Rename");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_Rename_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessDirectoryHandleProxy::Move(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> in_destination_directory, const std::string& in_new_entry_name, MoveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessDirectoryHandle::Move", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("destination_directory"), in_destination_directory,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_entry_name"), in_new_entry_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kMove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_Move_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
    in_destination_directory,
    &params->destination_directory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->destination_directory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid destination_directory in FileSystemAccessDirectoryHandle.Move request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_entry_name)::BaseType> new_entry_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_entry_name,
    new_entry_name_fragment);

  params->new_entry_name.Set(
      new_entry_name_fragment.is_null() ? nullptr : new_entry_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_entry_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_entry_name in FileSystemAccessDirectoryHandle.Move request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("Move");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_Move_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessDirectoryHandleProxy::Remove(
    bool in_recurse, RemoveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessDirectoryHandle::Remove", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recurse"), in_recurse,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kRemove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_Remove_Params_Data> params(
          message);
  params.Allocate();

  params->recurse = in_recurse;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("Remove");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_Remove_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessDirectoryHandleProxy::RemoveEntry(
    const std::string& in_basename, bool in_recurse, RemoveEntryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessDirectoryHandle::RemoveEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("basename"), in_basename,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recurse"), in_recurse,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kRemoveEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_RemoveEntry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->basename)::BaseType> basename_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_basename,
    basename_fragment);

  params->basename.Set(
      basename_fragment.is_null() ? nullptr : basename_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->basename.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null basename in FileSystemAccessDirectoryHandle.RemoveEntry request");

  params->recurse = in_recurse;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("RemoveEntry");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_RemoveEntry_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessDirectoryHandleProxy::Resolve(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> in_possible_child, ResolveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessDirectoryHandle::Resolve", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("possible_child"), in_possible_child,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kResolve), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_Resolve_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
    in_possible_child,
    &params->possible_child,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->possible_child)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid possible_child in FileSystemAccessDirectoryHandle.Resolve request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("Resolve");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_Resolve_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessDirectoryHandleProxy::Transfer(
    ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessDirectoryHandle::Transfer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kTransfer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_Transfer_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
    in_token,
    &params->token,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->token)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid token in FileSystemAccessDirectoryHandle.Transfer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("Transfer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FileSystemAccessDirectoryHandleProxy::GetUniqueId(
    GetUniqueIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FileSystemAccessDirectoryHandle::GetUniqueId");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kGetUniqueId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetUniqueId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetUniqueId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_GetUniqueId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessDirectoryHandleProxy::GetCloudIdentifiers(
    GetCloudIdentifiersCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FileSystemAccessDirectoryHandle::GetCloudIdentifiers");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kGetCloudIdentifiers), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetCloudIdentifiers");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::GetPermissionStatusCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessDirectoryHandle::GetPermissionStatusCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::PermissionStatus in_status);
};

bool FileSystemAccessDirectoryHandle_GetPermissionStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessDirectoryHandle.0
  bool success = true;
  ::blink::mojom::PermissionStatus p_status{};
  FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder::Run(
    ::blink::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessDirectoryHandle::GetPermissionStatus", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::PermissionStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kGetPermissionStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetPermissionStatus");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::RequestPermissionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessDirectoryHandle::RequestPermissionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::blink::mojom::PermissionStatus in_status);
};

bool FileSystemAccessDirectoryHandle_RequestPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessDirectoryHandle.1
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::blink::mojom::PermissionStatus p_status{};
  FileSystemAccessDirectoryHandle_RequestPermission_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_status));
  }
  return true;
}

void FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::blink::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessDirectoryHandle::RequestPermission", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::PermissionStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kRequestPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

  
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("RequestPermission");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::GetFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessDirectoryHandle::GetFileCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> in_file);
};

bool FileSystemAccessDirectoryHandle_GetFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_GetFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_GetFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessDirectoryHandle.2
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> p_file{};
  FileSystemAccessDirectoryHandle_GetFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_file =
        input_data_view.TakeFile<decltype(p_file)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_file));
  }
  return true;
}

void FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessDirectoryHandle::GetFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kGetFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessFileHandleInterfaceBase>>(
    in_file,
    &params->file,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::GetDirectoryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessDirectoryHandle::GetDirectoryCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> in_directory);
};

bool FileSystemAccessDirectoryHandle_GetDirectory_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessDirectoryHandle.3
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> p_directory{};
  FileSystemAccessDirectoryHandle_GetDirectory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_directory =
        input_data_view.TakeDirectory<decltype(p_directory)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_directory));
  }
  return true;
}

void FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> in_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessDirectoryHandle::GetDirectory", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory"), in_directory,
                        "<value of type ::mojo::PendingRemote<FileSystemAccessDirectoryHandle>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kGetDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessDirectoryHandleInterfaceBase>>(
    in_directory,
    &params->directory,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetDirectory");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_Rename_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::RenameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_Rename_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_Rename_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_Rename_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_Rename_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessDirectoryHandle_Rename_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessDirectoryHandle::RenameCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result);
};

bool FileSystemAccessDirectoryHandle_Rename_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_Rename_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_Rename_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessDirectoryHandle.5
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  FileSystemAccessDirectoryHandle_Rename_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FileSystemAccessDirectoryHandle_Rename_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessDirectoryHandle::Rename", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kRename), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_Rename_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("Rename");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_Move_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::MoveCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_Move_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_Move_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_Move_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_Move_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessDirectoryHandle_Move_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessDirectoryHandle::MoveCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result);
};

bool FileSystemAccessDirectoryHandle_Move_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_Move_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_Move_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessDirectoryHandle.6
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  FileSystemAccessDirectoryHandle_Move_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FileSystemAccessDirectoryHandle_Move_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessDirectoryHandle::Move", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kMove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_Move_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("Move");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_Remove_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::RemoveCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_Remove_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_Remove_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_Remove_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_Remove_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessDirectoryHandle_Remove_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessDirectoryHandle::RemoveCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result);
};

bool FileSystemAccessDirectoryHandle_Remove_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_Remove_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_Remove_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessDirectoryHandle.7
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  FileSystemAccessDirectoryHandle_Remove_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FileSystemAccessDirectoryHandle_Remove_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessDirectoryHandle::Remove", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kRemove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_Remove_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("Remove");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::RemoveEntryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessDirectoryHandle::RemoveEntryCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result);
};

bool FileSystemAccessDirectoryHandle_RemoveEntry_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessDirectoryHandle.8
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessDirectoryHandle::RemoveEntry", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kRemoveEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("RemoveEntry");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::ResolveCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessDirectoryHandle::ResolveCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, const std::optional<std::vector<std::string>>& in_path);
};

bool FileSystemAccessDirectoryHandle_Resolve_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_Resolve_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_Resolve_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessDirectoryHandle.9
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  std::optional<std::vector<std::string>> p_path{};
  FileSystemAccessDirectoryHandle_Resolve_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadPath(&p_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_path));
  }
  return true;
}

void FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, const std::optional<std::vector<std::string>>& in_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessDirectoryHandle::Resolve", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const std::optional<std::vector<std::string>>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kResolve), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_Resolve_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType>
      path_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& path_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_path,
    path_fragment,
    &path_validate_params);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("Resolve");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_GetUniqueId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::GetUniqueIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_GetUniqueId_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_GetUniqueId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_GetUniqueId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_GetUniqueId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessDirectoryHandle_GetUniqueId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessDirectoryHandle::GetUniqueIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, const std::string& in_id);
};

bool FileSystemAccessDirectoryHandle_GetUniqueId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessDirectoryHandle.11
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  std::string p_id{};
  FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadId(&p_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_id));
  }
  return true;
}

void FileSystemAccessDirectoryHandle_GetUniqueId_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessDirectoryHandle::GetUniqueId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kGetUniqueId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetUniqueId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessDirectoryHandle::GetCloudIdentifiersCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ProxyToResponder> proxy(
        new FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessDirectoryHandle::GetCloudIdentifiersCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr> in_cloud_identifiers);
};

bool FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessDirectoryHandle.12
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr> p_cloud_identifiers{};
  FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadCloudIdentifiers(&p_cloud_identifiers))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDirectoryHandle::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_cloud_identifiers));
  }
  return true;
}

void FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr> in_cloud_identifiers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessDirectoryHandle::GetCloudIdentifiers", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cloud_identifiers"), in_cloud_identifiers,
                        "<value of type std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDirectoryHandle::kGetCloudIdentifiers), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");
  mojo::internal::MessageFragment<
      typename decltype(params->cloud_identifiers)::BaseType>
      cloud_identifiers_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& cloud_identifiers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FileSystemAccessCloudIdentifierDataView>>(
    in_cloud_identifiers,
    cloud_identifiers_fragment,
    &cloud_identifiers_validate_params);

  params->cloud_identifiers.Set(
      cloud_identifiers_fragment.is_null() ? nullptr : cloud_identifiers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cloud_identifiers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cloud_identifiers in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDirectoryHandle::Name_);
  message.set_method_name("GetCloudIdentifiers");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileSystemAccessDirectoryHandleStubDispatch::Accept(
    FileSystemAccessDirectoryHandle* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileSystemAccessDirectoryHandle>(message->header()->name)) {
    case messages::FileSystemAccessDirectoryHandle::kGetPermissionStatus: {
      break;
    }
    case messages::FileSystemAccessDirectoryHandle::kRequestPermission: {
      break;
    }
    case messages::FileSystemAccessDirectoryHandle::kGetFile: {
      break;
    }
    case messages::FileSystemAccessDirectoryHandle::kGetDirectory: {
      break;
    }
    case messages::FileSystemAccessDirectoryHandle::kGetEntries: {
      DCHECK(message->is_serialized());
      internal::FileSystemAccessDirectoryHandle_GetEntries_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessDirectoryHandle_GetEntries_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemAccessDirectoryHandle.4
      bool success = true;
      ::mojo::PendingRemote<FileSystemAccessDirectoryEntriesListener> p_listener{};
      FileSystemAccessDirectoryHandle_GetEntries_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEntries(        
        std::move(p_listener));
      return true;
    }
    case messages::FileSystemAccessDirectoryHandle::kRename: {
      break;
    }
    case messages::FileSystemAccessDirectoryHandle::kMove: {
      break;
    }
    case messages::FileSystemAccessDirectoryHandle::kRemove: {
      break;
    }
    case messages::FileSystemAccessDirectoryHandle::kRemoveEntry: {
      break;
    }
    case messages::FileSystemAccessDirectoryHandle::kResolve: {
      break;
    }
    case messages::FileSystemAccessDirectoryHandle::kTransfer: {
      DCHECK(message->is_serialized());
      internal::FileSystemAccessDirectoryHandle_Transfer_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessDirectoryHandle_Transfer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemAccessDirectoryHandle.10
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> p_token{};
      FileSystemAccessDirectoryHandle_Transfer_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Transfer(        
        std::move(p_token));
      return true;
    }
    case messages::FileSystemAccessDirectoryHandle::kGetUniqueId: {
      break;
    }
    case messages::FileSystemAccessDirectoryHandle::kGetCloudIdentifiers: {
      break;
    }
  }
  return false;
}

// static
bool FileSystemAccessDirectoryHandleStubDispatch::AcceptWithResponder(
    FileSystemAccessDirectoryHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileSystemAccessDirectoryHandle>(message->header()->name)) {
    case messages::FileSystemAccessDirectoryHandle::kGetPermissionStatus: {
      internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessDirectoryHandle.0
      bool success = true;
      ::blink::mojom::FileSystemAccessPermissionMode p_mode{};
      FileSystemAccessDirectoryHandle_GetPermissionStatus_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 0, false);
        return false;
      }
      auto callback =
          FileSystemAccessDirectoryHandle_GetPermissionStatus_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPermissionStatus(        
        std::move(p_mode), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessDirectoryHandle::kRequestPermission: {
      internal::FileSystemAccessDirectoryHandle_RequestPermission_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_RequestPermission_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessDirectoryHandle.1
      bool success = true;
      ::blink::mojom::FileSystemAccessPermissionMode p_mode{};
      FileSystemAccessDirectoryHandle_RequestPermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 1, false);
        return false;
      }
      auto callback =
          FileSystemAccessDirectoryHandle_RequestPermission_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPermission(        
        std::move(p_mode), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessDirectoryHandle::kGetFile: {
      internal::FileSystemAccessDirectoryHandle_GetFile_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_GetFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessDirectoryHandle.2
      bool success = true;
      std::string p_basename{};
      bool p_create{};
      FileSystemAccessDirectoryHandle_GetFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBasename(&p_basename))
        success = false;
      if (success)
        p_create = input_data_view.create();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 2, false);
        return false;
      }
      auto callback =
          FileSystemAccessDirectoryHandle_GetFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFile(        
        std::move(p_basename), 
        std::move(p_create), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessDirectoryHandle::kGetDirectory: {
      internal::FileSystemAccessDirectoryHandle_GetDirectory_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_GetDirectory_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessDirectoryHandle.3
      bool success = true;
      std::string p_basename{};
      bool p_create{};
      FileSystemAccessDirectoryHandle_GetDirectory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBasename(&p_basename))
        success = false;
      if (success)
        p_create = input_data_view.create();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 3, false);
        return false;
      }
      auto callback =
          FileSystemAccessDirectoryHandle_GetDirectory_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDirectory(        
        std::move(p_basename), 
        std::move(p_create), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessDirectoryHandle::kGetEntries: {
      break;
    }
    case messages::FileSystemAccessDirectoryHandle::kRename: {
      internal::FileSystemAccessDirectoryHandle_Rename_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_Rename_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessDirectoryHandle.5
      bool success = true;
      std::string p_new_entry_name{};
      FileSystemAccessDirectoryHandle_Rename_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewEntryName(&p_new_entry_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 5, false);
        return false;
      }
      auto callback =
          FileSystemAccessDirectoryHandle_Rename_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Rename(        
        std::move(p_new_entry_name), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessDirectoryHandle::kMove: {
      internal::FileSystemAccessDirectoryHandle_Move_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_Move_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessDirectoryHandle.6
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> p_destination_directory{};
      std::string p_new_entry_name{};
      FileSystemAccessDirectoryHandle_Move_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_destination_directory =
            input_data_view.TakeDestinationDirectory<decltype(p_destination_directory)>();
      }
      if (success && !input_data_view.ReadNewEntryName(&p_new_entry_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 6, false);
        return false;
      }
      auto callback =
          FileSystemAccessDirectoryHandle_Move_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Move(        
        std::move(p_destination_directory), 
        std::move(p_new_entry_name), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessDirectoryHandle::kRemove: {
      internal::FileSystemAccessDirectoryHandle_Remove_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_Remove_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessDirectoryHandle.7
      bool success = true;
      bool p_recurse{};
      FileSystemAccessDirectoryHandle_Remove_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_recurse = input_data_view.recurse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 7, false);
        return false;
      }
      auto callback =
          FileSystemAccessDirectoryHandle_Remove_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Remove(        
        std::move(p_recurse), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessDirectoryHandle::kRemoveEntry: {
      internal::FileSystemAccessDirectoryHandle_RemoveEntry_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_RemoveEntry_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessDirectoryHandle.8
      bool success = true;
      std::string p_basename{};
      bool p_recurse{};
      FileSystemAccessDirectoryHandle_RemoveEntry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBasename(&p_basename))
        success = false;
      if (success)
        p_recurse = input_data_view.recurse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 8, false);
        return false;
      }
      auto callback =
          FileSystemAccessDirectoryHandle_RemoveEntry_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveEntry(        
        std::move(p_basename), 
        std::move(p_recurse), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessDirectoryHandle::kResolve: {
      internal::FileSystemAccessDirectoryHandle_Resolve_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_Resolve_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessDirectoryHandle.9
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> p_possible_child{};
      FileSystemAccessDirectoryHandle_Resolve_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_possible_child =
            input_data_view.TakePossibleChild<decltype(p_possible_child)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 9, false);
        return false;
      }
      auto callback =
          FileSystemAccessDirectoryHandle_Resolve_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resolve(        
        std::move(p_possible_child), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessDirectoryHandle::kTransfer: {
      break;
    }
    case messages::FileSystemAccessDirectoryHandle::kGetUniqueId: {
      internal::FileSystemAccessDirectoryHandle_GetUniqueId_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_GetUniqueId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessDirectoryHandle.11
      bool success = true;
      FileSystemAccessDirectoryHandle_GetUniqueId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 11, false);
        return false;
      }
      auto callback =
          FileSystemAccessDirectoryHandle_GetUniqueId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUniqueId(std::move(callback));
      return true;
    }
    case messages::FileSystemAccessDirectoryHandle::kGetCloudIdentifiers: {
      internal::FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessDirectoryHandle.12
      bool success = true;
      FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDirectoryHandle::Name_, 12, false);
        return false;
      }
      auto callback =
          FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCloudIdentifiers(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileSystemAccessDirectoryHandleValidationInfo[] = {
    { &internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessDirectoryHandle_RequestPermission_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessDirectoryHandle_GetFile_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_GetFile_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessDirectoryHandle_GetDirectory_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessDirectoryHandle_GetEntries_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FileSystemAccessDirectoryHandle_Rename_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_Rename_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessDirectoryHandle_Move_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_Move_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessDirectoryHandle_Remove_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_Remove_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessDirectoryHandle_RemoveEntry_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessDirectoryHandle_Resolve_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_Resolve_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessDirectoryHandle_Transfer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FileSystemAccessDirectoryHandle_GetUniqueId_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params_Data::Validate,
     &internal::FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams_Data::Validate},
};

bool FileSystemAccessDirectoryHandleRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::FileSystemAccessDirectoryHandle::Name_,
    kFileSystemAccessDirectoryHandleValidationInfo);
}

bool FileSystemAccessDirectoryHandleResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::FileSystemAccessDirectoryHandle::Name_,
    kFileSystemAccessDirectoryHandleValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::FileSystemAccessEntry::DataView, ::blink::mojom::FileSystemAccessEntryPtr>::Read(
    ::blink::mojom::FileSystemAccessEntry::DataView input,
    ::blink::mojom::FileSystemAccessEntryPtr* output) {
  bool success = true;
  ::blink::mojom::FileSystemAccessEntryPtr result(::blink::mojom::FileSystemAccessEntry::New());
  
      if (success && !input.ReadEntryHandle(&result->entry_handle))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::FileSystemAccessHandle::DataView, ::blink::mojom::FileSystemAccessHandlePtr>::Read(
    ::blink::mojom::FileSystemAccessHandle::DataView input,
    ::blink::mojom::FileSystemAccessHandlePtr* output) {
  using UnionType = ::blink::mojom::FileSystemAccessHandle;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kFile: {
      *output = UnionType::NewFile(
          input.TakeFile<::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>>());
      break;
    }
    case Tag::kDirectory: {
      *output = UnionType::NewDirectory(
          input.TakeDirectory<::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>>());
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void FileSystemAccessDirectoryEntriesListenerInterceptorForTesting::DidReadDirectory(::blink::mojom::FileSystemAccessErrorPtr result, std::vector<FileSystemAccessEntryPtr> entries, bool has_more_entries) {
  GetForwardingInterface()->DidReadDirectory(
    std::move(result)
    , 
    std::move(entries)
    , 
    std::move(has_more_entries)
    );
}
FileSystemAccessDirectoryEntriesListenerAsyncWaiter::FileSystemAccessDirectoryEntriesListenerAsyncWaiter(
    FileSystemAccessDirectoryEntriesListener* proxy) : proxy_(proxy) {}

FileSystemAccessDirectoryEntriesListenerAsyncWaiter::~FileSystemAccessDirectoryEntriesListenerAsyncWaiter() = default;





void FileSystemAccessDirectoryHandleInterceptorForTesting::GetPermissionStatus(::blink::mojom::FileSystemAccessPermissionMode mode, GetPermissionStatusCallback callback) {
  GetForwardingInterface()->GetPermissionStatus(
    std::move(mode)
    , std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::RequestPermission(::blink::mojom::FileSystemAccessPermissionMode mode, RequestPermissionCallback callback) {
  GetForwardingInterface()->RequestPermission(
    std::move(mode)
    , std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::GetFile(const std::string& basename, bool create, GetFileCallback callback) {
  GetForwardingInterface()->GetFile(
    std::move(basename)
    , 
    std::move(create)
    , std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::GetDirectory(const std::string& basename, bool create, GetDirectoryCallback callback) {
  GetForwardingInterface()->GetDirectory(
    std::move(basename)
    , 
    std::move(create)
    , std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::GetEntries(::mojo::PendingRemote<FileSystemAccessDirectoryEntriesListener> listener) {
  GetForwardingInterface()->GetEntries(
    std::move(listener)
    );
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::Rename(const std::string& new_entry_name, RenameCallback callback) {
  GetForwardingInterface()->Rename(
    std::move(new_entry_name)
    , std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::Move(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> destination_directory, const std::string& new_entry_name, MoveCallback callback) {
  GetForwardingInterface()->Move(
    std::move(destination_directory)
    , 
    std::move(new_entry_name)
    , std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::Remove(bool recurse, RemoveCallback callback) {
  GetForwardingInterface()->Remove(
    std::move(recurse)
    , std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::RemoveEntry(const std::string& basename, bool recurse, RemoveEntryCallback callback) {
  GetForwardingInterface()->RemoveEntry(
    std::move(basename)
    , 
    std::move(recurse)
    , std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::Resolve(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> possible_child, ResolveCallback callback) {
  GetForwardingInterface()->Resolve(
    std::move(possible_child)
    , std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::Transfer(::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> token) {
  GetForwardingInterface()->Transfer(
    std::move(token)
    );
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::GetUniqueId(GetUniqueIdCallback callback) {
  GetForwardingInterface()->GetUniqueId(std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::GetCloudIdentifiers(GetCloudIdentifiersCallback callback) {
  GetForwardingInterface()->GetCloudIdentifiers(std::move(callback));
}
FileSystemAccessDirectoryHandleAsyncWaiter::FileSystemAccessDirectoryHandleAsyncWaiter(
    FileSystemAccessDirectoryHandle* proxy) : proxy_(proxy) {}

FileSystemAccessDirectoryHandleAsyncWaiter::~FileSystemAccessDirectoryHandleAsyncWaiter() = default;


void FileSystemAccessDirectoryHandleAsyncWaiter::GetPermissionStatus(
    ::blink::mojom::FileSystemAccessPermissionMode mode, ::blink::mojom::PermissionStatus* out_status) {
  base::RunLoop loop;
  proxy_->GetPermissionStatus(
      std::move(mode),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::PermissionStatus* out_status
,
             ::blink::mojom::PermissionStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::PermissionStatus FileSystemAccessDirectoryHandleAsyncWaiter::GetPermissionStatus(
    ::blink::mojom::FileSystemAccessPermissionMode mode) {
  ::blink::mojom::PermissionStatus async_wait_result;
  GetPermissionStatus(std::move(mode),&async_wait_result);
  return async_wait_result;
}

void FileSystemAccessDirectoryHandleAsyncWaiter::RequestPermission(
    ::blink::mojom::FileSystemAccessPermissionMode mode, ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::blink::mojom::PermissionStatus* out_status) {
  base::RunLoop loop;
  proxy_->RequestPermission(
      std::move(mode),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::PermissionStatus* out_status
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             ::blink::mojom::PermissionStatus status) {*out_result = std::move(result);*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_result,
          out_status));
  loop.Run();
}



void FileSystemAccessDirectoryHandleAsyncWaiter::GetFile(
    const std::string& basename, bool create, ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>* out_file) {
  base::RunLoop loop;
  proxy_->GetFile(
      std::move(basename),
      std::move(create),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>* out_file
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> file) {*out_result = std::move(result);*out_file = std::move(file);
            loop->Quit();
          },
          &loop,
          out_result,
          out_file));
  loop.Run();
}



void FileSystemAccessDirectoryHandleAsyncWaiter::GetDirectory(
    const std::string& basename, bool create, ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::mojo::PendingRemote<FileSystemAccessDirectoryHandle>* out_directory) {
  base::RunLoop loop;
  proxy_->GetDirectory(
      std::move(basename),
      std::move(create),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::mojo::PendingRemote<FileSystemAccessDirectoryHandle>* out_directory
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> directory) {*out_result = std::move(result);*out_directory = std::move(directory);
            loop->Quit();
          },
          &loop,
          out_result,
          out_directory));
  loop.Run();
}



void FileSystemAccessDirectoryHandleAsyncWaiter::Rename(
    const std::string& new_entry_name, ::blink::mojom::FileSystemAccessErrorPtr* out_result) {
  base::RunLoop loop;
  proxy_->Rename(
      std::move(new_entry_name),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::FileSystemAccessErrorPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::mojom::FileSystemAccessErrorPtr FileSystemAccessDirectoryHandleAsyncWaiter::Rename(
    const std::string& new_entry_name) {
  ::blink::mojom::FileSystemAccessErrorPtr async_wait_result;
  Rename(std::move(new_entry_name),&async_wait_result);
  return async_wait_result;
}

void FileSystemAccessDirectoryHandleAsyncWaiter::Move(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> destination_directory, const std::string& new_entry_name, ::blink::mojom::FileSystemAccessErrorPtr* out_result) {
  base::RunLoop loop;
  proxy_->Move(
      std::move(destination_directory),
      std::move(new_entry_name),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::FileSystemAccessErrorPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::mojom::FileSystemAccessErrorPtr FileSystemAccessDirectoryHandleAsyncWaiter::Move(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> destination_directory, const std::string& new_entry_name) {
  ::blink::mojom::FileSystemAccessErrorPtr async_wait_result;
  Move(std::move(destination_directory),std::move(new_entry_name),&async_wait_result);
  return async_wait_result;
}

void FileSystemAccessDirectoryHandleAsyncWaiter::Remove(
    bool recurse, ::blink::mojom::FileSystemAccessErrorPtr* out_result) {
  base::RunLoop loop;
  proxy_->Remove(
      std::move(recurse),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::FileSystemAccessErrorPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::mojom::FileSystemAccessErrorPtr FileSystemAccessDirectoryHandleAsyncWaiter::Remove(
    bool recurse) {
  ::blink::mojom::FileSystemAccessErrorPtr async_wait_result;
  Remove(std::move(recurse),&async_wait_result);
  return async_wait_result;
}

void FileSystemAccessDirectoryHandleAsyncWaiter::RemoveEntry(
    const std::string& basename, bool recurse, ::blink::mojom::FileSystemAccessErrorPtr* out_result) {
  base::RunLoop loop;
  proxy_->RemoveEntry(
      std::move(basename),
      std::move(recurse),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::FileSystemAccessErrorPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::mojom::FileSystemAccessErrorPtr FileSystemAccessDirectoryHandleAsyncWaiter::RemoveEntry(
    const std::string& basename, bool recurse) {
  ::blink::mojom::FileSystemAccessErrorPtr async_wait_result;
  RemoveEntry(std::move(basename),std::move(recurse),&async_wait_result);
  return async_wait_result;
}

void FileSystemAccessDirectoryHandleAsyncWaiter::Resolve(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> possible_child, ::blink::mojom::FileSystemAccessErrorPtr* out_result, std::optional<std::vector<std::string>>* out_path) {
  base::RunLoop loop;
  proxy_->Resolve(
      std::move(possible_child),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             std::optional<std::vector<std::string>>* out_path
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             const std::optional<std::vector<std::string>>& path) {*out_result = std::move(result);*out_path = std::move(path);
            loop->Quit();
          },
          &loop,
          out_result,
          out_path));
  loop.Run();
}



void FileSystemAccessDirectoryHandleAsyncWaiter::GetUniqueId(
    ::blink::mojom::FileSystemAccessErrorPtr* out_result, std::string* out_id) {
  base::RunLoop loop;
  proxy_->GetUniqueId(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             std::string* out_id
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             const std::string& id) {*out_result = std::move(result);*out_id = std::move(id);
            loop->Quit();
          },
          &loop,
          out_result,
          out_id));
  loop.Run();
}



void FileSystemAccessDirectoryHandleAsyncWaiter::GetCloudIdentifiers(
    ::blink::mojom::FileSystemAccessErrorPtr* out_result, std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr>* out_cloud_identifiers) {
  base::RunLoop loop;
  proxy_->GetCloudIdentifiers(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr>* out_cloud_identifiers
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr> cloud_identifiers) {*out_result = std::move(result);*out_cloud_identifiers = std::move(cloud_identifiers);
            loop->Quit();
          },
          &loop,
          out_result,
          out_cloud_identifiers));
  loop.Run();
}








}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif