// third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_cloud_identifier.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_permission_mode.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-shared.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::FileSystemAccessEntryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FileSystemAccessEntryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FileSystemAccessEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::entry_handle(input)) in_entry_handle = Traits::entry_handle(input);
      mojo::internal::MessageFragment<decltype(fragment->entry_handle)>
          entry_handle_fragment(fragment.message());
      entry_handle_fragment.Claim(&fragment->entry_handle);
      
      mojo::internal::Serialize<::blink::mojom::FileSystemAccessHandleDataView, send_validation>(
        in_entry_handle,
        entry_handle_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->entry_handle.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null entry_handle in FileSystemAccessEntry struct");

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in FileSystemAccessEntry struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::FileSystemAccessHandleDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::FileSystemAccessHandleDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::FileSystemAccessHandle_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::FileSystemAccessHandleDataView::Tag::kFile: {
    decltype(Traits::file(input))
    in_file = Traits::file(input);
        
mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessFileHandleInterfaceBase>, send_validation>(
  in_file,
  &fragment->data.f_file,
  &fragment.message());
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_file)),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
  "null file in FileSystemAccessHandle union");
    break;
  }
  case ::blink::mojom::FileSystemAccessHandleDataView::Tag::kDirectory: {
    decltype(Traits::directory(input))
    in_directory = Traits::directory(input);
        
mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessDirectoryHandleInterfaceBase>, send_validation>(
  in_directory,
  &fragment->data.f_directory,
  &fragment.message());
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_directory)),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
  "null directory in FileSystemAccessHandle union");
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_SEND_VALIDATION_H_