// third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.UnguessableToken');






goog.provide('blink.mojom.FileSystemAccessDataTransferToken');
goog.provide('blink.mojom.FileSystemAccessDataTransferTokenReceiver');
goog.provide('blink.mojom.FileSystemAccessDataTransferTokenCallbackRouter');
goog.provide('blink.mojom.FileSystemAccessDataTransferTokenInterface');
goog.provide('blink.mojom.FileSystemAccessDataTransferTokenRemote');
goog.provide('blink.mojom.FileSystemAccessDataTransferTokenPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FileSystemAccessDataTransferTokenPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FileSystemAccessDataTransferToken.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.FileSystemAccessDataTransferTokenInterface = class {
  
  /**
   * @return {!Promise<{
        id: !mojoBase.mojom.UnguessableToken,
   *  }>}
   */

  getInternalId() {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessDataTransferTokenPendingReceiver } tokenClone
   */

  clone(tokenClone) {}
};

/**
 * @export
 * @implements { blink.mojom.FileSystemAccessDataTransferTokenInterface }
 */
blink.mojom.FileSystemAccessDataTransferTokenRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FileSystemAccessDataTransferTokenPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FileSystemAccessDataTransferTokenPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FileSystemAccessDataTransferTokenPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        id: !mojoBase.mojom.UnguessableToken,
   *  }>}
   */

  getInternalId() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_ParamsSpec.$,
        blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessDataTransferTokenPendingReceiver } tokenClone
   */

  clone(
      tokenClone) {
    this.proxy.sendMessage(
        1,
        blink.mojom.FileSystemAccessDataTransferToken_Clone_ParamsSpec.$,
        null,
        [
          tokenClone
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileSystemAccessDataTransferToken
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FileSystemAccessDataTransferTokenReceiver = class {
  /**
   * @param {!blink.mojom.FileSystemAccessDataTransferTokenInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FileSystemAccessDataTransferTokenRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FileSystemAccessDataTransferTokenRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessDataTransferTokenRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_ParamsSpec.$,
        blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_ResponseParamsSpec.$,
        impl.getInternalId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessDataTransferToken_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FileSystemAccessDataTransferToken = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessDataTransferToken";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FileSystemAccessDataTransferTokenRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FileSystemAccessDataTransferTokenRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileSystemAccessDataTransferToken
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FileSystemAccessDataTransferTokenCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FileSystemAccessDataTransferTokenRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessDataTransferTokenRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInternalId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_ParamsSpec.$,
        blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_ResponseParamsSpec.$,
        this.getInternalId.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessDataTransferToken_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDataTransferToken_Clone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDataTransferToken_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_ParamsSpec.$,
    'FileSystemAccessDataTransferToken_GetInternalId_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_Params');

/** @record */
blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_ResponseParamsSpec.$,
    'FileSystemAccessDataTransferToken_GetInternalId_ResponseParams',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessDataTransferToken_GetInternalId_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.id;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDataTransferToken_Clone_ParamsSpec.$,
    'FileSystemAccessDataTransferToken_Clone_Params',
    [
      mojo.internal.StructField(
        'tokenClone', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.FileSystemAccessDataTransferTokenPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessDataTransferToken_Clone_Params');

/** @record */
blink.mojom.FileSystemAccessDataTransferToken_Clone_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessDataTransferTokenPendingReceiver } */
    this.tokenClone;
  }
};

