// third_party/blink/public/mojom/file_system_access/file_system_access_cloud_identifier.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_CLOUD_IDENTIFIER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_CLOUD_IDENTIFIER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_cloud_identifier.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_cloud_identifier.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_cloud_identifier.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {





class PLATFORM_EXPORT FileSystemAccessCloudIdentifier {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemAccessCloudIdentifier, T>::value>;
  using DataView = FileSystemAccessCloudIdentifierDataView;
  using Data_ = internal::FileSystemAccessCloudIdentifier_Data;

  template <typename... Args>
  static FileSystemAccessCloudIdentifierPtr New(Args&&... args) {
    return FileSystemAccessCloudIdentifierPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemAccessCloudIdentifierPtr From(const U& u) {
    return mojo::TypeConverter<FileSystemAccessCloudIdentifierPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemAccessCloudIdentifier>::Convert(*this);
  }


  FileSystemAccessCloudIdentifier();

  FileSystemAccessCloudIdentifier(
      const ::blink::String& provider_name,
      const ::blink::String& id);


  ~FileSystemAccessCloudIdentifier();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemAccessCloudIdentifierPtr>
  FileSystemAccessCloudIdentifierPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemAccessCloudIdentifier::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemAccessCloudIdentifier::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemAccessCloudIdentifier::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessCloudIdentifier::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemAccessCloudIdentifier::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemAccessCloudIdentifier::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemAccessCloudIdentifier_UnserializedMessageContext<
            UserType, FileSystemAccessCloudIdentifier::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemAccessCloudIdentifier::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemAccessCloudIdentifier::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemAccessCloudIdentifier_UnserializedMessageContext<
            UserType, FileSystemAccessCloudIdentifier::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemAccessCloudIdentifier::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String provider_name;
  
  ::blink::String id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemAccessCloudIdentifier::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemAccessCloudIdentifier::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemAccessCloudIdentifier::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemAccessCloudIdentifier::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
FileSystemAccessCloudIdentifierPtr FileSystemAccessCloudIdentifier::Clone() const {
  return New(
      mojo::Clone(provider_name),
      mojo::Clone(id)
  );
}

template <typename T, FileSystemAccessCloudIdentifier::EnableIfSame<T>*>
bool FileSystemAccessCloudIdentifier::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->provider_name, other_struct.provider_name))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, FileSystemAccessCloudIdentifier::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.provider_name < rhs.provider_name)
    return true;
  if (rhs.provider_name < lhs.provider_name)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FileSystemAccessCloudIdentifier::DataView,
                                         ::blink::mojom::blink::FileSystemAccessCloudIdentifierPtr> {
  static bool IsNull(const ::blink::mojom::blink::FileSystemAccessCloudIdentifierPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FileSystemAccessCloudIdentifierPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::FileSystemAccessCloudIdentifier::provider_name)& provider_name(
      const ::blink::mojom::blink::FileSystemAccessCloudIdentifierPtr& input) {
    return input->provider_name;
  }

  static const decltype(::blink::mojom::blink::FileSystemAccessCloudIdentifier::id)& id(
      const ::blink::mojom::blink::FileSystemAccessCloudIdentifierPtr& input) {
    return input->id;
  }

  static bool Read(::blink::mojom::blink::FileSystemAccessCloudIdentifier::DataView input, ::blink::mojom::blink::FileSystemAccessCloudIdentifierPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_CLOUD_IDENTIFIER_MOJOM_BLINK_H_