// third_party/blink/public/mojom/file_system_access/file_system_access_access_handle_host.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/file_system_access/file_system_access_access_handle_host.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function FileSystemAccessAccessHandleHost_Close_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessAccessHandleHost_Close_Params.prototype.initDefaults_ = function() {
  };
  FileSystemAccessAccessHandleHost_Close_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessAccessHandleHost_Close_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessAccessHandleHost_Close_Params.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessAccessHandleHost_Close_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessAccessHandleHost_Close_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessAccessHandleHost_Close_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessAccessHandleHost_Close_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessAccessHandleHost_Close_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessAccessHandleHost_Close_ResponseParams.prototype.initDefaults_ = function() {
  };
  FileSystemAccessAccessHandleHost_Close_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessAccessHandleHost_Close_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessAccessHandleHost_Close_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessAccessHandleHost_Close_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessAccessHandleHost_Close_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessAccessHandleHost_Close_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessAccessHandleHost_Close_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  var kFileSystemAccessAccessHandleHost_Close_Name = 0;

  function FileSystemAccessAccessHandleHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FileSystemAccessAccessHandleHost,
                                                   handleOrPtrInfo);
  }

  function FileSystemAccessAccessHandleHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FileSystemAccessAccessHandleHost, associatedInterfacePtrInfo);
  }

  FileSystemAccessAccessHandleHostAssociatedPtr.prototype =
      Object.create(FileSystemAccessAccessHandleHostPtr.prototype);
  FileSystemAccessAccessHandleHostAssociatedPtr.prototype.constructor =
      FileSystemAccessAccessHandleHostAssociatedPtr;

  function FileSystemAccessAccessHandleHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  FileSystemAccessAccessHandleHostPtr.prototype.close = function() {
    return FileSystemAccessAccessHandleHostProxy.prototype.close
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessAccessHandleHostProxy.prototype.close = function() {
    var params_ = new FileSystemAccessAccessHandleHost_Close_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessAccessHandleHost_Close_Name,
          codec.align(FileSystemAccessAccessHandleHost_Close_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessAccessHandleHost_Close_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessAccessHandleHost_Close_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function FileSystemAccessAccessHandleHostStub(delegate) {
    this.delegate_ = delegate;
  }
  FileSystemAccessAccessHandleHostStub.prototype.close = function() {
    return this.delegate_ && this.delegate_.close && this.delegate_.close();
  }

  FileSystemAccessAccessHandleHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  FileSystemAccessAccessHandleHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessAccessHandleHost_Close_Name:
      var params = reader.decodeStruct(FileSystemAccessAccessHandleHost_Close_Params);
      this.close().then(function(response) {
        var responseParams =
            new FileSystemAccessAccessHandleHost_Close_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessAccessHandleHost_Close_Name,
            codec.align(FileSystemAccessAccessHandleHost_Close_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessAccessHandleHost_Close_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateFileSystemAccessAccessHandleHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFileSystemAccessAccessHandleHost_Close_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessAccessHandleHost_Close_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFileSystemAccessAccessHandleHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kFileSystemAccessAccessHandleHost_Close_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessAccessHandleHost_Close_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var FileSystemAccessAccessHandleHost = {
    name: 'blink.mojom.FileSystemAccessAccessHandleHost',
    kVersion: 0,
    ptrClass: FileSystemAccessAccessHandleHostPtr,
    proxyClass: FileSystemAccessAccessHandleHostProxy,
    stubClass: FileSystemAccessAccessHandleHostStub,
    validateRequest: validateFileSystemAccessAccessHandleHostRequest,
    validateResponse: validateFileSystemAccessAccessHandleHostResponse,
  };
  FileSystemAccessAccessHandleHostStub.prototype.validator = validateFileSystemAccessAccessHandleHostRequest;
  FileSystemAccessAccessHandleHostProxy.prototype.validator = validateFileSystemAccessAccessHandleHostResponse;
  exports.FileSystemAccessAccessHandleHost = FileSystemAccessAccessHandleHost;
  exports.FileSystemAccessAccessHandleHostPtr = FileSystemAccessAccessHandleHostPtr;
  exports.FileSystemAccessAccessHandleHostAssociatedPtr = FileSystemAccessAccessHandleHostAssociatedPtr;
})();