// third_party/blink/public/mojom/file/file_utilities.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.FileInfo');
goog.require('mojoBase.mojom.FilePath');






goog.provide('blink.mojom.FileUtilitiesHost');
goog.provide('blink.mojom.FileUtilitiesHostReceiver');
goog.provide('blink.mojom.FileUtilitiesHostCallbackRouter');
goog.provide('blink.mojom.FileUtilitiesHostInterface');
goog.provide('blink.mojom.FileUtilitiesHostRemote');
goog.provide('blink.mojom.FileUtilitiesHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FileUtilitiesHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FileUtilitiesHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.FileUtilitiesHostInterface = class {
  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @return {!Promise<{
        result: ?mojoBase.mojom.FileInfo,
   *  }>}
   */

  getFileInfo(path) {}
};

/**
 * @export
 * @implements { blink.mojom.FileUtilitiesHostInterface }
 */
blink.mojom.FileUtilitiesHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FileUtilitiesHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FileUtilitiesHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FileUtilitiesHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @return {!Promise<{
        result: ?mojoBase.mojom.FileInfo,
   *  }>}
   */

  getFileInfo(
      path) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.FileUtilitiesHost_GetFileInfo_ParamsSpec.$,
        blink.mojom.FileUtilitiesHost_GetFileInfo_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileUtilitiesHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FileUtilitiesHostReceiver = class {
  /**
   * @param {!blink.mojom.FileUtilitiesHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FileUtilitiesHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FileUtilitiesHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileUtilitiesHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileUtilitiesHost_GetFileInfo_ParamsSpec.$,
        blink.mojom.FileUtilitiesHost_GetFileInfo_ResponseParamsSpec.$,
        impl.getFileInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FileUtilitiesHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileUtilitiesHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FileUtilitiesHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FileUtilitiesHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileUtilitiesHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FileUtilitiesHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FileUtilitiesHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileUtilitiesHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFileInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileUtilitiesHost_GetFileInfo_ParamsSpec.$,
        blink.mojom.FileUtilitiesHost_GetFileInfo_ResponseParamsSpec.$,
        this.getFileInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.FileUtilitiesHost_GetFileInfo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileUtilitiesHost_GetFileInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileUtilitiesHost_GetFileInfo_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileUtilitiesHost_GetFileInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FileUtilitiesHost_GetFileInfo_ParamsSpec.$,
    'FileUtilitiesHost_GetFileInfo_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileUtilitiesHost_GetFileInfo_Params');

/** @record */
blink.mojom.FileUtilitiesHost_GetFileInfo_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
  }
};



mojo.internal.Struct(
    blink.mojom.FileUtilitiesHost_GetFileInfo_ResponseParamsSpec.$,
    'FileUtilitiesHost_GetFileInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase.mojom.FileInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileUtilitiesHost_GetFileInfo_ResponseParams');

/** @record */
blink.mojom.FileUtilitiesHost_GetFileInfo_ResponseParams = class {
  constructor() {
    /** @export { (mojoBase.mojom.FileInfo|undefined) } */
    this.result;
  }
};

