// third_party/blink/public/mojom/fetch/fetch_api_response.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_RESPONSE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_RESPONSE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/network_types.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_error_type.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FetchAPIResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FetchAPIResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FetchAPIResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url_list(input)) in_url_list = Traits::url_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url_list)::BaseType>
        url_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& url_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
      in_url_list,
      url_list_fragment,
      &url_list_validate_params);

    fragment->url_list.Set(
        url_list_fragment.is_null() ? nullptr : url_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url_list in FetchAPIResponse struct");

    fragment->status_code = Traits::status_code(input);

    decltype(Traits::status_text(input)) in_status_text = Traits::status_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->status_text)::BaseType> status_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_status_text,
      status_text_fragment);

    fragment->status_text.Set(
        status_text_fragment.is_null() ? nullptr : status_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->status_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status_text in FetchAPIResponse struct");

    
    mojo::internal::Serialize<::network::mojom::FetchResponseType>(
      Traits::response_type(input),
      &fragment->response_type);

    fragment->padding = Traits::padding(input);

    
    mojo::internal::Serialize<::network::mojom::FetchResponseSource>(
      Traits::response_source(input),
      &fragment->response_source);

    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers)::BaseType>
        headers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
      in_headers,
      headers_fragment,
      &headers_validate_params);

    fragment->headers.Set(
        headers_fragment.is_null() ? nullptr : headers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->headers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in FetchAPIResponse struct");

    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_mime_type,
      mime_type_fragment);

    fragment->mime_type.Set(
        mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

    decltype(Traits::request_method(input)) in_request_method = Traits::request_method(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_method)::BaseType> request_method_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_request_method,
      request_method_fragment);

    fragment->request_method.Set(
        request_method_fragment.is_null() ? nullptr : request_method_fragment.data());

    decltype(Traits::blob(input)) in_blob = Traits::blob(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->blob)::BaseType> blob_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::SerializedBlobDataView>(
      in_blob,
      blob_fragment);

    fragment->blob.Set(
        blob_fragment.is_null() ? nullptr : blob_fragment.data());

    
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerResponseError>(
      Traits::error(input),
      &fragment->error);

    decltype(Traits::response_time(input)) in_response_time = Traits::response_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response_time)::BaseType> response_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_response_time,
      response_time_fragment);

    fragment->response_time.Set(
        response_time_fragment.is_null() ? nullptr : response_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->response_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_time in FetchAPIResponse struct");

    decltype(Traits::cache_storage_cache_name(input)) in_cache_storage_cache_name = Traits::cache_storage_cache_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cache_storage_cache_name)::BaseType> cache_storage_cache_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_cache_storage_cache_name,
      cache_storage_cache_name_fragment);

    fragment->cache_storage_cache_name.Set(
        cache_storage_cache_name_fragment.is_null() ? nullptr : cache_storage_cache_name_fragment.data());

    decltype(Traits::cors_exposed_header_names(input)) in_cors_exposed_header_names = Traits::cors_exposed_header_names(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cors_exposed_header_names)::BaseType>
        cors_exposed_header_names_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cors_exposed_header_names_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_cors_exposed_header_names,
      cors_exposed_header_names_fragment,
      &cors_exposed_header_names_validate_params);

    fragment->cors_exposed_header_names.Set(
        cors_exposed_header_names_fragment.is_null() ? nullptr : cors_exposed_header_names_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cors_exposed_header_names.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cors_exposed_header_names in FetchAPIResponse struct");

    decltype(Traits::side_data_blob(input)) in_side_data_blob = Traits::side_data_blob(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->side_data_blob)::BaseType> side_data_blob_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::SerializedBlobDataView>(
      in_side_data_blob,
      side_data_blob_fragment);

    fragment->side_data_blob.Set(
        side_data_blob_fragment.is_null() ? nullptr : side_data_blob_fragment.data());

    decltype(Traits::side_data_blob_for_cache_put(input)) in_side_data_blob_for_cache_put = Traits::side_data_blob_for_cache_put(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->side_data_blob_for_cache_put)::BaseType> side_data_blob_for_cache_put_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::SerializedBlobDataView>(
      in_side_data_blob_for_cache_put,
      side_data_blob_for_cache_put_fragment);

    fragment->side_data_blob_for_cache_put.Set(
        side_data_blob_for_cache_put_fragment.is_null() ? nullptr : side_data_blob_for_cache_put_fragment.data());

    decltype(Traits::parsed_headers(input)) in_parsed_headers = Traits::parsed_headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parsed_headers)::BaseType> parsed_headers_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ParsedHeadersDataView>(
      in_parsed_headers,
      parsed_headers_fragment);

    fragment->parsed_headers.Set(
        parsed_headers_fragment.is_null() ? nullptr : parsed_headers_fragment.data());

    
    mojo::internal::Serialize<::network::mojom::ConnectionInfo>(
      Traits::connection_info(input),
      &fragment->connection_info);

    decltype(Traits::alpn_negotiated_protocol(input)) in_alpn_negotiated_protocol = Traits::alpn_negotiated_protocol(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->alpn_negotiated_protocol)::BaseType> alpn_negotiated_protocol_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_alpn_negotiated_protocol,
      alpn_negotiated_protocol_fragment);

    fragment->alpn_negotiated_protocol.Set(
        alpn_negotiated_protocol_fragment.is_null() ? nullptr : alpn_negotiated_protocol_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->alpn_negotiated_protocol.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alpn_negotiated_protocol in FetchAPIResponse struct");

    fragment->was_fetched_via_spdy = Traits::was_fetched_via_spdy(input);

    fragment->has_range_requested = Traits::has_range_requested(input);

    decltype(Traits::auth_challenge_info(input)) in_auth_challenge_info = Traits::auth_challenge_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->auth_challenge_info)::BaseType> auth_challenge_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::AuthChallengeInfoDataView>(
      in_auth_challenge_info,
      auth_challenge_info_fragment);

    fragment->auth_challenge_info.Set(
        auth_challenge_info_fragment.is_null() ? nullptr : auth_challenge_info_fragment.data());

    fragment->request_include_credentials = Traits::request_include_credentials(input);
  }

  static bool Deserialize(::blink::mojom::internal::FetchAPIResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FetchAPIResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void FetchAPIResponseDataView::GetUrlListDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->url_list.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}
inline void FetchAPIResponseDataView::GetStatusTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->status_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FetchAPIResponseDataView::GetHeadersDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->headers.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, message_);
}
inline void FetchAPIResponseDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FetchAPIResponseDataView::GetRequestMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->request_method.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FetchAPIResponseDataView::GetBlobDataView(
    ::blink::mojom::SerializedBlobDataView* output) {
  auto pointer = data_->blob.Get();
  *output = ::blink::mojom::SerializedBlobDataView(pointer, message_);
}
inline void FetchAPIResponseDataView::GetResponseTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->response_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void FetchAPIResponseDataView::GetCacheStorageCacheNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cache_storage_cache_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FetchAPIResponseDataView::GetCorsExposedHeaderNamesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->cors_exposed_header_names.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void FetchAPIResponseDataView::GetSideDataBlobDataView(
    ::blink::mojom::SerializedBlobDataView* output) {
  auto pointer = data_->side_data_blob.Get();
  *output = ::blink::mojom::SerializedBlobDataView(pointer, message_);
}
inline void FetchAPIResponseDataView::GetSideDataBlobForCachePutDataView(
    ::blink::mojom::SerializedBlobDataView* output) {
  auto pointer = data_->side_data_blob_for_cache_put.Get();
  *output = ::blink::mojom::SerializedBlobDataView(pointer, message_);
}
inline void FetchAPIResponseDataView::GetParsedHeadersDataView(
    ::network::mojom::ParsedHeadersDataView* output) {
  auto pointer = data_->parsed_headers.Get();
  *output = ::network::mojom::ParsedHeadersDataView(pointer, message_);
}
inline void FetchAPIResponseDataView::GetAlpnNegotiatedProtocolDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->alpn_negotiated_protocol.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FetchAPIResponseDataView::GetAuthChallengeInfoDataView(
    ::network::mojom::AuthChallengeInfoDataView* output) {
  auto pointer = data_->auth_challenge_info.Get();
  *output = ::network::mojom::AuthChallengeInfoDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_RESPONSE_MOJOM_SHARED_H_