// third_party/blink/public/mojom/fetch/fetch_api_response.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_RESPONSE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_RESPONSE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/network_types.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_error_type.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class FetchAPIResponseDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FetchAPIResponseDataView> {
  using Data = ::blink::mojom::internal::FetchAPIResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class FetchAPIResponseDataView {
 public:
  FetchAPIResponseDataView() = default;

  FetchAPIResponseDataView(
      internal::FetchAPIResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlListDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlList(UserType* output) {
    
    auto* pointer = data_->url_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  uint16_t status_code() const {
    return data_->status_code;
  }
  inline void GetStatusTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatusText(UserType* output) {
    
    auto* pointer = data_->status_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResponseType(UserType* output) const {
    auto data_value = data_->response_type;
    return mojo::internal::Deserialize<::network::mojom::FetchResponseType>(
        data_value, output);
  }
  ::network::mojom::FetchResponseType response_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::FetchResponseType>(data_->response_type));
  }
  int64_t padding() const {
    return data_->padding;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResponseSource(UserType* output) const {
    auto data_value = data_->response_source;
    return mojo::internal::Deserialize<::network::mojom::FetchResponseSource>(
        data_value, output);
  }
  ::network::mojom::FetchResponseSource response_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::FetchResponseSource>(data_->response_source));
  }
  inline void GetHeadersDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `mime_type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMimeType` instead "
    "of `ReadMimeType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRequestMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestMethod(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `request_method` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestMethod` instead "
    "of `ReadRequestMethod if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request_method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBlobDataView(
      ::blink::mojom::SerializedBlobDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlob(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SerializedBlobDataView, UserType>(),
    "Attempting to read the optional `blob` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlob` instead "
    "of `ReadBlob if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blob.Get();
    return mojo::internal::Deserialize<::blink::mojom::SerializedBlobDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerResponseError>(
        data_value, output);
  }
  ::blink::mojom::ServiceWorkerResponseError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ServiceWorkerResponseError>(data_->error));
  }
  inline void GetResponseTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponseTime(UserType* output) {
    
    auto* pointer = data_->response_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetCacheStorageCacheNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCacheStorageCacheName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `cache_storage_cache_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCacheStorageCacheName` instead "
    "of `ReadCacheStorageCacheName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cache_storage_cache_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCorsExposedHeaderNamesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCorsExposedHeaderNames(UserType* output) {
    
    auto* pointer = data_->cors_exposed_header_names.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetSideDataBlobDataView(
      ::blink::mojom::SerializedBlobDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSideDataBlob(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SerializedBlobDataView, UserType>(),
    "Attempting to read the optional `side_data_blob` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSideDataBlob` instead "
    "of `ReadSideDataBlob if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->side_data_blob.Get();
    return mojo::internal::Deserialize<::blink::mojom::SerializedBlobDataView>(
        pointer, output, message_);
  }
  inline void GetSideDataBlobForCachePutDataView(
      ::blink::mojom::SerializedBlobDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSideDataBlobForCachePut(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SerializedBlobDataView, UserType>(),
    "Attempting to read the optional `side_data_blob_for_cache_put` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSideDataBlobForCachePut` instead "
    "of `ReadSideDataBlobForCachePut if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->side_data_blob_for_cache_put.Get();
    return mojo::internal::Deserialize<::blink::mojom::SerializedBlobDataView>(
        pointer, output, message_);
  }
  inline void GetParsedHeadersDataView(
      ::network::mojom::ParsedHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParsedHeaders(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ParsedHeadersDataView, UserType>(),
    "Attempting to read the optional `parsed_headers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParsedHeaders` instead "
    "of `ReadParsedHeaders if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parsed_headers.Get();
    return mojo::internal::Deserialize<::network::mojom::ParsedHeadersDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadConnectionInfo(UserType* output) const {
    auto data_value = data_->connection_info;
    return mojo::internal::Deserialize<::network::mojom::ConnectionInfo>(
        data_value, output);
  }
  ::network::mojom::ConnectionInfo connection_info() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ConnectionInfo>(data_->connection_info));
  }
  inline void GetAlpnNegotiatedProtocolDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlpnNegotiatedProtocol(UserType* output) {
    
    auto* pointer = data_->alpn_negotiated_protocol.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool was_fetched_via_spdy() const {
    return data_->was_fetched_via_spdy;
  }
  bool has_range_requested() const {
    return data_->has_range_requested;
  }
  inline void GetAuthChallengeInfoDataView(
      ::network::mojom::AuthChallengeInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuthChallengeInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::AuthChallengeInfoDataView, UserType>(),
    "Attempting to read the optional `auth_challenge_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuthChallengeInfo` instead "
    "of `ReadAuthChallengeInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auth_challenge_info.Get();
    return mojo::internal::Deserialize<::network::mojom::AuthChallengeInfoDataView>(
        pointer, output, message_);
  }
  bool request_include_credentials() const {
    return data_->request_include_credentials;
  }
 private:
  internal::FetchAPIResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_RESPONSE_MOJOM_DATA_VIEW_H_