// third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FENCED_FRAME_FENCED_FRAME_CONFIG_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FENCED_FRAME_FENCED_FRAME_CONFIG_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-shared-internal.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy_feature.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"


namespace blink::mojom {
class AdAuctionDataDataView;

class URNConfigPairDataView;

class SharedStorageBudgetMetadataDataView;

class ParentPermissionsInfoDataView;

class FencedFrameConfigDataView;

class FencedFramePropertiesDataView;

class PotentiallyOpaqueURLDataView;
class PotentiallyOpaqueSizeDataView;
class PotentiallyOpaqueBoolDataView;
class PotentiallyOpaqueAdAuctionDataDataView;
class PotentiallyOpaqueConfigVectorDataView;
class PotentiallyOpaqueURNConfigVectorDataView;
class PotentiallyOpaqueSharedStorageBudgetMetadataDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AdAuctionDataDataView> {
  using Data = ::blink::mojom::internal::AdAuctionData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::URNConfigPairDataView> {
  using Data = ::blink::mojom::internal::URNConfigPair_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SharedStorageBudgetMetadataDataView> {
  using Data = ::blink::mojom::internal::SharedStorageBudgetMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ParentPermissionsInfoDataView> {
  using Data = ::blink::mojom::internal::ParentPermissionsInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FencedFrameConfigDataView> {
  using Data = ::blink::mojom::internal::FencedFrameConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FencedFramePropertiesDataView> {
  using Data = ::blink::mojom::internal::FencedFrameProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PotentiallyOpaqueURLDataView> {
  using Data = ::blink::mojom::internal::PotentiallyOpaqueURL_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::PotentiallyOpaqueSizeDataView> {
  using Data = ::blink::mojom::internal::PotentiallyOpaqueSize_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::PotentiallyOpaqueBoolDataView> {
  using Data = ::blink::mojom::internal::PotentiallyOpaqueBool_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView> {
  using Data = ::blink::mojom::internal::PotentiallyOpaqueAdAuctionData_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::PotentiallyOpaqueConfigVectorDataView> {
  using Data = ::blink::mojom::internal::PotentiallyOpaqueConfigVector_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::PotentiallyOpaqueURNConfigVectorDataView> {
  using Data = ::blink::mojom::internal::PotentiallyOpaqueURNConfigVector_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView> {
  using Data = ::blink::mojom::internal::PotentiallyOpaqueSharedStorageBudgetMetadata_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class ReportingDestination : int32_t {
  
  kBuyer = 0,
  
  kSeller = 1,
  
  kComponentSeller = 2,
  
  kSharedStorageSelectUrl = 3,
  
  kDirectSeller = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ReportingDestination value);
inline bool IsKnownEnumValue(ReportingDestination value) {
  return internal::ReportingDestination_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DeprecatedFencedFrameMode : int32_t {
  
  kDefault = 0,
  
  kOpaqueAds = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, DeprecatedFencedFrameMode value);
inline bool IsKnownEnumValue(DeprecatedFencedFrameMode value) {
  return internal::DeprecatedFencedFrameMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Opaque : int32_t {
  
  kOpaque = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, Opaque value);
inline bool IsKnownEnumValue(Opaque value) {
  return internal::Opaque_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AutomaticBeaconType : int32_t {
  
  kDeprecatedTopNavigation = 0,
  
  kTopNavigationStart = 1,
  
  kTopNavigationCommit = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AutomaticBeaconType value);
inline bool IsKnownEnumValue(AutomaticBeaconType value) {
  return internal::AutomaticBeaconType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class AdAuctionDataDataView {
 public:
  AdAuctionDataDataView() = default;

  AdAuctionDataDataView(
      internal::AdAuctionData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInterestGroupOwnerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterestGroupOwner(UserType* output) {
    
    auto* pointer = data_->interest_group_owner.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetInterestGroupNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterestGroupName(UserType* output) {
    
    auto* pointer = data_->interest_group_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AdAuctionData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URNConfigPairDataView {
 public:
  URNConfigPairDataView() = default;

  URNConfigPairDataView(
      internal::URNConfigPair_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrnDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrn(UserType* output) {
    
    auto* pointer = data_->urn.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetConfigDataView(
      FencedFrameConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::blink::mojom::FencedFrameConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::URNConfigPair_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedStorageBudgetMetadataDataView {
 public:
  SharedStorageBudgetMetadataDataView() = default;

  SharedStorageBudgetMetadataDataView(
      internal::SharedStorageBudgetMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSiteDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSite(UserType* output) {
    
    auto* pointer = data_->site.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  double budget_to_charge() const {
    return data_->budget_to_charge;
  }
  bool top_navigated() const {
    return data_->top_navigated;
  }
 private:
  internal::SharedStorageBudgetMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ParentPermissionsInfoDataView {
 public:
  ParentPermissionsInfoDataView() = default;

  ParentPermissionsInfoDataView(
      internal::ParentPermissionsInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParsedPermissionsPolicyDataView(
      mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParsedPermissionsPolicy(UserType* output) {
    
    auto* pointer = data_->parsed_permissions_policy.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
        pointer, output, message_);
  }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::ParentPermissionsInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FencedFrameConfigDataView {
 public:
  FencedFrameConfigDataView() = default;

  FencedFrameConfigDataView(
      internal::FencedFrameConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMappedUrlDataView(
      PotentiallyOpaqueURLDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMappedUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueURLDataView, UserType>(),
    "Attempting to read the optional `mapped_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMappedUrl` instead "
    "of `ReadMappedUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->mapped_url.is_null() ? &data_->mapped_url : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueURLDataView>(
        pointer, output, message_);
  }
  inline void GetContainerSizeDataView(
      PotentiallyOpaqueSizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContainerSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueSizeDataView, UserType>(),
    "Attempting to read the optional `container_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContainerSize` instead "
    "of `ReadContainerSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->container_size.is_null() ? &data_->container_size : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueSizeDataView>(
        pointer, output, message_);
  }
  inline void GetContentSizeDataView(
      PotentiallyOpaqueSizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueSizeDataView, UserType>(),
    "Attempting to read the optional `content_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContentSize` instead "
    "of `ReadContentSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->content_size.is_null() ? &data_->content_size : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueSizeDataView>(
        pointer, output, message_);
  }
  inline void GetDeprecatedShouldFreezeInitialSizeDataView(
      PotentiallyOpaqueBoolDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeprecatedShouldFreezeInitialSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueBoolDataView, UserType>(),
    "Attempting to read the optional `deprecated_should_freeze_initial_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDeprecatedShouldFreezeInitialSize` instead "
    "of `ReadDeprecatedShouldFreezeInitialSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->deprecated_should_freeze_initial_size.is_null() ? &data_->deprecated_should_freeze_initial_size : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueBoolDataView>(
        pointer, output, message_);
  }
  inline void GetAdAuctionDataDataView(
      PotentiallyOpaqueAdAuctionDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdAuctionData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView, UserType>(),
    "Attempting to read the optional `ad_auction_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdAuctionData` instead "
    "of `ReadAdAuctionData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->ad_auction_data.is_null() ? &data_->ad_auction_data : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView>(
        pointer, output, message_);
  }
  inline void GetNestedConfigsDataView(
      PotentiallyOpaqueConfigVectorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNestedConfigs(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueConfigVectorDataView, UserType>(),
    "Attempting to read the optional `nested_configs` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNestedConfigs` instead "
    "of `ReadNestedConfigs if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->nested_configs.is_null() ? &data_->nested_configs : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueConfigVectorDataView>(
        pointer, output, message_);
  }
  inline void GetSharedStorageBudgetMetadataDataView(
      PotentiallyOpaqueSharedStorageBudgetMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedStorageBudgetMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView, UserType>(),
    "Attempting to read the optional `shared_storage_budget_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSharedStorageBudgetMetadata` instead "
    "of `ReadSharedStorageBudgetMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->shared_storage_budget_metadata.is_null() ? &data_->shared_storage_budget_metadata : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetUrnUuidDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrnUuid(UserType* output) {
    
    auto* pointer = data_->urn_uuid.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::blink::mojom::DeprecatedFencedFrameMode>(
        data_value, output);
  }
  DeprecatedFencedFrameMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DeprecatedFencedFrameMode>(data_->mode));
  }
  inline void GetEffectiveEnabledPermissionsDataView(
      mojo::ArrayDataView<::network::mojom::PermissionsPolicyFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEffectiveEnabledPermissions(UserType* output) {
    
    auto* pointer = data_->effective_enabled_permissions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::PermissionsPolicyFeature>>(
        pointer, output, message_);
  }
  inline void GetParentPermissionsInfoDataView(
      ParentPermissionsInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParentPermissionsInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ParentPermissionsInfoDataView, UserType>(),
    "Attempting to read the optional `parent_permissions_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParentPermissionsInfo` instead "
    "of `ReadParentPermissionsInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parent_permissions_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::ParentPermissionsInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::FencedFrameConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FencedFramePropertiesDataView {
 public:
  FencedFramePropertiesDataView() = default;

  FencedFramePropertiesDataView(
      internal::FencedFrameProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMappedUrlDataView(
      PotentiallyOpaqueURLDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMappedUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueURLDataView, UserType>(),
    "Attempting to read the optional `mapped_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMappedUrl` instead "
    "of `ReadMappedUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->mapped_url.is_null() ? &data_->mapped_url : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueURLDataView>(
        pointer, output, message_);
  }
  inline void GetContainerSizeDataView(
      PotentiallyOpaqueSizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContainerSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueSizeDataView, UserType>(),
    "Attempting to read the optional `container_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContainerSize` instead "
    "of `ReadContainerSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->container_size.is_null() ? &data_->container_size : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueSizeDataView>(
        pointer, output, message_);
  }
  inline void GetContentSizeDataView(
      PotentiallyOpaqueSizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueSizeDataView, UserType>(),
    "Attempting to read the optional `content_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContentSize` instead "
    "of `ReadContentSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->content_size.is_null() ? &data_->content_size : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueSizeDataView>(
        pointer, output, message_);
  }
  inline void GetDeprecatedShouldFreezeInitialSizeDataView(
      PotentiallyOpaqueBoolDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeprecatedShouldFreezeInitialSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueBoolDataView, UserType>(),
    "Attempting to read the optional `deprecated_should_freeze_initial_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDeprecatedShouldFreezeInitialSize` instead "
    "of `ReadDeprecatedShouldFreezeInitialSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->deprecated_should_freeze_initial_size.is_null() ? &data_->deprecated_should_freeze_initial_size : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueBoolDataView>(
        pointer, output, message_);
  }
  inline void GetAdAuctionDataDataView(
      PotentiallyOpaqueAdAuctionDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdAuctionData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView, UserType>(),
    "Attempting to read the optional `ad_auction_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdAuctionData` instead "
    "of `ReadAdAuctionData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->ad_auction_data.is_null() ? &data_->ad_auction_data : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView>(
        pointer, output, message_);
  }
  inline void GetNestedUrnConfigPairsDataView(
      PotentiallyOpaqueURNConfigVectorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNestedUrnConfigPairs(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueURNConfigVectorDataView, UserType>(),
    "Attempting to read the optional `nested_urn_config_pairs` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNestedUrnConfigPairs` instead "
    "of `ReadNestedUrnConfigPairs if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->nested_urn_config_pairs.is_null() ? &data_->nested_urn_config_pairs : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueURNConfigVectorDataView>(
        pointer, output, message_);
  }
  inline void GetSharedStorageBudgetMetadataDataView(
      PotentiallyOpaqueSharedStorageBudgetMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedStorageBudgetMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView, UserType>(),
    "Attempting to read the optional `shared_storage_budget_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSharedStorageBudgetMetadata` instead "
    "of `ReadSharedStorageBudgetMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->shared_storage_budget_metadata.is_null() ? &data_->shared_storage_budget_metadata : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::blink::mojom::DeprecatedFencedFrameMode>(
        data_value, output);
  }
  DeprecatedFencedFrameMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DeprecatedFencedFrameMode>(data_->mode));
  }
  inline void GetEffectiveEnabledPermissionsDataView(
      mojo::ArrayDataView<::network::mojom::PermissionsPolicyFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEffectiveEnabledPermissions(UserType* output) {
    
    auto* pointer = data_->effective_enabled_permissions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::PermissionsPolicyFeature>>(
        pointer, output, message_);
  }
  inline void GetParentPermissionsInfoDataView(
      ParentPermissionsInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParentPermissionsInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ParentPermissionsInfoDataView, UserType>(),
    "Attempting to read the optional `parent_permissions_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParentPermissionsInfo` instead "
    "of `ReadParentPermissionsInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parent_permissions_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::ParentPermissionsInfoDataView>(
        pointer, output, message_);
  }
  bool can_disable_untrusted_network() const {
    return data_->can_disable_untrusted_network;
  }
  bool is_cross_origin_content() const {
    return data_->is_cross_origin_content;
  }
  bool allow_cross_origin_event_reporting() const {
    return data_->allow_cross_origin_event_reporting;
  }
 private:
  internal::FencedFrameProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PotentiallyOpaqueURLDataView {
 public:
  using Tag = internal::PotentiallyOpaqueURL_Data::PotentiallyOpaqueURL_Tag;

  PotentiallyOpaqueURLDataView() = default;

  PotentiallyOpaqueURLDataView(
      internal::PotentiallyOpaqueURL_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transparent() const { return data_->tag == Tag::kTransparent; }
  inline void GetTransparentDataView(
      ::url::mojom::UrlDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTransparent(UserType* output) const {
    
    CHECK(is_transparent());
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        data_->data.f_transparent.Get(), output, message_);
  }
  bool is_opaque() const { return data_->tag == Tag::kOpaque; }
  template <typename UserType>
  [[nodiscard]] bool ReadOpaque(UserType* output) const {
    CHECK(is_opaque());
    return mojo::internal::Deserialize<::blink::mojom::Opaque>(
        data_->data.f_opaque, output);
  }
  Opaque opaque() const {
    CHECK(is_opaque());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Opaque>(data_->data.f_opaque));
  }

 private:
  internal::PotentiallyOpaqueURL_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class PotentiallyOpaqueSizeDataView {
 public:
  using Tag = internal::PotentiallyOpaqueSize_Data::PotentiallyOpaqueSize_Tag;

  PotentiallyOpaqueSizeDataView() = default;

  PotentiallyOpaqueSizeDataView(
      internal::PotentiallyOpaqueSize_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transparent() const { return data_->tag == Tag::kTransparent; }
  inline void GetTransparentDataView(
      ::gfx::mojom::SizeDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTransparent(UserType* output) const {
    
    CHECK(is_transparent());
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        data_->data.f_transparent.Get(), output, message_);
  }
  bool is_opaque() const { return data_->tag == Tag::kOpaque; }
  template <typename UserType>
  [[nodiscard]] bool ReadOpaque(UserType* output) const {
    CHECK(is_opaque());
    return mojo::internal::Deserialize<::blink::mojom::Opaque>(
        data_->data.f_opaque, output);
  }
  Opaque opaque() const {
    CHECK(is_opaque());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Opaque>(data_->data.f_opaque));
  }

 private:
  internal::PotentiallyOpaqueSize_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class PotentiallyOpaqueBoolDataView {
 public:
  using Tag = internal::PotentiallyOpaqueBool_Data::PotentiallyOpaqueBool_Tag;

  PotentiallyOpaqueBoolDataView() = default;

  PotentiallyOpaqueBoolDataView(
      internal::PotentiallyOpaqueBool_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transparent() const { return data_->tag == Tag::kTransparent; }
  bool transparent() const {
    CHECK(is_transparent());
    return data_->data.f_transparent;
  }
  bool is_opaque() const { return data_->tag == Tag::kOpaque; }
  template <typename UserType>
  [[nodiscard]] bool ReadOpaque(UserType* output) const {
    CHECK(is_opaque());
    return mojo::internal::Deserialize<::blink::mojom::Opaque>(
        data_->data.f_opaque, output);
  }
  Opaque opaque() const {
    CHECK(is_opaque());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Opaque>(data_->data.f_opaque));
  }

 private:
  internal::PotentiallyOpaqueBool_Data* data_ = nullptr;
};



class PotentiallyOpaqueAdAuctionDataDataView {
 public:
  using Tag = internal::PotentiallyOpaqueAdAuctionData_Data::PotentiallyOpaqueAdAuctionData_Tag;

  PotentiallyOpaqueAdAuctionDataDataView() = default;

  PotentiallyOpaqueAdAuctionDataDataView(
      internal::PotentiallyOpaqueAdAuctionData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transparent() const { return data_->tag == Tag::kTransparent; }
  inline void GetTransparentDataView(
      AdAuctionDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTransparent(UserType* output) const {
    
    CHECK(is_transparent());
    return mojo::internal::Deserialize<::blink::mojom::AdAuctionDataDataView>(
        data_->data.f_transparent.Get(), output, message_);
  }
  bool is_opaque() const { return data_->tag == Tag::kOpaque; }
  template <typename UserType>
  [[nodiscard]] bool ReadOpaque(UserType* output) const {
    CHECK(is_opaque());
    return mojo::internal::Deserialize<::blink::mojom::Opaque>(
        data_->data.f_opaque, output);
  }
  Opaque opaque() const {
    CHECK(is_opaque());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Opaque>(data_->data.f_opaque));
  }

 private:
  internal::PotentiallyOpaqueAdAuctionData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class PotentiallyOpaqueConfigVectorDataView {
 public:
  using Tag = internal::PotentiallyOpaqueConfigVector_Data::PotentiallyOpaqueConfigVector_Tag;

  PotentiallyOpaqueConfigVectorDataView() = default;

  PotentiallyOpaqueConfigVectorDataView(
      internal::PotentiallyOpaqueConfigVector_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transparent() const { return data_->tag == Tag::kTransparent; }
  inline void GetTransparentDataView(
      mojo::ArrayDataView<FencedFrameConfigDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTransparent(UserType* output) const {
    
    CHECK(is_transparent());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::FencedFrameConfigDataView>>(
        data_->data.f_transparent.Get(), output, message_);
  }
  bool is_opaque() const { return data_->tag == Tag::kOpaque; }
  template <typename UserType>
  [[nodiscard]] bool ReadOpaque(UserType* output) const {
    CHECK(is_opaque());
    return mojo::internal::Deserialize<::blink::mojom::Opaque>(
        data_->data.f_opaque, output);
  }
  Opaque opaque() const {
    CHECK(is_opaque());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Opaque>(data_->data.f_opaque));
  }

 private:
  internal::PotentiallyOpaqueConfigVector_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class PotentiallyOpaqueURNConfigVectorDataView {
 public:
  using Tag = internal::PotentiallyOpaqueURNConfigVector_Data::PotentiallyOpaqueURNConfigVector_Tag;

  PotentiallyOpaqueURNConfigVectorDataView() = default;

  PotentiallyOpaqueURNConfigVectorDataView(
      internal::PotentiallyOpaqueURNConfigVector_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transparent() const { return data_->tag == Tag::kTransparent; }
  inline void GetTransparentDataView(
      mojo::ArrayDataView<URNConfigPairDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTransparent(UserType* output) const {
    
    CHECK(is_transparent());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::URNConfigPairDataView>>(
        data_->data.f_transparent.Get(), output, message_);
  }
  bool is_opaque() const { return data_->tag == Tag::kOpaque; }
  template <typename UserType>
  [[nodiscard]] bool ReadOpaque(UserType* output) const {
    CHECK(is_opaque());
    return mojo::internal::Deserialize<::blink::mojom::Opaque>(
        data_->data.f_opaque, output);
  }
  Opaque opaque() const {
    CHECK(is_opaque());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Opaque>(data_->data.f_opaque));
  }

 private:
  internal::PotentiallyOpaqueURNConfigVector_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class PotentiallyOpaqueSharedStorageBudgetMetadataDataView {
 public:
  using Tag = internal::PotentiallyOpaqueSharedStorageBudgetMetadata_Data::PotentiallyOpaqueSharedStorageBudgetMetadata_Tag;

  PotentiallyOpaqueSharedStorageBudgetMetadataDataView() = default;

  PotentiallyOpaqueSharedStorageBudgetMetadataDataView(
      internal::PotentiallyOpaqueSharedStorageBudgetMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transparent() const { return data_->tag == Tag::kTransparent; }
  inline void GetTransparentDataView(
      SharedStorageBudgetMetadataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTransparent(UserType* output) const {
    
    CHECK(is_transparent());
    return mojo::internal::Deserialize<::blink::mojom::SharedStorageBudgetMetadataDataView>(
        data_->data.f_transparent.Get(), output, message_);
  }
  bool is_opaque() const { return data_->tag == Tag::kOpaque; }
  template <typename UserType>
  [[nodiscard]] bool ReadOpaque(UserType* output) const {
    CHECK(is_opaque());
    return mojo::internal::Deserialize<::blink::mojom::Opaque>(
        data_->data.f_opaque, output);
  }
  Opaque opaque() const {
    CHECK(is_opaque());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Opaque>(data_->data.f_opaque));
  }

 private:
  internal::PotentiallyOpaqueSharedStorageBudgetMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FENCED_FRAME_FENCED_FRAME_CONFIG_MOJOM_DATA_VIEW_H_