// third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FencedFrameOwnerHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FencedFrameOwnerHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.FencedFrameOwnerHostInterface }
 */
blink.mojom.FencedFrameOwnerHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FencedFrameOwnerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FencedFrameOwnerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FencedFrameOwnerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !mojoBase.mojom.TimeTicks } navigationStartTime
   * @param { ?mojoBase.mojom.String16 } embedderSharedStorageContext
   */

  navigate(
      url,
      navigationStartTime,
      embedderSharedStorageContext) {
    this.proxy.sendMessage(
        0,
        blink.mojom.FencedFrameOwnerHost_Navigate_ParamsSpec.$,
        null,
        [
          url,
          navigationStartTime,
          embedderSharedStorageContext
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FramePolicy } framePolicy
   */

  didChangeFramePolicy(
      framePolicy) {
    this.proxy.sendMessage(
        1,
        blink.mojom.FencedFrameOwnerHost_DidChangeFramePolicy_ParamsSpec.$,
        null,
        [
          framePolicy
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FencedFrameOwnerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FencedFrameOwnerHostReceiver = class {
  /**
   * @param {!blink.mojom.FencedFrameOwnerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FencedFrameOwnerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FencedFrameOwnerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FencedFrameOwnerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FencedFrameOwnerHost_Navigate_ParamsSpec.$,
        null,
        impl.navigate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FencedFrameOwnerHost_DidChangeFramePolicy_ParamsSpec.$,
        null,
        impl.didChangeFramePolicy.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FencedFrameOwnerHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FencedFrameOwnerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FencedFrameOwnerHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FencedFrameOwnerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FencedFrameOwnerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FencedFrameOwnerHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FencedFrameOwnerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FencedFrameOwnerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.navigate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FencedFrameOwnerHost_Navigate_ParamsSpec.$,
        null,
        this.navigate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeFramePolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FencedFrameOwnerHost_DidChangeFramePolicy_ParamsSpec.$,
        null,
        this.didChangeFramePolicy.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FencedFrameOwnerHost_Navigate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FencedFrameOwnerHost_DidChangeFramePolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FencedFrameOwnerHost_Navigate_ParamsSpec.$,
    'FencedFrameOwnerHost_Navigate_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationStartTime', 8,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'embedderSharedStorageContext', 16,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.FencedFrameOwnerHost_Navigate_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.navigationStartTime;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.embedderSharedStorageContext;
  }
};



mojo.internal.Struct(
    blink.mojom.FencedFrameOwnerHost_DidChangeFramePolicy_ParamsSpec.$,
    'FencedFrameOwnerHost_DidChangeFramePolicy_Params',
    [
      mojo.internal.StructField(
        'framePolicy', 0,
        0,
        blink.mojom.FramePolicySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FencedFrameOwnerHost_DidChangeFramePolicy_Params = class {
  constructor() {
    /** @export { !blink.mojom.FramePolicy } */
    this.framePolicy;
  }
};

