// third_party/blink/public/mojom/feature_observer/feature_observer.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/feature_observer/feature_observer.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');


  var ObservedFeatureType = {};
  ObservedFeatureType.kWebLock = 0;
  ObservedFeatureType.kBlockingIndexedDBLock = 1;
  ObservedFeatureType.MIN_VALUE = 0;
  ObservedFeatureType.MAX_VALUE = 1;

  ObservedFeatureType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  ObservedFeatureType.toKnownEnumValue = function(value) {
    return value;
  };

  ObservedFeatureType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function FeatureObserver_Register_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FeatureObserver_Register_Params.prototype.initDefaults_ = function() {
    this.feature = new bindings.InterfaceRequest();
    this.type = 0;
  };
  FeatureObserver_Register_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FeatureObserver_Register_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FeatureObserver_Register_Params.feature
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FeatureObserver_Register_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ObservedFeatureType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FeatureObserver_Register_Params.encodedSize = codec.kStructHeaderSize + 8;

  FeatureObserver_Register_Params.decode = function(decoder) {
    var packed;
    var val = new FeatureObserver_Register_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.feature =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.type =
        decoder.decodeStruct(new codec.Enum(ObservedFeatureType));
    return val;
  };

  FeatureObserver_Register_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FeatureObserver_Register_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.feature);
    encoder.encodeStruct(codec.Int32, val.type);
  };

  function ObservedFeaturePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ObservedFeature,
                                                   handleOrPtrInfo);
  }

  function ObservedFeatureAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ObservedFeature, associatedInterfacePtrInfo);
  }

  ObservedFeatureAssociatedPtr.prototype =
      Object.create(ObservedFeaturePtr.prototype);
  ObservedFeatureAssociatedPtr.prototype.constructor =
      ObservedFeatureAssociatedPtr;

  function ObservedFeatureProxy(receiver) {
    this.receiver_ = receiver;
  }

  function ObservedFeatureStub(delegate) {
    this.delegate_ = delegate;
  }

  ObservedFeatureStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  ObservedFeatureStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateObservedFeatureRequest(messageValidator) {
    return validator.validationError.NONE;
  }

  function validateObservedFeatureResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ObservedFeature = {
    name: 'blink.mojom.ObservedFeature',
    kVersion: 0,
    ptrClass: ObservedFeaturePtr,
    proxyClass: ObservedFeatureProxy,
    stubClass: ObservedFeatureStub,
    validateRequest: validateObservedFeatureRequest,
    validateResponse: null,
  };
  ObservedFeatureStub.prototype.validator = validateObservedFeatureRequest;
  ObservedFeatureProxy.prototype.validator = null;
  var kFeatureObserver_Register_Name = 0;

  function FeatureObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FeatureObserver,
                                                   handleOrPtrInfo);
  }

  function FeatureObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FeatureObserver, associatedInterfacePtrInfo);
  }

  FeatureObserverAssociatedPtr.prototype =
      Object.create(FeatureObserverPtr.prototype);
  FeatureObserverAssociatedPtr.prototype.constructor =
      FeatureObserverAssociatedPtr;

  function FeatureObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  FeatureObserverPtr.prototype.register = function() {
    return FeatureObserverProxy.prototype.register
        .apply(this.ptr.getProxy(), arguments);
  };

  FeatureObserverProxy.prototype.register = function(feature, type) {
    var params_ = new FeatureObserver_Register_Params();
    params_.feature = feature;
    params_.type = type;
    var builder = new codec.MessageV0Builder(
        kFeatureObserver_Register_Name,
        codec.align(FeatureObserver_Register_Params.encodedSize));
    builder.encodeStruct(FeatureObserver_Register_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FeatureObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  FeatureObserverStub.prototype.register = function(feature, type) {
    return this.delegate_ && this.delegate_.register && this.delegate_.register(feature, type);
  }

  FeatureObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFeatureObserver_Register_Name:
      var params = reader.decodeStruct(FeatureObserver_Register_Params);
      this.register(params.feature, params.type);
      return true;
    default:
      return false;
    }
  };

  FeatureObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFeatureObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFeatureObserver_Register_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FeatureObserver_Register_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFeatureObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FeatureObserver = {
    name: 'blink.mojom.FeatureObserver',
    kVersion: 0,
    ptrClass: FeatureObserverPtr,
    proxyClass: FeatureObserverProxy,
    stubClass: FeatureObserverStub,
    validateRequest: validateFeatureObserverRequest,
    validateResponse: null,
  };
  FeatureObserverStub.prototype.validator = validateFeatureObserverRequest;
  FeatureObserverProxy.prototype.validator = null;
  exports.ObservedFeatureType = ObservedFeatureType;
  exports.ObservedFeature = ObservedFeature;
  exports.ObservedFeaturePtr = ObservedFeaturePtr;
  exports.ObservedFeatureAssociatedPtr = ObservedFeatureAssociatedPtr;
  exports.FeatureObserver = FeatureObserver;
  exports.FeatureObserverPtr = FeatureObserverPtr;
  exports.FeatureObserverAssociatedPtr = FeatureObserverAssociatedPtr;
})();