// third_party/blink/public/mojom/drag/drag.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DRAG_DRAG_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DRAG_DRAG_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/drag/drag.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "ui/base/dragdrop/mojom/drag_drop_types.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/drag/drag.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AllowedDragOperationsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AllowedDragOperationsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AllowedDragOperations_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->allow_copy = Traits::allow_copy(input);

    fragment->allow_link = Traits::allow_link(input);

    fragment->allow_move = Traits::allow_move(input);
  }

  static bool Deserialize(::blink::mojom::internal::AllowedDragOperations_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AllowedDragOperationsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragItemStringDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragItemStringDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DragItemString_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::string_type(input)) in_string_type = Traits::string_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->string_type)::BaseType> string_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_string_type,
      string_type_fragment);

    fragment->string_type.Set(
        string_type_fragment.is_null() ? nullptr : string_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->string_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null string_type in DragItemString struct");

    decltype(Traits::string_data(input)) in_string_data = Traits::string_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->string_data)::BaseType> string_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_string_data,
      string_data_fragment);

    fragment->string_data.Set(
        string_data_fragment.is_null() ? nullptr : string_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->string_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null string_data in DragItemString struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    decltype(Traits::base_url(input)) in_base_url = Traits::base_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->base_url)::BaseType> base_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_base_url,
      base_url_fragment);

    fragment->base_url.Set(
        base_url_fragment.is_null() ? nullptr : base_url_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::DragItemString_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragItemStringDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragItemBinaryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragItemBinaryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DragItemBinary_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<decltype(fragment->data)>
        data_fragment(fragment.message());
    data_fragment.Claim(&fragment->data);
    
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data,
      data_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in DragItemBinary struct");

    fragment->is_image_accessible = Traits::is_image_accessible(input);

    decltype(Traits::source_url(input)) in_source_url = Traits::source_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_url)::BaseType> source_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_source_url,
      source_url_fragment);

    fragment->source_url.Set(
        source_url_fragment.is_null() ? nullptr : source_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->source_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_url in DragItemBinary struct");

    decltype(Traits::filename_extension(input)) in_filename_extension = Traits::filename_extension(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filename_extension)::BaseType> filename_extension_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_filename_extension,
      filename_extension_fragment);

    fragment->filename_extension.Set(
        filename_extension_fragment.is_null() ? nullptr : filename_extension_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->filename_extension.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filename_extension in DragItemBinary struct");

    decltype(Traits::content_disposition(input)) in_content_disposition = Traits::content_disposition(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_disposition)::BaseType> content_disposition_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_content_disposition,
      content_disposition_fragment);

    fragment->content_disposition.Set(
        content_disposition_fragment.is_null() ? nullptr : content_disposition_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::DragItemBinary_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragItemBinaryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragItemFileSystemFileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragItemFileSystemFileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DragItemFileSystemFile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in DragItemFileSystemFile struct");

    fragment->size = Traits::size(input);

    decltype(Traits::file_system_id(input)) in_file_system_id = Traits::file_system_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_system_id)::BaseType> file_system_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_file_system_id,
      file_system_id_fragment);

    fragment->file_system_id.Set(
        file_system_id_fragment.is_null() ? nullptr : file_system_id_fragment.data());

    decltype(Traits::serialized_blob(input)) in_serialized_blob = Traits::serialized_blob(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->serialized_blob)::BaseType> serialized_blob_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::SerializedBlobDataView>(
      in_serialized_blob,
      serialized_blob_fragment);

    fragment->serialized_blob.Set(
        serialized_blob_fragment.is_null() ? nullptr : serialized_blob_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::DragItemFileSystemFile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragItemFileSystemFileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DragData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::items(input)) in_items = Traits::items(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->items)::BaseType>
        items_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::DragItemDataView>>(
      in_items,
      items_fragment,
      &items_validate_params);

    fragment->items.Set(
        items_fragment.is_null() ? nullptr : items_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->items.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null items in DragData struct");

    decltype(Traits::file_system_id(input)) in_file_system_id = Traits::file_system_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_system_id)::BaseType> file_system_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_file_system_id,
      file_system_id_fragment);

    fragment->file_system_id.Set(
        file_system_id_fragment.is_null() ? nullptr : file_system_id_fragment.data());

    fragment->force_default_action = Traits::force_default_action(input);

    
    mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
      Traits::referrer_policy(input),
      &fragment->referrer_policy);
  }

  static bool Deserialize(::blink::mojom::internal::DragData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragEventSourceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragEventSourceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DragEventSourceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::location(input)) in_location = Traits::location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->location)::BaseType> location_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_location,
      location_fragment);

    fragment->location.Set(
        location_fragment.is_null() ? nullptr : location_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->location.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null location in DragEventSourceInfo struct");

    
    mojo::internal::Serialize<::ui::mojom::DragEventSource>(
      Traits::source(input),
      &fragment->source);
  }

  static bool Deserialize(::blink::mojom::internal::DragEventSourceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragEventSourceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::DragItemDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::DragItem_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::DragItemDataView::Tag::kString: {
    decltype(Traits::string(input))
    in_string = Traits::string(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_string)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DragItemStringDataView>(
  in_string,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null string in DragItem union");
    fragment->data.f_string.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::DragItemDataView::Tag::kFile: {
    decltype(Traits::file(input))
    in_file = Traits::file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DataTransferFileDataView>(
  in_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null file in DragItem union");
    fragment->data.f_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::DragItemDataView::Tag::kBinary: {
    decltype(Traits::binary(input))
    in_binary = Traits::binary(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_binary)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DragItemBinaryDataView>(
  in_binary,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null binary in DragItem union");
    fragment->data.f_binary.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::DragItemDataView::Tag::kFileSystemFile: {
    decltype(Traits::file_system_file(input))
    in_file_system_file = Traits::file_system_file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_file_system_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DragItemFileSystemFileDataView>(
  in_file_system_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null file_system_file in DragItem union");
    fragment->data.f_file_system_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::DragItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



inline void DragItemStringDataView::GetStringTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->string_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DragItemStringDataView::GetStringDataDataView(
    ::mojo_base::mojom::BigString16DataView* output) {
  auto pointer = data_->string_data.Get();
  *output = ::mojo_base::mojom::BigString16DataView(pointer, message_);
}
inline void DragItemStringDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void DragItemStringDataView::GetBaseUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->base_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void DragItemBinaryDataView::GetDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}
inline void DragItemBinaryDataView::GetSourceUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->source_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DragItemBinaryDataView::GetFilenameExtensionDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->filename_extension.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void DragItemBinaryDataView::GetContentDispositionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->content_disposition.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DragItemFileSystemFileDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DragItemFileSystemFileDataView::GetFileSystemIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->file_system_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DragItemFileSystemFileDataView::GetSerializedBlobDataView(
    ::blink::mojom::SerializedBlobDataView* output) {
  auto pointer = data_->serialized_blob.Get();
  *output = ::blink::mojom::SerializedBlobDataView(pointer, message_);
}


inline void DragDataDataView::GetItemsDataView(
    mojo::ArrayDataView<DragItemDataView>* output) {
  auto pointer = data_->items.Get();
  *output = mojo::ArrayDataView<DragItemDataView>(pointer, message_);
}
inline void DragDataDataView::GetFileSystemIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->file_system_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DragEventSourceInfoDataView::GetLocationDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->location.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}


inline void DragItemDataView::GetStringDataView(
    DragItemStringDataView* output) const {
  CHECK(is_string());
  *output = DragItemStringDataView(data_->data.f_string.Get(), message_);
}
inline void DragItemDataView::GetFileDataView(
    ::blink::mojom::DataTransferFileDataView* output) const {
  CHECK(is_file());
  *output = ::blink::mojom::DataTransferFileDataView(data_->data.f_file.Get(), message_);
}
inline void DragItemDataView::GetBinaryDataView(
    DragItemBinaryDataView* output) const {
  CHECK(is_binary());
  *output = DragItemBinaryDataView(data_->data.f_binary.Get(), message_);
}
inline void DragItemDataView::GetFileSystemFileDataView(
    DragItemFileSystemFileDataView* output) const {
  CHECK(is_file_system_file());
  *output = DragItemFileSystemFileDataView(data_->data.f_file_system_file.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DRAG_DRAG_MOJOM_SHARED_H_