// third_party/blink/public/mojom/drag/drag.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DRAG_DRAG_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DRAG_DRAG_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/drag/drag.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "ui/base/dragdrop/mojom/drag_drop_types.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"


namespace blink::mojom {
class AllowedDragOperationsDataView;

class DragItemStringDataView;

class DragItemBinaryDataView;

class DragItemFileSystemFileDataView;

class DragDataDataView;

class DragEventSourceInfoDataView;

class DragItemDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AllowedDragOperationsDataView> {
  using Data = ::blink::mojom::internal::AllowedDragOperations_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragItemStringDataView> {
  using Data = ::blink::mojom::internal::DragItemString_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragItemBinaryDataView> {
  using Data = ::blink::mojom::internal::DragItemBinary_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragItemFileSystemFileDataView> {
  using Data = ::blink::mojom::internal::DragItemFileSystemFile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragDataDataView> {
  using Data = ::blink::mojom::internal::DragData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragEventSourceInfoDataView> {
  using Data = ::blink::mojom::internal::DragEventSourceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragItemDataView> {
  using Data = ::blink::mojom::internal::DragItem_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class AllowedDragOperationsDataView {
 public:
  AllowedDragOperationsDataView() = default;

  AllowedDragOperationsDataView(
      internal::AllowedDragOperations_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool allow_copy() const {
    return data_->allow_copy;
  }
  bool allow_link() const {
    return data_->allow_link;
  }
  bool allow_move() const {
    return data_->allow_move;
  }
 private:
  internal::AllowedDragOperations_Data* data_ = nullptr;
};


class DragItemStringDataView {
 public:
  DragItemStringDataView() = default;

  DragItemStringDataView(
      internal::DragItemString_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStringTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStringType(UserType* output) {
    
    auto* pointer = data_->string_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStringDataDataView(
      ::mojo_base::mojom::BigString16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStringData(UserType* output) {
    
    auto* pointer = data_->string_data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::BigString16DataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `title` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTitle` instead "
    "of `ReadTitle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetBaseUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBaseUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `base_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBaseUrl` instead "
    "of `ReadBaseUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->base_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::DragItemString_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DragItemBinaryDataView {
 public:
  DragItemBinaryDataView() = default;

  DragItemBinaryDataView(
      internal::DragItemBinary_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
  bool is_image_accessible() const {
    return data_->is_image_accessible;
  }
  inline void GetSourceUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceUrl(UserType* output) {
    
    auto* pointer = data_->source_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetFilenameExtensionDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilenameExtension(UserType* output) {
    
    auto* pointer = data_->filename_extension.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetContentDispositionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentDisposition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `content_disposition` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContentDisposition` instead "
    "of `ReadContentDisposition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->content_disposition.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DragItemBinary_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DragItemFileSystemFileDataView {
 public:
  DragItemFileSystemFileDataView() = default;

  DragItemFileSystemFileDataView(
      internal::DragItemFileSystemFile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int64_t size() const {
    return data_->size;
  }
  inline void GetFileSystemIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileSystemId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `file_system_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFileSystemId` instead "
    "of `ReadFileSystemId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_system_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSerializedBlobDataView(
      ::blink::mojom::SerializedBlobDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSerializedBlob(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SerializedBlobDataView, UserType>(),
    "Attempting to read the optional `serialized_blob` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSerializedBlob` instead "
    "of `ReadSerializedBlob if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->serialized_blob.Get();
    return mojo::internal::Deserialize<::blink::mojom::SerializedBlobDataView>(
        pointer, output, message_);
  }
 private:
  internal::DragItemFileSystemFile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DragDataDataView {
 public:
  DragDataDataView() = default;

  DragDataDataView(
      internal::DragData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetItemsDataView(
      mojo::ArrayDataView<DragItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItems(UserType* output) {
    
    auto* pointer = data_->items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::DragItemDataView>>(
        pointer, output, message_);
  }
  inline void GetFileSystemIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileSystemId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `file_system_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFileSystemId` instead "
    "of `ReadFileSystemId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_system_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool force_default_action() const {
    return data_->force_default_action;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::ReferrerPolicy>(
        data_value, output);
  }
  ::network::mojom::ReferrerPolicy referrer_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ReferrerPolicy>(data_->referrer_policy));
  }
 private:
  internal::DragData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DragEventSourceInfoDataView {
 public:
  DragEventSourceInfoDataView() = default;

  DragEventSourceInfoDataView(
      internal::DragEventSourceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocationDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocation(UserType* output) {
    
    auto* pointer = data_->location.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) const {
    auto data_value = data_->source;
    return mojo::internal::Deserialize<::ui::mojom::DragEventSource>(
        data_value, output);
  }
  ::ui::mojom::DragEventSource source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::DragEventSource>(data_->source));
  }
 private:
  internal::DragEventSourceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DragItemDataView {
 public:
  using Tag = internal::DragItem_Data::DragItem_Tag;

  DragItemDataView() = default;

  DragItemDataView(
      internal::DragItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_string() const { return data_->tag == Tag::kString; }
  inline void GetStringDataView(
      DragItemStringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadString(UserType* output) const {
    
    CHECK(is_string());
    return mojo::internal::Deserialize<::blink::mojom::DragItemStringDataView>(
        data_->data.f_string.Get(), output, message_);
  }
  bool is_file() const { return data_->tag == Tag::kFile; }
  inline void GetFileDataView(
      ::blink::mojom::DataTransferFileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) const {
    
    CHECK(is_file());
    return mojo::internal::Deserialize<::blink::mojom::DataTransferFileDataView>(
        data_->data.f_file.Get(), output, message_);
  }
  bool is_binary() const { return data_->tag == Tag::kBinary; }
  inline void GetBinaryDataView(
      DragItemBinaryDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBinary(UserType* output) const {
    
    CHECK(is_binary());
    return mojo::internal::Deserialize<::blink::mojom::DragItemBinaryDataView>(
        data_->data.f_binary.Get(), output, message_);
  }
  bool is_file_system_file() const { return data_->tag == Tag::kFileSystemFile; }
  inline void GetFileSystemFileDataView(
      DragItemFileSystemFileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFileSystemFile(UserType* output) const {
    
    CHECK(is_file_system_file());
    return mojo::internal::Deserialize<::blink::mojom::DragItemFileSystemFileDataView>(
        data_->data.f_file_system_file.Get(), output, message_);
  }

 private:
  internal::DragItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DRAG_DRAG_MOJOM_DATA_VIEW_H_