// third_party/blink/public/mojom/dom_storage/storage_area.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_STORAGE_AREA_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_STORAGE_AREA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class StorageAreaObserverProxy;

template <typename ImplRefTraits>
class StorageAreaObserverStub;

class StorageAreaObserverRequestValidator;


class BLINK_COMMON_EXPORT StorageAreaObserver
    : public StorageAreaObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.StorageAreaObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = StorageAreaObserverInterfaceBase;
  using Proxy_ = StorageAreaObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = StorageAreaObserverStub<ImplRefTraits>;

  using RequestValidator_ = StorageAreaObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kKeyChangedMinVersion = 0,
    kKeyChangeFailedMinVersion = 0,
    kKeyDeletedMinVersion = 0,
    kAllDeletedMinVersion = 0,
    kShouldSendOldValueOnMutationsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct KeyChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct KeyChangeFailed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct KeyDeleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AllDeleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShouldSendOldValueOnMutations_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~StorageAreaObserver() = default;

  virtual void KeyChanged(const std::vector<uint8_t>& key, const std::vector<uint8_t>& new_value, const std::optional<std::vector<uint8_t>>& old_value, const std::string& source) = 0;

  virtual void KeyChangeFailed(const std::vector<uint8_t>& key, const std::string& source) = 0;

  virtual void KeyDeleted(const std::vector<uint8_t>& key, const std::optional<std::vector<uint8_t>>& old_value, const std::string& source) = 0;

  virtual void AllDeleted(bool was_nonempty, const std::string& source) = 0;

  virtual void ShouldSendOldValueOnMutations(bool value) = 0;
};

class StorageAreaProxy;

template <typename ImplRefTraits>
class StorageAreaStub;

class StorageAreaRequestValidator;
class StorageAreaResponseValidator;


class BLINK_COMMON_EXPORT StorageArea
    : public StorageAreaInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.StorageArea";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    5
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = StorageAreaInterfaceBase;
  using Proxy_ = StorageAreaProxy;

  template <typename ImplRefTraits>
  using Stub_ = StorageAreaStub<ImplRefTraits>;

  using RequestValidator_ = StorageAreaRequestValidator;
  using ResponseValidator_ = StorageAreaResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAddObserverMinVersion = 0,
    kPutMinVersion = 0,
    kDeleteMinVersion = 0,
    kDeleteAllMinVersion = 0,
    kGetMinVersion = 0,
    kGetAllMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Put_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Delete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteAll_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Get_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAll_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  static constexpr uint32_t kPerStorageAreaQuota = 10485760U;
  
  static constexpr uint32_t kPerStorageAreaOverQuotaAllowance = 102400U;
  virtual ~StorageArea() = default;

  virtual void AddObserver(::mojo::PendingRemote<StorageAreaObserver> observer) = 0;

  using PutCallback = base::OnceCallback<void(bool)>;
  using PutMojoCallback = base::OnceCallback<void(bool)>;

  virtual void Put(const std::vector<uint8_t>& key, const std::vector<uint8_t>& value, const std::optional<std::vector<uint8_t>>& client_old_value, const std::string& source, PutCallback callback) = 0;

  using DeleteCallback = base::OnceCallback<void(bool)>;
  using DeleteMojoCallback = base::OnceCallback<void(bool)>;

  virtual void Delete(const std::vector<uint8_t>& key, const std::optional<std::vector<uint8_t>>& client_old_value, const std::string& source, DeleteCallback callback) = 0;

  using DeleteAllCallback = base::OnceCallback<void(bool)>;
  using DeleteAllMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DeleteAll(const std::string& source, ::mojo::PendingRemote<StorageAreaObserver> new_observer, DeleteAllCallback callback) = 0;

  using GetCallback = base::OnceCallback<void(bool, const std::vector<uint8_t>&)>;
  using GetMojoCallback = base::OnceCallback<void(bool, const std::vector<uint8_t>&)>;

  virtual void Get(const std::vector<uint8_t>& key, GetCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetAll(::mojo::PendingRemote<StorageAreaObserver> new_observer, std::vector<KeyValuePtr>* out_data);
  using GetAllCallback = base::OnceCallback<void(std::vector<KeyValuePtr>)>;
  using GetAllMojoCallback = base::OnceCallback<void(std::vector<KeyValuePtr>)>;

  virtual void GetAll(::mojo::PendingRemote<StorageAreaObserver> new_observer, GetAllCallback callback) = 0;
};



class BLINK_COMMON_EXPORT StorageAreaObserverProxy
    : public StorageAreaObserver {
 public:
  using InterfaceType = StorageAreaObserver;

  explicit StorageAreaObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void KeyChanged(const std::vector<uint8_t>& key, const std::vector<uint8_t>& new_value, const std::optional<std::vector<uint8_t>>& old_value, const std::string& source) final;
  
  void KeyChangeFailed(const std::vector<uint8_t>& key, const std::string& source) final;
  
  void KeyDeleted(const std::vector<uint8_t>& key, const std::optional<std::vector<uint8_t>>& old_value, const std::string& source) final;
  
  void AllDeleted(bool was_nonempty, const std::string& source) final;
  
  void ShouldSendOldValueOnMutations(bool value) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT StorageAreaProxy
    : public StorageArea {
 public:
  using InterfaceType = StorageArea;

  explicit StorageAreaProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddObserver(::mojo::PendingRemote<StorageAreaObserver> observer) final;
  
  void Put(const std::vector<uint8_t>& key, const std::vector<uint8_t>& value, const std::optional<std::vector<uint8_t>>& client_old_value, const std::string& source, PutCallback callback) final;
  
  void Delete(const std::vector<uint8_t>& key, const std::optional<std::vector<uint8_t>>& client_old_value, const std::string& source, DeleteCallback callback) final;
  
  void DeleteAll(const std::string& source, ::mojo::PendingRemote<StorageAreaObserver> new_observer, DeleteAllCallback callback) final;
  
  void Get(const std::vector<uint8_t>& key, GetCallback callback) final;
  
  bool GetAll(::mojo::PendingRemote<StorageAreaObserver> new_observer, std::vector<KeyValuePtr>* out_data) final;
  
  void GetAll(::mojo::PendingRemote<StorageAreaObserver> new_observer, GetAllCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT StorageAreaObserverStubDispatch {
 public:
  static bool Accept(StorageAreaObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      StorageAreaObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<StorageAreaObserver>>
class StorageAreaObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  StorageAreaObserverStub() = default;
  ~StorageAreaObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StorageAreaObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StorageAreaObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT StorageAreaStubDispatch {
 public:
  static bool Accept(StorageArea* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      StorageArea* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<StorageArea>>
class StorageAreaStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  StorageAreaStub() = default;
  ~StorageAreaStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StorageAreaStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StorageAreaStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT StorageAreaObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT StorageAreaRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT StorageAreaResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT KeyValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<KeyValue, T>::value>;
  using DataView = KeyValueDataView;
  using Data_ = internal::KeyValue_Data;

  template <typename... Args>
  static KeyValuePtr New(Args&&... args) {
    return KeyValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static KeyValuePtr From(const U& u) {
    return mojo::TypeConverter<KeyValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, KeyValue>::Convert(*this);
  }


  KeyValue();

  KeyValue(
      std::vector<uint8_t> key,
      std::vector<uint8_t> value);


  ~KeyValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = KeyValuePtr>
  KeyValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, KeyValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, KeyValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, KeyValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        KeyValue::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        KeyValue::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        KeyValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::KeyValue_UnserializedMessageContext<
            UserType, KeyValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<KeyValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return KeyValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::KeyValue_UnserializedMessageContext<
            UserType, KeyValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<KeyValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> key;
  
  std::vector<uint8_t> value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, KeyValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, KeyValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, KeyValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, KeyValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
KeyValuePtr KeyValue::Clone() const {
  return New(
      mojo::Clone(key),
      mojo::Clone(value)
  );
}

template <typename T, KeyValue::EnableIfSame<T>*>
bool KeyValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, KeyValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::KeyValue::DataView,
                                         ::blink::mojom::KeyValuePtr> {
  static bool IsNull(const ::blink::mojom::KeyValuePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::KeyValuePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::KeyValue::key)& key(
      const ::blink::mojom::KeyValuePtr& input) {
    return input->key;
  }

  static const decltype(::blink::mojom::KeyValue::value)& value(
      const ::blink::mojom::KeyValuePtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::KeyValue::DataView input, ::blink::mojom::KeyValuePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_STORAGE_AREA_MOJOM_H_