// third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var read_only_buffer$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/read_only_buffer.mojom', '../../../../../mojo/public/mojom/base/read_only_buffer.mojom.js');
  }
  var host_resolver$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/host_resolver.mojom', '../../../../../services/network/public/mojom/host_resolver.mojom.js');
  }
  var ip_endpoint$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_endpoint.mojom', '../../../../../services/network/public/mojom/ip_endpoint.mojom.js');
  }
  var mutable_network_traffic_annotation_tag$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom', '../../../../../services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', '../../../../../services/network/public/mojom/network_param.mojom.js');
  }
  var restricted_udp_socket$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/restricted_udp_socket.mojom', '../../../../../services/network/public/mojom/restricted_udp_socket.mojom.js');
  }
  var tcp_socket$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/tcp_socket.mojom', '../../../../../services/network/public/mojom/tcp_socket.mojom.js');
  }
  var udp_socket$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/udp_socket.mojom', '../../../../../services/network/public/mojom/udp_socket.mojom.js');
  }



  function DirectTCPSocketOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectTCPSocketOptions.prototype.initDefaults_ = function() {
    this.remoteAddr = null;
    this.send_buffer_size_$flag = false;
    this.receive_buffer_size_$flag = false;
    this.noDelay = false;
    this.dns_query_type_$flag = false;
    this.send_buffer_size_$value = 0;
    this.receive_buffer_size_$value = 0;
    this.dns_query_type_$value = 0;
    this.keepAliveOptions = null;
  };
  DirectTCPSocketOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectTCPSocketOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectTCPSocketOptions.remoteAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.HostPortPair, false);
    if (err !== validator.validationError.NONE)
        return err;







    // validate DirectTCPSocketOptions.keepAliveOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, tcp_socket$.TCPKeepAliveOptions, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DirectTCPSocketOptions.dns_query_type_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, host_resolver$.DnsQueryType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DirectTCPSocketOptions.encodedSize = codec.kStructHeaderSize + 32;

  DirectTCPSocketOptions.decode = function(decoder) {
    var packed;
    var val = new DirectTCPSocketOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.remoteAddr =
        decoder.decodeStructPointer(network_param$.HostPortPair);
    packed = decoder.readUint8();
    val.send_buffer_size_$flag = (packed >> 0) & 1 ? true : false;
    val.receive_buffer_size_$flag = (packed >> 1) & 1 ? true : false;
    val.noDelay = (packed >> 2) & 1 ? true : false;
    val.dns_query_type_$flag = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.send_buffer_size_$value =
        decoder.decodeStruct(codec.Int32);
    val.receive_buffer_size_$value =
        decoder.decodeStruct(codec.Int32);
    val.dns_query_type_$value =
        decoder.decodeStruct(new codec.Enum(host_resolver$.DnsQueryType));
    val.keepAliveOptions =
        decoder.decodeStructPointer(tcp_socket$.TCPKeepAliveOptions);
    return val;
  };

  DirectTCPSocketOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectTCPSocketOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.HostPortPair, val.remoteAddr);
    packed = 0;
    packed |= (val.send_buffer_size_$flag & 1) << 0
    packed |= (val.receive_buffer_size_$flag & 1) << 1
    packed |= (val.noDelay & 1) << 2
    packed |= (val.dns_query_type_$flag & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.send_buffer_size_$value);
    encoder.encodeStruct(codec.Int32, val.receive_buffer_size_$value);
    encoder.encodeStruct(codec.Int32, val.dns_query_type_$value);
    encoder.encodeStructPointer(tcp_socket$.TCPKeepAliveOptions, val.keepAliveOptions);
  };
  function DirectConnectedUDPSocketOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectConnectedUDPSocketOptions.prototype.initDefaults_ = function() {
    this.remoteAddr = null;
    this.send_buffer_size_$flag = false;
    this.receive_buffer_size_$flag = false;
    this.dns_query_type_$flag = false;
    this.multicast_time_to_live_$flag = false;
    this.multicast_loopback_$flag = false;
    this.multicast_loopback_$value = false;
    this.multicast_time_to_live_$value = 0;
    this.send_buffer_size_$value = 0;
    this.receive_buffer_size_$value = 0;
    this.dns_query_type_$value = 0;
  };
  DirectConnectedUDPSocketOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectConnectedUDPSocketOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectConnectedUDPSocketOptions.remoteAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.HostPortPair, false);
    if (err !== validator.validationError.NONE)
        return err;







    // validate DirectConnectedUDPSocketOptions.dns_query_type_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, host_resolver$.DnsQueryType);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  DirectConnectedUDPSocketOptions.encodedSize = codec.kStructHeaderSize + 24;

  DirectConnectedUDPSocketOptions.decode = function(decoder) {
    var packed;
    var val = new DirectConnectedUDPSocketOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.remoteAddr =
        decoder.decodeStructPointer(network_param$.HostPortPair);
    packed = decoder.readUint8();
    val.send_buffer_size_$flag = (packed >> 0) & 1 ? true : false;
    val.receive_buffer_size_$flag = (packed >> 1) & 1 ? true : false;
    val.dns_query_type_$flag = (packed >> 2) & 1 ? true : false;
    val.multicast_time_to_live_$flag = (packed >> 3) & 1 ? true : false;
    val.multicast_loopback_$flag = (packed >> 4) & 1 ? true : false;
    val.multicast_loopback_$value = (packed >> 5) & 1 ? true : false;
    val.multicast_time_to_live_$value =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    val.send_buffer_size_$value =
        decoder.decodeStruct(codec.Int32);
    val.receive_buffer_size_$value =
        decoder.decodeStruct(codec.Int32);
    val.dns_query_type_$value =
        decoder.decodeStruct(new codec.Enum(host_resolver$.DnsQueryType));
    return val;
  };

  DirectConnectedUDPSocketOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectConnectedUDPSocketOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.HostPortPair, val.remoteAddr);
    packed = 0;
    packed |= (val.send_buffer_size_$flag & 1) << 0
    packed |= (val.receive_buffer_size_$flag & 1) << 1
    packed |= (val.dns_query_type_$flag & 1) << 2
    packed |= (val.multicast_time_to_live_$flag & 1) << 3
    packed |= (val.multicast_loopback_$flag & 1) << 4
    packed |= (val.multicast_loopback_$value & 1) << 5
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.multicast_time_to_live_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.send_buffer_size_$value);
    encoder.encodeStruct(codec.Int32, val.receive_buffer_size_$value);
    encoder.encodeStruct(codec.Int32, val.dns_query_type_$value);
  };
  function DirectBoundUDPSocketOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectBoundUDPSocketOptions.prototype.initDefaults_ = function() {
    this.localAddr = null;
    this.send_buffer_size_$flag = false;
    this.receive_buffer_size_$flag = false;
    this.ipv6_only_$flag = false;
    this.ipv6_only_$value = false;
    this.multicast_allow_address_sharing_$flag = false;
    this.multicast_allow_address_sharing_$value = false;
    this.multicast_time_to_live_$flag = false;
    this.multicast_loopback_$flag = false;
    this.multicast_time_to_live_$value = 0;
    this.multicast_loopback_$value = false;
    this.send_buffer_size_$value = 0;
    this.receive_buffer_size_$value = 0;
  };
  DirectBoundUDPSocketOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectBoundUDPSocketOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectBoundUDPSocketOptions.localAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ip_endpoint$.IPEndPoint, false);
    if (err !== validator.validationError.NONE)
        return err;













    return validator.validationError.NONE;
  };

  DirectBoundUDPSocketOptions.encodedSize = codec.kStructHeaderSize + 24;

  DirectBoundUDPSocketOptions.decode = function(decoder) {
    var packed;
    var val = new DirectBoundUDPSocketOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.localAddr =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    packed = decoder.readUint8();
    val.send_buffer_size_$flag = (packed >> 0) & 1 ? true : false;
    val.receive_buffer_size_$flag = (packed >> 1) & 1 ? true : false;
    val.ipv6_only_$flag = (packed >> 2) & 1 ? true : false;
    val.ipv6_only_$value = (packed >> 3) & 1 ? true : false;
    val.multicast_allow_address_sharing_$flag = (packed >> 4) & 1 ? true : false;
    val.multicast_allow_address_sharing_$value = (packed >> 5) & 1 ? true : false;
    val.multicast_time_to_live_$flag = (packed >> 6) & 1 ? true : false;
    val.multicast_loopback_$flag = (packed >> 7) & 1 ? true : false;
    val.multicast_time_to_live_$value =
        decoder.decodeStruct(codec.Uint8);
    packed = decoder.readUint8();
    val.multicast_loopback_$value = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    val.send_buffer_size_$value =
        decoder.decodeStruct(codec.Int32);
    val.receive_buffer_size_$value =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DirectBoundUDPSocketOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectBoundUDPSocketOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.localAddr);
    packed = 0;
    packed |= (val.send_buffer_size_$flag & 1) << 0
    packed |= (val.receive_buffer_size_$flag & 1) << 1
    packed |= (val.ipv6_only_$flag & 1) << 2
    packed |= (val.ipv6_only_$value & 1) << 3
    packed |= (val.multicast_allow_address_sharing_$flag & 1) << 4
    packed |= (val.multicast_allow_address_sharing_$value & 1) << 5
    packed |= (val.multicast_time_to_live_$flag & 1) << 6
    packed |= (val.multicast_loopback_$flag & 1) << 7
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.multicast_time_to_live_$value);
    packed = 0;
    packed |= (val.multicast_loopback_$value & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.send_buffer_size_$value);
    encoder.encodeStruct(codec.Int32, val.receive_buffer_size_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DirectTCPServerSocketOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectTCPServerSocketOptions.prototype.initDefaults_ = function() {
    this.localAddr = null;
    this.ipv6_only_$flag = false;
    this.ipv6_only_$value = false;
    this.backlog_$flag = false;
    this.backlog_$value = 0;
  };
  DirectTCPServerSocketOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectTCPServerSocketOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectTCPServerSocketOptions.localAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ip_endpoint$.IPEndPoint, false);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  DirectTCPServerSocketOptions.encodedSize = codec.kStructHeaderSize + 16;

  DirectTCPServerSocketOptions.decode = function(decoder) {
    var packed;
    var val = new DirectTCPServerSocketOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.localAddr =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    packed = decoder.readUint8();
    val.ipv6_only_$flag = (packed >> 0) & 1 ? true : false;
    val.ipv6_only_$value = (packed >> 1) & 1 ? true : false;
    val.backlog_$flag = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.backlog_$value =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  DirectTCPServerSocketOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectTCPServerSocketOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.localAddr);
    packed = 0;
    packed |= (val.ipv6_only_$flag & 1) << 0
    packed |= (val.ipv6_only_$value & 1) << 1
    packed |= (val.backlog_$flag & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.backlog_$value);
  };
  function DirectSocketsService_OpenTCPSocket_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectSocketsService_OpenTCPSocket_Params.prototype.initDefaults_ = function() {
    this.options = null;
    this.receiver = new bindings.InterfaceRequest();
    this.observer = new tcp_socket$.SocketObserverPtr();
  };
  DirectSocketsService_OpenTCPSocket_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectSocketsService_OpenTCPSocket_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectSocketsService_OpenTCPSocket_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, DirectTCPSocketOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectSocketsService_OpenTCPSocket_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectSocketsService_OpenTCPSocket_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 12, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DirectSocketsService_OpenTCPSocket_Params.encodedSize = codec.kStructHeaderSize + 24;

  DirectSocketsService_OpenTCPSocket_Params.decode = function(decoder) {
    var packed;
    var val = new DirectSocketsService_OpenTCPSocket_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(DirectTCPSocketOptions);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.observer =
        decoder.decodeStruct(new codec.NullableInterface(tcp_socket$.SocketObserverPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DirectSocketsService_OpenTCPSocket_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectSocketsService_OpenTCPSocket_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(DirectTCPSocketOptions, val.options);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.encodeStruct(new codec.NullableInterface(tcp_socket$.SocketObserverPtr), val.observer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DirectSocketsService_OpenTCPSocket_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectSocketsService_OpenTCPSocket_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.receiveStream = null;
    this.localAddr = null;
    this.peerAddr = null;
    this.sendStream = null;
  };
  DirectSocketsService_OpenTCPSocket_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectSocketsService_OpenTCPSocket_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DirectSocketsService_OpenTCPSocket_ResponseParams.localAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ip_endpoint$.IPEndPoint, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectSocketsService_OpenTCPSocket_ResponseParams.peerAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, ip_endpoint$.IPEndPoint, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectSocketsService_OpenTCPSocket_ResponseParams.receiveStream
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 4, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectSocketsService_OpenTCPSocket_ResponseParams.sendStream
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DirectSocketsService_OpenTCPSocket_ResponseParams.encodedSize = codec.kStructHeaderSize + 32;

  DirectSocketsService_OpenTCPSocket_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DirectSocketsService_OpenTCPSocket_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    val.receiveStream =
        decoder.decodeStruct(codec.Handle);
    val.localAddr =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    val.peerAddr =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    val.sendStream =
        decoder.decodeStruct(codec.Handle);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DirectSocketsService_OpenTCPSocket_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectSocketsService_OpenTCPSocket_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.encodeStruct(codec.Handle, val.receiveStream);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.localAddr);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.peerAddr);
    encoder.encodeStruct(codec.Handle, val.sendStream);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DirectSocketsService_OpenConnectedUDPSocket_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectSocketsService_OpenConnectedUDPSocket_Params.prototype.initDefaults_ = function() {
    this.options = null;
    this.receiver = new bindings.InterfaceRequest();
    this.listener = new udp_socket$.UDPSocketListenerPtr();
  };
  DirectSocketsService_OpenConnectedUDPSocket_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectSocketsService_OpenConnectedUDPSocket_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectSocketsService_OpenConnectedUDPSocket_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, DirectConnectedUDPSocketOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectSocketsService_OpenConnectedUDPSocket_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectSocketsService_OpenConnectedUDPSocket_Params.listener
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 12, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DirectSocketsService_OpenConnectedUDPSocket_Params.encodedSize = codec.kStructHeaderSize + 24;

  DirectSocketsService_OpenConnectedUDPSocket_Params.decode = function(decoder) {
    var packed;
    var val = new DirectSocketsService_OpenConnectedUDPSocket_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(DirectConnectedUDPSocketOptions);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.listener =
        decoder.decodeStruct(new codec.NullableInterface(udp_socket$.UDPSocketListenerPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DirectSocketsService_OpenConnectedUDPSocket_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectSocketsService_OpenConnectedUDPSocket_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(DirectConnectedUDPSocketOptions, val.options);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.encodeStruct(new codec.NullableInterface(udp_socket$.UDPSocketListenerPtr), val.listener);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DirectSocketsService_OpenConnectedUDPSocket_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectSocketsService_OpenConnectedUDPSocket_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.localAddr = null;
    this.peerAddr = null;
  };
  DirectSocketsService_OpenConnectedUDPSocket_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectSocketsService_OpenConnectedUDPSocket_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DirectSocketsService_OpenConnectedUDPSocket_ResponseParams.localAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ip_endpoint$.IPEndPoint, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectSocketsService_OpenConnectedUDPSocket_ResponseParams.peerAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, ip_endpoint$.IPEndPoint, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DirectSocketsService_OpenConnectedUDPSocket_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  DirectSocketsService_OpenConnectedUDPSocket_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DirectSocketsService_OpenConnectedUDPSocket_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.localAddr =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    val.peerAddr =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    return val;
  };

  DirectSocketsService_OpenConnectedUDPSocket_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectSocketsService_OpenConnectedUDPSocket_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.localAddr);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.peerAddr);
  };
  function DirectSocketsService_OpenBoundUDPSocket_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectSocketsService_OpenBoundUDPSocket_Params.prototype.initDefaults_ = function() {
    this.options = null;
    this.receiver = new bindings.InterfaceRequest();
    this.listener = new udp_socket$.UDPSocketListenerPtr();
  };
  DirectSocketsService_OpenBoundUDPSocket_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectSocketsService_OpenBoundUDPSocket_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectSocketsService_OpenBoundUDPSocket_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, DirectBoundUDPSocketOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectSocketsService_OpenBoundUDPSocket_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectSocketsService_OpenBoundUDPSocket_Params.listener
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 12, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DirectSocketsService_OpenBoundUDPSocket_Params.encodedSize = codec.kStructHeaderSize + 24;

  DirectSocketsService_OpenBoundUDPSocket_Params.decode = function(decoder) {
    var packed;
    var val = new DirectSocketsService_OpenBoundUDPSocket_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(DirectBoundUDPSocketOptions);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.listener =
        decoder.decodeStruct(new codec.NullableInterface(udp_socket$.UDPSocketListenerPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DirectSocketsService_OpenBoundUDPSocket_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectSocketsService_OpenBoundUDPSocket_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(DirectBoundUDPSocketOptions, val.options);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.encodeStruct(new codec.NullableInterface(udp_socket$.UDPSocketListenerPtr), val.listener);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DirectSocketsService_OpenBoundUDPSocket_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectSocketsService_OpenBoundUDPSocket_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.localAddr = null;
  };
  DirectSocketsService_OpenBoundUDPSocket_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectSocketsService_OpenBoundUDPSocket_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DirectSocketsService_OpenBoundUDPSocket_ResponseParams.localAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ip_endpoint$.IPEndPoint, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DirectSocketsService_OpenBoundUDPSocket_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  DirectSocketsService_OpenBoundUDPSocket_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DirectSocketsService_OpenBoundUDPSocket_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.localAddr =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    return val;
  };

  DirectSocketsService_OpenBoundUDPSocket_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectSocketsService_OpenBoundUDPSocket_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.localAddr);
  };
  function DirectSocketsService_OpenTCPServerSocket_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectSocketsService_OpenTCPServerSocket_Params.prototype.initDefaults_ = function() {
    this.options = null;
    this.receiver = new bindings.InterfaceRequest();
  };
  DirectSocketsService_OpenTCPServerSocket_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectSocketsService_OpenTCPServerSocket_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectSocketsService_OpenTCPServerSocket_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, DirectTCPServerSocketOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectSocketsService_OpenTCPServerSocket_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DirectSocketsService_OpenTCPServerSocket_Params.encodedSize = codec.kStructHeaderSize + 16;

  DirectSocketsService_OpenTCPServerSocket_Params.decode = function(decoder) {
    var packed;
    var val = new DirectSocketsService_OpenTCPServerSocket_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(DirectTCPServerSocketOptions);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DirectSocketsService_OpenTCPServerSocket_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectSocketsService_OpenTCPServerSocket_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(DirectTCPServerSocketOptions, val.options);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DirectSocketsService_OpenTCPServerSocket_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectSocketsService_OpenTCPServerSocket_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.localAddr = null;
  };
  DirectSocketsService_OpenTCPServerSocket_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectSocketsService_OpenTCPServerSocket_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DirectSocketsService_OpenTCPServerSocket_ResponseParams.localAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ip_endpoint$.IPEndPoint, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DirectSocketsService_OpenTCPServerSocket_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  DirectSocketsService_OpenTCPServerSocket_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DirectSocketsService_OpenTCPServerSocket_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.localAddr =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    return val;
  };

  DirectSocketsService_OpenTCPServerSocket_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectSocketsService_OpenTCPServerSocket_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.localAddr);
  };
  var kDirectSocketsService_OpenTCPSocket_Name = 0;
  var kDirectSocketsService_OpenConnectedUDPSocket_Name = 1;
  var kDirectSocketsService_OpenBoundUDPSocket_Name = 2;
  var kDirectSocketsService_OpenTCPServerSocket_Name = 3;

  function DirectSocketsServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(DirectSocketsService,
                                                   handleOrPtrInfo);
  }

  function DirectSocketsServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        DirectSocketsService, associatedInterfacePtrInfo);
  }

  DirectSocketsServiceAssociatedPtr.prototype =
      Object.create(DirectSocketsServicePtr.prototype);
  DirectSocketsServiceAssociatedPtr.prototype.constructor =
      DirectSocketsServiceAssociatedPtr;

  function DirectSocketsServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  DirectSocketsServicePtr.prototype.openTCPSocket = function() {
    return DirectSocketsServiceProxy.prototype.openTCPSocket
        .apply(this.ptr.getProxy(), arguments);
  };

  DirectSocketsServiceProxy.prototype.openTCPSocket = function(options, receiver, observer) {
    var params_ = new DirectSocketsService_OpenTCPSocket_Params();
    params_.options = options;
    params_.receiver = receiver;
    params_.observer = observer;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDirectSocketsService_OpenTCPSocket_Name,
          codec.align(DirectSocketsService_OpenTCPSocket_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DirectSocketsService_OpenTCPSocket_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DirectSocketsService_OpenTCPSocket_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  DirectSocketsServicePtr.prototype.openConnectedUDPSocket = function() {
    return DirectSocketsServiceProxy.prototype.openConnectedUDPSocket
        .apply(this.ptr.getProxy(), arguments);
  };

  DirectSocketsServiceProxy.prototype.openConnectedUDPSocket = function(options, receiver, listener) {
    var params_ = new DirectSocketsService_OpenConnectedUDPSocket_Params();
    params_.options = options;
    params_.receiver = receiver;
    params_.listener = listener;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDirectSocketsService_OpenConnectedUDPSocket_Name,
          codec.align(DirectSocketsService_OpenConnectedUDPSocket_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DirectSocketsService_OpenConnectedUDPSocket_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DirectSocketsService_OpenConnectedUDPSocket_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  DirectSocketsServicePtr.prototype.openBoundUDPSocket = function() {
    return DirectSocketsServiceProxy.prototype.openBoundUDPSocket
        .apply(this.ptr.getProxy(), arguments);
  };

  DirectSocketsServiceProxy.prototype.openBoundUDPSocket = function(options, receiver, listener) {
    var params_ = new DirectSocketsService_OpenBoundUDPSocket_Params();
    params_.options = options;
    params_.receiver = receiver;
    params_.listener = listener;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDirectSocketsService_OpenBoundUDPSocket_Name,
          codec.align(DirectSocketsService_OpenBoundUDPSocket_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DirectSocketsService_OpenBoundUDPSocket_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DirectSocketsService_OpenBoundUDPSocket_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  DirectSocketsServicePtr.prototype.openTCPServerSocket = function() {
    return DirectSocketsServiceProxy.prototype.openTCPServerSocket
        .apply(this.ptr.getProxy(), arguments);
  };

  DirectSocketsServiceProxy.prototype.openTCPServerSocket = function(options, receiver) {
    var params_ = new DirectSocketsService_OpenTCPServerSocket_Params();
    params_.options = options;
    params_.receiver = receiver;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDirectSocketsService_OpenTCPServerSocket_Name,
          codec.align(DirectSocketsService_OpenTCPServerSocket_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DirectSocketsService_OpenTCPServerSocket_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DirectSocketsService_OpenTCPServerSocket_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function DirectSocketsServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  DirectSocketsServiceStub.prototype.openTCPSocket = function(options, receiver, observer) {
    return this.delegate_ && this.delegate_.openTCPSocket && this.delegate_.openTCPSocket(options, receiver, observer);
  }
  DirectSocketsServiceStub.prototype.openConnectedUDPSocket = function(options, receiver, listener) {
    return this.delegate_ && this.delegate_.openConnectedUDPSocket && this.delegate_.openConnectedUDPSocket(options, receiver, listener);
  }
  DirectSocketsServiceStub.prototype.openBoundUDPSocket = function(options, receiver, listener) {
    return this.delegate_ && this.delegate_.openBoundUDPSocket && this.delegate_.openBoundUDPSocket(options, receiver, listener);
  }
  DirectSocketsServiceStub.prototype.openTCPServerSocket = function(options, receiver) {
    return this.delegate_ && this.delegate_.openTCPServerSocket && this.delegate_.openTCPServerSocket(options, receiver);
  }

  DirectSocketsServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  DirectSocketsServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDirectSocketsService_OpenTCPSocket_Name:
      var params = reader.decodeStruct(DirectSocketsService_OpenTCPSocket_Params);
      this.openTCPSocket(params.options, params.receiver, params.observer).then(function(response) {
        var responseParams =
            new DirectSocketsService_OpenTCPSocket_ResponseParams();
        responseParams.result = response.result;
        responseParams.localAddr = response.localAddr;
        responseParams.peerAddr = response.peerAddr;
        responseParams.receiveStream = response.receiveStream;
        responseParams.sendStream = response.sendStream;
        var builder = new codec.MessageV1Builder(
            kDirectSocketsService_OpenTCPSocket_Name,
            codec.align(DirectSocketsService_OpenTCPSocket_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DirectSocketsService_OpenTCPSocket_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kDirectSocketsService_OpenConnectedUDPSocket_Name:
      var params = reader.decodeStruct(DirectSocketsService_OpenConnectedUDPSocket_Params);
      this.openConnectedUDPSocket(params.options, params.receiver, params.listener).then(function(response) {
        var responseParams =
            new DirectSocketsService_OpenConnectedUDPSocket_ResponseParams();
        responseParams.result = response.result;
        responseParams.localAddr = response.localAddr;
        responseParams.peerAddr = response.peerAddr;
        var builder = new codec.MessageV1Builder(
            kDirectSocketsService_OpenConnectedUDPSocket_Name,
            codec.align(DirectSocketsService_OpenConnectedUDPSocket_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DirectSocketsService_OpenConnectedUDPSocket_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kDirectSocketsService_OpenBoundUDPSocket_Name:
      var params = reader.decodeStruct(DirectSocketsService_OpenBoundUDPSocket_Params);
      this.openBoundUDPSocket(params.options, params.receiver, params.listener).then(function(response) {
        var responseParams =
            new DirectSocketsService_OpenBoundUDPSocket_ResponseParams();
        responseParams.result = response.result;
        responseParams.localAddr = response.localAddr;
        var builder = new codec.MessageV1Builder(
            kDirectSocketsService_OpenBoundUDPSocket_Name,
            codec.align(DirectSocketsService_OpenBoundUDPSocket_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DirectSocketsService_OpenBoundUDPSocket_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kDirectSocketsService_OpenTCPServerSocket_Name:
      var params = reader.decodeStruct(DirectSocketsService_OpenTCPServerSocket_Params);
      this.openTCPServerSocket(params.options, params.receiver).then(function(response) {
        var responseParams =
            new DirectSocketsService_OpenTCPServerSocket_ResponseParams();
        responseParams.result = response.result;
        responseParams.localAddr = response.localAddr;
        var builder = new codec.MessageV1Builder(
            kDirectSocketsService_OpenTCPServerSocket_Name,
            codec.align(DirectSocketsService_OpenTCPServerSocket_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DirectSocketsService_OpenTCPServerSocket_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateDirectSocketsServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kDirectSocketsService_OpenTCPSocket_Name:
        if (message.expectsResponse())
          paramsClass = DirectSocketsService_OpenTCPSocket_Params;
      break;
      case kDirectSocketsService_OpenConnectedUDPSocket_Name:
        if (message.expectsResponse())
          paramsClass = DirectSocketsService_OpenConnectedUDPSocket_Params;
      break;
      case kDirectSocketsService_OpenBoundUDPSocket_Name:
        if (message.expectsResponse())
          paramsClass = DirectSocketsService_OpenBoundUDPSocket_Params;
      break;
      case kDirectSocketsService_OpenTCPServerSocket_Name:
        if (message.expectsResponse())
          paramsClass = DirectSocketsService_OpenTCPServerSocket_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateDirectSocketsServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kDirectSocketsService_OpenTCPSocket_Name:
        if (message.isResponse())
          paramsClass = DirectSocketsService_OpenTCPSocket_ResponseParams;
        break;
      case kDirectSocketsService_OpenConnectedUDPSocket_Name:
        if (message.isResponse())
          paramsClass = DirectSocketsService_OpenConnectedUDPSocket_ResponseParams;
        break;
      case kDirectSocketsService_OpenBoundUDPSocket_Name:
        if (message.isResponse())
          paramsClass = DirectSocketsService_OpenBoundUDPSocket_ResponseParams;
        break;
      case kDirectSocketsService_OpenTCPServerSocket_Name:
        if (message.isResponse())
          paramsClass = DirectSocketsService_OpenTCPServerSocket_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var DirectSocketsService = {
    name: 'blink.mojom.DirectSocketsService',
    kVersion: 0,
    ptrClass: DirectSocketsServicePtr,
    proxyClass: DirectSocketsServiceProxy,
    stubClass: DirectSocketsServiceStub,
    validateRequest: validateDirectSocketsServiceRequest,
    validateResponse: validateDirectSocketsServiceResponse,
  };
  DirectSocketsServiceStub.prototype.validator = validateDirectSocketsServiceRequest;
  DirectSocketsServiceProxy.prototype.validator = validateDirectSocketsServiceResponse;
  exports.DirectTCPSocketOptions = DirectTCPSocketOptions;
  exports.DirectConnectedUDPSocketOptions = DirectConnectedUDPSocketOptions;
  exports.DirectBoundUDPSocketOptions = DirectBoundUDPSocketOptions;
  exports.DirectTCPServerSocketOptions = DirectTCPServerSocketOptions;
  exports.DirectSocketsService = DirectSocketsService;
  exports.DirectSocketsServicePtr = DirectSocketsServicePtr;
  exports.DirectSocketsServiceAssociatedPtr = DirectSocketsServiceAssociatedPtr;
})();