// third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-shared-internal.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "services/network/public/mojom/host_resolver.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/restricted_udp_socket.mojom-shared.h"
#include "services/network/public/mojom/tcp_socket.mojom-shared.h"
#include "services/network/public/mojom/udp_socket.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DirectTCPSocketOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DirectTCPSocketOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DirectTCPSocketOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::remote_addr(input)) in_remote_addr = Traits::remote_addr(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->remote_addr)::BaseType> remote_addr_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
      in_remote_addr,
      remote_addr_fragment);

    fragment->remote_addr.Set(
        remote_addr_fragment.is_null() ? nullptr : remote_addr_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->remote_addr.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_addr in DirectTCPSocketOptions struct");
    fragment->send_buffer_size_$flag = Traits::send_buffer_size(input).has_value();
    if (Traits::send_buffer_size(input).has_value()) {
      fragment->send_buffer_size_$value = Traits::send_buffer_size(input).value();
    }
    fragment->receive_buffer_size_$flag = Traits::receive_buffer_size(input).has_value();
    if (Traits::receive_buffer_size(input).has_value()) {
      fragment->receive_buffer_size_$value = Traits::receive_buffer_size(input).value();
    }

    fragment->no_delay = Traits::no_delay(input);

    decltype(Traits::keep_alive_options(input)) in_keep_alive_options = Traits::keep_alive_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->keep_alive_options)::BaseType> keep_alive_options_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::TCPKeepAliveOptionsDataView>(
      in_keep_alive_options,
      keep_alive_options_fragment);

    fragment->keep_alive_options.Set(
        keep_alive_options_fragment.is_null() ? nullptr : keep_alive_options_fragment.data());
    fragment->dns_query_type_$flag = Traits::dns_query_type(input).has_value();
    if (Traits::dns_query_type(input).has_value()) {
      
      mojo::internal::Serialize<::network::mojom::DnsQueryType>(
        Traits::dns_query_type(input).value(),
        &fragment->dns_query_type_$value);
    } else {
      fragment->dns_query_type_$value =
          static_cast<int32_t>(::network::mojom::DnsQueryType::kMinValue);
    }
  }

  static bool Deserialize(::blink::mojom::internal::DirectTCPSocketOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DirectTCPSocketOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DirectConnectedUDPSocketOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DirectConnectedUDPSocketOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DirectConnectedUDPSocketOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::remote_addr(input)) in_remote_addr = Traits::remote_addr(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->remote_addr)::BaseType> remote_addr_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
      in_remote_addr,
      remote_addr_fragment);

    fragment->remote_addr.Set(
        remote_addr_fragment.is_null() ? nullptr : remote_addr_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->remote_addr.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_addr in DirectConnectedUDPSocketOptions struct");
    fragment->send_buffer_size_$flag = Traits::send_buffer_size(input).has_value();
    if (Traits::send_buffer_size(input).has_value()) {
      fragment->send_buffer_size_$value = Traits::send_buffer_size(input).value();
    }
    fragment->receive_buffer_size_$flag = Traits::receive_buffer_size(input).has_value();
    if (Traits::receive_buffer_size(input).has_value()) {
      fragment->receive_buffer_size_$value = Traits::receive_buffer_size(input).value();
    }
    fragment->dns_query_type_$flag = Traits::dns_query_type(input).has_value();
    if (Traits::dns_query_type(input).has_value()) {
      
      mojo::internal::Serialize<::network::mojom::DnsQueryType>(
        Traits::dns_query_type(input).value(),
        &fragment->dns_query_type_$value);
    } else {
      fragment->dns_query_type_$value =
          static_cast<int32_t>(::network::mojom::DnsQueryType::kMinValue);
    }
    fragment->multicast_time_to_live_$flag = Traits::multicast_time_to_live(input).has_value();
    if (Traits::multicast_time_to_live(input).has_value()) {
      fragment->multicast_time_to_live_$value = Traits::multicast_time_to_live(input).value();
    }
    fragment->multicast_loopback_$flag = Traits::multicast_loopback(input).has_value();
    if (Traits::multicast_loopback(input).has_value()) {
      fragment->multicast_loopback_$value = Traits::multicast_loopback(input).value();
    }
  }

  static bool Deserialize(::blink::mojom::internal::DirectConnectedUDPSocketOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DirectConnectedUDPSocketOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DirectBoundUDPSocketOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DirectBoundUDPSocketOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DirectBoundUDPSocketOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::local_addr(input)) in_local_addr = Traits::local_addr(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local_addr)::BaseType> local_addr_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr,
      local_addr_fragment);

    fragment->local_addr.Set(
        local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->local_addr.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_addr in DirectBoundUDPSocketOptions struct");
    fragment->send_buffer_size_$flag = Traits::send_buffer_size(input).has_value();
    if (Traits::send_buffer_size(input).has_value()) {
      fragment->send_buffer_size_$value = Traits::send_buffer_size(input).value();
    }
    fragment->receive_buffer_size_$flag = Traits::receive_buffer_size(input).has_value();
    if (Traits::receive_buffer_size(input).has_value()) {
      fragment->receive_buffer_size_$value = Traits::receive_buffer_size(input).value();
    }
    fragment->ipv6_only_$flag = Traits::ipv6_only(input).has_value();
    if (Traits::ipv6_only(input).has_value()) {
      fragment->ipv6_only_$value = Traits::ipv6_only(input).value();
    }
    fragment->multicast_allow_address_sharing_$flag = Traits::multicast_allow_address_sharing(input).has_value();
    if (Traits::multicast_allow_address_sharing(input).has_value()) {
      fragment->multicast_allow_address_sharing_$value = Traits::multicast_allow_address_sharing(input).value();
    }
    fragment->multicast_time_to_live_$flag = Traits::multicast_time_to_live(input).has_value();
    if (Traits::multicast_time_to_live(input).has_value()) {
      fragment->multicast_time_to_live_$value = Traits::multicast_time_to_live(input).value();
    }
    fragment->multicast_loopback_$flag = Traits::multicast_loopback(input).has_value();
    if (Traits::multicast_loopback(input).has_value()) {
      fragment->multicast_loopback_$value = Traits::multicast_loopback(input).value();
    }
  }

  static bool Deserialize(::blink::mojom::internal::DirectBoundUDPSocketOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DirectBoundUDPSocketOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DirectTCPServerSocketOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DirectTCPServerSocketOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DirectTCPServerSocketOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::local_addr(input)) in_local_addr = Traits::local_addr(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local_addr)::BaseType> local_addr_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr,
      local_addr_fragment);

    fragment->local_addr.Set(
        local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->local_addr.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_addr in DirectTCPServerSocketOptions struct");
    fragment->ipv6_only_$flag = Traits::ipv6_only(input).has_value();
    if (Traits::ipv6_only(input).has_value()) {
      fragment->ipv6_only_$value = Traits::ipv6_only(input).value();
    }
    fragment->backlog_$flag = Traits::backlog(input).has_value();
    if (Traits::backlog(input).has_value()) {
      fragment->backlog_$value = Traits::backlog(input).value();
    }
  }

  static bool Deserialize(::blink::mojom::internal::DirectTCPServerSocketOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DirectTCPServerSocketOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void DirectTCPSocketOptionsDataView::GetRemoteAddrDataView(
    ::network::mojom::HostPortPairDataView* output) {
  auto pointer = data_->remote_addr.Get();
  *output = ::network::mojom::HostPortPairDataView(pointer, message_);
}
inline void DirectTCPSocketOptionsDataView::GetKeepAliveOptionsDataView(
    ::network::mojom::TCPKeepAliveOptionsDataView* output) {
  auto pointer = data_->keep_alive_options.Get();
  *output = ::network::mojom::TCPKeepAliveOptionsDataView(pointer, message_);
}


inline void DirectConnectedUDPSocketOptionsDataView::GetRemoteAddrDataView(
    ::network::mojom::HostPortPairDataView* output) {
  auto pointer = data_->remote_addr.Get();
  *output = ::network::mojom::HostPortPairDataView(pointer, message_);
}


inline void DirectBoundUDPSocketOptionsDataView::GetLocalAddrDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->local_addr.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, message_);
}


inline void DirectTCPServerSocketOptionsDataView::GetLocalAddrDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->local_addr.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_SHARED_H_