// third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-params-data.h"
#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
DirectTCPSocketOptions::DirectTCPSocketOptions()
    : remote_addr(),
      send_buffer_size(),
      receive_buffer_size(),
      no_delay(false),
      keep_alive_options(),
      dns_query_type() {}

DirectTCPSocketOptions::DirectTCPSocketOptions(
    const ::net::HostPortPair& remote_addr_in,
    std::optional<int32_t> send_buffer_size_in,
    std::optional<int32_t> receive_buffer_size_in,
    bool no_delay_in,
    ::network::mojom::blink::TCPKeepAliveOptionsPtr keep_alive_options_in,
    std::optional<::net::DnsQueryType> dns_query_type_in)
    : remote_addr(std::move(remote_addr_in)),
      send_buffer_size(std::move(send_buffer_size_in)),
      receive_buffer_size(std::move(receive_buffer_size_in)),
      no_delay(std::move(no_delay_in)),
      keep_alive_options(std::move(keep_alive_options_in)),
      dns_query_type(std::move(dns_query_type_in)) {}

DirectTCPSocketOptions::~DirectTCPSocketOptions() = default;

void DirectTCPSocketOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_addr"), this->remote_addr,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::HostPortPair&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_buffer_size"), this->send_buffer_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receive_buffer_size"), this->receive_buffer_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "no_delay"), this->no_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keep_alive_options"), this->keep_alive_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::TCPKeepAliveOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dns_query_type"), this->dns_query_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::net::DnsQueryType>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DirectTCPSocketOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DirectConnectedUDPSocketOptions::DirectConnectedUDPSocketOptions()
    : remote_addr(),
      send_buffer_size(),
      receive_buffer_size(),
      dns_query_type(),
      multicast_time_to_live(),
      multicast_loopback() {}

DirectConnectedUDPSocketOptions::DirectConnectedUDPSocketOptions(
    const ::net::HostPortPair& remote_addr_in,
    std::optional<int32_t> send_buffer_size_in,
    std::optional<int32_t> receive_buffer_size_in,
    std::optional<::net::DnsQueryType> dns_query_type_in,
    std::optional<uint8_t> multicast_time_to_live_in,
    std::optional<bool> multicast_loopback_in)
    : remote_addr(std::move(remote_addr_in)),
      send_buffer_size(std::move(send_buffer_size_in)),
      receive_buffer_size(std::move(receive_buffer_size_in)),
      dns_query_type(std::move(dns_query_type_in)),
      multicast_time_to_live(std::move(multicast_time_to_live_in)),
      multicast_loopback(std::move(multicast_loopback_in)) {}

DirectConnectedUDPSocketOptions::~DirectConnectedUDPSocketOptions() = default;

void DirectConnectedUDPSocketOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_addr"), this->remote_addr,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::HostPortPair&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_buffer_size"), this->send_buffer_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receive_buffer_size"), this->receive_buffer_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dns_query_type"), this->dns_query_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::net::DnsQueryType>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "multicast_time_to_live"), this->multicast_time_to_live,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint8_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "multicast_loopback"), this->multicast_loopback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DirectConnectedUDPSocketOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DirectBoundUDPSocketOptions::DirectBoundUDPSocketOptions()
    : local_addr(),
      send_buffer_size(),
      receive_buffer_size(),
      ipv6_only(),
      multicast_allow_address_sharing(),
      multicast_time_to_live(),
      multicast_loopback() {}

DirectBoundUDPSocketOptions::DirectBoundUDPSocketOptions(
    const ::net::IPEndPoint& local_addr_in,
    std::optional<int32_t> send_buffer_size_in,
    std::optional<int32_t> receive_buffer_size_in,
    std::optional<bool> ipv6_only_in,
    std::optional<bool> multicast_allow_address_sharing_in,
    std::optional<uint8_t> multicast_time_to_live_in,
    std::optional<bool> multicast_loopback_in)
    : local_addr(std::move(local_addr_in)),
      send_buffer_size(std::move(send_buffer_size_in)),
      receive_buffer_size(std::move(receive_buffer_size_in)),
      ipv6_only(std::move(ipv6_only_in)),
      multicast_allow_address_sharing(std::move(multicast_allow_address_sharing_in)),
      multicast_time_to_live(std::move(multicast_time_to_live_in)),
      multicast_loopback(std::move(multicast_loopback_in)) {}

DirectBoundUDPSocketOptions::~DirectBoundUDPSocketOptions() = default;

void DirectBoundUDPSocketOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_addr"), this->local_addr,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::IPEndPoint&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_buffer_size"), this->send_buffer_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receive_buffer_size"), this->receive_buffer_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ipv6_only"), this->ipv6_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "multicast_allow_address_sharing"), this->multicast_allow_address_sharing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "multicast_time_to_live"), this->multicast_time_to_live,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint8_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "multicast_loopback"), this->multicast_loopback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DirectBoundUDPSocketOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DirectTCPServerSocketOptions::DirectTCPServerSocketOptions()
    : local_addr(),
      ipv6_only(),
      backlog() {}

DirectTCPServerSocketOptions::DirectTCPServerSocketOptions(
    const ::net::IPEndPoint& local_addr_in,
    std::optional<bool> ipv6_only_in,
    std::optional<uint32_t> backlog_in)
    : local_addr(std::move(local_addr_in)),
      ipv6_only(std::move(ipv6_only_in)),
      backlog(std::move(backlog_in)) {}

DirectTCPServerSocketOptions::~DirectTCPServerSocketOptions() = default;

void DirectTCPServerSocketOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_addr"), this->local_addr,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::IPEndPoint&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ipv6_only"), this->ipv6_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "backlog"), this->backlog,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DirectTCPServerSocketOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

DirectSocketsService::IPCStableHashFunction DirectSocketsService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DirectSocketsService>(message.name())) {
    case messages::DirectSocketsService::kOpenTCPSocket: {
      return &DirectSocketsService::OpenTCPSocket_Sym::IPCStableHash;
    }
    case messages::DirectSocketsService::kOpenConnectedUDPSocket: {
      return &DirectSocketsService::OpenConnectedUDPSocket_Sym::IPCStableHash;
    }
    case messages::DirectSocketsService::kOpenBoundUDPSocket: {
      return &DirectSocketsService::OpenBoundUDPSocket_Sym::IPCStableHash;
    }
    case messages::DirectSocketsService::kOpenTCPServerSocket: {
      return &DirectSocketsService::OpenTCPServerSocket_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DirectSocketsService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DirectSocketsService>(message.name())) {
      case messages::DirectSocketsService::kOpenTCPSocket:
            return "Receive blink::mojom::DirectSocketsService::OpenTCPSocket";
      case messages::DirectSocketsService::kOpenConnectedUDPSocket:
            return "Receive blink::mojom::DirectSocketsService::OpenConnectedUDPSocket";
      case messages::DirectSocketsService::kOpenBoundUDPSocket:
            return "Receive blink::mojom::DirectSocketsService::OpenBoundUDPSocket";
      case messages::DirectSocketsService::kOpenTCPServerSocket:
            return "Receive blink::mojom::DirectSocketsService::OpenTCPServerSocket";
    }
  } else {
    switch (static_cast<messages::DirectSocketsService>(message.name())) {
      case messages::DirectSocketsService::kOpenTCPSocket:
            return "Receive reply blink::mojom::DirectSocketsService::OpenTCPSocket";
      case messages::DirectSocketsService::kOpenConnectedUDPSocket:
            return "Receive reply blink::mojom::DirectSocketsService::OpenConnectedUDPSocket";
      case messages::DirectSocketsService::kOpenBoundUDPSocket:
            return "Receive reply blink::mojom::DirectSocketsService::OpenBoundUDPSocket";
      case messages::DirectSocketsService::kOpenTCPServerSocket:
            return "Receive reply blink::mojom::DirectSocketsService::OpenTCPServerSocket";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DirectSocketsService::OpenTCPSocket_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe00d3347;  // IPCStableHash for blink::mojom::DirectSocketsService::OpenTCPSocket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DirectSocketsService::OpenConnectedUDPSocket_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe90c4103;  // IPCStableHash for blink::mojom::DirectSocketsService::OpenConnectedUDPSocket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DirectSocketsService::OpenBoundUDPSocket_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x72f19ec5;  // IPCStableHash for blink::mojom::DirectSocketsService::OpenBoundUDPSocket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DirectSocketsService::OpenTCPServerSocket_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9e02a218;  // IPCStableHash for blink::mojom::DirectSocketsService::OpenTCPServerSocket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DirectSocketsService_OpenTCPSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DirectSocketsService_OpenTCPSocket_ForwardToCallback(
      DirectSocketsService::OpenTCPSocketCallback callback
      ) : callback_(std::move(callback)) {
  }

  DirectSocketsService_OpenTCPSocket_ForwardToCallback(const DirectSocketsService_OpenTCPSocket_ForwardToCallback&) = delete;
  DirectSocketsService_OpenTCPSocket_ForwardToCallback& operator=(const DirectSocketsService_OpenTCPSocket_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DirectSocketsService::OpenTCPSocketCallback callback_;
};

class DirectSocketsService_OpenConnectedUDPSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DirectSocketsService_OpenConnectedUDPSocket_ForwardToCallback(
      DirectSocketsService::OpenConnectedUDPSocketCallback callback
      ) : callback_(std::move(callback)) {
  }

  DirectSocketsService_OpenConnectedUDPSocket_ForwardToCallback(const DirectSocketsService_OpenConnectedUDPSocket_ForwardToCallback&) = delete;
  DirectSocketsService_OpenConnectedUDPSocket_ForwardToCallback& operator=(const DirectSocketsService_OpenConnectedUDPSocket_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DirectSocketsService::OpenConnectedUDPSocketCallback callback_;
};

class DirectSocketsService_OpenBoundUDPSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DirectSocketsService_OpenBoundUDPSocket_ForwardToCallback(
      DirectSocketsService::OpenBoundUDPSocketCallback callback
      ) : callback_(std::move(callback)) {
  }

  DirectSocketsService_OpenBoundUDPSocket_ForwardToCallback(const DirectSocketsService_OpenBoundUDPSocket_ForwardToCallback&) = delete;
  DirectSocketsService_OpenBoundUDPSocket_ForwardToCallback& operator=(const DirectSocketsService_OpenBoundUDPSocket_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DirectSocketsService::OpenBoundUDPSocketCallback callback_;
};

class DirectSocketsService_OpenTCPServerSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DirectSocketsService_OpenTCPServerSocket_ForwardToCallback(
      DirectSocketsService::OpenTCPServerSocketCallback callback
      ) : callback_(std::move(callback)) {
  }

  DirectSocketsService_OpenTCPServerSocket_ForwardToCallback(const DirectSocketsService_OpenTCPServerSocket_ForwardToCallback&) = delete;
  DirectSocketsService_OpenTCPServerSocket_ForwardToCallback& operator=(const DirectSocketsService_OpenTCPServerSocket_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DirectSocketsService::OpenTCPServerSocketCallback callback_;
};

DirectSocketsServiceProxy::DirectSocketsServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DirectSocketsServiceProxy::OpenTCPSocket(
    DirectTCPSocketOptionsPtr in_options, ::mojo::PendingReceiver<::network::mojom::blink::TCPConnectedSocket> in_receiver, ::mojo::PendingRemote<::network::mojom::blink::SocketObserver> in_observer, OpenTCPSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DirectSocketsService::OpenTCPSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type DirectTCPSocketOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::blink::TCPConnectedSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<::network::mojom::blink::SocketObserver>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DirectSocketsService::kOpenTCPSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DirectSocketsService_OpenTCPSocket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DirectTCPSocketOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in DirectSocketsService.OpenTCPSocket request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TCPConnectedSocketInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in DirectSocketsService.OpenTCPSocket request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SocketObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DirectSocketsService::Name_);
  message.set_method_name("OpenTCPSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DirectSocketsService_OpenTCPSocket_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DirectSocketsServiceProxy::OpenConnectedUDPSocket(
    DirectConnectedUDPSocketOptionsPtr in_options, ::mojo::PendingReceiver<::network::mojom::blink::RestrictedUDPSocket> in_receiver, ::mojo::PendingRemote<::network::mojom::blink::UDPSocketListener> in_listener, OpenConnectedUDPSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DirectSocketsService::OpenConnectedUDPSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type DirectConnectedUDPSocketOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::blink::RestrictedUDPSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<::network::mojom::blink::UDPSocketListener>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DirectSocketsService::kOpenConnectedUDPSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DirectSocketsService_OpenConnectedUDPSocket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DirectConnectedUDPSocketOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in DirectSocketsService.OpenConnectedUDPSocket request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::RestrictedUDPSocketInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in DirectSocketsService.OpenConnectedUDPSocket request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::UDPSocketListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DirectSocketsService::Name_);
  message.set_method_name("OpenConnectedUDPSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DirectSocketsService_OpenConnectedUDPSocket_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DirectSocketsServiceProxy::OpenBoundUDPSocket(
    DirectBoundUDPSocketOptionsPtr in_options, ::mojo::PendingReceiver<::network::mojom::blink::RestrictedUDPSocket> in_receiver, ::mojo::PendingRemote<::network::mojom::blink::UDPSocketListener> in_listener, OpenBoundUDPSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DirectSocketsService::OpenBoundUDPSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type DirectBoundUDPSocketOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::blink::RestrictedUDPSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<::network::mojom::blink::UDPSocketListener>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DirectSocketsService::kOpenBoundUDPSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DirectSocketsService_OpenBoundUDPSocket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DirectBoundUDPSocketOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in DirectSocketsService.OpenBoundUDPSocket request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::RestrictedUDPSocketInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in DirectSocketsService.OpenBoundUDPSocket request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::UDPSocketListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DirectSocketsService::Name_);
  message.set_method_name("OpenBoundUDPSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DirectSocketsService_OpenBoundUDPSocket_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DirectSocketsServiceProxy::OpenTCPServerSocket(
    DirectTCPServerSocketOptionsPtr in_options, ::mojo::PendingReceiver<::network::mojom::blink::TCPServerSocket> in_receiver, OpenTCPServerSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DirectSocketsService::OpenTCPServerSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type DirectTCPServerSocketOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::blink::TCPServerSocket>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DirectSocketsService::kOpenTCPServerSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DirectSocketsService_OpenTCPServerSocket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DirectTCPServerSocketOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in DirectSocketsService.OpenTCPServerSocket request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TCPServerSocketInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in DirectSocketsService.OpenTCPServerSocket request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DirectSocketsService::Name_);
  message.set_method_name("OpenTCPServerSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DirectSocketsService_OpenTCPServerSocket_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class DirectSocketsService_OpenTCPSocket_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DirectSocketsService::OpenTCPSocketCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DirectSocketsService_OpenTCPSocket_ProxyToResponder> proxy(
        new DirectSocketsService_OpenTCPSocket_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DirectSocketsService_OpenTCPSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DirectSocketsService_OpenTCPSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DirectSocketsService_OpenTCPSocket_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DirectSocketsService::OpenTCPSocketCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr, const std::optional<::net::IPEndPoint>& in_peer_addr, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream);
};

bool DirectSocketsService_OpenTCPSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DirectSocketsService_OpenTCPSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DirectSocketsService_OpenTCPSocket_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DirectSocketsService.0
  bool success = true;
  int32_t p_result{};
  std::optional<::net::IPEndPoint> p_local_addr{};
  std::optional<::net::IPEndPoint> p_peer_addr{};
  ::mojo::ScopedDataPipeConsumerHandle p_receive_stream{};
  ::mojo::ScopedDataPipeProducerHandle p_send_stream{};
  DirectSocketsService_OpenTCPSocket_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
    success = false;
  if (success && !input_data_view.ReadPeerAddr(&p_peer_addr))
    success = false;
  if (success)
    p_receive_stream = input_data_view.TakeReceiveStream();
  if (success)
    p_send_stream = input_data_view.TakeSendStream();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DirectSocketsService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr), 
std::move(p_peer_addr), 
std::move(p_receive_stream), 
std::move(p_send_stream));
  }
  return true;
}

void DirectSocketsService_OpenTCPSocket_ProxyToResponder::Run(
    int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr, const std::optional<::net::IPEndPoint>& in_peer_addr, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::DirectSocketsService::OpenTCPSocket", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr"), in_local_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peer_addr"), in_peer_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_stream"), in_receive_stream,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_stream"), in_send_stream,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DirectSocketsService::kOpenTCPSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DirectSocketsService_OpenTCPSocket_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr)::BaseType> local_addr_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_local_addr,
    local_addr_fragment);

  params->local_addr.Set(
      local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->peer_addr)::BaseType> peer_addr_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_peer_addr,
    peer_addr_fragment);

  params->peer_addr.Set(
      peer_addr_fragment.is_null() ? nullptr : peer_addr_fragment.data());

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_receive_stream,
    &params->receive_stream,
    &params.message());

  
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
    in_send_stream,
    &params->send_stream,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DirectSocketsService::Name_);
  message.set_method_name("OpenTCPSocket");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DirectSocketsService_OpenConnectedUDPSocket_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DirectSocketsService::OpenConnectedUDPSocketCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DirectSocketsService_OpenConnectedUDPSocket_ProxyToResponder> proxy(
        new DirectSocketsService_OpenConnectedUDPSocket_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DirectSocketsService_OpenConnectedUDPSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DirectSocketsService_OpenConnectedUDPSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DirectSocketsService_OpenConnectedUDPSocket_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DirectSocketsService::OpenConnectedUDPSocketCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr, const std::optional<::net::IPEndPoint>& in_peer_addr);
};

bool DirectSocketsService_OpenConnectedUDPSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DirectSocketsService_OpenConnectedUDPSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DirectSocketsService_OpenConnectedUDPSocket_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DirectSocketsService.1
  bool success = true;
  int32_t p_result{};
  std::optional<::net::IPEndPoint> p_local_addr{};
  std::optional<::net::IPEndPoint> p_peer_addr{};
  DirectSocketsService_OpenConnectedUDPSocket_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
    success = false;
  if (success && !input_data_view.ReadPeerAddr(&p_peer_addr))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DirectSocketsService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr), 
std::move(p_peer_addr));
  }
  return true;
}

void DirectSocketsService_OpenConnectedUDPSocket_ProxyToResponder::Run(
    int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr, const std::optional<::net::IPEndPoint>& in_peer_addr) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::DirectSocketsService::OpenConnectedUDPSocket", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr"), in_local_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peer_addr"), in_peer_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DirectSocketsService::kOpenConnectedUDPSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DirectSocketsService_OpenConnectedUDPSocket_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr)::BaseType> local_addr_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_local_addr,
    local_addr_fragment);

  params->local_addr.Set(
      local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->peer_addr)::BaseType> peer_addr_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_peer_addr,
    peer_addr_fragment);

  params->peer_addr.Set(
      peer_addr_fragment.is_null() ? nullptr : peer_addr_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DirectSocketsService::Name_);
  message.set_method_name("OpenConnectedUDPSocket");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DirectSocketsService_OpenBoundUDPSocket_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DirectSocketsService::OpenBoundUDPSocketCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DirectSocketsService_OpenBoundUDPSocket_ProxyToResponder> proxy(
        new DirectSocketsService_OpenBoundUDPSocket_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DirectSocketsService_OpenBoundUDPSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DirectSocketsService_OpenBoundUDPSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DirectSocketsService_OpenBoundUDPSocket_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DirectSocketsService::OpenBoundUDPSocketCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr);
};

bool DirectSocketsService_OpenBoundUDPSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DirectSocketsService_OpenBoundUDPSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DirectSocketsService_OpenBoundUDPSocket_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DirectSocketsService.2
  bool success = true;
  int32_t p_result{};
  std::optional<::net::IPEndPoint> p_local_addr{};
  DirectSocketsService_OpenBoundUDPSocket_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DirectSocketsService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr));
  }
  return true;
}

void DirectSocketsService_OpenBoundUDPSocket_ProxyToResponder::Run(
    int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::DirectSocketsService::OpenBoundUDPSocket", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr"), in_local_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DirectSocketsService::kOpenBoundUDPSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DirectSocketsService_OpenBoundUDPSocket_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr)::BaseType> local_addr_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_local_addr,
    local_addr_fragment);

  params->local_addr.Set(
      local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DirectSocketsService::Name_);
  message.set_method_name("OpenBoundUDPSocket");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DirectSocketsService_OpenTCPServerSocket_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DirectSocketsService::OpenTCPServerSocketCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DirectSocketsService_OpenTCPServerSocket_ProxyToResponder> proxy(
        new DirectSocketsService_OpenTCPServerSocket_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DirectSocketsService_OpenTCPServerSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DirectSocketsService_OpenTCPServerSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DirectSocketsService_OpenTCPServerSocket_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DirectSocketsService::OpenTCPServerSocketCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr);
};

bool DirectSocketsService_OpenTCPServerSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DirectSocketsService_OpenTCPServerSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DirectSocketsService_OpenTCPServerSocket_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DirectSocketsService.3
  bool success = true;
  int32_t p_result{};
  std::optional<::net::IPEndPoint> p_local_addr{};
  DirectSocketsService_OpenTCPServerSocket_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DirectSocketsService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr));
  }
  return true;
}

void DirectSocketsService_OpenTCPServerSocket_ProxyToResponder::Run(
    int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::DirectSocketsService::OpenTCPServerSocket", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr"), in_local_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DirectSocketsService::kOpenTCPServerSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DirectSocketsService_OpenTCPServerSocket_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr)::BaseType> local_addr_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_local_addr,
    local_addr_fragment);

  params->local_addr.Set(
      local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DirectSocketsService::Name_);
  message.set_method_name("OpenTCPServerSocket");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DirectSocketsServiceStubDispatch::Accept(
    DirectSocketsService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DirectSocketsService>(message->header()->name)) {
    case messages::DirectSocketsService::kOpenTCPSocket: {
      break;
    }
    case messages::DirectSocketsService::kOpenConnectedUDPSocket: {
      break;
    }
    case messages::DirectSocketsService::kOpenBoundUDPSocket: {
      break;
    }
    case messages::DirectSocketsService::kOpenTCPServerSocket: {
      break;
    }
  }
  return false;
}

// static
bool DirectSocketsServiceStubDispatch::AcceptWithResponder(
    DirectSocketsService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DirectSocketsService>(message->header()->name)) {
    case messages::DirectSocketsService::kOpenTCPSocket: {
      internal::DirectSocketsService_OpenTCPSocket_Params_Data* params =
          reinterpret_cast<
              internal::DirectSocketsService_OpenTCPSocket_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DirectSocketsService.0
      bool success = true;
      DirectTCPSocketOptionsPtr p_options{};
      ::mojo::PendingReceiver<::network::mojom::blink::TCPConnectedSocket> p_receiver{};
      ::mojo::PendingRemote<::network::mojom::blink::SocketObserver> p_observer{};
      DirectSocketsService_OpenTCPSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DirectSocketsService::Name_, 0, false);
        return false;
      }
      auto callback =
          DirectSocketsService_OpenTCPSocket_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenTCPSocket(        
        std::move(p_options), 
        std::move(p_receiver), 
        std::move(p_observer), std::move(callback));
      return true;
    }
    case messages::DirectSocketsService::kOpenConnectedUDPSocket: {
      internal::DirectSocketsService_OpenConnectedUDPSocket_Params_Data* params =
          reinterpret_cast<
              internal::DirectSocketsService_OpenConnectedUDPSocket_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DirectSocketsService.1
      bool success = true;
      DirectConnectedUDPSocketOptionsPtr p_options{};
      ::mojo::PendingReceiver<::network::mojom::blink::RestrictedUDPSocket> p_receiver{};
      ::mojo::PendingRemote<::network::mojom::blink::UDPSocketListener> p_listener{};
      DirectSocketsService_OpenConnectedUDPSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DirectSocketsService::Name_, 1, false);
        return false;
      }
      auto callback =
          DirectSocketsService_OpenConnectedUDPSocket_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenConnectedUDPSocket(        
        std::move(p_options), 
        std::move(p_receiver), 
        std::move(p_listener), std::move(callback));
      return true;
    }
    case messages::DirectSocketsService::kOpenBoundUDPSocket: {
      internal::DirectSocketsService_OpenBoundUDPSocket_Params_Data* params =
          reinterpret_cast<
              internal::DirectSocketsService_OpenBoundUDPSocket_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DirectSocketsService.2
      bool success = true;
      DirectBoundUDPSocketOptionsPtr p_options{};
      ::mojo::PendingReceiver<::network::mojom::blink::RestrictedUDPSocket> p_receiver{};
      ::mojo::PendingRemote<::network::mojom::blink::UDPSocketListener> p_listener{};
      DirectSocketsService_OpenBoundUDPSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DirectSocketsService::Name_, 2, false);
        return false;
      }
      auto callback =
          DirectSocketsService_OpenBoundUDPSocket_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenBoundUDPSocket(        
        std::move(p_options), 
        std::move(p_receiver), 
        std::move(p_listener), std::move(callback));
      return true;
    }
    case messages::DirectSocketsService::kOpenTCPServerSocket: {
      internal::DirectSocketsService_OpenTCPServerSocket_Params_Data* params =
          reinterpret_cast<
              internal::DirectSocketsService_OpenTCPServerSocket_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DirectSocketsService.3
      bool success = true;
      DirectTCPServerSocketOptionsPtr p_options{};
      ::mojo::PendingReceiver<::network::mojom::blink::TCPServerSocket> p_receiver{};
      DirectSocketsService_OpenTCPServerSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DirectSocketsService::Name_, 3, false);
        return false;
      }
      auto callback =
          DirectSocketsService_OpenTCPServerSocket_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenTCPServerSocket(        
        std::move(p_options), 
        std::move(p_receiver), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDirectSocketsServiceValidationInfo[] = {
    { &internal::DirectSocketsService_OpenTCPSocket_Params_Data::Validate,
     &internal::DirectSocketsService_OpenTCPSocket_ResponseParams_Data::Validate},
    { &internal::DirectSocketsService_OpenConnectedUDPSocket_Params_Data::Validate,
     &internal::DirectSocketsService_OpenConnectedUDPSocket_ResponseParams_Data::Validate},
    { &internal::DirectSocketsService_OpenBoundUDPSocket_Params_Data::Validate,
     &internal::DirectSocketsService_OpenBoundUDPSocket_ResponseParams_Data::Validate},
    { &internal::DirectSocketsService_OpenTCPServerSocket_Params_Data::Validate,
     &internal::DirectSocketsService_OpenTCPServerSocket_ResponseParams_Data::Validate},
};

bool DirectSocketsServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::DirectSocketsService::Name_,
    kDirectSocketsServiceValidationInfo);
}

bool DirectSocketsServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::DirectSocketsService::Name_,
    kDirectSocketsServiceValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::DirectTCPSocketOptions::DataView, ::blink::mojom::blink::DirectTCPSocketOptionsPtr>::Read(
    ::blink::mojom::blink::DirectTCPSocketOptions::DataView input,
    ::blink::mojom::blink::DirectTCPSocketOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DirectTCPSocketOptionsPtr result(::blink::mojom::blink::DirectTCPSocketOptions::New());
  
      if (success && !input.ReadRemoteAddr(&result->remote_addr))
        success = false;
      if (success) {
        result->send_buffer_size = input.send_buffer_size();
      }
      if (success) {
        result->receive_buffer_size = input.receive_buffer_size();
      }
      if (success)
        result->no_delay = input.no_delay();
      if (success && !input.ReadKeepAliveOptions(&result->keep_alive_options))
        success = false;
      if (success && !input.ReadDnsQueryType(&result->dns_query_type)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DirectConnectedUDPSocketOptions::DataView, ::blink::mojom::blink::DirectConnectedUDPSocketOptionsPtr>::Read(
    ::blink::mojom::blink::DirectConnectedUDPSocketOptions::DataView input,
    ::blink::mojom::blink::DirectConnectedUDPSocketOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DirectConnectedUDPSocketOptionsPtr result(::blink::mojom::blink::DirectConnectedUDPSocketOptions::New());
  
      if (success && !input.ReadRemoteAddr(&result->remote_addr))
        success = false;
      if (success) {
        result->send_buffer_size = input.send_buffer_size();
      }
      if (success) {
        result->receive_buffer_size = input.receive_buffer_size();
      }
      if (success && !input.ReadDnsQueryType(&result->dns_query_type)) {
        success = false;
      }
      if (success) {
        result->multicast_time_to_live = input.multicast_time_to_live();
      }
      if (success) {
        result->multicast_loopback = input.multicast_loopback();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DirectBoundUDPSocketOptions::DataView, ::blink::mojom::blink::DirectBoundUDPSocketOptionsPtr>::Read(
    ::blink::mojom::blink::DirectBoundUDPSocketOptions::DataView input,
    ::blink::mojom::blink::DirectBoundUDPSocketOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DirectBoundUDPSocketOptionsPtr result(::blink::mojom::blink::DirectBoundUDPSocketOptions::New());
  
      if (success && !input.ReadLocalAddr(&result->local_addr))
        success = false;
      if (success) {
        result->send_buffer_size = input.send_buffer_size();
      }
      if (success) {
        result->receive_buffer_size = input.receive_buffer_size();
      }
      if (success) {
        result->ipv6_only = input.ipv6_only();
      }
      if (success) {
        result->multicast_allow_address_sharing = input.multicast_allow_address_sharing();
      }
      if (success) {
        result->multicast_time_to_live = input.multicast_time_to_live();
      }
      if (success) {
        result->multicast_loopback = input.multicast_loopback();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DirectTCPServerSocketOptions::DataView, ::blink::mojom::blink::DirectTCPServerSocketOptionsPtr>::Read(
    ::blink::mojom::blink::DirectTCPServerSocketOptions::DataView input,
    ::blink::mojom::blink::DirectTCPServerSocketOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DirectTCPServerSocketOptionsPtr result(::blink::mojom::blink::DirectTCPServerSocketOptions::New());
  
      if (success && !input.ReadLocalAddr(&result->local_addr))
        success = false;
      if (success) {
        result->ipv6_only = input.ipv6_only();
      }
      if (success) {
        result->backlog = input.backlog();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void DirectSocketsServiceInterceptorForTesting::OpenTCPSocket(DirectTCPSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::blink::TCPConnectedSocket> receiver, ::mojo::PendingRemote<::network::mojom::blink::SocketObserver> observer, OpenTCPSocketCallback callback) {
  GetForwardingInterface()->OpenTCPSocket(
    std::move(options)
    , 
    std::move(receiver)
    , 
    std::move(observer)
    , std::move(callback));
}
void DirectSocketsServiceInterceptorForTesting::OpenConnectedUDPSocket(DirectConnectedUDPSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::blink::RestrictedUDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::blink::UDPSocketListener> listener, OpenConnectedUDPSocketCallback callback) {
  GetForwardingInterface()->OpenConnectedUDPSocket(
    std::move(options)
    , 
    std::move(receiver)
    , 
    std::move(listener)
    , std::move(callback));
}
void DirectSocketsServiceInterceptorForTesting::OpenBoundUDPSocket(DirectBoundUDPSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::blink::RestrictedUDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::blink::UDPSocketListener> listener, OpenBoundUDPSocketCallback callback) {
  GetForwardingInterface()->OpenBoundUDPSocket(
    std::move(options)
    , 
    std::move(receiver)
    , 
    std::move(listener)
    , std::move(callback));
}
void DirectSocketsServiceInterceptorForTesting::OpenTCPServerSocket(DirectTCPServerSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::blink::TCPServerSocket> receiver, OpenTCPServerSocketCallback callback) {
  GetForwardingInterface()->OpenTCPServerSocket(
    std::move(options)
    , 
    std::move(receiver)
    , std::move(callback));
}
DirectSocketsServiceAsyncWaiter::DirectSocketsServiceAsyncWaiter(
    DirectSocketsService* proxy) : proxy_(proxy) {}

DirectSocketsServiceAsyncWaiter::~DirectSocketsServiceAsyncWaiter() = default;


void DirectSocketsServiceAsyncWaiter::OpenTCPSocket(
    DirectTCPSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::blink::TCPConnectedSocket> receiver, ::mojo::PendingRemote<::network::mojom::blink::SocketObserver> observer, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr, std::optional<::net::IPEndPoint>* out_peer_addr, ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream, ::mojo::ScopedDataPipeProducerHandle* out_send_stream) {
  base::RunLoop loop;
  proxy_->OpenTCPSocket(
      std::move(options),
      std::move(receiver),
      std::move(observer),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             std::optional<::net::IPEndPoint>* out_local_addr
,
             std::optional<::net::IPEndPoint>* out_peer_addr
,
             ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream
,
             ::mojo::ScopedDataPipeProducerHandle* out_send_stream
,
             int32_t result,
             const std::optional<::net::IPEndPoint>& local_addr,
             const std::optional<::net::IPEndPoint>& peer_addr,
             ::mojo::ScopedDataPipeConsumerHandle receive_stream,
             ::mojo::ScopedDataPipeProducerHandle send_stream) {*out_result = std::move(result);*out_local_addr = std::move(local_addr);*out_peer_addr = std::move(peer_addr);*out_receive_stream = std::move(receive_stream);*out_send_stream = std::move(send_stream);
            loop->Quit();
          },
          &loop,
          out_result,
          out_local_addr,
          out_peer_addr,
          out_receive_stream,
          out_send_stream));
  loop.Run();
}



void DirectSocketsServiceAsyncWaiter::OpenConnectedUDPSocket(
    DirectConnectedUDPSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::blink::RestrictedUDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::blink::UDPSocketListener> listener, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr, std::optional<::net::IPEndPoint>* out_peer_addr) {
  base::RunLoop loop;
  proxy_->OpenConnectedUDPSocket(
      std::move(options),
      std::move(receiver),
      std::move(listener),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             std::optional<::net::IPEndPoint>* out_local_addr
,
             std::optional<::net::IPEndPoint>* out_peer_addr
,
             int32_t result,
             const std::optional<::net::IPEndPoint>& local_addr,
             const std::optional<::net::IPEndPoint>& peer_addr) {*out_result = std::move(result);*out_local_addr = std::move(local_addr);*out_peer_addr = std::move(peer_addr);
            loop->Quit();
          },
          &loop,
          out_result,
          out_local_addr,
          out_peer_addr));
  loop.Run();
}



void DirectSocketsServiceAsyncWaiter::OpenBoundUDPSocket(
    DirectBoundUDPSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::blink::RestrictedUDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::blink::UDPSocketListener> listener, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr) {
  base::RunLoop loop;
  proxy_->OpenBoundUDPSocket(
      std::move(options),
      std::move(receiver),
      std::move(listener),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             std::optional<::net::IPEndPoint>* out_local_addr
,
             int32_t result,
             const std::optional<::net::IPEndPoint>& local_addr) {*out_result = std::move(result);*out_local_addr = std::move(local_addr);
            loop->Quit();
          },
          &loop,
          out_result,
          out_local_addr));
  loop.Run();
}



void DirectSocketsServiceAsyncWaiter::OpenTCPServerSocket(
    DirectTCPServerSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::blink::TCPServerSocket> receiver, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr) {
  base::RunLoop loop;
  proxy_->OpenTCPServerSocket(
      std::move(options),
      std::move(receiver),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             std::optional<::net::IPEndPoint>* out_local_addr
,
             int32_t result,
             const std::optional<::net::IPEndPoint>& local_addr) {*out_result = std::move(result);*out_local_addr = std::move(local_addr);
            loop->Quit();
          },
          &loop,
          out_result,
          out_local_addr));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif