// third_party/blink/public/mojom/devtools/inspector_issue.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  BlockedByResponseReason as network_mojom_BlockedByResponseReason,
  BlockedByResponseReasonSpec as network_mojom_BlockedByResponseReasonSpec
} from '../../../../../services/network/public/mojom/blocked_by_response_reason.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  RequestContextType as blink_mojom_RequestContextType,
  RequestContextTypeSpec as blink_mojom_RequestContextTypeSpec
} from '../fetch/fetch_api_request.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const InspectorIssueCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const InspectorIssueCode = {
  
  kCookieIssue: 0,
  kMixedContentIssue: 1,
  kBlockedByResponseIssue: 2,
  kContentSecurityPolicyIssue: 3,
  kSharedArrayBufferIssue: 4,
  kHeavyAdIssue: 5,
  kAttributionReportingIssue: 6,
  kLowTextContrastIssue: 7,
  kFederatedAuthRequestIssue: 8,
  kBounceTrackingIssue: 9,
  kCookieDeprecationMetadataIssue: 10,
  kGenericIssue: 11,
  kDeprecationIssue: 12,
  kFederatedAuthUserInfoRequestIssue: 13,
  kPartitioningBlobURLIssue: 14,
  kUserReidentificationIssue: 15,
  MIN_VALUE: 0,
  MAX_VALUE: 15,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const HeavyAdResolutionStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const HeavyAdResolutionStatus = {
  
  kHeavyAdBlocked: 0,
  kHeavyAdWarning: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const HeavyAdReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const HeavyAdReason = {
  
  kNetworkTotalLimit: 0,
  kCpuTotalLimit: 1,
  kCpuPeakLimit: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AttributionReportingIssueTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AttributionReportingIssueType = {
  
  kPermissionPolicyDisabled: 0,
  kUntrustworthyReportingOrigin: 1,
  kInsecureContext: 2,
  kInvalidRegisterSourceHeader: 3,
  kInvalidRegisterTriggerHeader: 4,
  kSourceAndTriggerHeaders: 5,
  kSourceIgnored: 6,
  kTriggerIgnored: 7,
  kOsSourceIgnored: 8,
  kOsTriggerIgnored: 9,
  kInvalidRegisterOsSourceHeader: 10,
  kInvalidRegisterOsTriggerHeader: 11,
  kWebAndOsHeaders: 12,
  kNoWebOrOsSupport: 13,
  kNavigationRegistrationWithoutTransientUserActivation: 14,
  kInvalidInfoHeader: 15,
  kNoRegisterSourceHeader: 16,
  kNoRegisterTriggerHeader: 17,
  kNoRegisterOsSourceHeader: 18,
  kNoRegisterOsTriggerHeader: 19,
  kNavigationRegistrationUniqueScopeAlreadySet: 20,
  MIN_VALUE: 0,
  MAX_VALUE: 20,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MixedContentResolutionStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MixedContentResolutionStatus = {
  
  kMixedContentBlocked: 0,
  kMixedContentAutomaticallyUpgraded: 1,
  kMixedContentWarning: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ContentSecurityPolicyViolationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ContentSecurityPolicyViolationType = {
  
  kInlineViolation: 0,
  kEvalViolation: 1,
  kURLViolation: 2,
  kSRIViolation: 3,
  kTrustedTypesSinkViolation: 4,
  kTrustedTypesPolicyViolation: 5,
  kWasmEvalViolation: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookieOperationSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookieOperation = {
  
  kSetCookie: 0,
  kReadCookie: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookieExclusionReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookieExclusionReason = {
  
  kExcludeSameSiteUnspecifiedTreatedAsLax: 0,
  kExcludeSameSiteNoneInsecure: 1,
  kExcludeSameSiteLax: 2,
  kExcludeSameSiteStrict: 3,
  kExcludeDomainNonASCII: 4,
  kExcludeThirdPartyPhaseout: 5,
  kExcludePortMismatch: 6,
  kExcludeSchemeMismatch: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookieWarningReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookieWarningReason = {
  
  kWarnSameSiteUnspecifiedCrossSiteContext: 0,
  kWarnSameSiteNoneInsecure: 1,
  kWarnSameSiteUnspecifiedLaxAllowUnsafe: 2,
  kWarnSameSiteStrictLaxDowngradeStrict: 3,
  kWarnSameSiteStrictCrossDowngradeStrict: 4,
  kWarnSameSiteStrictCrossDowngradeLax: 5,
  kWarnSameSiteLaxCrossDowngradeStrict: 6,
  kWarnSameSiteLaxCrossDowngradeLax: 7,
  kWarnAttributeValueExceedsMaxSize: 8,
  kWarnDomainNonASCII: 9,
  kWarnThirdPartyPhaseout: 10,
  kWarnCrossSiteRedirectDowngradeChangesInclusion: 11,
  MIN_VALUE: 0,
  MAX_VALUE: 11,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SharedArrayBufferIssueTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SharedArrayBufferIssueType = {
  
  kTransferIssue: 0,
  kCreationIssue: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FederatedAuthRequestResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FederatedAuthRequestResult = {
  
  kSuccess: 0,
  kShouldEmbargo: 1,
  kIdpNotPotentiallyTrustworthy: 2,
  kDisabledInSettings: 3,
  kDisabledInFlags: 4,
  kTooManyRequests: 5,
  kWellKnownHttpNotFound: 6,
  kWellKnownNoResponse: 7,
  kWellKnownInvalidResponse: 8,
  kWellKnownListEmpty: 9,
  kWellKnownInvalidContentType: 10,
  kConfigNotInWellKnown: 11,
  kWellKnownTooBig: 12,
  kConfigHttpNotFound: 13,
  kConfigNoResponse: 14,
  kConfigInvalidResponse: 15,
  kConfigInvalidContentType: 16,
  kClientMetadataHttpNotFound: 17,
  kClientMetadataNoResponse: 18,
  kClientMetadataInvalidResponse: 19,
  kClientMetadataInvalidContentType: 20,
  kAccountsHttpNotFound: 21,
  kAccountsNoResponse: 22,
  kAccountsInvalidResponse: 23,
  kAccountsListEmpty: 24,
  kAccountsInvalidContentType: 25,
  kIdTokenHttpNotFound: 26,
  kIdTokenNoResponse: 27,
  kIdTokenInvalidResponse: 28,
  kIdTokenIdpErrorResponse: 29,
  kIdTokenCrossSiteIdpErrorResponse: 30,
  kIdTokenInvalidContentType: 31,
  kCanceled: 32,
  kRpPageNotVisible: 33,
  kSilentMediationFailure: 34,
  kThirdPartyCookiesBlocked: 35,
  kNotSignedInWithIdp: 36,
  kMissingTransientUserActivation: 37,
  kReplacedByActiveMode: 38,
  kInvalidFieldsSpecified: 39,
  kRelyingPartyOriginIsOpaque: 40,
  kTypeNotMatching: 41,
  kError: 42,
  kUiDismissedNoEmbargo: 43,
  kCorsError: 44,
  kSuppressedBySegmentationPlatform: 45,
  MIN_VALUE: 0,
  MAX_VALUE: 45,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FederatedAuthUserInfoRequestResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FederatedAuthUserInfoRequestResult = {
  
  kSuccess: 0,
  kNotSameOrigin: 1,
  kNotIframe: 2,
  kNotPotentiallyTrustworthy: 3,
  kNoApiPermission: 4,
  kNotSignedInWithIdp: 5,
  kNoAccountSharingPermission: 6,
  kInvalidConfigOrWellKnown: 7,
  kInvalidAccountsResponse: 8,
  kNoReturningUserFromFetchedAccounts: 9,
  kUnhandledRequest: 10,
  MIN_VALUE: 0,
  MAX_VALUE: 10,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PartitioningBlobURLInfoSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PartitioningBlobURLInfo = {
  
  kBlockedCrossPartitionFetching: 0,
  kEnforceNoopenerForNavigation: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const GenericIssueErrorTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const GenericIssueErrorType = {
  
  kFormLabelForNameError: 0,
  kFormDuplicateIdForInputError: 1,
  kFormInputWithNoLabelError: 2,
  kFormAutocompleteAttributeEmptyError: 3,
  kFormEmptyIdAndNameAttributesForInputError: 4,
  kFormAriaLabelledByToNonExistingIdError: 5,
  kFormInputAssignedAutocompleteValueToIdOrNameAttributeError: 6,
  kFormLabelHasNeitherForNorNestedInputError: 7,
  kFormLabelForMatchesNonExistingIdError: 8,
  kFormInputHasWrongButWellIntendedAutocompleteValueError: 9,
  kResponseWasBlockedByORB: 10,
  kNavigationEntryMarkedSkippable: 11,
  MIN_VALUE: 0,
  MAX_VALUE: 11,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DeprecationIssueTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DeprecationIssueType = {
  
  kExampleBrowserProcessDeprecation: 0,
  kRelatedWebsiteSets: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const UserReidentificationIssueTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const UserReidentificationIssueType = {
  
  kBlockedFrameNavigation: 0,
  kBlockedSubresource: 1,
  kNoisedCanvasReadback: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AffectedCookieSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AffectedRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AffectedFrameSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AffectedLocationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlockedByResponseIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HeavyAdIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AttributionReportingIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MixedContentIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentSecurityPolicyIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedArrayBufferIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LowTextContrastIssueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthRequestIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FederatedAuthUserInfoRequestIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BounceTrackingIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PartitioningBlobURLIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieDeprecationMetadataIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GenericIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DeprecationIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UserReidentificationIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InspectorIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InspectorIssueInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AffectedCookieSpec.$,
    'AffectedCookie',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'path', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'domain', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AffectedCookie {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !string } */
    this.path;
    /** @type { !string } */
    this.domain;
  }
}



mojo.internal.Struct(
    AffectedRequestSpec.$,
    'AffectedRequest',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AffectedRequest {
  constructor() {
    /** @type { (string|undefined) } */
    this.requestId;
    /** @type { !string } */
    this.url;
  }
}



mojo.internal.Struct(
    AffectedFrameSpec.$,
    'AffectedFrame',
    [
      mojo.internal.StructField(
        'frameId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AffectedFrame {
  constructor() {
    /** @type { !string } */
    this.frameId;
  }
}



mojo.internal.Struct(
    AffectedLocationSpec.$,
    'AffectedLocation',
    [
      mojo.internal.StructField(
        'scriptId', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'line', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'column', 20,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AffectedLocation {
  constructor() {
    /** @type { (string|undefined) } */
    this.scriptId;
    /** @type { (string|undefined) } */
    this.url;
    /** @type { !number } */
    this.line;
    /** @type { !number } */
    this.column;
  }
}



mojo.internal.Struct(
    BlockedByResponseIssueDetailsSpec.$,
    'BlockedByResponseIssueDetails',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        AffectedRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'parentFrame', 8,
        0,
        AffectedFrameSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blockedFrame', 16,
        0,
        AffectedFrameSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reason', 24,
        0,
        network_mojom_BlockedByResponseReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class BlockedByResponseIssueDetails {
  constructor() {
    /** @type { !AffectedRequest } */
    this.request;
    /** @type { (AffectedFrame|undefined) } */
    this.parentFrame;
    /** @type { (AffectedFrame|undefined) } */
    this.blockedFrame;
    /** @type { !network_mojom_BlockedByResponseReason } */
    this.reason;
  }
}



mojo.internal.Struct(
    HeavyAdIssueDetailsSpec.$,
    'HeavyAdIssueDetails',
    [
      mojo.internal.StructField(
        'resolution', 0,
        0,
        HeavyAdResolutionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reason', 4,
        0,
        HeavyAdReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frame', 8,
        0,
        AffectedFrameSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HeavyAdIssueDetails {
  constructor() {
    /** @type { !HeavyAdResolutionStatus } */
    this.resolution;
    /** @type { !HeavyAdReason } */
    this.reason;
    /** @type { !AffectedFrame } */
    this.frame;
  }
}



mojo.internal.Struct(
    AttributionReportingIssueDetailsSpec.$,
    'AttributionReportingIssueDetails',
    [
      mojo.internal.StructField(
        'violationType', 0,
        0,
        AttributionReportingIssueTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'request', 8,
        0,
        AffectedRequestSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'invalidParameter', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AttributionReportingIssueDetails {
  constructor() {
    /** @type { !AttributionReportingIssueType } */
    this.violationType;
    /** @type { (AffectedRequest|undefined) } */
    this.request;
    /** @type { (string|undefined) } */
    this.invalidParameter;
  }
}



mojo.internal.Struct(
    MixedContentIssueDetailsSpec.$,
    'MixedContentIssueDetails',
    [
      mojo.internal.StructField(
        'requestContext', 0,
        0,
        blink_mojom_RequestContextTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resolutionStatus', 4,
        0,
        MixedContentResolutionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'insecureUrl', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mainResourceUrl', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'request', 24,
        0,
        AffectedRequestSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frame', 32,
        0,
        AffectedFrameSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class MixedContentIssueDetails {
  constructor() {
    /** @type { !blink_mojom_RequestContextType } */
    this.requestContext;
    /** @type { !MixedContentResolutionStatus } */
    this.resolutionStatus;
    /** @type { !string } */
    this.insecureUrl;
    /** @type { !string } */
    this.mainResourceUrl;
    /** @type { (AffectedRequest|undefined) } */
    this.request;
    /** @type { (AffectedFrame|undefined) } */
    this.frame;
  }
}



mojo.internal.Struct(
    ContentSecurityPolicyIssueDetailsSpec.$,
    'ContentSecurityPolicyIssueDetails',
    [
      mojo.internal.StructField(
        'blockedUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'violatedDirective', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isReportOnly', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentSecurityPolicyViolationType', 20,
        0,
        ContentSecurityPolicyViolationTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameAncestor', 24,
        0,
        AffectedFrameSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'affectedLocation', 32,
        0,
        AffectedLocationSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'violatingNodeId', 40,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class ContentSecurityPolicyIssueDetails {
  constructor() {
    /** @type { (url_mojom_Url|undefined) } */
    this.blockedUrl;
    /** @type { !string } */
    this.violatedDirective;
    /** @type { !boolean } */
    this.isReportOnly;
    /** @type { !ContentSecurityPolicyViolationType } */
    this.contentSecurityPolicyViolationType;
    /** @type { (AffectedFrame|undefined) } */
    this.frameAncestor;
    /** @type { (AffectedLocation|undefined) } */
    this.affectedLocation;
    /** @type { !number } */
    this.violatingNodeId;
  }
}



mojo.internal.Struct(
    CookieIssueDetailsSpec.$,
    'CookieIssueDetails',
    [
      mojo.internal.StructField(
        'cookie', 0,
        0,
        AffectedCookieSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'exclusionReason', 8,
        0,
        mojo.internal.Array(CookieExclusionReasonSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'warningReason', 16,
        0,
        mojo.internal.Array(CookieWarningReasonSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'operation', 24,
        0,
        CookieOperationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'siteForCookies', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieUrl', 40,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'request', 48,
        0,
        AffectedRequestSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class CookieIssueDetails {
  constructor() {
    /** @type { !AffectedCookie } */
    this.cookie;
    /** @type { !Array<!CookieExclusionReason> } */
    this.exclusionReason;
    /** @type { !Array<!CookieWarningReason> } */
    this.warningReason;
    /** @type { !CookieOperation } */
    this.operation;
    /** @type { (url_mojom_Url|undefined) } */
    this.siteForCookies;
    /** @type { (url_mojom_Url|undefined) } */
    this.cookieUrl;
    /** @type { (AffectedRequest|undefined) } */
    this.request;
  }
}



mojo.internal.Struct(
    SharedArrayBufferIssueDetailsSpec.$,
    'SharedArrayBufferIssueDetails',
    [
      mojo.internal.StructField(
        'affectedLocation', 0,
        0,
        AffectedLocationSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isWarning', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 12,
        0,
        SharedArrayBufferIssueTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedArrayBufferIssueDetails {
  constructor() {
    /** @type { (AffectedLocation|undefined) } */
    this.affectedLocation;
    /** @type { !boolean } */
    this.isWarning;
    /** @type { !SharedArrayBufferIssueType } */
    this.type;
  }
}



mojo.internal.Struct(
    LowTextContrastIssueSpec.$,
    'LowTextContrastIssue',
    [
      mojo.internal.StructField(
        'violatingNodeId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'violatingNodeSelector', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contrastRatio', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'thresholdAa', 16,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'thresholdAaa', 20,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fontSize', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fontWeight', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class LowTextContrastIssue {
  constructor() {
    /** @type { !number } */
    this.violatingNodeId;
    /** @type { !string } */
    this.violatingNodeSelector;
    /** @type { !number } */
    this.contrastRatio;
    /** @type { !number } */
    this.thresholdAa;
    /** @type { !number } */
    this.thresholdAaa;
    /** @type { !string } */
    this.fontSize;
    /** @type { !string } */
    this.fontWeight;
  }
}



mojo.internal.Struct(
    FederatedAuthRequestIssueDetailsSpec.$,
    'FederatedAuthRequestIssueDetails',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        FederatedAuthRequestResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FederatedAuthRequestIssueDetails {
  constructor() {
    /** @type { !FederatedAuthRequestResult } */
    this.status;
  }
}



mojo.internal.Struct(
    FederatedAuthUserInfoRequestIssueDetailsSpec.$,
    'FederatedAuthUserInfoRequestIssueDetails',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        FederatedAuthUserInfoRequestResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FederatedAuthUserInfoRequestIssueDetails {
  constructor() {
    /** @type { !FederatedAuthUserInfoRequestResult } */
    this.status;
  }
}



mojo.internal.Struct(
    BounceTrackingIssueDetailsSpec.$,
    'BounceTrackingIssueDetails',
    [
      mojo.internal.StructField(
        'trackingSites', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BounceTrackingIssueDetails {
  constructor() {
    /** @type { !Array<!string> } */
    this.trackingSites;
  }
}



mojo.internal.Struct(
    PartitioningBlobURLIssueDetailsSpec.$,
    'PartitioningBlobURLIssueDetails',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'partitioningBlobUrlInfo', 8,
        0,
        PartitioningBlobURLInfoSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PartitioningBlobURLIssueDetails {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !PartitioningBlobURLInfo } */
    this.partitioningBlobUrlInfo;
  }
}



mojo.internal.Struct(
    CookieDeprecationMetadataIssueDetailsSpec.$,
    'CookieDeprecationMetadataIssueDetails',
    [
      mojo.internal.StructField(
        'allowedSites', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'optOutPercentage', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isOptOutTopLevel', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'operation', 16,
        0,
        CookieOperationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CookieDeprecationMetadataIssueDetails {
  constructor() {
    /** @type { !Array<!string> } */
    this.allowedSites;
    /** @type { !number } */
    this.optOutPercentage;
    /** @type { !boolean } */
    this.isOptOutTopLevel;
    /** @type { !CookieOperation } */
    this.operation;
  }
}



mojo.internal.Struct(
    GenericIssueDetailsSpec.$,
    'GenericIssueDetails',
    [
      mojo.internal.StructField(
        'errorType', 0,
        0,
        GenericIssueErrorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameId', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'violatingNodeId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'violatingNodeAttribute', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class GenericIssueDetails {
  constructor() {
    /** @type { !GenericIssueErrorType } */
    this.errorType;
    /** @type { (string|undefined) } */
    this.frameId;
    /** @type { !number } */
    this.violatingNodeId;
    /** @type { (string|undefined) } */
    this.violatingNodeAttribute;
  }
}



mojo.internal.Struct(
    DeprecationIssueDetailsSpec.$,
    'DeprecationIssueDetails',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        DeprecationIssueTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'affectedLocation', 8,
        0,
        AffectedLocationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DeprecationIssueDetails {
  constructor() {
    /** @type { !DeprecationIssueType } */
    this.type;
    /** @type { !AffectedLocation } */
    this.affectedLocation;
  }
}



mojo.internal.Struct(
    UserReidentificationIssueDetailsSpec.$,
    'UserReidentificationIssueDetails',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        UserReidentificationIssueTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'request', 8,
        0,
        AffectedRequestSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceCodeLocation', 16,
        0,
        AffectedLocationSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class UserReidentificationIssueDetails {
  constructor() {
    /** @type { !UserReidentificationIssueType } */
    this.type;
    /** @type { (AffectedRequest|undefined) } */
    this.request;
    /** @type { (AffectedLocation|undefined) } */
    this.sourceCodeLocation;
  }
}



mojo.internal.Struct(
    InspectorIssueDetailsSpec.$,
    'InspectorIssueDetails',
    [
      mojo.internal.StructField(
        'cookieIssueDetails', 0,
        0,
        CookieIssueDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mixedContentIssueDetails', 8,
        0,
        MixedContentIssueDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blockedByResponseIssueDetails', 16,
        0,
        BlockedByResponseIssueDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cspIssueDetails', 24,
        0,
        ContentSecurityPolicyIssueDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sabIssueDetails', 32,
        0,
        SharedArrayBufferIssueDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'heavyAdIssueDetails', 40,
        0,
        HeavyAdIssueDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'attributionReportingIssueDetails', 48,
        0,
        AttributionReportingIssueDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lowTextContrastDetails', 56,
        0,
        LowTextContrastIssueSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'federatedAuthRequestDetails', 64,
        0,
        FederatedAuthRequestIssueDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bounceTrackingIssueDetails', 72,
        0,
        BounceTrackingIssueDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'partitioningBlobUrlIssueDetails', 80,
        0,
        PartitioningBlobURLIssueDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieDeprecationMetadataIssueDetails', 88,
        0,
        CookieDeprecationMetadataIssueDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'genericIssueDetails', 96,
        0,
        GenericIssueDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deprecationIssueDetails', 104,
        0,
        DeprecationIssueDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'federatedAuthUserInfoRequestDetails', 112,
        0,
        FederatedAuthUserInfoRequestIssueDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userReidentificationIssueDetails', 120,
        0,
        UserReidentificationIssueDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'issueId', 128,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 144],]);



/**
 * @record
 */
export class InspectorIssueDetails {
  constructor() {
    /** @type { (CookieIssueDetails|undefined) } */
    this.cookieIssueDetails;
    /** @type { (MixedContentIssueDetails|undefined) } */
    this.mixedContentIssueDetails;
    /** @type { (BlockedByResponseIssueDetails|undefined) } */
    this.blockedByResponseIssueDetails;
    /** @type { (ContentSecurityPolicyIssueDetails|undefined) } */
    this.cspIssueDetails;
    /** @type { (SharedArrayBufferIssueDetails|undefined) } */
    this.sabIssueDetails;
    /** @type { (HeavyAdIssueDetails|undefined) } */
    this.heavyAdIssueDetails;
    /** @type { (AttributionReportingIssueDetails|undefined) } */
    this.attributionReportingIssueDetails;
    /** @type { (LowTextContrastIssue|undefined) } */
    this.lowTextContrastDetails;
    /** @type { (FederatedAuthRequestIssueDetails|undefined) } */
    this.federatedAuthRequestDetails;
    /** @type { (BounceTrackingIssueDetails|undefined) } */
    this.bounceTrackingIssueDetails;
    /** @type { (PartitioningBlobURLIssueDetails|undefined) } */
    this.partitioningBlobUrlIssueDetails;
    /** @type { (CookieDeprecationMetadataIssueDetails|undefined) } */
    this.cookieDeprecationMetadataIssueDetails;
    /** @type { (GenericIssueDetails|undefined) } */
    this.genericIssueDetails;
    /** @type { (DeprecationIssueDetails|undefined) } */
    this.deprecationIssueDetails;
    /** @type { (FederatedAuthUserInfoRequestIssueDetails|undefined) } */
    this.federatedAuthUserInfoRequestDetails;
    /** @type { (UserReidentificationIssueDetails|undefined) } */
    this.userReidentificationIssueDetails;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.issueId;
  }
}



mojo.internal.Struct(
    InspectorIssueInfoSpec.$,
    'InspectorIssueInfo',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        InspectorIssueCodeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'details', 8,
        0,
        InspectorIssueDetailsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InspectorIssueInfo {
  constructor() {
    /** @type { !InspectorIssueCode } */
    this.code;
    /** @type { !InspectorIssueDetails } */
    this.details;
  }
}

