// third_party/blink/public/mojom/devtools/inspector_issue.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/devtools/inspector_issue.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var blocked_by_response_reason$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/blocked_by_response_reason.mojom', '../../../../../services/network/public/mojom/blocked_by_response_reason.mojom.js');
  }
  var cookie_manager$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cookie_manager.mojom', '../../../../../services/network/public/mojom/cookie_manager.mojom.js');
  }
  var fetch_api_request$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/fetch/fetch_api_request.mojom', '../fetch/fetch_api_request.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var InspectorIssueCode = {};
  InspectorIssueCode.kCookieIssue = 0;
  InspectorIssueCode.kMixedContentIssue = 1;
  InspectorIssueCode.kBlockedByResponseIssue = 2;
  InspectorIssueCode.kContentSecurityPolicyIssue = 3;
  InspectorIssueCode.kSharedArrayBufferIssue = 4;
  InspectorIssueCode.kHeavyAdIssue = 5;
  InspectorIssueCode.kAttributionReportingIssue = 6;
  InspectorIssueCode.kLowTextContrastIssue = 7;
  InspectorIssueCode.kFederatedAuthRequestIssue = 8;
  InspectorIssueCode.kBounceTrackingIssue = 9;
  InspectorIssueCode.kCookieDeprecationMetadataIssue = 10;
  InspectorIssueCode.kGenericIssue = 11;
  InspectorIssueCode.kDeprecationIssue = 12;
  InspectorIssueCode.kFederatedAuthUserInfoRequestIssue = 13;
  InspectorIssueCode.kPartitioningBlobURLIssue = 14;
  InspectorIssueCode.kUserReidentificationIssue = 15;
  InspectorIssueCode.MIN_VALUE = 0;
  InspectorIssueCode.MAX_VALUE = 15;

  InspectorIssueCode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
      return true;
    }
    return false;
  };

  InspectorIssueCode.toKnownEnumValue = function(value) {
    return value;
  };

  InspectorIssueCode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var HeavyAdResolutionStatus = {};
  HeavyAdResolutionStatus.kHeavyAdBlocked = 0;
  HeavyAdResolutionStatus.kHeavyAdWarning = 1;
  HeavyAdResolutionStatus.MIN_VALUE = 0;
  HeavyAdResolutionStatus.MAX_VALUE = 1;

  HeavyAdResolutionStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  HeavyAdResolutionStatus.toKnownEnumValue = function(value) {
    return value;
  };

  HeavyAdResolutionStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var HeavyAdReason = {};
  HeavyAdReason.kNetworkTotalLimit = 0;
  HeavyAdReason.kCpuTotalLimit = 1;
  HeavyAdReason.kCpuPeakLimit = 2;
  HeavyAdReason.MIN_VALUE = 0;
  HeavyAdReason.MAX_VALUE = 2;

  HeavyAdReason.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  HeavyAdReason.toKnownEnumValue = function(value) {
    return value;
  };

  HeavyAdReason.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AttributionReportingIssueType = {};
  AttributionReportingIssueType.kPermissionPolicyDisabled = 0;
  AttributionReportingIssueType.kUntrustworthyReportingOrigin = 1;
  AttributionReportingIssueType.kInsecureContext = 2;
  AttributionReportingIssueType.kInvalidRegisterSourceHeader = 3;
  AttributionReportingIssueType.kInvalidRegisterTriggerHeader = 4;
  AttributionReportingIssueType.kSourceAndTriggerHeaders = 5;
  AttributionReportingIssueType.kSourceIgnored = 6;
  AttributionReportingIssueType.kTriggerIgnored = 7;
  AttributionReportingIssueType.kOsSourceIgnored = 8;
  AttributionReportingIssueType.kOsTriggerIgnored = 9;
  AttributionReportingIssueType.kInvalidRegisterOsSourceHeader = 10;
  AttributionReportingIssueType.kInvalidRegisterOsTriggerHeader = 11;
  AttributionReportingIssueType.kWebAndOsHeaders = 12;
  AttributionReportingIssueType.kNoWebOrOsSupport = 13;
  AttributionReportingIssueType.kNavigationRegistrationWithoutTransientUserActivation = 14;
  AttributionReportingIssueType.kInvalidInfoHeader = 15;
  AttributionReportingIssueType.kNoRegisterSourceHeader = 16;
  AttributionReportingIssueType.kNoRegisterTriggerHeader = 17;
  AttributionReportingIssueType.kNoRegisterOsSourceHeader = 18;
  AttributionReportingIssueType.kNoRegisterOsTriggerHeader = 19;
  AttributionReportingIssueType.kNavigationRegistrationUniqueScopeAlreadySet = 20;
  AttributionReportingIssueType.MIN_VALUE = 0;
  AttributionReportingIssueType.MAX_VALUE = 20;

  AttributionReportingIssueType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
      return true;
    }
    return false;
  };

  AttributionReportingIssueType.toKnownEnumValue = function(value) {
    return value;
  };

  AttributionReportingIssueType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MixedContentResolutionStatus = {};
  MixedContentResolutionStatus.kMixedContentBlocked = 0;
  MixedContentResolutionStatus.kMixedContentAutomaticallyUpgraded = 1;
  MixedContentResolutionStatus.kMixedContentWarning = 2;
  MixedContentResolutionStatus.MIN_VALUE = 0;
  MixedContentResolutionStatus.MAX_VALUE = 2;

  MixedContentResolutionStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  MixedContentResolutionStatus.toKnownEnumValue = function(value) {
    return value;
  };

  MixedContentResolutionStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ContentSecurityPolicyViolationType = {};
  ContentSecurityPolicyViolationType.kInlineViolation = 0;
  ContentSecurityPolicyViolationType.kEvalViolation = 1;
  ContentSecurityPolicyViolationType.kURLViolation = 2;
  ContentSecurityPolicyViolationType.kSRIViolation = 3;
  ContentSecurityPolicyViolationType.kTrustedTypesSinkViolation = 4;
  ContentSecurityPolicyViolationType.kTrustedTypesPolicyViolation = 5;
  ContentSecurityPolicyViolationType.kWasmEvalViolation = 6;
  ContentSecurityPolicyViolationType.MIN_VALUE = 0;
  ContentSecurityPolicyViolationType.MAX_VALUE = 6;

  ContentSecurityPolicyViolationType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  ContentSecurityPolicyViolationType.toKnownEnumValue = function(value) {
    return value;
  };

  ContentSecurityPolicyViolationType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CookieOperation = {};
  CookieOperation.kSetCookie = 0;
  CookieOperation.kReadCookie = 1;
  CookieOperation.MIN_VALUE = 0;
  CookieOperation.MAX_VALUE = 1;

  CookieOperation.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  CookieOperation.toKnownEnumValue = function(value) {
    return value;
  };

  CookieOperation.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CookieExclusionReason = {};
  CookieExclusionReason.kExcludeSameSiteUnspecifiedTreatedAsLax = 0;
  CookieExclusionReason.kExcludeSameSiteNoneInsecure = 1;
  CookieExclusionReason.kExcludeSameSiteLax = 2;
  CookieExclusionReason.kExcludeSameSiteStrict = 3;
  CookieExclusionReason.kExcludeDomainNonASCII = 4;
  CookieExclusionReason.kExcludeThirdPartyPhaseout = 5;
  CookieExclusionReason.kExcludePortMismatch = 6;
  CookieExclusionReason.kExcludeSchemeMismatch = 7;
  CookieExclusionReason.MIN_VALUE = 0;
  CookieExclusionReason.MAX_VALUE = 7;

  CookieExclusionReason.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  CookieExclusionReason.toKnownEnumValue = function(value) {
    return value;
  };

  CookieExclusionReason.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CookieWarningReason = {};
  CookieWarningReason.kWarnSameSiteUnspecifiedCrossSiteContext = 0;
  CookieWarningReason.kWarnSameSiteNoneInsecure = 1;
  CookieWarningReason.kWarnSameSiteUnspecifiedLaxAllowUnsafe = 2;
  CookieWarningReason.kWarnSameSiteStrictLaxDowngradeStrict = 3;
  CookieWarningReason.kWarnSameSiteStrictCrossDowngradeStrict = 4;
  CookieWarningReason.kWarnSameSiteStrictCrossDowngradeLax = 5;
  CookieWarningReason.kWarnSameSiteLaxCrossDowngradeStrict = 6;
  CookieWarningReason.kWarnSameSiteLaxCrossDowngradeLax = 7;
  CookieWarningReason.kWarnAttributeValueExceedsMaxSize = 8;
  CookieWarningReason.kWarnDomainNonASCII = 9;
  CookieWarningReason.kWarnThirdPartyPhaseout = 10;
  CookieWarningReason.kWarnCrossSiteRedirectDowngradeChangesInclusion = 11;
  CookieWarningReason.MIN_VALUE = 0;
  CookieWarningReason.MAX_VALUE = 11;

  CookieWarningReason.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
      return true;
    }
    return false;
  };

  CookieWarningReason.toKnownEnumValue = function(value) {
    return value;
  };

  CookieWarningReason.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SharedArrayBufferIssueType = {};
  SharedArrayBufferIssueType.kTransferIssue = 0;
  SharedArrayBufferIssueType.kCreationIssue = 1;
  SharedArrayBufferIssueType.MIN_VALUE = 0;
  SharedArrayBufferIssueType.MAX_VALUE = 1;

  SharedArrayBufferIssueType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  SharedArrayBufferIssueType.toKnownEnumValue = function(value) {
    return value;
  };

  SharedArrayBufferIssueType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var FederatedAuthRequestResult = {};
  FederatedAuthRequestResult.kSuccess = 0;
  FederatedAuthRequestResult.kShouldEmbargo = 1;
  FederatedAuthRequestResult.kIdpNotPotentiallyTrustworthy = 2;
  FederatedAuthRequestResult.kDisabledInSettings = 3;
  FederatedAuthRequestResult.kDisabledInFlags = 4;
  FederatedAuthRequestResult.kTooManyRequests = 5;
  FederatedAuthRequestResult.kWellKnownHttpNotFound = 6;
  FederatedAuthRequestResult.kWellKnownNoResponse = 7;
  FederatedAuthRequestResult.kWellKnownInvalidResponse = 8;
  FederatedAuthRequestResult.kWellKnownListEmpty = 9;
  FederatedAuthRequestResult.kWellKnownInvalidContentType = 10;
  FederatedAuthRequestResult.kConfigNotInWellKnown = 11;
  FederatedAuthRequestResult.kWellKnownTooBig = 12;
  FederatedAuthRequestResult.kConfigHttpNotFound = 13;
  FederatedAuthRequestResult.kConfigNoResponse = 14;
  FederatedAuthRequestResult.kConfigInvalidResponse = 15;
  FederatedAuthRequestResult.kConfigInvalidContentType = 16;
  FederatedAuthRequestResult.kClientMetadataHttpNotFound = 17;
  FederatedAuthRequestResult.kClientMetadataNoResponse = 18;
  FederatedAuthRequestResult.kClientMetadataInvalidResponse = 19;
  FederatedAuthRequestResult.kClientMetadataInvalidContentType = 20;
  FederatedAuthRequestResult.kAccountsHttpNotFound = 21;
  FederatedAuthRequestResult.kAccountsNoResponse = 22;
  FederatedAuthRequestResult.kAccountsInvalidResponse = 23;
  FederatedAuthRequestResult.kAccountsListEmpty = 24;
  FederatedAuthRequestResult.kAccountsInvalidContentType = 25;
  FederatedAuthRequestResult.kIdTokenHttpNotFound = 26;
  FederatedAuthRequestResult.kIdTokenNoResponse = 27;
  FederatedAuthRequestResult.kIdTokenInvalidResponse = 28;
  FederatedAuthRequestResult.kIdTokenIdpErrorResponse = 29;
  FederatedAuthRequestResult.kIdTokenCrossSiteIdpErrorResponse = 30;
  FederatedAuthRequestResult.kIdTokenInvalidContentType = 31;
  FederatedAuthRequestResult.kCanceled = 32;
  FederatedAuthRequestResult.kRpPageNotVisible = 33;
  FederatedAuthRequestResult.kSilentMediationFailure = 34;
  FederatedAuthRequestResult.kThirdPartyCookiesBlocked = 35;
  FederatedAuthRequestResult.kNotSignedInWithIdp = 36;
  FederatedAuthRequestResult.kMissingTransientUserActivation = 37;
  FederatedAuthRequestResult.kReplacedByActiveMode = 38;
  FederatedAuthRequestResult.kInvalidFieldsSpecified = 39;
  FederatedAuthRequestResult.kRelyingPartyOriginIsOpaque = 40;
  FederatedAuthRequestResult.kTypeNotMatching = 41;
  FederatedAuthRequestResult.kError = 42;
  FederatedAuthRequestResult.kUiDismissedNoEmbargo = 43;
  FederatedAuthRequestResult.kCorsError = 44;
  FederatedAuthRequestResult.kSuppressedBySegmentationPlatform = 45;
  FederatedAuthRequestResult.MIN_VALUE = 0;
  FederatedAuthRequestResult.MAX_VALUE = 45;

  FederatedAuthRequestResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
      return true;
    }
    return false;
  };

  FederatedAuthRequestResult.toKnownEnumValue = function(value) {
    return value;
  };

  FederatedAuthRequestResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var FederatedAuthUserInfoRequestResult = {};
  FederatedAuthUserInfoRequestResult.kSuccess = 0;
  FederatedAuthUserInfoRequestResult.kNotSameOrigin = 1;
  FederatedAuthUserInfoRequestResult.kNotIframe = 2;
  FederatedAuthUserInfoRequestResult.kNotPotentiallyTrustworthy = 3;
  FederatedAuthUserInfoRequestResult.kNoApiPermission = 4;
  FederatedAuthUserInfoRequestResult.kNotSignedInWithIdp = 5;
  FederatedAuthUserInfoRequestResult.kNoAccountSharingPermission = 6;
  FederatedAuthUserInfoRequestResult.kInvalidConfigOrWellKnown = 7;
  FederatedAuthUserInfoRequestResult.kInvalidAccountsResponse = 8;
  FederatedAuthUserInfoRequestResult.kNoReturningUserFromFetchedAccounts = 9;
  FederatedAuthUserInfoRequestResult.kUnhandledRequest = 10;
  FederatedAuthUserInfoRequestResult.MIN_VALUE = 0;
  FederatedAuthUserInfoRequestResult.MAX_VALUE = 10;

  FederatedAuthUserInfoRequestResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
      return true;
    }
    return false;
  };

  FederatedAuthUserInfoRequestResult.toKnownEnumValue = function(value) {
    return value;
  };

  FederatedAuthUserInfoRequestResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var PartitioningBlobURLInfo = {};
  PartitioningBlobURLInfo.kBlockedCrossPartitionFetching = 0;
  PartitioningBlobURLInfo.kEnforceNoopenerForNavigation = 1;
  PartitioningBlobURLInfo.MIN_VALUE = 0;
  PartitioningBlobURLInfo.MAX_VALUE = 1;

  PartitioningBlobURLInfo.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  PartitioningBlobURLInfo.toKnownEnumValue = function(value) {
    return value;
  };

  PartitioningBlobURLInfo.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var GenericIssueErrorType = {};
  GenericIssueErrorType.kFormLabelForNameError = 0;
  GenericIssueErrorType.kFormDuplicateIdForInputError = 1;
  GenericIssueErrorType.kFormInputWithNoLabelError = 2;
  GenericIssueErrorType.kFormAutocompleteAttributeEmptyError = 3;
  GenericIssueErrorType.kFormEmptyIdAndNameAttributesForInputError = 4;
  GenericIssueErrorType.kFormAriaLabelledByToNonExistingIdError = 5;
  GenericIssueErrorType.kFormInputAssignedAutocompleteValueToIdOrNameAttributeError = 6;
  GenericIssueErrorType.kFormLabelHasNeitherForNorNestedInputError = 7;
  GenericIssueErrorType.kFormLabelForMatchesNonExistingIdError = 8;
  GenericIssueErrorType.kFormInputHasWrongButWellIntendedAutocompleteValueError = 9;
  GenericIssueErrorType.kResponseWasBlockedByORB = 10;
  GenericIssueErrorType.kNavigationEntryMarkedSkippable = 11;
  GenericIssueErrorType.MIN_VALUE = 0;
  GenericIssueErrorType.MAX_VALUE = 11;

  GenericIssueErrorType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
      return true;
    }
    return false;
  };

  GenericIssueErrorType.toKnownEnumValue = function(value) {
    return value;
  };

  GenericIssueErrorType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var DeprecationIssueType = {};
  DeprecationIssueType.kExampleBrowserProcessDeprecation = 0;
  DeprecationIssueType.kRelatedWebsiteSets = 1;
  DeprecationIssueType.MIN_VALUE = 0;
  DeprecationIssueType.MAX_VALUE = 1;

  DeprecationIssueType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  DeprecationIssueType.toKnownEnumValue = function(value) {
    return value;
  };

  DeprecationIssueType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var UserReidentificationIssueType = {};
  UserReidentificationIssueType.kBlockedFrameNavigation = 0;
  UserReidentificationIssueType.kBlockedSubresource = 1;
  UserReidentificationIssueType.kNoisedCanvasReadback = 2;
  UserReidentificationIssueType.MIN_VALUE = 0;
  UserReidentificationIssueType.MAX_VALUE = 2;

  UserReidentificationIssueType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  UserReidentificationIssueType.toKnownEnumValue = function(value) {
    return value;
  };

  UserReidentificationIssueType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function AffectedCookie(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AffectedCookie.prototype.initDefaults_ = function() {
    this.name = null;
    this.path = null;
    this.domain = null;
  };
  AffectedCookie.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AffectedCookie.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AffectedCookie.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AffectedCookie.path
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AffectedCookie.domain
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AffectedCookie.encodedSize = codec.kStructHeaderSize + 24;

  AffectedCookie.decode = function(decoder) {
    var packed;
    var val = new AffectedCookie();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.path =
        decoder.decodeStruct(codec.String);
    val.domain =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AffectedCookie.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AffectedCookie.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.path);
    encoder.encodeStruct(codec.String, val.domain);
  };
  function AffectedRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AffectedRequest.prototype.initDefaults_ = function() {
    this.requestId = null;
    this.url = null;
  };
  AffectedRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AffectedRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AffectedRequest.requestId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AffectedRequest.url
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AffectedRequest.encodedSize = codec.kStructHeaderSize + 16;

  AffectedRequest.decode = function(decoder) {
    var packed;
    var val = new AffectedRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AffectedRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AffectedRequest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.requestId);
    encoder.encodeStruct(codec.String, val.url);
  };
  function AffectedFrame(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AffectedFrame.prototype.initDefaults_ = function() {
    this.frameId = null;
  };
  AffectedFrame.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AffectedFrame.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AffectedFrame.frameId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AffectedFrame.encodedSize = codec.kStructHeaderSize + 8;

  AffectedFrame.decode = function(decoder) {
    var packed;
    var val = new AffectedFrame();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AffectedFrame.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AffectedFrame.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.frameId);
  };
  function AffectedLocation(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AffectedLocation.prototype.initDefaults_ = function() {
    this.scriptId = null;
    this.url = null;
    this.line = 0;
    this.column = 0;
  };
  AffectedLocation.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AffectedLocation.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AffectedLocation.scriptId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AffectedLocation.url
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AffectedLocation.encodedSize = codec.kStructHeaderSize + 24;

  AffectedLocation.decode = function(decoder) {
    var packed;
    var val = new AffectedLocation();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scriptId =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStruct(codec.String);
    val.line =
        decoder.decodeStruct(codec.Uint32);
    val.column =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  AffectedLocation.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AffectedLocation.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.scriptId);
    encoder.encodeStruct(codec.String, val.url);
    encoder.encodeStruct(codec.Uint32, val.line);
    encoder.encodeStruct(codec.Uint32, val.column);
  };
  function BlockedByResponseIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BlockedByResponseIssueDetails.prototype.initDefaults_ = function() {
    this.request = null;
    this.parentFrame = null;
    this.blockedFrame = null;
    this.reason = 0;
  };
  BlockedByResponseIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BlockedByResponseIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlockedByResponseIssueDetails.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AffectedRequest, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlockedByResponseIssueDetails.parentFrame
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AffectedFrame, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlockedByResponseIssueDetails.blockedFrame
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, AffectedFrame, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlockedByResponseIssueDetails.reason
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, blocked_by_response_reason$.BlockedByResponseReason);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BlockedByResponseIssueDetails.encodedSize = codec.kStructHeaderSize + 32;

  BlockedByResponseIssueDetails.decode = function(decoder) {
    var packed;
    var val = new BlockedByResponseIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(AffectedRequest);
    val.parentFrame =
        decoder.decodeStructPointer(AffectedFrame);
    val.blockedFrame =
        decoder.decodeStructPointer(AffectedFrame);
    val.reason =
        decoder.decodeStruct(new codec.Enum(blocked_by_response_reason$.BlockedByResponseReason));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BlockedByResponseIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BlockedByResponseIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AffectedRequest, val.request);
    encoder.encodeStructPointer(AffectedFrame, val.parentFrame);
    encoder.encodeStructPointer(AffectedFrame, val.blockedFrame);
    encoder.encodeStruct(codec.Int32, val.reason);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HeavyAdIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HeavyAdIssueDetails.prototype.initDefaults_ = function() {
    this.resolution = 0;
    this.reason = 0;
    this.frame = null;
  };
  HeavyAdIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HeavyAdIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HeavyAdIssueDetails.resolution
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, HeavyAdResolutionStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HeavyAdIssueDetails.reason
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, HeavyAdReason);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HeavyAdIssueDetails.frame
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AffectedFrame, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HeavyAdIssueDetails.encodedSize = codec.kStructHeaderSize + 16;

  HeavyAdIssueDetails.decode = function(decoder) {
    var packed;
    var val = new HeavyAdIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.resolution =
        decoder.decodeStruct(new codec.Enum(HeavyAdResolutionStatus));
    val.reason =
        decoder.decodeStruct(new codec.Enum(HeavyAdReason));
    val.frame =
        decoder.decodeStructPointer(AffectedFrame);
    return val;
  };

  HeavyAdIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HeavyAdIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.resolution);
    encoder.encodeStruct(codec.Int32, val.reason);
    encoder.encodeStructPointer(AffectedFrame, val.frame);
  };
  function AttributionReportingIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AttributionReportingIssueDetails.prototype.initDefaults_ = function() {
    this.violationType = 0;
    this.request = null;
    this.invalidParameter = null;
  };
  AttributionReportingIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AttributionReportingIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AttributionReportingIssueDetails.violationType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AttributionReportingIssueType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AttributionReportingIssueDetails.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AffectedRequest, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AttributionReportingIssueDetails.invalidParameter
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AttributionReportingIssueDetails.encodedSize = codec.kStructHeaderSize + 24;

  AttributionReportingIssueDetails.decode = function(decoder) {
    var packed;
    var val = new AttributionReportingIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.violationType =
        decoder.decodeStruct(new codec.Enum(AttributionReportingIssueType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.request =
        decoder.decodeStructPointer(AffectedRequest);
    val.invalidParameter =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AttributionReportingIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AttributionReportingIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.violationType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(AffectedRequest, val.request);
    encoder.encodeStruct(codec.String, val.invalidParameter);
  };
  function MixedContentIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MixedContentIssueDetails.prototype.initDefaults_ = function() {
    this.requestContext = 0;
    this.resolutionStatus = 0;
    this.insecureUrl = null;
    this.mainResourceUrl = null;
    this.request = null;
    this.frame = null;
  };
  MixedContentIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MixedContentIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MixedContentIssueDetails.requestContext
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, fetch_api_request$.RequestContextType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MixedContentIssueDetails.resolutionStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, MixedContentResolutionStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MixedContentIssueDetails.insecureUrl
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MixedContentIssueDetails.mainResourceUrl
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MixedContentIssueDetails.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, AffectedRequest, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MixedContentIssueDetails.frame
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, AffectedFrame, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MixedContentIssueDetails.encodedSize = codec.kStructHeaderSize + 40;

  MixedContentIssueDetails.decode = function(decoder) {
    var packed;
    var val = new MixedContentIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestContext =
        decoder.decodeStruct(new codec.Enum(fetch_api_request$.RequestContextType));
    val.resolutionStatus =
        decoder.decodeStruct(new codec.Enum(MixedContentResolutionStatus));
    val.insecureUrl =
        decoder.decodeStruct(codec.String);
    val.mainResourceUrl =
        decoder.decodeStruct(codec.String);
    val.request =
        decoder.decodeStructPointer(AffectedRequest);
    val.frame =
        decoder.decodeStructPointer(AffectedFrame);
    return val;
  };

  MixedContentIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MixedContentIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestContext);
    encoder.encodeStruct(codec.Int32, val.resolutionStatus);
    encoder.encodeStruct(codec.String, val.insecureUrl);
    encoder.encodeStruct(codec.String, val.mainResourceUrl);
    encoder.encodeStructPointer(AffectedRequest, val.request);
    encoder.encodeStructPointer(AffectedFrame, val.frame);
  };
  function ContentSecurityPolicyIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ContentSecurityPolicyIssueDetails.prototype.initDefaults_ = function() {
    this.blockedUrl = null;
    this.violatedDirective = null;
    this.isReportOnly = false;
    this.contentSecurityPolicyViolationType = 0;
    this.frameAncestor = null;
    this.affectedLocation = null;
    this.violatingNodeId = 0;
  };
  ContentSecurityPolicyIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ContentSecurityPolicyIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContentSecurityPolicyIssueDetails.blockedUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContentSecurityPolicyIssueDetails.violatedDirective
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate ContentSecurityPolicyIssueDetails.contentSecurityPolicyViolationType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, ContentSecurityPolicyViolationType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContentSecurityPolicyIssueDetails.frameAncestor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, AffectedFrame, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContentSecurityPolicyIssueDetails.affectedLocation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, AffectedLocation, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ContentSecurityPolicyIssueDetails.encodedSize = codec.kStructHeaderSize + 48;

  ContentSecurityPolicyIssueDetails.decode = function(decoder) {
    var packed;
    var val = new ContentSecurityPolicyIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.blockedUrl =
        decoder.decodeStructPointer(url$.Url);
    val.violatedDirective =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.isReportOnly = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.contentSecurityPolicyViolationType =
        decoder.decodeStruct(new codec.Enum(ContentSecurityPolicyViolationType));
    val.frameAncestor =
        decoder.decodeStructPointer(AffectedFrame);
    val.affectedLocation =
        decoder.decodeStructPointer(AffectedLocation);
    val.violatingNodeId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ContentSecurityPolicyIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ContentSecurityPolicyIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.blockedUrl);
    encoder.encodeStruct(codec.String, val.violatedDirective);
    packed = 0;
    packed |= (val.isReportOnly & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.contentSecurityPolicyViolationType);
    encoder.encodeStructPointer(AffectedFrame, val.frameAncestor);
    encoder.encodeStructPointer(AffectedLocation, val.affectedLocation);
    encoder.encodeStruct(codec.Int32, val.violatingNodeId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieIssueDetails.prototype.initDefaults_ = function() {
    this.cookie = null;
    this.exclusionReason = null;
    this.warningReason = null;
    this.operation = 0;
    this.siteForCookies = null;
    this.cookieUrl = null;
    this.request = null;
  };
  CookieIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieIssueDetails.cookie
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AffectedCookie, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieIssueDetails.exclusionReason
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 4, new codec.Enum(CookieExclusionReason), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieIssueDetails.warningReason
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 4, new codec.Enum(CookieWarningReason), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieIssueDetails.operation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, CookieOperation);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieIssueDetails.siteForCookies
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieIssueDetails.cookieUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieIssueDetails.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, AffectedRequest, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieIssueDetails.encodedSize = codec.kStructHeaderSize + 56;

  CookieIssueDetails.decode = function(decoder) {
    var packed;
    var val = new CookieIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cookie =
        decoder.decodeStructPointer(AffectedCookie);
    val.exclusionReason =
        decoder.decodeArrayPointer(new codec.Enum(CookieExclusionReason));
    val.warningReason =
        decoder.decodeArrayPointer(new codec.Enum(CookieWarningReason));
    val.operation =
        decoder.decodeStruct(new codec.Enum(CookieOperation));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.siteForCookies =
        decoder.decodeStructPointer(url$.Url);
    val.cookieUrl =
        decoder.decodeStructPointer(url$.Url);
    val.request =
        decoder.decodeStructPointer(AffectedRequest);
    return val;
  };

  CookieIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AffectedCookie, val.cookie);
    encoder.encodeArrayPointer(new codec.Enum(CookieExclusionReason), val.exclusionReason);
    encoder.encodeArrayPointer(new codec.Enum(CookieWarningReason), val.warningReason);
    encoder.encodeStruct(codec.Int32, val.operation);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(url$.Url, val.siteForCookies);
    encoder.encodeStructPointer(url$.Url, val.cookieUrl);
    encoder.encodeStructPointer(AffectedRequest, val.request);
  };
  function SharedArrayBufferIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedArrayBufferIssueDetails.prototype.initDefaults_ = function() {
    this.affectedLocation = null;
    this.isWarning = false;
    this.type = 0;
  };
  SharedArrayBufferIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedArrayBufferIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedArrayBufferIssueDetails.affectedLocation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AffectedLocation, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedArrayBufferIssueDetails.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, SharedArrayBufferIssueType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedArrayBufferIssueDetails.encodedSize = codec.kStructHeaderSize + 16;

  SharedArrayBufferIssueDetails.decode = function(decoder) {
    var packed;
    var val = new SharedArrayBufferIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.affectedLocation =
        decoder.decodeStructPointer(AffectedLocation);
    packed = decoder.readUint8();
    val.isWarning = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.type =
        decoder.decodeStruct(new codec.Enum(SharedArrayBufferIssueType));
    return val;
  };

  SharedArrayBufferIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedArrayBufferIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AffectedLocation, val.affectedLocation);
    packed = 0;
    packed |= (val.isWarning & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.type);
  };
  function LowTextContrastIssue(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LowTextContrastIssue.prototype.initDefaults_ = function() {
    this.violatingNodeId = 0;
    this.contrastRatio = 0;
    this.violatingNodeSelector = null;
    this.thresholdAa = 0;
    this.thresholdAaa = 0;
    this.fontSize = null;
    this.fontWeight = null;
  };
  LowTextContrastIssue.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LowTextContrastIssue.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate LowTextContrastIssue.violatingNodeSelector
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;





    // validate LowTextContrastIssue.fontSize
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LowTextContrastIssue.fontWeight
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LowTextContrastIssue.encodedSize = codec.kStructHeaderSize + 40;

  LowTextContrastIssue.decode = function(decoder) {
    var packed;
    var val = new LowTextContrastIssue();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.violatingNodeId =
        decoder.decodeStruct(codec.Int32);
    val.contrastRatio =
        decoder.decodeStruct(codec.Float);
    val.violatingNodeSelector =
        decoder.decodeStruct(codec.String);
    val.thresholdAa =
        decoder.decodeStruct(codec.Float);
    val.thresholdAaa =
        decoder.decodeStruct(codec.Float);
    val.fontSize =
        decoder.decodeStruct(codec.String);
    val.fontWeight =
        decoder.decodeStruct(codec.String);
    return val;
  };

  LowTextContrastIssue.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LowTextContrastIssue.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.violatingNodeId);
    encoder.encodeStruct(codec.Float, val.contrastRatio);
    encoder.encodeStruct(codec.String, val.violatingNodeSelector);
    encoder.encodeStruct(codec.Float, val.thresholdAa);
    encoder.encodeStruct(codec.Float, val.thresholdAaa);
    encoder.encodeStruct(codec.String, val.fontSize);
    encoder.encodeStruct(codec.String, val.fontWeight);
  };
  function FederatedAuthRequestIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthRequestIssueDetails.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  FederatedAuthRequestIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthRequestIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthRequestIssueDetails.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, FederatedAuthRequestResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthRequestIssueDetails.encodedSize = codec.kStructHeaderSize + 8;

  FederatedAuthRequestIssueDetails.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthRequestIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(FederatedAuthRequestResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FederatedAuthRequestIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthRequestIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FederatedAuthUserInfoRequestIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FederatedAuthUserInfoRequestIssueDetails.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  FederatedAuthUserInfoRequestIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FederatedAuthUserInfoRequestIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FederatedAuthUserInfoRequestIssueDetails.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, FederatedAuthUserInfoRequestResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FederatedAuthUserInfoRequestIssueDetails.encodedSize = codec.kStructHeaderSize + 8;

  FederatedAuthUserInfoRequestIssueDetails.decode = function(decoder) {
    var packed;
    var val = new FederatedAuthUserInfoRequestIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(FederatedAuthUserInfoRequestResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FederatedAuthUserInfoRequestIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FederatedAuthUserInfoRequestIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BounceTrackingIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BounceTrackingIssueDetails.prototype.initDefaults_ = function() {
    this.trackingSites = null;
  };
  BounceTrackingIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BounceTrackingIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BounceTrackingIssueDetails.trackingSites
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BounceTrackingIssueDetails.encodedSize = codec.kStructHeaderSize + 8;

  BounceTrackingIssueDetails.decode = function(decoder) {
    var packed;
    var val = new BounceTrackingIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.trackingSites =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  BounceTrackingIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BounceTrackingIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.trackingSites);
  };
  function PartitioningBlobURLIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PartitioningBlobURLIssueDetails.prototype.initDefaults_ = function() {
    this.url = null;
    this.partitioningBlobUrlInfo = 0;
  };
  PartitioningBlobURLIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PartitioningBlobURLIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PartitioningBlobURLIssueDetails.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PartitioningBlobURLIssueDetails.partitioningBlobUrlInfo
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, PartitioningBlobURLInfo);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PartitioningBlobURLIssueDetails.encodedSize = codec.kStructHeaderSize + 16;

  PartitioningBlobURLIssueDetails.decode = function(decoder) {
    var packed;
    var val = new PartitioningBlobURLIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.partitioningBlobUrlInfo =
        decoder.decodeStruct(new codec.Enum(PartitioningBlobURLInfo));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PartitioningBlobURLIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PartitioningBlobURLIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.Int32, val.partitioningBlobUrlInfo);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieDeprecationMetadataIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieDeprecationMetadataIssueDetails.prototype.initDefaults_ = function() {
    this.allowedSites = null;
    this.optOutPercentage = 0;
    this.isOptOutTopLevel = false;
    this.operation = 0;
  };
  CookieDeprecationMetadataIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieDeprecationMetadataIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieDeprecationMetadataIssueDetails.allowedSites
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;




    // validate CookieDeprecationMetadataIssueDetails.operation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, CookieOperation);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieDeprecationMetadataIssueDetails.encodedSize = codec.kStructHeaderSize + 24;

  CookieDeprecationMetadataIssueDetails.decode = function(decoder) {
    var packed;
    var val = new CookieDeprecationMetadataIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.allowedSites =
        decoder.decodeArrayPointer(codec.String);
    val.optOutPercentage =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.isOptOutTopLevel = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.operation =
        decoder.decodeStruct(new codec.Enum(CookieOperation));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieDeprecationMetadataIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieDeprecationMetadataIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.allowedSites);
    encoder.encodeStruct(codec.Uint32, val.optOutPercentage);
    packed = 0;
    packed |= (val.isOptOutTopLevel & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.operation);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function GenericIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GenericIssueDetails.prototype.initDefaults_ = function() {
    this.errorType = 0;
    this.violatingNodeId = 0;
    this.frameId = null;
    this.violatingNodeAttribute = null;
  };
  GenericIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GenericIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GenericIssueDetails.errorType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, GenericIssueErrorType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GenericIssueDetails.frameId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;



    // validate GenericIssueDetails.violatingNodeAttribute
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GenericIssueDetails.encodedSize = codec.kStructHeaderSize + 24;

  GenericIssueDetails.decode = function(decoder) {
    var packed;
    var val = new GenericIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorType =
        decoder.decodeStruct(new codec.Enum(GenericIssueErrorType));
    val.violatingNodeId =
        decoder.decodeStruct(codec.Int32);
    val.frameId =
        decoder.decodeStruct(codec.String);
    val.violatingNodeAttribute =
        decoder.decodeStruct(codec.String);
    return val;
  };

  GenericIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GenericIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.errorType);
    encoder.encodeStruct(codec.Int32, val.violatingNodeId);
    encoder.encodeStruct(codec.String, val.frameId);
    encoder.encodeStruct(codec.String, val.violatingNodeAttribute);
  };
  function DeprecationIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeprecationIssueDetails.prototype.initDefaults_ = function() {
    this.type = 0;
    this.affectedLocation = null;
  };
  DeprecationIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeprecationIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeprecationIssueDetails.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, DeprecationIssueType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeprecationIssueDetails.affectedLocation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AffectedLocation, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeprecationIssueDetails.encodedSize = codec.kStructHeaderSize + 16;

  DeprecationIssueDetails.decode = function(decoder) {
    var packed;
    var val = new DeprecationIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(DeprecationIssueType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.affectedLocation =
        decoder.decodeStructPointer(AffectedLocation);
    return val;
  };

  DeprecationIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeprecationIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(AffectedLocation, val.affectedLocation);
  };
  function UserReidentificationIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UserReidentificationIssueDetails.prototype.initDefaults_ = function() {
    this.type = 0;
    this.request = null;
    this.sourceCodeLocation = null;
  };
  UserReidentificationIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UserReidentificationIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UserReidentificationIssueDetails.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, UserReidentificationIssueType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UserReidentificationIssueDetails.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AffectedRequest, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UserReidentificationIssueDetails.sourceCodeLocation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, AffectedLocation, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UserReidentificationIssueDetails.encodedSize = codec.kStructHeaderSize + 24;

  UserReidentificationIssueDetails.decode = function(decoder) {
    var packed;
    var val = new UserReidentificationIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(UserReidentificationIssueType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.request =
        decoder.decodeStructPointer(AffectedRequest);
    val.sourceCodeLocation =
        decoder.decodeStructPointer(AffectedLocation);
    return val;
  };

  UserReidentificationIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UserReidentificationIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(AffectedRequest, val.request);
    encoder.encodeStructPointer(AffectedLocation, val.sourceCodeLocation);
  };
  function InspectorIssueDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InspectorIssueDetails.prototype.initDefaults_ = function() {
    this.cookieIssueDetails = null;
    this.mixedContentIssueDetails = null;
    this.blockedByResponseIssueDetails = null;
    this.cspIssueDetails = null;
    this.sabIssueDetails = null;
    this.heavyAdIssueDetails = null;
    this.attributionReportingIssueDetails = null;
    this.lowTextContrastDetails = null;
    this.federatedAuthRequestDetails = null;
    this.bounceTrackingIssueDetails = null;
    this.partitioningBlobUrlIssueDetails = null;
    this.cookieDeprecationMetadataIssueDetails = null;
    this.genericIssueDetails = null;
    this.deprecationIssueDetails = null;
    this.federatedAuthUserInfoRequestDetails = null;
    this.userReidentificationIssueDetails = null;
    this.issueId = null;
  };
  InspectorIssueDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InspectorIssueDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 144}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.cookieIssueDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CookieIssueDetails, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.mixedContentIssueDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, MixedContentIssueDetails, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.blockedByResponseIssueDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, BlockedByResponseIssueDetails, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.cspIssueDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, ContentSecurityPolicyIssueDetails, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.sabIssueDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, SharedArrayBufferIssueDetails, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.heavyAdIssueDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, HeavyAdIssueDetails, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.attributionReportingIssueDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, AttributionReportingIssueDetails, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.lowTextContrastDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, LowTextContrastIssue, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.federatedAuthRequestDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, FederatedAuthRequestIssueDetails, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.bounceTrackingIssueDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, BounceTrackingIssueDetails, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.partitioningBlobUrlIssueDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, PartitioningBlobURLIssueDetails, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.cookieDeprecationMetadataIssueDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, CookieDeprecationMetadataIssueDetails, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.genericIssueDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, GenericIssueDetails, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.deprecationIssueDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, DeprecationIssueDetails, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.federatedAuthUserInfoRequestDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, FederatedAuthUserInfoRequestIssueDetails, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.userReidentificationIssueDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 120, UserReidentificationIssueDetails, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueDetails.issueId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 128, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InspectorIssueDetails.encodedSize = codec.kStructHeaderSize + 136;

  InspectorIssueDetails.decode = function(decoder) {
    var packed;
    var val = new InspectorIssueDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cookieIssueDetails =
        decoder.decodeStructPointer(CookieIssueDetails);
    val.mixedContentIssueDetails =
        decoder.decodeStructPointer(MixedContentIssueDetails);
    val.blockedByResponseIssueDetails =
        decoder.decodeStructPointer(BlockedByResponseIssueDetails);
    val.cspIssueDetails =
        decoder.decodeStructPointer(ContentSecurityPolicyIssueDetails);
    val.sabIssueDetails =
        decoder.decodeStructPointer(SharedArrayBufferIssueDetails);
    val.heavyAdIssueDetails =
        decoder.decodeStructPointer(HeavyAdIssueDetails);
    val.attributionReportingIssueDetails =
        decoder.decodeStructPointer(AttributionReportingIssueDetails);
    val.lowTextContrastDetails =
        decoder.decodeStructPointer(LowTextContrastIssue);
    val.federatedAuthRequestDetails =
        decoder.decodeStructPointer(FederatedAuthRequestIssueDetails);
    val.bounceTrackingIssueDetails =
        decoder.decodeStructPointer(BounceTrackingIssueDetails);
    val.partitioningBlobUrlIssueDetails =
        decoder.decodeStructPointer(PartitioningBlobURLIssueDetails);
    val.cookieDeprecationMetadataIssueDetails =
        decoder.decodeStructPointer(CookieDeprecationMetadataIssueDetails);
    val.genericIssueDetails =
        decoder.decodeStructPointer(GenericIssueDetails);
    val.deprecationIssueDetails =
        decoder.decodeStructPointer(DeprecationIssueDetails);
    val.federatedAuthUserInfoRequestDetails =
        decoder.decodeStructPointer(FederatedAuthUserInfoRequestIssueDetails);
    val.userReidentificationIssueDetails =
        decoder.decodeStructPointer(UserReidentificationIssueDetails);
    val.issueId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  InspectorIssueDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InspectorIssueDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CookieIssueDetails, val.cookieIssueDetails);
    encoder.encodeStructPointer(MixedContentIssueDetails, val.mixedContentIssueDetails);
    encoder.encodeStructPointer(BlockedByResponseIssueDetails, val.blockedByResponseIssueDetails);
    encoder.encodeStructPointer(ContentSecurityPolicyIssueDetails, val.cspIssueDetails);
    encoder.encodeStructPointer(SharedArrayBufferIssueDetails, val.sabIssueDetails);
    encoder.encodeStructPointer(HeavyAdIssueDetails, val.heavyAdIssueDetails);
    encoder.encodeStructPointer(AttributionReportingIssueDetails, val.attributionReportingIssueDetails);
    encoder.encodeStructPointer(LowTextContrastIssue, val.lowTextContrastDetails);
    encoder.encodeStructPointer(FederatedAuthRequestIssueDetails, val.federatedAuthRequestDetails);
    encoder.encodeStructPointer(BounceTrackingIssueDetails, val.bounceTrackingIssueDetails);
    encoder.encodeStructPointer(PartitioningBlobURLIssueDetails, val.partitioningBlobUrlIssueDetails);
    encoder.encodeStructPointer(CookieDeprecationMetadataIssueDetails, val.cookieDeprecationMetadataIssueDetails);
    encoder.encodeStructPointer(GenericIssueDetails, val.genericIssueDetails);
    encoder.encodeStructPointer(DeprecationIssueDetails, val.deprecationIssueDetails);
    encoder.encodeStructPointer(FederatedAuthUserInfoRequestIssueDetails, val.federatedAuthUserInfoRequestDetails);
    encoder.encodeStructPointer(UserReidentificationIssueDetails, val.userReidentificationIssueDetails);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.issueId);
  };
  function InspectorIssueInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InspectorIssueInfo.prototype.initDefaults_ = function() {
    this.code = 0;
    this.details = null;
  };
  InspectorIssueInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InspectorIssueInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueInfo.code
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, InspectorIssueCode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InspectorIssueInfo.details
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, InspectorIssueDetails, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InspectorIssueInfo.encodedSize = codec.kStructHeaderSize + 16;

  InspectorIssueInfo.decode = function(decoder) {
    var packed;
    var val = new InspectorIssueInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.code =
        decoder.decodeStruct(new codec.Enum(InspectorIssueCode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.details =
        decoder.decodeStructPointer(InspectorIssueDetails);
    return val;
  };

  InspectorIssueInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InspectorIssueInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.code);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(InspectorIssueDetails, val.details);
  };
  exports.InspectorIssueCode = InspectorIssueCode;
  exports.HeavyAdResolutionStatus = HeavyAdResolutionStatus;
  exports.HeavyAdReason = HeavyAdReason;
  exports.AttributionReportingIssueType = AttributionReportingIssueType;
  exports.MixedContentResolutionStatus = MixedContentResolutionStatus;
  exports.ContentSecurityPolicyViolationType = ContentSecurityPolicyViolationType;
  exports.CookieOperation = CookieOperation;
  exports.CookieExclusionReason = CookieExclusionReason;
  exports.CookieWarningReason = CookieWarningReason;
  exports.SharedArrayBufferIssueType = SharedArrayBufferIssueType;
  exports.FederatedAuthRequestResult = FederatedAuthRequestResult;
  exports.FederatedAuthUserInfoRequestResult = FederatedAuthUserInfoRequestResult;
  exports.PartitioningBlobURLInfo = PartitioningBlobURLInfo;
  exports.GenericIssueErrorType = GenericIssueErrorType;
  exports.DeprecationIssueType = DeprecationIssueType;
  exports.UserReidentificationIssueType = UserReidentificationIssueType;
  exports.AffectedCookie = AffectedCookie;
  exports.AffectedRequest = AffectedRequest;
  exports.AffectedFrame = AffectedFrame;
  exports.AffectedLocation = AffectedLocation;
  exports.BlockedByResponseIssueDetails = BlockedByResponseIssueDetails;
  exports.HeavyAdIssueDetails = HeavyAdIssueDetails;
  exports.AttributionReportingIssueDetails = AttributionReportingIssueDetails;
  exports.MixedContentIssueDetails = MixedContentIssueDetails;
  exports.ContentSecurityPolicyIssueDetails = ContentSecurityPolicyIssueDetails;
  exports.CookieIssueDetails = CookieIssueDetails;
  exports.SharedArrayBufferIssueDetails = SharedArrayBufferIssueDetails;
  exports.LowTextContrastIssue = LowTextContrastIssue;
  exports.FederatedAuthRequestIssueDetails = FederatedAuthRequestIssueDetails;
  exports.FederatedAuthUserInfoRequestIssueDetails = FederatedAuthUserInfoRequestIssueDetails;
  exports.BounceTrackingIssueDetails = BounceTrackingIssueDetails;
  exports.PartitioningBlobURLIssueDetails = PartitioningBlobURLIssueDetails;
  exports.CookieDeprecationMetadataIssueDetails = CookieDeprecationMetadataIssueDetails;
  exports.GenericIssueDetails = GenericIssueDetails;
  exports.DeprecationIssueDetails = DeprecationIssueDetails;
  exports.UserReidentificationIssueDetails = UserReidentificationIssueDetails;
  exports.InspectorIssueDetails = InspectorIssueDetails;
  exports.InspectorIssueInfo = InspectorIssueInfo;
})();