// third_party/blink/public/mojom/devtools/devtools_agent.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.DevToolsExecutionContextTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.DevToolsExecutionContextType = {
  
  kDedicatedWorker: 0,
  kWorklet: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DevToolsAgentPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DevToolsAgent.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.DevToolsAgentInterface }
 */
blink.mojom.DevToolsAgentRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DevToolsAgentPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DevToolsAgentPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DevToolsAgentPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } host
   * @param { !Object } session
   * @param { !blink.mojom.DevToolsSessionPendingReceiver } ioSession
   * @param { ?blink.mojom.DevToolsSessionState } reattachSessionState
   * @param { !string } scriptToEvaluateOnLoad
   * @param { !boolean } clientExpectsBinaryResponses
   * @param { !boolean } clientIsTrusted
   * @param { !string } sessionId
   * @param { !boolean } sessionWaitsForDebugger
   */

  attachDevToolsSession(
      host,
      session,
      ioSession,
      reattachSessionState,
      scriptToEvaluateOnLoad,
      clientExpectsBinaryResponses,
      clientIsTrusted,
      sessionId,
      sessionWaitsForDebugger) {
    this.proxy.sendMessage(
        0,
        blink.mojom.DevToolsAgent_AttachDevToolsSession_ParamsSpec.$,
        null,
        [
          host,
          session,
          ioSession,
          reattachSessionState,
          scriptToEvaluateOnLoad,
          clientExpectsBinaryResponses,
          clientIsTrusted,
          sessionId,
          sessionWaitsForDebugger
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Point } point
   */

  inspectElement(
      point) {
    this.proxy.sendMessage(
        1,
        blink.mojom.DevToolsAgent_InspectElement_ParamsSpec.$,
        null,
        [
          point
        ],
        false);
  }

  
  /**
   * @param { !boolean } report
   * @param { !boolean } waitForDebugger
   * @return {!Promise}
   */

  reportChildTargets(
      report,
      waitForDebugger) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.DevToolsAgent_ReportChildTargets_ParamsSpec.$,
        blink.mojom.DevToolsAgent_ReportChildTargets_ResponseParamsSpec.$,
        [
          report,
          waitForDebugger
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DevToolsAgent
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DevToolsAgentReceiver = class {
  /**
   * @param {!blink.mojom.DevToolsAgentInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DevToolsAgentRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DevToolsAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevToolsAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevToolsAgent_AttachDevToolsSession_ParamsSpec.$,
        null,
        impl.attachDevToolsSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DevToolsAgent_InspectElement_ParamsSpec.$,
        null,
        impl.inspectElement.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DevToolsAgent_ReportChildTargets_ParamsSpec.$,
        blink.mojom.DevToolsAgent_ReportChildTargets_ResponseParamsSpec.$,
        impl.reportChildTargets.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DevToolsAgent = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevToolsAgent";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DevToolsAgentRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DevToolsAgentRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DevToolsAgent
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DevToolsAgentCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DevToolsAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevToolsAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.attachDevToolsSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevToolsAgent_AttachDevToolsSession_ParamsSpec.$,
        null,
        this.attachDevToolsSession.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.inspectElement =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DevToolsAgent_InspectElement_ParamsSpec.$,
        null,
        this.inspectElement.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportChildTargets =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DevToolsAgent_ReportChildTargets_ParamsSpec.$,
        blink.mojom.DevToolsAgent_ReportChildTargets_ResponseParamsSpec.$,
        this.reportChildTargets.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DevToolsAgentHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DevToolsAgentHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.DevToolsAgentHostInterface }
 */
blink.mojom.DevToolsAgentHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DevToolsAgentHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DevToolsAgentHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DevToolsAgentHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.DevToolsAgentRemote } workerDevtoolsAgent
   * @param { !blink.mojom.DevToolsAgentHostPendingReceiver } workerDevtoolsAgentHost
   * @param { !url.mojom.Url } url
   * @param { !string } name
   * @param { !mojoBase.mojom.UnguessableToken } devtoolsWorkerToken
   * @param { !boolean } waitingForDebugger
   * @param { !blink.mojom.DevToolsExecutionContextType } contextType
   */

  childTargetCreated(
      workerDevtoolsAgent,
      workerDevtoolsAgentHost,
      url,
      name,
      devtoolsWorkerToken,
      waitingForDebugger,
      contextType) {
    this.proxy.sendMessage(
        0,
        blink.mojom.DevToolsAgentHost_ChildTargetCreated_ParamsSpec.$,
        null,
        [
          workerDevtoolsAgent,
          workerDevtoolsAgentHost,
          url,
          name,
          devtoolsWorkerToken,
          waitingForDebugger,
          contextType
        ],
        false);
  }

  
  /**
   */

  mainThreadDebuggerPaused() {
    this.proxy.sendMessage(
        1,
        blink.mojom.DevToolsAgentHost_MainThreadDebuggerPaused_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  mainThreadDebuggerResumed() {
    this.proxy.sendMessage(
        2,
        blink.mojom.DevToolsAgentHost_MainThreadDebuggerResumed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  bringToForeground() {
    this.proxy.sendMessage(
        3,
        blink.mojom.DevToolsAgentHost_BringToForeground_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DevToolsAgentHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DevToolsAgentHostReceiver = class {
  /**
   * @param {!blink.mojom.DevToolsAgentHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DevToolsAgentHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DevToolsAgentHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevToolsAgentHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevToolsAgentHost_ChildTargetCreated_ParamsSpec.$,
        null,
        impl.childTargetCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DevToolsAgentHost_MainThreadDebuggerPaused_ParamsSpec.$,
        null,
        impl.mainThreadDebuggerPaused.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DevToolsAgentHost_MainThreadDebuggerResumed_ParamsSpec.$,
        null,
        impl.mainThreadDebuggerResumed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.DevToolsAgentHost_BringToForeground_ParamsSpec.$,
        null,
        impl.bringToForeground.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DevToolsAgentHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevToolsAgentHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DevToolsAgentHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DevToolsAgentHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DevToolsAgentHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DevToolsAgentHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DevToolsAgentHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevToolsAgentHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.childTargetCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevToolsAgentHost_ChildTargetCreated_ParamsSpec.$,
        null,
        this.childTargetCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mainThreadDebuggerPaused =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DevToolsAgentHost_MainThreadDebuggerPaused_ParamsSpec.$,
        null,
        this.mainThreadDebuggerPaused.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mainThreadDebuggerResumed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DevToolsAgentHost_MainThreadDebuggerResumed_ParamsSpec.$,
        null,
        this.mainThreadDebuggerResumed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bringToForeground =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.DevToolsAgentHost_BringToForeground_ParamsSpec.$,
        null,
        this.bringToForeground.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DevToolsSessionPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DevToolsSession.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.DevToolsSessionInterface }
 */
blink.mojom.DevToolsSessionRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DevToolsSessionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DevToolsSessionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DevToolsSessionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } callId
   * @param { !string } method
   * @param { !mojoBase.mojom.ReadOnlyBuffer } message
   */

  dispatchProtocolCommand(
      callId,
      method,
      message) {
    this.proxy.sendMessage(
        0,
        blink.mojom.DevToolsSession_DispatchProtocolCommand_ParamsSpec.$,
        null,
        [
          callId,
          method,
          message
        ],
        false);
  }

  
  /**
   */

  unpauseAndTerminate() {
    this.proxy.sendMessage(
        1,
        blink.mojom.DevToolsSession_UnpauseAndTerminate_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DevToolsSession
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DevToolsSessionReceiver = class {
  /**
   * @param {!blink.mojom.DevToolsSessionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DevToolsSessionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DevToolsSessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevToolsSessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevToolsSession_DispatchProtocolCommand_ParamsSpec.$,
        null,
        impl.dispatchProtocolCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DevToolsSession_UnpauseAndTerminate_ParamsSpec.$,
        null,
        impl.unpauseAndTerminate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DevToolsSession = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevToolsSession";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DevToolsSessionRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DevToolsSessionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DevToolsSession
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DevToolsSessionCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DevToolsSessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevToolsSessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchProtocolCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevToolsSession_DispatchProtocolCommand_ParamsSpec.$,
        null,
        this.dispatchProtocolCommand.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unpauseAndTerminate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DevToolsSession_UnpauseAndTerminate_ParamsSpec.$,
        null,
        this.unpauseAndTerminate.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DevToolsSessionHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DevToolsSessionHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.DevToolsSessionHostInterface }
 */
blink.mojom.DevToolsSessionHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DevToolsSessionHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DevToolsSessionHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DevToolsSessionHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.DevToolsMessage } message
   * @param { !number } callId
   * @param { ?blink.mojom.DevToolsSessionState } updates
   */

  dispatchProtocolResponse(
      message,
      callId,
      updates) {
    this.proxy.sendMessage(
        0,
        blink.mojom.DevToolsSessionHost_DispatchProtocolResponse_ParamsSpec.$,
        null,
        [
          message,
          callId,
          updates
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.DevToolsMessage } message
   * @param { ?blink.mojom.DevToolsSessionState } updates
   */

  dispatchProtocolNotification(
      message,
      updates) {
    this.proxy.sendMessage(
        1,
        blink.mojom.DevToolsSessionHost_DispatchProtocolNotification_ParamsSpec.$,
        null,
        [
          message,
          updates
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DevToolsSessionHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DevToolsSessionHostReceiver = class {
  /**
   * @param {!blink.mojom.DevToolsSessionHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DevToolsSessionHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DevToolsSessionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevToolsSessionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevToolsSessionHost_DispatchProtocolResponse_ParamsSpec.$,
        null,
        impl.dispatchProtocolResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DevToolsSessionHost_DispatchProtocolNotification_ParamsSpec.$,
        null,
        impl.dispatchProtocolNotification.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DevToolsSessionHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevToolsSessionHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DevToolsSessionHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DevToolsSessionHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DevToolsSessionHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DevToolsSessionHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DevToolsSessionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevToolsSessionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchProtocolResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevToolsSessionHost_DispatchProtocolResponse_ParamsSpec.$,
        null,
        this.dispatchProtocolResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchProtocolNotification =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DevToolsSessionHost_DispatchProtocolNotification_ParamsSpec.$,
        null,
        this.dispatchProtocolNotification.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsMessageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsSessionStateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsAgent_AttachDevToolsSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsAgent_InspectElement_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsAgent_ReportChildTargets_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsAgent_ReportChildTargets_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsAgentHost_ChildTargetCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsAgentHost_MainThreadDebuggerPaused_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsAgentHost_MainThreadDebuggerResumed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsAgentHost_BringToForeground_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsSession_DispatchProtocolCommand_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsSession_UnpauseAndTerminate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsSessionHost_DispatchProtocolResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsSessionHost_DispatchProtocolNotification_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.DevToolsMessageSpec.$,
    'DevToolsMessage',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase.mojom.BigBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.DevToolsMessage = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigBuffer } */
    this.data;
  }
};



mojo.internal.Struct(
    blink.mojom.DevToolsSessionStateSpec.$,
    'DevToolsSessionState',
    [
      mojo.internal.StructField(
        'entries', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Array(mojo.internal.Uint8, false), true),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.DevToolsSessionState = class {
  constructor() {
    /** @export { !Object<!string, ?Array<!number>> } */
    this.entries;
  }
};



mojo.internal.Struct(
    blink.mojom.DevToolsAgent_AttachDevToolsSession_ParamsSpec.$,
    'DevToolsAgent_AttachDevToolsSession_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.DevToolsSessionHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'session', 8,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.DevToolsSessionPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ioSession', 12,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.DevToolsSessionPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reattachSessionState', 16,
        0,
        blink.mojom.DevToolsSessionStateSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scriptToEvaluateOnLoad', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientExpectsBinaryResponses', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientIsTrusted', 32,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionId', 40,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionWaitsForDebugger', 32,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
blink.mojom.DevToolsAgent_AttachDevToolsSession_Params = class {
  constructor() {
    /** @export { !Object } */
    this.host;
    /** @export { !Object } */
    this.session;
    /** @export { !blink.mojom.DevToolsSessionPendingReceiver } */
    this.ioSession;
    /** @export { (blink.mojom.DevToolsSessionState|undefined) } */
    this.reattachSessionState;
    /** @export { !string } */
    this.scriptToEvaluateOnLoad;
    /** @export { !boolean } */
    this.clientExpectsBinaryResponses;
    /** @export { !boolean } */
    this.clientIsTrusted;
    /** @export { !string } */
    this.sessionId;
    /** @export { !boolean } */
    this.sessionWaitsForDebugger;
  }
};



mojo.internal.Struct(
    blink.mojom.DevToolsAgent_InspectElement_ParamsSpec.$,
    'DevToolsAgent_InspectElement_Params',
    [
      mojo.internal.StructField(
        'point', 0,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.DevToolsAgent_InspectElement_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Point } */
    this.point;
  }
};



mojo.internal.Struct(
    blink.mojom.DevToolsAgent_ReportChildTargets_ParamsSpec.$,
    'DevToolsAgent_ReportChildTargets_Params',
    [
      mojo.internal.StructField(
        'report', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'waitForDebugger', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.DevToolsAgent_ReportChildTargets_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.report;
    /** @export { !boolean } */
    this.waitForDebugger;
  }
};



mojo.internal.Struct(
    blink.mojom.DevToolsAgent_ReportChildTargets_ResponseParamsSpec.$,
    'DevToolsAgent_ReportChildTargets_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.DevToolsAgent_ReportChildTargets_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.DevToolsAgentHost_ChildTargetCreated_ParamsSpec.$,
    'DevToolsAgentHost_ChildTargetCreated_Params',
    [
      mojo.internal.StructField(
        'workerDevtoolsAgent', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.DevToolsAgentRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'workerDevtoolsAgentHost', 8,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.DevToolsAgentHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsWorkerToken', 32,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'waitingForDebugger', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contextType', 40,
        0,
        blink.mojom.DevToolsExecutionContextTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
blink.mojom.DevToolsAgentHost_ChildTargetCreated_Params = class {
  constructor() {
    /** @export { !blink.mojom.DevToolsAgentRemote } */
    this.workerDevtoolsAgent;
    /** @export { !blink.mojom.DevToolsAgentHostPendingReceiver } */
    this.workerDevtoolsAgentHost;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.name;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.devtoolsWorkerToken;
    /** @export { !boolean } */
    this.waitingForDebugger;
    /** @export { !blink.mojom.DevToolsExecutionContextType } */
    this.contextType;
  }
};



mojo.internal.Struct(
    blink.mojom.DevToolsAgentHost_MainThreadDebuggerPaused_ParamsSpec.$,
    'DevToolsAgentHost_MainThreadDebuggerPaused_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.DevToolsAgentHost_MainThreadDebuggerPaused_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.DevToolsAgentHost_MainThreadDebuggerResumed_ParamsSpec.$,
    'DevToolsAgentHost_MainThreadDebuggerResumed_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.DevToolsAgentHost_MainThreadDebuggerResumed_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.DevToolsAgentHost_BringToForeground_ParamsSpec.$,
    'DevToolsAgentHost_BringToForeground_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.DevToolsAgentHost_BringToForeground_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.DevToolsSession_DispatchProtocolCommand_ParamsSpec.$,
    'DevToolsSession_DispatchProtocolCommand_Params',
    [
      mojo.internal.StructField(
        'callId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'method', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 16,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.DevToolsSession_DispatchProtocolCommand_Params = class {
  constructor() {
    /** @export { !number } */
    this.callId;
    /** @export { !string } */
    this.method;
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.message;
  }
};



mojo.internal.Struct(
    blink.mojom.DevToolsSession_UnpauseAndTerminate_ParamsSpec.$,
    'DevToolsSession_UnpauseAndTerminate_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.DevToolsSession_UnpauseAndTerminate_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.DevToolsSessionHost_DispatchProtocolResponse_ParamsSpec.$,
    'DevToolsSessionHost_DispatchProtocolResponse_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        blink.mojom.DevToolsMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'callId', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'updates', 16,
        0,
        blink.mojom.DevToolsSessionStateSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.DevToolsSessionHost_DispatchProtocolResponse_Params = class {
  constructor() {
    /** @export { !blink.mojom.DevToolsMessage } */
    this.message;
    /** @export { !number } */
    this.callId;
    /** @export { (blink.mojom.DevToolsSessionState|undefined) } */
    this.updates;
  }
};



mojo.internal.Struct(
    blink.mojom.DevToolsSessionHost_DispatchProtocolNotification_ParamsSpec.$,
    'DevToolsSessionHost_DispatchProtocolNotification_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        blink.mojom.DevToolsMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'updates', 8,
        0,
        blink.mojom.DevToolsSessionStateSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.DevToolsSessionHost_DispatchProtocolNotification_Params = class {
  constructor() {
    /** @export { !blink.mojom.DevToolsMessage } */
    this.message;
    /** @export { (blink.mojom.DevToolsSessionState|undefined) } */
    this.updates;
  }
};

