// third_party/blink/public/mojom/device_posture/device_posture_provider.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/device_posture/device_posture_provider.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/device_posture/device_posture_provider.mojom-params-data.h"
#include "third_party/blink/public/mojom/device_posture/device_posture_provider.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/device_posture/device_posture_provider.mojom-import-headers.h"
#include "third_party/blink/public/mojom/device_posture/device_posture_provider.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

DevicePostureProvider::IPCStableHashFunction DevicePostureProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DevicePostureProvider>(message.name())) {
    case messages::DevicePostureProvider::kAddListenerAndGetCurrentPosture: {
      return &DevicePostureProvider::AddListenerAndGetCurrentPosture_Sym::IPCStableHash;
    }
    case messages::DevicePostureProvider::kOverrideDevicePostureForEmulation: {
      return &DevicePostureProvider::OverrideDevicePostureForEmulation_Sym::IPCStableHash;
    }
    case messages::DevicePostureProvider::kDisableDevicePostureOverrideForEmulation: {
      return &DevicePostureProvider::DisableDevicePostureOverrideForEmulation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DevicePostureProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DevicePostureProvider>(message.name())) {
      case messages::DevicePostureProvider::kAddListenerAndGetCurrentPosture:
            return "Receive blink::mojom::DevicePostureProvider::AddListenerAndGetCurrentPosture";
      case messages::DevicePostureProvider::kOverrideDevicePostureForEmulation:
            return "Receive blink::mojom::DevicePostureProvider::OverrideDevicePostureForEmulation";
      case messages::DevicePostureProvider::kDisableDevicePostureOverrideForEmulation:
            return "Receive blink::mojom::DevicePostureProvider::DisableDevicePostureOverrideForEmulation";
    }
  } else {
    switch (static_cast<messages::DevicePostureProvider>(message.name())) {
      case messages::DevicePostureProvider::kAddListenerAndGetCurrentPosture:
            return "Receive reply blink::mojom::DevicePostureProvider::AddListenerAndGetCurrentPosture";
      case messages::DevicePostureProvider::kOverrideDevicePostureForEmulation:
            return "Receive reply blink::mojom::DevicePostureProvider::OverrideDevicePostureForEmulation";
      case messages::DevicePostureProvider::kDisableDevicePostureOverrideForEmulation:
            return "Receive reply blink::mojom::DevicePostureProvider::DisableDevicePostureOverrideForEmulation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DevicePostureProvider::AddListenerAndGetCurrentPosture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe463bbba;  // IPCStableHash for blink::mojom::DevicePostureProvider::AddListenerAndGetCurrentPosture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevicePostureProvider::OverrideDevicePostureForEmulation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x110e190c;  // IPCStableHash for blink::mojom::DevicePostureProvider::OverrideDevicePostureForEmulation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevicePostureProvider::DisableDevicePostureOverrideForEmulation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xacf52633;  // IPCStableHash for blink::mojom::DevicePostureProvider::DisableDevicePostureOverrideForEmulation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DevicePostureProvider_AddListenerAndGetCurrentPosture_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DevicePostureProvider_AddListenerAndGetCurrentPosture_ForwardToCallback(
      DevicePostureProvider::AddListenerAndGetCurrentPostureCallback callback
      ) : callback_(std::move(callback)) {
  }

  DevicePostureProvider_AddListenerAndGetCurrentPosture_ForwardToCallback(const DevicePostureProvider_AddListenerAndGetCurrentPosture_ForwardToCallback&) = delete;
  DevicePostureProvider_AddListenerAndGetCurrentPosture_ForwardToCallback& operator=(const DevicePostureProvider_AddListenerAndGetCurrentPosture_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DevicePostureProvider::AddListenerAndGetCurrentPostureCallback callback_;
};

DevicePostureProviderProxy::DevicePostureProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevicePostureProviderProxy::AddListenerAndGetCurrentPosture(
    ::mojo::PendingRemote<DevicePostureClient> in_client, AddListenerAndGetCurrentPostureCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DevicePostureProvider::AddListenerAndGetCurrentPosture", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<DevicePostureClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePostureProvider::kAddListenerAndGetCurrentPosture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::DevicePostureClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in DevicePostureProvider.AddListenerAndGetCurrentPosture request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePostureProvider::Name_);
  message.set_method_name("AddListenerAndGetCurrentPosture");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DevicePostureProvider_AddListenerAndGetCurrentPosture_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DevicePostureProviderProxy::OverrideDevicePostureForEmulation(
    DevicePostureType in_posture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DevicePostureProvider::OverrideDevicePostureForEmulation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("posture"), in_posture,
                        "<value of type DevicePostureType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePostureProvider::kOverrideDevicePostureForEmulation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevicePostureProvider_OverrideDevicePostureForEmulation_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::DevicePostureType>(
    in_posture,
    &params->posture);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePostureProvider::Name_);
  message.set_method_name("OverrideDevicePostureForEmulation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevicePostureProviderProxy::DisableDevicePostureOverrideForEmulation(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DevicePostureProvider::DisableDevicePostureOverrideForEmulation");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePostureProvider::kDisableDevicePostureOverrideForEmulation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevicePostureProvider_DisableDevicePostureOverrideForEmulation_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePostureProvider::Name_);
  message.set_method_name("DisableDevicePostureOverrideForEmulation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DevicePostureProvider::AddListenerAndGetCurrentPostureCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder> proxy(
        new DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DevicePostureProvider::AddListenerAndGetCurrentPostureCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DevicePostureType in_posture);
};

bool DevicePostureProvider_AddListenerAndGetCurrentPosture_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DevicePostureProvider.0
  bool success = true;
  DevicePostureType p_posture{};
  DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPosture(&p_posture))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DevicePostureProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_posture));
  }
  return true;
}

void DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder::Run(
    DevicePostureType in_posture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::DevicePostureProvider::AddListenerAndGetCurrentPosture", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("posture"), in_posture,
                        "<value of type DevicePostureType>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePostureProvider::kAddListenerAndGetCurrentPosture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::DevicePostureType>(
    in_posture,
    &params->posture);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePostureProvider::Name_);
  message.set_method_name("AddListenerAndGetCurrentPosture");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DevicePostureProviderStubDispatch::Accept(
    DevicePostureProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DevicePostureProvider>(message->header()->name)) {
    case messages::DevicePostureProvider::kAddListenerAndGetCurrentPosture: {
      break;
    }
    case messages::DevicePostureProvider::kOverrideDevicePostureForEmulation: {
      DCHECK(message->is_serialized());
      internal::DevicePostureProvider_OverrideDevicePostureForEmulation_Params_Data* params =
          reinterpret_cast<internal::DevicePostureProvider_OverrideDevicePostureForEmulation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePostureProvider.1
      bool success = true;
      DevicePostureType p_posture{};
      DevicePostureProvider_OverrideDevicePostureForEmulation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPosture(&p_posture))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePostureProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OverrideDevicePostureForEmulation(        
        std::move(p_posture));
      return true;
    }
    case messages::DevicePostureProvider::kDisableDevicePostureOverrideForEmulation: {
      DCHECK(message->is_serialized());
      internal::DevicePostureProvider_DisableDevicePostureOverrideForEmulation_Params_Data* params =
          reinterpret_cast<internal::DevicePostureProvider_DisableDevicePostureOverrideForEmulation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePostureProvider.2
      bool success = true;
      DevicePostureProvider_DisableDevicePostureOverrideForEmulation_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePostureProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableDevicePostureOverrideForEmulation(        );
      return true;
    }
  }
  return false;
}

// static
bool DevicePostureProviderStubDispatch::AcceptWithResponder(
    DevicePostureProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DevicePostureProvider>(message->header()->name)) {
    case messages::DevicePostureProvider::kAddListenerAndGetCurrentPosture: {
      internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_Params_Data* params =
          reinterpret_cast<
              internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DevicePostureProvider.0
      bool success = true;
      ::mojo::PendingRemote<DevicePostureClient> p_client{};
      DevicePostureProvider_AddListenerAndGetCurrentPosture_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePostureProvider::Name_, 0, false);
        return false;
      }
      auto callback =
          DevicePostureProvider_AddListenerAndGetCurrentPosture_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddListenerAndGetCurrentPosture(        
        std::move(p_client), std::move(callback));
      return true;
    }
    case messages::DevicePostureProvider::kOverrideDevicePostureForEmulation: {
      break;
    }
    case messages::DevicePostureProvider::kDisableDevicePostureOverrideForEmulation: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDevicePostureProviderValidationInfo[] = {
    { &internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_Params_Data::Validate,
     &internal::DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams_Data::Validate},
    { &internal::DevicePostureProvider_OverrideDevicePostureForEmulation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevicePostureProvider_DisableDevicePostureOverrideForEmulation_Params_Data::Validate,
     nullptr /* no response */},
};

bool DevicePostureProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::DevicePostureProvider::Name_,
    kDevicePostureProviderValidationInfo);
}

bool DevicePostureProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::DevicePostureProvider::Name_,
    kDevicePostureProviderValidationInfo);
}
// The declaration includes the definition on other builds.

DevicePostureClient::IPCStableHashFunction DevicePostureClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DevicePostureClient>(message.name())) {
    case messages::DevicePostureClient::kOnPostureChanged: {
      return &DevicePostureClient::OnPostureChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DevicePostureClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DevicePostureClient>(message.name())) {
      case messages::DevicePostureClient::kOnPostureChanged:
            return "Receive blink::mojom::DevicePostureClient::OnPostureChanged";
    }
  } else {
    switch (static_cast<messages::DevicePostureClient>(message.name())) {
      case messages::DevicePostureClient::kOnPostureChanged:
            return "Receive reply blink::mojom::DevicePostureClient::OnPostureChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DevicePostureClient::OnPostureChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5d639d94;  // IPCStableHash for blink::mojom::DevicePostureClient::OnPostureChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DevicePostureClientProxy::DevicePostureClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevicePostureClientProxy::OnPostureChanged(
    DevicePostureType in_posture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DevicePostureClient::OnPostureChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("posture"), in_posture,
                        "<value of type DevicePostureType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePostureClient::kOnPostureChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevicePostureClient_OnPostureChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::DevicePostureType>(
    in_posture,
    &params->posture);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePostureClient::Name_);
  message.set_method_name("OnPostureChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DevicePostureClientStubDispatch::Accept(
    DevicePostureClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DevicePostureClient>(message->header()->name)) {
    case messages::DevicePostureClient::kOnPostureChanged: {
      DCHECK(message->is_serialized());
      internal::DevicePostureClient_OnPostureChanged_Params_Data* params =
          reinterpret_cast<internal::DevicePostureClient_OnPostureChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePostureClient.0
      bool success = true;
      DevicePostureType p_posture{};
      DevicePostureClient_OnPostureChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPosture(&p_posture))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePostureClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPostureChanged(        
        std::move(p_posture));
      return true;
    }
  }
  return false;
}

// static
bool DevicePostureClientStubDispatch::AcceptWithResponder(
    DevicePostureClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DevicePostureClient>(message->header()->name)) {
    case messages::DevicePostureClient::kOnPostureChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDevicePostureClientValidationInfo[] = {
    { &internal::DevicePostureClient_OnPostureChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool DevicePostureClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::DevicePostureClient::Name_,
    kDevicePostureClientValidationInfo);
}



}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void DevicePostureProviderInterceptorForTesting::AddListenerAndGetCurrentPosture(::mojo::PendingRemote<DevicePostureClient> client, AddListenerAndGetCurrentPostureCallback callback) {
  GetForwardingInterface()->AddListenerAndGetCurrentPosture(
    std::move(client)
    , std::move(callback));
}
void DevicePostureProviderInterceptorForTesting::OverrideDevicePostureForEmulation(DevicePostureType posture) {
  GetForwardingInterface()->OverrideDevicePostureForEmulation(
    std::move(posture)
    );
}
void DevicePostureProviderInterceptorForTesting::DisableDevicePostureOverrideForEmulation() {
  GetForwardingInterface()->DisableDevicePostureOverrideForEmulation();
}
DevicePostureProviderAsyncWaiter::DevicePostureProviderAsyncWaiter(
    DevicePostureProvider* proxy) : proxy_(proxy) {}

DevicePostureProviderAsyncWaiter::~DevicePostureProviderAsyncWaiter() = default;


void DevicePostureProviderAsyncWaiter::AddListenerAndGetCurrentPosture(
    ::mojo::PendingRemote<DevicePostureClient> client, DevicePostureType* out_posture) {
  base::RunLoop loop;
  proxy_->AddListenerAndGetCurrentPosture(
      std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             DevicePostureType* out_posture
,
             DevicePostureType posture) {*out_posture = std::move(posture);
            loop->Quit();
          },
          &loop,
          out_posture));
  loop.Run();
}

DevicePostureType DevicePostureProviderAsyncWaiter::AddListenerAndGetCurrentPosture(
    ::mojo::PendingRemote<DevicePostureClient> client) {
  DevicePostureType async_wait_result;
  AddListenerAndGetCurrentPosture(std::move(client),&async_wait_result);
  return async_wait_result;
}




void DevicePostureClientInterceptorForTesting::OnPostureChanged(DevicePostureType posture) {
  GetForwardingInterface()->OnPostureChanged(
    std::move(posture)
    );
}
DevicePostureClientAsyncWaiter::DevicePostureClientAsyncWaiter(
    DevicePostureClient* proxy) : proxy_(proxy) {}

DevicePostureClientAsyncWaiter::~DevicePostureClientAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif