// third_party/blink/public/mojom/device/device.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/device/device.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/device/device.mojom-params-data.h"
#include "third_party/blink/public/mojom/device/device.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/device/device.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/device/device.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
DeviceAttributeResultPtr
DeviceAttributeResult::NewErrorMessage(
    const ::blink::String& value) {
  return DeviceAttributeResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorMessage)>,
      std::move(value));
}

DeviceAttributeResultPtr
DeviceAttributeResult::NewAttribute(
    const ::blink::String& value) {
  return DeviceAttributeResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kAttribute)>,
      std::move(value));
}

DeviceAttributeResult::DeviceAttributeResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorMessage)>,
    const ::blink::String& value)
    : tag_(Tag::kErrorMessage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorMessage)>,
            std::move(value)) {}

DeviceAttributeResult::DeviceAttributeResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kAttribute)>,
    const ::blink::String& value)
    : tag_(Tag::kAttribute),
      data_(std::in_place_index<static_cast<size_t>(Tag::kAttribute)>,
            std::move(value)) {}
DeviceAttributeResult::~DeviceAttributeResult() {
  DestroyActive();
}

void DeviceAttributeResult::set_error_message(const ::blink::String& error_message) {
  if (tag_ == Tag::kErrorMessage) {
    data_.error_message = std::move(error_message);
  } else {
    DestroyActive();
    tag_ = Tag::kErrorMessage;
    new (&data_.error_message) ::blink::String(
        std::move(error_message));
  }
}

void DeviceAttributeResult::set_attribute(const ::blink::String& attribute) {
  if (tag_ == Tag::kAttribute) {
    data_.attribute = std::move(attribute);
  } else {
    DestroyActive();
    tag_ = Tag::kAttribute;
    new (&data_.attribute) ::blink::String(
        std::move(attribute));
  }
}


DeviceAttributeResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorMessage)>,
    const ::blink::String& value)
    : error_message(std::move(value)) {}

DeviceAttributeResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kAttribute)>,
    const ::blink::String& value)
    : attribute(std::move(value)) {}

void DeviceAttributeResult::DestroyActive() {
  switch (tag_) {

    case Tag::kErrorMessage:
      std::destroy_at(&data_.error_message);
      break;
    case Tag::kAttribute:
      std::destroy_at(&data_.attribute);
      break;
  }
}

bool DeviceAttributeResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

ManagedConfigurationObserver::IPCStableHashFunction ManagedConfigurationObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ManagedConfigurationObserver>(message.name())) {
    case messages::ManagedConfigurationObserver::kOnConfigurationChanged: {
      return &ManagedConfigurationObserver::OnConfigurationChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ManagedConfigurationObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ManagedConfigurationObserver>(message.name())) {
      case messages::ManagedConfigurationObserver::kOnConfigurationChanged:
            return "Receive blink::mojom::ManagedConfigurationObserver::OnConfigurationChanged";
    }
  } else {
    switch (static_cast<messages::ManagedConfigurationObserver>(message.name())) {
      case messages::ManagedConfigurationObserver::kOnConfigurationChanged:
            return "Receive reply blink::mojom::ManagedConfigurationObserver::OnConfigurationChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ManagedConfigurationObserver::OnConfigurationChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71e2e470;  // IPCStableHash for blink::mojom::ManagedConfigurationObserver::OnConfigurationChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ManagedConfigurationObserverProxy::ManagedConfigurationObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ManagedConfigurationObserverProxy::OnConfigurationChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ManagedConfigurationObserver::OnConfigurationChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ManagedConfigurationObserver::kOnConfigurationChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManagedConfigurationObserver_OnConfigurationChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManagedConfigurationObserver::Name_);
  message.set_method_name("OnConfigurationChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ManagedConfigurationObserverStubDispatch::Accept(
    ManagedConfigurationObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ManagedConfigurationObserver>(message->header()->name)) {
    case messages::ManagedConfigurationObserver::kOnConfigurationChanged: {
      DCHECK(message->is_serialized());
      internal::ManagedConfigurationObserver_OnConfigurationChanged_Params_Data* params =
          reinterpret_cast<internal::ManagedConfigurationObserver_OnConfigurationChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ManagedConfigurationObserver.0
      bool success = true;
      ManagedConfigurationObserver_OnConfigurationChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ManagedConfigurationObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConfigurationChanged(        );
      return true;
    }
  }
  return false;
}

// static
bool ManagedConfigurationObserverStubDispatch::AcceptWithResponder(
    ManagedConfigurationObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ManagedConfigurationObserver>(message->header()->name)) {
    case messages::ManagedConfigurationObserver::kOnConfigurationChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kManagedConfigurationObserverValidationInfo[] = {
    { &internal::ManagedConfigurationObserver_OnConfigurationChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool ManagedConfigurationObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ManagedConfigurationObserver::Name_,
    kManagedConfigurationObserverValidationInfo);
}

// The declaration includes the definition on other builds.

DeviceAPIService::IPCStableHashFunction DeviceAPIService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DeviceAPIService>(message.name())) {
    case messages::DeviceAPIService::kGetDirectoryId: {
      return &DeviceAPIService::GetDirectoryId_Sym::IPCStableHash;
    }
    case messages::DeviceAPIService::kGetHostname: {
      return &DeviceAPIService::GetHostname_Sym::IPCStableHash;
    }
    case messages::DeviceAPIService::kGetSerialNumber: {
      return &DeviceAPIService::GetSerialNumber_Sym::IPCStableHash;
    }
    case messages::DeviceAPIService::kGetAnnotatedAssetId: {
      return &DeviceAPIService::GetAnnotatedAssetId_Sym::IPCStableHash;
    }
    case messages::DeviceAPIService::kGetAnnotatedLocation: {
      return &DeviceAPIService::GetAnnotatedLocation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DeviceAPIService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DeviceAPIService>(message.name())) {
      case messages::DeviceAPIService::kGetDirectoryId:
            return "Receive blink::mojom::DeviceAPIService::GetDirectoryId";
      case messages::DeviceAPIService::kGetHostname:
            return "Receive blink::mojom::DeviceAPIService::GetHostname";
      case messages::DeviceAPIService::kGetSerialNumber:
            return "Receive blink::mojom::DeviceAPIService::GetSerialNumber";
      case messages::DeviceAPIService::kGetAnnotatedAssetId:
            return "Receive blink::mojom::DeviceAPIService::GetAnnotatedAssetId";
      case messages::DeviceAPIService::kGetAnnotatedLocation:
            return "Receive blink::mojom::DeviceAPIService::GetAnnotatedLocation";
    }
  } else {
    switch (static_cast<messages::DeviceAPIService>(message.name())) {
      case messages::DeviceAPIService::kGetDirectoryId:
            return "Receive reply blink::mojom::DeviceAPIService::GetDirectoryId";
      case messages::DeviceAPIService::kGetHostname:
            return "Receive reply blink::mojom::DeviceAPIService::GetHostname";
      case messages::DeviceAPIService::kGetSerialNumber:
            return "Receive reply blink::mojom::DeviceAPIService::GetSerialNumber";
      case messages::DeviceAPIService::kGetAnnotatedAssetId:
            return "Receive reply blink::mojom::DeviceAPIService::GetAnnotatedAssetId";
      case messages::DeviceAPIService::kGetAnnotatedLocation:
            return "Receive reply blink::mojom::DeviceAPIService::GetAnnotatedLocation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DeviceAPIService::GetDirectoryId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8d29f86;  // IPCStableHash for blink::mojom::DeviceAPIService::GetDirectoryId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceAPIService::GetHostname_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb223c38b;  // IPCStableHash for blink::mojom::DeviceAPIService::GetHostname
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceAPIService::GetSerialNumber_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf23bf6be;  // IPCStableHash for blink::mojom::DeviceAPIService::GetSerialNumber
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceAPIService::GetAnnotatedAssetId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3dd06be9;  // IPCStableHash for blink::mojom::DeviceAPIService::GetAnnotatedAssetId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceAPIService::GetAnnotatedLocation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b43a34a;  // IPCStableHash for blink::mojom::DeviceAPIService::GetAnnotatedLocation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DeviceAPIService_GetDirectoryId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DeviceAPIService_GetDirectoryId_ForwardToCallback(
      DeviceAPIService::GetDirectoryIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  DeviceAPIService_GetDirectoryId_ForwardToCallback(const DeviceAPIService_GetDirectoryId_ForwardToCallback&) = delete;
  DeviceAPIService_GetDirectoryId_ForwardToCallback& operator=(const DeviceAPIService_GetDirectoryId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DeviceAPIService::GetDirectoryIdCallback callback_;
};

class DeviceAPIService_GetHostname_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DeviceAPIService_GetHostname_ForwardToCallback(
      DeviceAPIService::GetHostnameCallback callback
      ) : callback_(std::move(callback)) {
  }

  DeviceAPIService_GetHostname_ForwardToCallback(const DeviceAPIService_GetHostname_ForwardToCallback&) = delete;
  DeviceAPIService_GetHostname_ForwardToCallback& operator=(const DeviceAPIService_GetHostname_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DeviceAPIService::GetHostnameCallback callback_;
};

class DeviceAPIService_GetSerialNumber_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DeviceAPIService_GetSerialNumber_ForwardToCallback(
      DeviceAPIService::GetSerialNumberCallback callback
      ) : callback_(std::move(callback)) {
  }

  DeviceAPIService_GetSerialNumber_ForwardToCallback(const DeviceAPIService_GetSerialNumber_ForwardToCallback&) = delete;
  DeviceAPIService_GetSerialNumber_ForwardToCallback& operator=(const DeviceAPIService_GetSerialNumber_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DeviceAPIService::GetSerialNumberCallback callback_;
};

class DeviceAPIService_GetAnnotatedAssetId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DeviceAPIService_GetAnnotatedAssetId_ForwardToCallback(
      DeviceAPIService::GetAnnotatedAssetIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  DeviceAPIService_GetAnnotatedAssetId_ForwardToCallback(const DeviceAPIService_GetAnnotatedAssetId_ForwardToCallback&) = delete;
  DeviceAPIService_GetAnnotatedAssetId_ForwardToCallback& operator=(const DeviceAPIService_GetAnnotatedAssetId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DeviceAPIService::GetAnnotatedAssetIdCallback callback_;
};

class DeviceAPIService_GetAnnotatedLocation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DeviceAPIService_GetAnnotatedLocation_ForwardToCallback(
      DeviceAPIService::GetAnnotatedLocationCallback callback
      ) : callback_(std::move(callback)) {
  }

  DeviceAPIService_GetAnnotatedLocation_ForwardToCallback(const DeviceAPIService_GetAnnotatedLocation_ForwardToCallback&) = delete;
  DeviceAPIService_GetAnnotatedLocation_ForwardToCallback& operator=(const DeviceAPIService_GetAnnotatedLocation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DeviceAPIService::GetAnnotatedLocationCallback callback_;
};

DeviceAPIServiceProxy::DeviceAPIServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DeviceAPIServiceProxy::GetDirectoryId(
    GetDirectoryIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DeviceAPIService::GetDirectoryId");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceAPIService::kGetDirectoryId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetDirectoryId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetDirectoryId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DeviceAPIService_GetDirectoryId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DeviceAPIServiceProxy::GetHostname(
    GetHostnameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DeviceAPIService::GetHostname");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceAPIService::kGetHostname), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetHostname_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetHostname");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DeviceAPIService_GetHostname_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DeviceAPIServiceProxy::GetSerialNumber(
    GetSerialNumberCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DeviceAPIService::GetSerialNumber");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceAPIService::kGetSerialNumber), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetSerialNumber_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetSerialNumber");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DeviceAPIService_GetSerialNumber_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DeviceAPIServiceProxy::GetAnnotatedAssetId(
    GetAnnotatedAssetIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DeviceAPIService::GetAnnotatedAssetId");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceAPIService::kGetAnnotatedAssetId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetAnnotatedAssetId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetAnnotatedAssetId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DeviceAPIService_GetAnnotatedAssetId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DeviceAPIServiceProxy::GetAnnotatedLocation(
    GetAnnotatedLocationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DeviceAPIService::GetAnnotatedLocation");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceAPIService::kGetAnnotatedLocation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetAnnotatedLocation_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetAnnotatedLocation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DeviceAPIService_GetAnnotatedLocation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class DeviceAPIService_GetDirectoryId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DeviceAPIService::GetDirectoryIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DeviceAPIService_GetDirectoryId_ProxyToResponder> proxy(
        new DeviceAPIService_GetDirectoryId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DeviceAPIService_GetDirectoryId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DeviceAPIService_GetDirectoryId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DeviceAPIService_GetDirectoryId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DeviceAPIService::GetDirectoryIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeviceAttributeResultPtr in_result);
};

bool DeviceAPIService_GetDirectoryId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DeviceAPIService_GetDirectoryId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DeviceAPIService_GetDirectoryId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DeviceAPIService.0
  bool success = true;
  DeviceAttributeResultPtr p_result{};
  DeviceAPIService_GetDirectoryId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DeviceAPIService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void DeviceAPIService_GetDirectoryId_ProxyToResponder::Run(
    DeviceAttributeResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::DeviceAPIService::GetDirectoryId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type DeviceAttributeResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceAPIService::kGetDirectoryId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetDirectoryId_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::DeviceAttributeResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetDirectoryId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DeviceAPIService_GetHostname_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DeviceAPIService::GetHostnameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DeviceAPIService_GetHostname_ProxyToResponder> proxy(
        new DeviceAPIService_GetHostname_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DeviceAPIService_GetHostname_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DeviceAPIService_GetHostname_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DeviceAPIService_GetHostname_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DeviceAPIService::GetHostnameCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeviceAttributeResultPtr in_result);
};

bool DeviceAPIService_GetHostname_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DeviceAPIService_GetHostname_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DeviceAPIService_GetHostname_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DeviceAPIService.1
  bool success = true;
  DeviceAttributeResultPtr p_result{};
  DeviceAPIService_GetHostname_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DeviceAPIService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void DeviceAPIService_GetHostname_ProxyToResponder::Run(
    DeviceAttributeResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::DeviceAPIService::GetHostname", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type DeviceAttributeResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceAPIService::kGetHostname), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetHostname_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::DeviceAttributeResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetHostname");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DeviceAPIService_GetSerialNumber_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DeviceAPIService::GetSerialNumberCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DeviceAPIService_GetSerialNumber_ProxyToResponder> proxy(
        new DeviceAPIService_GetSerialNumber_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DeviceAPIService_GetSerialNumber_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DeviceAPIService_GetSerialNumber_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DeviceAPIService_GetSerialNumber_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DeviceAPIService::GetSerialNumberCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeviceAttributeResultPtr in_result);
};

bool DeviceAPIService_GetSerialNumber_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DeviceAPIService_GetSerialNumber_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DeviceAPIService_GetSerialNumber_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DeviceAPIService.2
  bool success = true;
  DeviceAttributeResultPtr p_result{};
  DeviceAPIService_GetSerialNumber_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DeviceAPIService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void DeviceAPIService_GetSerialNumber_ProxyToResponder::Run(
    DeviceAttributeResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::DeviceAPIService::GetSerialNumber", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type DeviceAttributeResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceAPIService::kGetSerialNumber), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetSerialNumber_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::DeviceAttributeResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetSerialNumber");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DeviceAPIService::GetAnnotatedAssetIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder> proxy(
        new DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DeviceAPIService::GetAnnotatedAssetIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeviceAttributeResultPtr in_result);
};

bool DeviceAPIService_GetAnnotatedAssetId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DeviceAPIService_GetAnnotatedAssetId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DeviceAPIService_GetAnnotatedAssetId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DeviceAPIService.3
  bool success = true;
  DeviceAttributeResultPtr p_result{};
  DeviceAPIService_GetAnnotatedAssetId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DeviceAPIService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder::Run(
    DeviceAttributeResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::DeviceAPIService::GetAnnotatedAssetId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type DeviceAttributeResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceAPIService::kGetAnnotatedAssetId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetAnnotatedAssetId_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::DeviceAttributeResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetAnnotatedAssetId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DeviceAPIService_GetAnnotatedLocation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DeviceAPIService::GetAnnotatedLocationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DeviceAPIService_GetAnnotatedLocation_ProxyToResponder> proxy(
        new DeviceAPIService_GetAnnotatedLocation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DeviceAPIService_GetAnnotatedLocation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DeviceAPIService_GetAnnotatedLocation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DeviceAPIService_GetAnnotatedLocation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DeviceAPIService::GetAnnotatedLocationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeviceAttributeResultPtr in_result);
};

bool DeviceAPIService_GetAnnotatedLocation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DeviceAPIService_GetAnnotatedLocation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DeviceAPIService_GetAnnotatedLocation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DeviceAPIService.4
  bool success = true;
  DeviceAttributeResultPtr p_result{};
  DeviceAPIService_GetAnnotatedLocation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DeviceAPIService::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void DeviceAPIService_GetAnnotatedLocation_ProxyToResponder::Run(
    DeviceAttributeResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::DeviceAPIService::GetAnnotatedLocation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type DeviceAttributeResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceAPIService::kGetAnnotatedLocation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetAnnotatedLocation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::DeviceAttributeResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetAnnotatedLocation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DeviceAPIServiceStubDispatch::Accept(
    DeviceAPIService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DeviceAPIService>(message->header()->name)) {
    case messages::DeviceAPIService::kGetDirectoryId: {
      break;
    }
    case messages::DeviceAPIService::kGetHostname: {
      break;
    }
    case messages::DeviceAPIService::kGetSerialNumber: {
      break;
    }
    case messages::DeviceAPIService::kGetAnnotatedAssetId: {
      break;
    }
    case messages::DeviceAPIService::kGetAnnotatedLocation: {
      break;
    }
  }
  return false;
}

// static
bool DeviceAPIServiceStubDispatch::AcceptWithResponder(
    DeviceAPIService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DeviceAPIService>(message->header()->name)) {
    case messages::DeviceAPIService::kGetDirectoryId: {
      internal::DeviceAPIService_GetDirectoryId_Params_Data* params =
          reinterpret_cast<
              internal::DeviceAPIService_GetDirectoryId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DeviceAPIService.0
      bool success = true;
      DeviceAPIService_GetDirectoryId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceAPIService::Name_, 0, false);
        return false;
      }
      auto callback =
          DeviceAPIService_GetDirectoryId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDirectoryId(std::move(callback));
      return true;
    }
    case messages::DeviceAPIService::kGetHostname: {
      internal::DeviceAPIService_GetHostname_Params_Data* params =
          reinterpret_cast<
              internal::DeviceAPIService_GetHostname_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DeviceAPIService.1
      bool success = true;
      DeviceAPIService_GetHostname_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceAPIService::Name_, 1, false);
        return false;
      }
      auto callback =
          DeviceAPIService_GetHostname_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetHostname(std::move(callback));
      return true;
    }
    case messages::DeviceAPIService::kGetSerialNumber: {
      internal::DeviceAPIService_GetSerialNumber_Params_Data* params =
          reinterpret_cast<
              internal::DeviceAPIService_GetSerialNumber_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DeviceAPIService.2
      bool success = true;
      DeviceAPIService_GetSerialNumber_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceAPIService::Name_, 2, false);
        return false;
      }
      auto callback =
          DeviceAPIService_GetSerialNumber_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSerialNumber(std::move(callback));
      return true;
    }
    case messages::DeviceAPIService::kGetAnnotatedAssetId: {
      internal::DeviceAPIService_GetAnnotatedAssetId_Params_Data* params =
          reinterpret_cast<
              internal::DeviceAPIService_GetAnnotatedAssetId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DeviceAPIService.3
      bool success = true;
      DeviceAPIService_GetAnnotatedAssetId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceAPIService::Name_, 3, false);
        return false;
      }
      auto callback =
          DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAnnotatedAssetId(std::move(callback));
      return true;
    }
    case messages::DeviceAPIService::kGetAnnotatedLocation: {
      internal::DeviceAPIService_GetAnnotatedLocation_Params_Data* params =
          reinterpret_cast<
              internal::DeviceAPIService_GetAnnotatedLocation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DeviceAPIService.4
      bool success = true;
      DeviceAPIService_GetAnnotatedLocation_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceAPIService::Name_, 4, false);
        return false;
      }
      auto callback =
          DeviceAPIService_GetAnnotatedLocation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAnnotatedLocation(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDeviceAPIServiceValidationInfo[] = {
    { &internal::DeviceAPIService_GetDirectoryId_Params_Data::Validate,
     &internal::DeviceAPIService_GetDirectoryId_ResponseParams_Data::Validate},
    { &internal::DeviceAPIService_GetHostname_Params_Data::Validate,
     &internal::DeviceAPIService_GetHostname_ResponseParams_Data::Validate},
    { &internal::DeviceAPIService_GetSerialNumber_Params_Data::Validate,
     &internal::DeviceAPIService_GetSerialNumber_ResponseParams_Data::Validate},
    { &internal::DeviceAPIService_GetAnnotatedAssetId_Params_Data::Validate,
     &internal::DeviceAPIService_GetAnnotatedAssetId_ResponseParams_Data::Validate},
    { &internal::DeviceAPIService_GetAnnotatedLocation_Params_Data::Validate,
     &internal::DeviceAPIService_GetAnnotatedLocation_ResponseParams_Data::Validate},
};

bool DeviceAPIServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::DeviceAPIService::Name_,
    kDeviceAPIServiceValidationInfo);
}

bool DeviceAPIServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::DeviceAPIService::Name_,
    kDeviceAPIServiceValidationInfo);
}
// The declaration includes the definition on other builds.

ManagedConfigurationService::IPCStableHashFunction ManagedConfigurationService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ManagedConfigurationService>(message.name())) {
    case messages::ManagedConfigurationService::kGetManagedConfiguration: {
      return &ManagedConfigurationService::GetManagedConfiguration_Sym::IPCStableHash;
    }
    case messages::ManagedConfigurationService::kSubscribeToManagedConfiguration: {
      return &ManagedConfigurationService::SubscribeToManagedConfiguration_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ManagedConfigurationService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ManagedConfigurationService>(message.name())) {
      case messages::ManagedConfigurationService::kGetManagedConfiguration:
            return "Receive blink::mojom::ManagedConfigurationService::GetManagedConfiguration";
      case messages::ManagedConfigurationService::kSubscribeToManagedConfiguration:
            return "Receive blink::mojom::ManagedConfigurationService::SubscribeToManagedConfiguration";
    }
  } else {
    switch (static_cast<messages::ManagedConfigurationService>(message.name())) {
      case messages::ManagedConfigurationService::kGetManagedConfiguration:
            return "Receive reply blink::mojom::ManagedConfigurationService::GetManagedConfiguration";
      case messages::ManagedConfigurationService::kSubscribeToManagedConfiguration:
            return "Receive reply blink::mojom::ManagedConfigurationService::SubscribeToManagedConfiguration";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ManagedConfigurationService::GetManagedConfiguration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x78abbfd5;  // IPCStableHash for blink::mojom::ManagedConfigurationService::GetManagedConfiguration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ManagedConfigurationService::SubscribeToManagedConfiguration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x25223421;  // IPCStableHash for blink::mojom::ManagedConfigurationService::SubscribeToManagedConfiguration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ManagedConfigurationService_GetManagedConfiguration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ManagedConfigurationService_GetManagedConfiguration_ForwardToCallback(
      ManagedConfigurationService::GetManagedConfigurationCallback callback
      ) : callback_(std::move(callback)) {
  }

  ManagedConfigurationService_GetManagedConfiguration_ForwardToCallback(const ManagedConfigurationService_GetManagedConfiguration_ForwardToCallback&) = delete;
  ManagedConfigurationService_GetManagedConfiguration_ForwardToCallback& operator=(const ManagedConfigurationService_GetManagedConfiguration_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ManagedConfigurationService::GetManagedConfigurationCallback callback_;
};

ManagedConfigurationServiceProxy::ManagedConfigurationServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ManagedConfigurationServiceProxy::GetManagedConfiguration(
    const ::blink::Vector<::blink::String>& in_keys, GetManagedConfigurationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ManagedConfigurationService::GetManagedConfiguration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keys"), in_keys,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ManagedConfigurationService::kGetManagedConfiguration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManagedConfigurationService_GetManagedConfiguration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->keys)::BaseType>
      keys_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_keys,
    keys_fragment,
    &keys_validate_params);

  params->keys.Set(
      keys_fragment.is_null() ? nullptr : keys_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->keys.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null keys in ManagedConfigurationService.GetManagedConfiguration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManagedConfigurationService::Name_);
  message.set_method_name("GetManagedConfiguration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ManagedConfigurationService_GetManagedConfiguration_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ManagedConfigurationServiceProxy::SubscribeToManagedConfiguration(
    ::mojo::PendingRemote<ManagedConfigurationObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ManagedConfigurationService::SubscribeToManagedConfiguration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<ManagedConfigurationObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ManagedConfigurationService::kSubscribeToManagedConfiguration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManagedConfigurationService_SubscribeToManagedConfiguration_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ManagedConfigurationObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in ManagedConfigurationService.SubscribeToManagedConfiguration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManagedConfigurationService::Name_);
  message.set_method_name("SubscribeToManagedConfiguration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ManagedConfigurationService::GetManagedConfigurationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder> proxy(
        new ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ManagedConfigurationService::GetManagedConfigurationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::blink::HashMap<::blink::String, ::blink::String>>& in_configurations);
};

bool ManagedConfigurationService_GetManagedConfiguration_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ManagedConfigurationService_GetManagedConfiguration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ManagedConfigurationService_GetManagedConfiguration_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ManagedConfigurationService.0
  bool success = true;
  std::optional<::blink::HashMap<::blink::String, ::blink::String>> p_configurations{};
  ManagedConfigurationService_GetManagedConfiguration_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadConfigurations(&p_configurations))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ManagedConfigurationService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_configurations));
  }
  return true;
}

void ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder::Run(
    const std::optional<::blink::HashMap<::blink::String, ::blink::String>>& in_configurations) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ManagedConfigurationService::GetManagedConfiguration", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("configurations"), in_configurations,
                        "<value of type const std::optional<::blink::HashMap<::blink::String, ::blink::String>>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ManagedConfigurationService::kGetManagedConfiguration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManagedConfigurationService_GetManagedConfiguration_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->configurations)::BaseType>
      configurations_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& configurations_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
    in_configurations,
    configurations_fragment,
    &configurations_validate_params);

  params->configurations.Set(
      configurations_fragment.is_null() ? nullptr : configurations_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManagedConfigurationService::Name_);
  message.set_method_name("GetManagedConfiguration");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ManagedConfigurationServiceStubDispatch::Accept(
    ManagedConfigurationService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ManagedConfigurationService>(message->header()->name)) {
    case messages::ManagedConfigurationService::kGetManagedConfiguration: {
      break;
    }
    case messages::ManagedConfigurationService::kSubscribeToManagedConfiguration: {
      DCHECK(message->is_serialized());
      internal::ManagedConfigurationService_SubscribeToManagedConfiguration_Params_Data* params =
          reinterpret_cast<internal::ManagedConfigurationService_SubscribeToManagedConfiguration_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ManagedConfigurationService.1
      bool success = true;
      ::mojo::PendingRemote<ManagedConfigurationObserver> p_observer{};
      ManagedConfigurationService_SubscribeToManagedConfiguration_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ManagedConfigurationService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubscribeToManagedConfiguration(        
        std::move(p_observer));
      return true;
    }
  }
  return false;
}

// static
bool ManagedConfigurationServiceStubDispatch::AcceptWithResponder(
    ManagedConfigurationService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ManagedConfigurationService>(message->header()->name)) {
    case messages::ManagedConfigurationService::kGetManagedConfiguration: {
      internal::ManagedConfigurationService_GetManagedConfiguration_Params_Data* params =
          reinterpret_cast<
              internal::ManagedConfigurationService_GetManagedConfiguration_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ManagedConfigurationService.0
      bool success = true;
      ::blink::Vector<::blink::String> p_keys{};
      ManagedConfigurationService_GetManagedConfiguration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeys(&p_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ManagedConfigurationService::Name_, 0, false);
        return false;
      }
      auto callback =
          ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetManagedConfiguration(        
        std::move(p_keys), std::move(callback));
      return true;
    }
    case messages::ManagedConfigurationService::kSubscribeToManagedConfiguration: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kManagedConfigurationServiceValidationInfo[] = {
    { &internal::ManagedConfigurationService_GetManagedConfiguration_Params_Data::Validate,
     &internal::ManagedConfigurationService_GetManagedConfiguration_ResponseParams_Data::Validate},
    { &internal::ManagedConfigurationService_SubscribeToManagedConfiguration_Params_Data::Validate,
     nullptr /* no response */},
};

bool ManagedConfigurationServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ManagedConfigurationService::Name_,
    kManagedConfigurationServiceValidationInfo);
}

bool ManagedConfigurationServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::ManagedConfigurationService::Name_,
    kManagedConfigurationServiceValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

// static
bool UnionTraits<::blink::mojom::blink::DeviceAttributeResult::DataView, ::blink::mojom::blink::DeviceAttributeResultPtr>::Read(
    ::blink::mojom::blink::DeviceAttributeResult::DataView input,
    ::blink::mojom::blink::DeviceAttributeResultPtr* output) {
  using UnionType = ::blink::mojom::blink::DeviceAttributeResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kErrorMessage: {
      ::blink::String result_error_message{};
      if (!input.ReadErrorMessage(&result_error_message))
        return false;

      *output = UnionType::NewErrorMessage(
          std::move(result_error_message));
      break;
    }
    case Tag::kAttribute: {
      ::blink::String result_attribute{};
      if (!input.ReadAttribute(&result_attribute))
        return false;

      *output = UnionType::NewAttribute(
          std::move(result_attribute));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void ManagedConfigurationObserverInterceptorForTesting::OnConfigurationChanged() {
  GetForwardingInterface()->OnConfigurationChanged();
}
ManagedConfigurationObserverAsyncWaiter::ManagedConfigurationObserverAsyncWaiter(
    ManagedConfigurationObserver* proxy) : proxy_(proxy) {}

ManagedConfigurationObserverAsyncWaiter::~ManagedConfigurationObserverAsyncWaiter() = default;





void DeviceAPIServiceInterceptorForTesting::GetDirectoryId(GetDirectoryIdCallback callback) {
  GetForwardingInterface()->GetDirectoryId(std::move(callback));
}
void DeviceAPIServiceInterceptorForTesting::GetHostname(GetHostnameCallback callback) {
  GetForwardingInterface()->GetHostname(std::move(callback));
}
void DeviceAPIServiceInterceptorForTesting::GetSerialNumber(GetSerialNumberCallback callback) {
  GetForwardingInterface()->GetSerialNumber(std::move(callback));
}
void DeviceAPIServiceInterceptorForTesting::GetAnnotatedAssetId(GetAnnotatedAssetIdCallback callback) {
  GetForwardingInterface()->GetAnnotatedAssetId(std::move(callback));
}
void DeviceAPIServiceInterceptorForTesting::GetAnnotatedLocation(GetAnnotatedLocationCallback callback) {
  GetForwardingInterface()->GetAnnotatedLocation(std::move(callback));
}
DeviceAPIServiceAsyncWaiter::DeviceAPIServiceAsyncWaiter(
    DeviceAPIService* proxy) : proxy_(proxy) {}

DeviceAPIServiceAsyncWaiter::~DeviceAPIServiceAsyncWaiter() = default;


void DeviceAPIServiceAsyncWaiter::GetDirectoryId(
    DeviceAttributeResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetDirectoryId(
      base::BindOnce(
          [](base::RunLoop* loop,
             DeviceAttributeResultPtr* out_result
,
             DeviceAttributeResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

DeviceAttributeResultPtr DeviceAPIServiceAsyncWaiter::GetDirectoryId(
    ) {
  DeviceAttributeResultPtr async_wait_result;
  GetDirectoryId(&async_wait_result);
  return async_wait_result;
}

void DeviceAPIServiceAsyncWaiter::GetHostname(
    DeviceAttributeResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetHostname(
      base::BindOnce(
          [](base::RunLoop* loop,
             DeviceAttributeResultPtr* out_result
,
             DeviceAttributeResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

DeviceAttributeResultPtr DeviceAPIServiceAsyncWaiter::GetHostname(
    ) {
  DeviceAttributeResultPtr async_wait_result;
  GetHostname(&async_wait_result);
  return async_wait_result;
}

void DeviceAPIServiceAsyncWaiter::GetSerialNumber(
    DeviceAttributeResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetSerialNumber(
      base::BindOnce(
          [](base::RunLoop* loop,
             DeviceAttributeResultPtr* out_result
,
             DeviceAttributeResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

DeviceAttributeResultPtr DeviceAPIServiceAsyncWaiter::GetSerialNumber(
    ) {
  DeviceAttributeResultPtr async_wait_result;
  GetSerialNumber(&async_wait_result);
  return async_wait_result;
}

void DeviceAPIServiceAsyncWaiter::GetAnnotatedAssetId(
    DeviceAttributeResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetAnnotatedAssetId(
      base::BindOnce(
          [](base::RunLoop* loop,
             DeviceAttributeResultPtr* out_result
,
             DeviceAttributeResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

DeviceAttributeResultPtr DeviceAPIServiceAsyncWaiter::GetAnnotatedAssetId(
    ) {
  DeviceAttributeResultPtr async_wait_result;
  GetAnnotatedAssetId(&async_wait_result);
  return async_wait_result;
}

void DeviceAPIServiceAsyncWaiter::GetAnnotatedLocation(
    DeviceAttributeResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetAnnotatedLocation(
      base::BindOnce(
          [](base::RunLoop* loop,
             DeviceAttributeResultPtr* out_result
,
             DeviceAttributeResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

DeviceAttributeResultPtr DeviceAPIServiceAsyncWaiter::GetAnnotatedLocation(
    ) {
  DeviceAttributeResultPtr async_wait_result;
  GetAnnotatedLocation(&async_wait_result);
  return async_wait_result;
}




void ManagedConfigurationServiceInterceptorForTesting::GetManagedConfiguration(const ::blink::Vector<::blink::String>& keys, GetManagedConfigurationCallback callback) {
  GetForwardingInterface()->GetManagedConfiguration(
    std::move(keys)
    , std::move(callback));
}
void ManagedConfigurationServiceInterceptorForTesting::SubscribeToManagedConfiguration(::mojo::PendingRemote<ManagedConfigurationObserver> observer) {
  GetForwardingInterface()->SubscribeToManagedConfiguration(
    std::move(observer)
    );
}
ManagedConfigurationServiceAsyncWaiter::ManagedConfigurationServiceAsyncWaiter(
    ManagedConfigurationService* proxy) : proxy_(proxy) {}

ManagedConfigurationServiceAsyncWaiter::~ManagedConfigurationServiceAsyncWaiter() = default;


void ManagedConfigurationServiceAsyncWaiter::GetManagedConfiguration(
    const ::blink::Vector<::blink::String>& keys, std::optional<::blink::HashMap<::blink::String, ::blink::String>>* out_configurations) {
  base::RunLoop loop;
  proxy_->GetManagedConfiguration(
      std::move(keys),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::blink::HashMap<::blink::String, ::blink::String>>* out_configurations
,
             const std::optional<::blink::HashMap<::blink::String, ::blink::String>>& configurations) {*out_configurations = std::move(configurations);
            loop->Quit();
          },
          &loop,
          out_configurations));
  loop.Run();
}

std::optional<::blink::HashMap<::blink::String, ::blink::String>> ManagedConfigurationServiceAsyncWaiter::GetManagedConfiguration(
    const ::blink::Vector<::blink::String>& keys) {
  std::optional<::blink::HashMap<::blink::String, ::blink::String>> async_wait_result;
  GetManagedConfiguration(std::move(keys),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif