// third_party/blink/public/mojom/data_transfer/data_transfer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DATA_TRANSFER_DATA_TRANSFER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DATA_TRANSFER_DATA_TRANSFER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT DataTransferFile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataTransferFile, T>::value>;
  using DataView = DataTransferFileDataView;
  using Data_ = internal::DataTransferFile_Data;

  template <typename... Args>
  static DataTransferFilePtr New(Args&&... args) {
    return DataTransferFilePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataTransferFilePtr From(const U& u) {
    return mojo::TypeConverter<DataTransferFilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataTransferFile>::Convert(*this);
  }


  DataTransferFile();

  DataTransferFile(
      const ::base::FilePath& path,
      const ::base::FilePath& display_name,
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDataTransferToken> file_system_access_token);

DataTransferFile(const DataTransferFile&) = delete;
DataTransferFile& operator=(const DataTransferFile&) = delete;

  ~DataTransferFile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataTransferFilePtr>
  DataTransferFilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataTransferFile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataTransferFile::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataTransferFile::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataTransferFile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataTransferFile_UnserializedMessageContext<
            UserType, DataTransferFile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataTransferFile::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataTransferFile::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataTransferFile_UnserializedMessageContext<
            UserType, DataTransferFile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataTransferFile::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::FilePath path;
  
  ::base::FilePath display_name;
  
  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDataTransferToken> file_system_access_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataTransferFile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataTransferFile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataTransferFile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataTransferFile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DataTransferFilePtr DataTransferFile::Clone() const {
  return New(
      mojo::Clone(path),
      mojo::Clone(display_name),
      mojo::Clone(file_system_access_token)
  );
}

template <typename T, DataTransferFile::EnableIfSame<T>*>
bool DataTransferFile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->file_system_access_token, other_struct.file_system_access_token))
    return false;
  return true;
}

template <typename T, DataTransferFile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.file_system_access_token < rhs.file_system_access_token)
    return true;
  if (rhs.file_system_access_token < lhs.file_system_access_token)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::DataTransferFile::DataView,
                                         ::blink::mojom::DataTransferFilePtr> {
  static bool IsNull(const ::blink::mojom::DataTransferFilePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DataTransferFilePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::DataTransferFile::path)& path(
      const ::blink::mojom::DataTransferFilePtr& input) {
    return input->path;
  }

  static const decltype(::blink::mojom::DataTransferFile::display_name)& display_name(
      const ::blink::mojom::DataTransferFilePtr& input) {
    return input->display_name;
  }

  static  decltype(::blink::mojom::DataTransferFile::file_system_access_token)& file_system_access_token(
       ::blink::mojom::DataTransferFilePtr& input) {
    return input->file_system_access_token;
  }

  static bool Read(::blink::mojom::DataTransferFile::DataView input, ::blink::mojom::DataTransferFilePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DATA_TRANSFER_DATA_TRANSFER_MOJOM_H_