// third_party/blink/public/mojom/data_transfer/data_transfer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom-params-data.h"
#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom-import-headers.h"
#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom-test-utils.h"


namespace blink::mojom {
DataTransferFile::DataTransferFile()
    : path(),
      display_name(),
      file_system_access_token() {}

DataTransferFile::DataTransferFile(
    const ::base::FilePath& path_in,
    const ::base::FilePath& display_name_in,
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDataTransferToken> file_system_access_token_in)
    : path(std::move(path_in)),
      display_name(std::move(display_name_in)),
      file_system_access_token(std::move(file_system_access_token_in)) {}

DataTransferFile::~DataTransferFile() = default;

void DataTransferFile::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_system_access_token"), this->file_system_access_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDataTransferToken>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DataTransferFile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::DataTransferFile::DataView, ::blink::mojom::DataTransferFilePtr>::Read(
    ::blink::mojom::DataTransferFile::DataView input,
    ::blink::mojom::DataTransferFilePtr* output) {
  bool success = true;
  ::blink::mojom::DataTransferFilePtr result(::blink::mojom::DataTransferFile::New());
  
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success) {
        result->file_system_access_token =
            input.TakeFileSystemAccessToken<decltype(result->file_system_access_token)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {




}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif