// third_party/blink/public/mojom/cookie_store/cookie_store.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  CookieMatchType as network_mojom_CookieMatchType,
  CookieMatchTypeSpec as network_mojom_CookieMatchTypeSpec
} from '../../../../../services/network/public/mojom/restricted_cookie_manager.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CookieStorePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.CookieStore', scope);
  }
}

/** @interface */
export class CookieStoreInterface {
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !Array<!CookieChangeSubscription> } subscription
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  addSubscriptions(serviceWorkerRegistrationId, subscription) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !Array<!CookieChangeSubscription> } subscription
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  removeSubscriptions(serviceWorkerRegistrationId, subscription) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        subscriptions: !Array<!CookieChangeSubscription>,
        success: !boolean,
   *  }>}
   */

  getSubscriptions(serviceWorkerRegistrationId) {}
}

/**
 * @implements { CookieStoreInterface }
 */
export class CookieStoreRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CookieStorePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CookieStorePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CookieStorePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !Array<!CookieChangeSubscription> } subscription
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  addSubscriptions(
      serviceWorkerRegistrationId,
      subscription) {
    return this.proxy.sendMessage(
        0,
        CookieStore_AddSubscriptions_ParamsSpec.$,
        CookieStore_AddSubscriptions_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          subscription
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !Array<!CookieChangeSubscription> } subscription
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  removeSubscriptions(
      serviceWorkerRegistrationId,
      subscription) {
    return this.proxy.sendMessage(
        1,
        CookieStore_RemoveSubscriptions_ParamsSpec.$,
        CookieStore_RemoveSubscriptions_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          subscription
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        subscriptions: !Array<!CookieChangeSubscription>,
        success: !boolean,
   *  }>}
   */

  getSubscriptions(
      serviceWorkerRegistrationId) {
    return this.proxy.sendMessage(
        2,
        CookieStore_GetSubscriptions_ParamsSpec.$,
        CookieStore_GetSubscriptions_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CookieStore
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CookieStoreReceiver {
  /**
   * @param {!CookieStoreInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CookieStoreRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CookieStoreRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CookieStoreRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CookieStore_AddSubscriptions_ParamsSpec.$,
        CookieStore_AddSubscriptions_ResponseParamsSpec.$,
        impl.addSubscriptions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CookieStore_RemoveSubscriptions_ParamsSpec.$,
        CookieStore_RemoveSubscriptions_ResponseParamsSpec.$,
        impl.removeSubscriptions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CookieStore_GetSubscriptions_ParamsSpec.$,
        CookieStore_GetSubscriptions_ResponseParamsSpec.$,
        impl.getSubscriptions.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CookieStore {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.CookieStore";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CookieStoreRemote}
   */
  static getRemote() {
    let remote = new CookieStoreRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CookieStore
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CookieStoreCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CookieStoreRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CookieStoreRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addSubscriptions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CookieStore_AddSubscriptions_ParamsSpec.$,
        CookieStore_AddSubscriptions_ResponseParamsSpec.$,
        this.addSubscriptions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeSubscriptions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CookieStore_RemoveSubscriptions_ParamsSpec.$,
        CookieStore_RemoveSubscriptions_ResponseParamsSpec.$,
        this.removeSubscriptions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSubscriptions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CookieStore_GetSubscriptions_ParamsSpec.$,
        CookieStore_GetSubscriptions_ResponseParamsSpec.$,
        this.getSubscriptions.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieChangeSubscriptionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieStore_AddSubscriptions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieStore_AddSubscriptions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieStore_RemoveSubscriptions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieStore_RemoveSubscriptions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieStore_GetSubscriptions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieStore_GetSubscriptions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CookieChangeSubscriptionSpec.$,
    'CookieChangeSubscription',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'matchType', 8,
        0,
        network_mojom_CookieMatchTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CookieChangeSubscription {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !network_mojom_CookieMatchType } */
    this.matchType;
    /** @type { !string } */
    this.name;
  }
}



mojo.internal.Struct(
    CookieStore_AddSubscriptions_ParamsSpec.$,
    'CookieStore_AddSubscriptions_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subscription', 8,
        0,
        mojo.internal.Array(CookieChangeSubscriptionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CookieStore_AddSubscriptions_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @type { !Array<!CookieChangeSubscription> } */
    this.subscription;
  }
}



mojo.internal.Struct(
    CookieStore_AddSubscriptions_ResponseParamsSpec.$,
    'CookieStore_AddSubscriptions_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieStore_AddSubscriptions_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    CookieStore_RemoveSubscriptions_ParamsSpec.$,
    'CookieStore_RemoveSubscriptions_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subscription', 8,
        0,
        mojo.internal.Array(CookieChangeSubscriptionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CookieStore_RemoveSubscriptions_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @type { !Array<!CookieChangeSubscription> } */
    this.subscription;
  }
}



mojo.internal.Struct(
    CookieStore_RemoveSubscriptions_ResponseParamsSpec.$,
    'CookieStore_RemoveSubscriptions_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieStore_RemoveSubscriptions_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    CookieStore_GetSubscriptions_ParamsSpec.$,
    'CookieStore_GetSubscriptions_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieStore_GetSubscriptions_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
  }
}



mojo.internal.Struct(
    CookieStore_GetSubscriptions_ResponseParamsSpec.$,
    'CookieStore_GetSubscriptions_ResponseParams',
    [
      mojo.internal.StructField(
        'subscriptions', 0,
        0,
        mojo.internal.Array(CookieChangeSubscriptionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'success', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CookieStore_GetSubscriptions_ResponseParams {
  constructor() {
    /** @type { !Array<!CookieChangeSubscription> } */
    this.subscriptions;
    /** @type { !boolean } */
    this.success;
  }
}

