// third_party/blink/public/mojom/cookie_store/cookie_store.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/cookie_store/cookie_store.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/cookie_store/cookie_store.mojom-params-data.h"
#include "third_party/blink/public/mojom/cookie_store/cookie_store.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/cookie_store/cookie_store.mojom-import-headers.h"
#include "third_party/blink/public/mojom/cookie_store/cookie_store.mojom-test-utils.h"


namespace blink::mojom {
CookieChangeSubscription::CookieChangeSubscription()
    : url(),
      match_type(),
      name() {}

CookieChangeSubscription::CookieChangeSubscription(
    const ::GURL& url_in,
    ::network::mojom::CookieMatchType match_type_in,
    const std::string& name_in)
    : url(std::move(url_in)),
      match_type(std::move(match_type_in)),
      name(std::move(name_in)) {}

CookieChangeSubscription::~CookieChangeSubscription() = default;

void CookieChangeSubscription::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "match_type"), this->match_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::CookieMatchType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieChangeSubscription::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

CookieStore::IPCStableHashFunction CookieStore::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CookieStore>(message.name())) {
    case messages::CookieStore::kAddSubscriptions: {
      return &CookieStore::AddSubscriptions_Sym::IPCStableHash;
    }
    case messages::CookieStore::kRemoveSubscriptions: {
      return &CookieStore::RemoveSubscriptions_Sym::IPCStableHash;
    }
    case messages::CookieStore::kGetSubscriptions: {
      return &CookieStore::GetSubscriptions_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CookieStore::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CookieStore>(message.name())) {
      case messages::CookieStore::kAddSubscriptions:
            return "Receive blink::mojom::CookieStore::AddSubscriptions";
      case messages::CookieStore::kRemoveSubscriptions:
            return "Receive blink::mojom::CookieStore::RemoveSubscriptions";
      case messages::CookieStore::kGetSubscriptions:
            return "Receive blink::mojom::CookieStore::GetSubscriptions";
    }
  } else {
    switch (static_cast<messages::CookieStore>(message.name())) {
      case messages::CookieStore::kAddSubscriptions:
            return "Receive reply blink::mojom::CookieStore::AddSubscriptions";
      case messages::CookieStore::kRemoveSubscriptions:
            return "Receive reply blink::mojom::CookieStore::RemoveSubscriptions";
      case messages::CookieStore::kGetSubscriptions:
            return "Receive reply blink::mojom::CookieStore::GetSubscriptions";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CookieStore::AddSubscriptions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xafd24d61;  // IPCStableHash for blink::mojom::CookieStore::AddSubscriptions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieStore::RemoveSubscriptions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbbc310b1;  // IPCStableHash for blink::mojom::CookieStore::RemoveSubscriptions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieStore::GetSubscriptions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf34ccb2b;  // IPCStableHash for blink::mojom::CookieStore::GetSubscriptions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CookieStore_AddSubscriptions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieStore_AddSubscriptions_ForwardToCallback(
      CookieStore::AddSubscriptionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  CookieStore_AddSubscriptions_ForwardToCallback(const CookieStore_AddSubscriptions_ForwardToCallback&) = delete;
  CookieStore_AddSubscriptions_ForwardToCallback& operator=(const CookieStore_AddSubscriptions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CookieStore::AddSubscriptionsCallback callback_;
};

class CookieStore_RemoveSubscriptions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieStore_RemoveSubscriptions_ForwardToCallback(
      CookieStore::RemoveSubscriptionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  CookieStore_RemoveSubscriptions_ForwardToCallback(const CookieStore_RemoveSubscriptions_ForwardToCallback&) = delete;
  CookieStore_RemoveSubscriptions_ForwardToCallback& operator=(const CookieStore_RemoveSubscriptions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CookieStore::RemoveSubscriptionsCallback callback_;
};

class CookieStore_GetSubscriptions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieStore_GetSubscriptions_ForwardToCallback(
      CookieStore::GetSubscriptionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  CookieStore_GetSubscriptions_ForwardToCallback(const CookieStore_GetSubscriptions_ForwardToCallback&) = delete;
  CookieStore_GetSubscriptions_ForwardToCallback& operator=(const CookieStore_GetSubscriptions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CookieStore::GetSubscriptionsCallback callback_;
};

CookieStoreProxy::CookieStoreProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CookieStoreProxy::AddSubscriptions(
    int64_t in_service_worker_registration_id, std::vector<CookieChangeSubscriptionPtr> in_subscription, AddSubscriptionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CookieStore::AddSubscriptions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription"), in_subscription,
                        "<value of type std::vector<CookieChangeSubscriptionPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieStore::kAddSubscriptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CookieStore_AddSubscriptions_Params_Data> params(
          message);
  params.Allocate();

  params->service_worker_registration_id = in_service_worker_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->subscription)::BaseType>
      subscription_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& subscription_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::CookieChangeSubscriptionDataView>>(
    in_subscription,
    subscription_fragment,
    &subscription_validate_params);

  params->subscription.Set(
      subscription_fragment.is_null() ? nullptr : subscription_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subscription.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subscription in CookieStore.AddSubscriptions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieStore::Name_);
  message.set_method_name("AddSubscriptions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieStore_AddSubscriptions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CookieStoreProxy::RemoveSubscriptions(
    int64_t in_service_worker_registration_id, std::vector<CookieChangeSubscriptionPtr> in_subscription, RemoveSubscriptionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CookieStore::RemoveSubscriptions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription"), in_subscription,
                        "<value of type std::vector<CookieChangeSubscriptionPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieStore::kRemoveSubscriptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CookieStore_RemoveSubscriptions_Params_Data> params(
          message);
  params.Allocate();

  params->service_worker_registration_id = in_service_worker_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->subscription)::BaseType>
      subscription_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& subscription_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::CookieChangeSubscriptionDataView>>(
    in_subscription,
    subscription_fragment,
    &subscription_validate_params);

  params->subscription.Set(
      subscription_fragment.is_null() ? nullptr : subscription_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subscription.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subscription in CookieStore.RemoveSubscriptions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieStore::Name_);
  message.set_method_name("RemoveSubscriptions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieStore_RemoveSubscriptions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CookieStoreProxy::GetSubscriptions(
    int64_t in_service_worker_registration_id, GetSubscriptionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CookieStore::GetSubscriptions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieStore::kGetSubscriptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CookieStore_GetSubscriptions_Params_Data> params(
          message);
  params.Allocate();

  params->service_worker_registration_id = in_service_worker_registration_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieStore::Name_);
  message.set_method_name("GetSubscriptions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieStore_GetSubscriptions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class CookieStore_AddSubscriptions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CookieStore::AddSubscriptionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CookieStore_AddSubscriptions_ProxyToResponder> proxy(
        new CookieStore_AddSubscriptions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CookieStore_AddSubscriptions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieStore_AddSubscriptions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CookieStore_AddSubscriptions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CookieStore::AddSubscriptionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool CookieStore_AddSubscriptions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CookieStore_AddSubscriptions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieStore_AddSubscriptions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CookieStore.0
  bool success = true;
  bool p_success{};
  CookieStore_AddSubscriptions_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieStore::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void CookieStore_AddSubscriptions_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CookieStore::AddSubscriptions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieStore::kAddSubscriptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CookieStore_AddSubscriptions_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieStore::Name_);
  message.set_method_name("AddSubscriptions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieStore_RemoveSubscriptions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CookieStore::RemoveSubscriptionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CookieStore_RemoveSubscriptions_ProxyToResponder> proxy(
        new CookieStore_RemoveSubscriptions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CookieStore_RemoveSubscriptions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieStore_RemoveSubscriptions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CookieStore_RemoveSubscriptions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CookieStore::RemoveSubscriptionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool CookieStore_RemoveSubscriptions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CookieStore_RemoveSubscriptions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieStore_RemoveSubscriptions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CookieStore.1
  bool success = true;
  bool p_success{};
  CookieStore_RemoveSubscriptions_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieStore::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void CookieStore_RemoveSubscriptions_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CookieStore::RemoveSubscriptions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieStore::kRemoveSubscriptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CookieStore_RemoveSubscriptions_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieStore::Name_);
  message.set_method_name("RemoveSubscriptions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieStore_GetSubscriptions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CookieStore::GetSubscriptionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CookieStore_GetSubscriptions_ProxyToResponder> proxy(
        new CookieStore_GetSubscriptions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CookieStore_GetSubscriptions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieStore_GetSubscriptions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CookieStore_GetSubscriptions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CookieStore::GetSubscriptionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<CookieChangeSubscriptionPtr> in_subscriptions, bool in_success);
};

bool CookieStore_GetSubscriptions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CookieStore_GetSubscriptions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieStore_GetSubscriptions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CookieStore.2
  bool success = true;
  std::vector<CookieChangeSubscriptionPtr> p_subscriptions{};
  bool p_success{};
  CookieStore_GetSubscriptions_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSubscriptions(&p_subscriptions))
    success = false;
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieStore::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_subscriptions), 
std::move(p_success));
  }
  return true;
}

void CookieStore_GetSubscriptions_ProxyToResponder::Run(
    std::vector<CookieChangeSubscriptionPtr> in_subscriptions, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CookieStore::GetSubscriptions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscriptions"), in_subscriptions,
                        "<value of type std::vector<CookieChangeSubscriptionPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieStore::kGetSubscriptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CookieStore_GetSubscriptions_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->subscriptions)::BaseType>
      subscriptions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& subscriptions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::CookieChangeSubscriptionDataView>>(
    in_subscriptions,
    subscriptions_fragment,
    &subscriptions_validate_params);

  params->subscriptions.Set(
      subscriptions_fragment.is_null() ? nullptr : subscriptions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subscriptions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subscriptions in ");

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieStore::Name_);
  message.set_method_name("GetSubscriptions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CookieStoreStubDispatch::Accept(
    CookieStore* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CookieStore>(message->header()->name)) {
    case messages::CookieStore::kAddSubscriptions: {
      break;
    }
    case messages::CookieStore::kRemoveSubscriptions: {
      break;
    }
    case messages::CookieStore::kGetSubscriptions: {
      break;
    }
  }
  return false;
}

// static
bool CookieStoreStubDispatch::AcceptWithResponder(
    CookieStore* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CookieStore>(message->header()->name)) {
    case messages::CookieStore::kAddSubscriptions: {
      internal::CookieStore_AddSubscriptions_Params_Data* params =
          reinterpret_cast<
              internal::CookieStore_AddSubscriptions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CookieStore.0
      bool success = true;
      int64_t p_service_worker_registration_id{};
      std::vector<CookieChangeSubscriptionPtr> p_subscription{};
      CookieStore_AddSubscriptions_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadSubscription(&p_subscription))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieStore::Name_, 0, false);
        return false;
      }
      auto callback =
          CookieStore_AddSubscriptions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddSubscriptions(        
        std::move(p_service_worker_registration_id), 
        std::move(p_subscription), std::move(callback));
      return true;
    }
    case messages::CookieStore::kRemoveSubscriptions: {
      internal::CookieStore_RemoveSubscriptions_Params_Data* params =
          reinterpret_cast<
              internal::CookieStore_RemoveSubscriptions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CookieStore.1
      bool success = true;
      int64_t p_service_worker_registration_id{};
      std::vector<CookieChangeSubscriptionPtr> p_subscription{};
      CookieStore_RemoveSubscriptions_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadSubscription(&p_subscription))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieStore::Name_, 1, false);
        return false;
      }
      auto callback =
          CookieStore_RemoveSubscriptions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveSubscriptions(        
        std::move(p_service_worker_registration_id), 
        std::move(p_subscription), std::move(callback));
      return true;
    }
    case messages::CookieStore::kGetSubscriptions: {
      internal::CookieStore_GetSubscriptions_Params_Data* params =
          reinterpret_cast<
              internal::CookieStore_GetSubscriptions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CookieStore.2
      bool success = true;
      int64_t p_service_worker_registration_id{};
      CookieStore_GetSubscriptions_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieStore::Name_, 2, false);
        return false;
      }
      auto callback =
          CookieStore_GetSubscriptions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSubscriptions(        
        std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCookieStoreValidationInfo[] = {
    { &internal::CookieStore_AddSubscriptions_Params_Data::Validate,
     &internal::CookieStore_AddSubscriptions_ResponseParams_Data::Validate},
    { &internal::CookieStore_RemoveSubscriptions_Params_Data::Validate,
     &internal::CookieStore_RemoveSubscriptions_ResponseParams_Data::Validate},
    { &internal::CookieStore_GetSubscriptions_Params_Data::Validate,
     &internal::CookieStore_GetSubscriptions_ResponseParams_Data::Validate},
};

bool CookieStoreRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::CookieStore::Name_,
    kCookieStoreValidationInfo);
}

bool CookieStoreResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::CookieStore::Name_,
    kCookieStoreValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::CookieChangeSubscription::DataView, ::blink::mojom::CookieChangeSubscriptionPtr>::Read(
    ::blink::mojom::CookieChangeSubscription::DataView input,
    ::blink::mojom::CookieChangeSubscriptionPtr* output) {
  bool success = true;
  ::blink::mojom::CookieChangeSubscriptionPtr result(::blink::mojom::CookieChangeSubscription::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadMatchType(&result->match_type))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void CookieStoreInterceptorForTesting::AddSubscriptions(int64_t service_worker_registration_id, std::vector<CookieChangeSubscriptionPtr> subscription, AddSubscriptionsCallback callback) {
  GetForwardingInterface()->AddSubscriptions(
    std::move(service_worker_registration_id)
    , 
    std::move(subscription)
    , std::move(callback));
}
void CookieStoreInterceptorForTesting::RemoveSubscriptions(int64_t service_worker_registration_id, std::vector<CookieChangeSubscriptionPtr> subscription, RemoveSubscriptionsCallback callback) {
  GetForwardingInterface()->RemoveSubscriptions(
    std::move(service_worker_registration_id)
    , 
    std::move(subscription)
    , std::move(callback));
}
void CookieStoreInterceptorForTesting::GetSubscriptions(int64_t service_worker_registration_id, GetSubscriptionsCallback callback) {
  GetForwardingInterface()->GetSubscriptions(
    std::move(service_worker_registration_id)
    , std::move(callback));
}
CookieStoreAsyncWaiter::CookieStoreAsyncWaiter(
    CookieStore* proxy) : proxy_(proxy) {}

CookieStoreAsyncWaiter::~CookieStoreAsyncWaiter() = default;


void CookieStoreAsyncWaiter::AddSubscriptions(
    int64_t service_worker_registration_id, std::vector<CookieChangeSubscriptionPtr> subscription, bool* out_success) {
  base::RunLoop loop;
  proxy_->AddSubscriptions(
      std::move(service_worker_registration_id),
      std::move(subscription),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool CookieStoreAsyncWaiter::AddSubscriptions(
    int64_t service_worker_registration_id, std::vector<CookieChangeSubscriptionPtr> subscription) {
  bool async_wait_result;
  AddSubscriptions(std::move(service_worker_registration_id),std::move(subscription),&async_wait_result);
  return async_wait_result;
}

void CookieStoreAsyncWaiter::RemoveSubscriptions(
    int64_t service_worker_registration_id, std::vector<CookieChangeSubscriptionPtr> subscription, bool* out_success) {
  base::RunLoop loop;
  proxy_->RemoveSubscriptions(
      std::move(service_worker_registration_id),
      std::move(subscription),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool CookieStoreAsyncWaiter::RemoveSubscriptions(
    int64_t service_worker_registration_id, std::vector<CookieChangeSubscriptionPtr> subscription) {
  bool async_wait_result;
  RemoveSubscriptions(std::move(service_worker_registration_id),std::move(subscription),&async_wait_result);
  return async_wait_result;
}

void CookieStoreAsyncWaiter::GetSubscriptions(
    int64_t service_worker_registration_id, std::vector<CookieChangeSubscriptionPtr>* out_subscriptions, bool* out_success) {
  base::RunLoop loop;
  proxy_->GetSubscriptions(
      std::move(service_worker_registration_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<CookieChangeSubscriptionPtr>* out_subscriptions
,
             bool* out_success
,
             std::vector<CookieChangeSubscriptionPtr> subscriptions,
             bool success) {*out_subscriptions = std::move(subscriptions);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_subscriptions,
          out_success));
  loop.Run();
}








}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif