// third_party/blink/public/mojom/conversions/conversions.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  DataHostRemote as attributionReporting_mojom_DataHostRemote,
  DataHostPendingReceiver as attributionReporting_mojom_DataHostPendingReceiver
} from '../../../../../components/attribution_reporting/data_host.mojom.m.js';

import {
  RegistrationEligibility as attributionReporting_mojom_RegistrationEligibility,
  RegistrationEligibilitySpec as attributionReporting_mojom_RegistrationEligibilitySpec
} from '../../../../../components/attribution_reporting/registration_eligibility.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  AttributionSrcToken as blink_mojom_AttributionSrcToken,
  AttributionSrcTokenSpec as blink_mojom_AttributionSrcTokenSpec
} from '../tokens/tokens.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AttributionHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AttributionHost', scope);
  }
}

/** @interface */
export class AttributionHostInterface {
  
  /**
   * @param { !attributionReporting_mojom_DataHostPendingReceiver } dataHost
   * @param { !attributionReporting_mojom_RegistrationEligibility } registrationEligibility
   * @param { !boolean } isForBackgroundRequests
   * @param { !Array<!url_mojom_Origin> } reportingOrigins
   */

  registerDataHost(dataHost, registrationEligibility, isForBackgroundRequests, reportingOrigins) {}
  
  /**
   * @param { !attributionReporting_mojom_DataHostPendingReceiver } dataHost
   * @param { !blink_mojom_AttributionSrcToken } attributionSrcToken
   */

  registerNavigationDataHost(dataHost, attributionSrcToken) {}
  
  /**
   * @param { !blink_mojom_AttributionSrcToken } attributionSrcToken
   * @param { !number } expectedRegistrations
   */

  notifyNavigationWithBackgroundRegistrationsWillStart(attributionSrcToken, expectedRegistrations) {}
}

/**
 * @implements { AttributionHostInterface }
 */
export class AttributionHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AttributionHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AttributionHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AttributionHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !attributionReporting_mojom_DataHostPendingReceiver } dataHost
   * @param { !attributionReporting_mojom_RegistrationEligibility } registrationEligibility
   * @param { !boolean } isForBackgroundRequests
   * @param { !Array<!url_mojom_Origin> } reportingOrigins
   */

  registerDataHost(
      dataHost,
      registrationEligibility,
      isForBackgroundRequests,
      reportingOrigins) {
    this.proxy.sendMessage(
        0,
        AttributionHost_RegisterDataHost_ParamsSpec.$,
        null,
        [
          dataHost,
          registrationEligibility,
          isForBackgroundRequests,
          reportingOrigins
        ],
        false);
  }

  
  /**
   * @param { !attributionReporting_mojom_DataHostPendingReceiver } dataHost
   * @param { !blink_mojom_AttributionSrcToken } attributionSrcToken
   */

  registerNavigationDataHost(
      dataHost,
      attributionSrcToken) {
    this.proxy.sendMessage(
        1,
        AttributionHost_RegisterNavigationDataHost_ParamsSpec.$,
        null,
        [
          dataHost,
          attributionSrcToken
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_AttributionSrcToken } attributionSrcToken
   * @param { !number } expectedRegistrations
   */

  notifyNavigationWithBackgroundRegistrationsWillStart(
      attributionSrcToken,
      expectedRegistrations) {
    this.proxy.sendMessage(
        2,
        AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_ParamsSpec.$,
        null,
        [
          attributionSrcToken,
          expectedRegistrations
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AttributionHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AttributionHostReceiver {
  /**
   * @param {!AttributionHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AttributionHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AttributionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AttributionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AttributionHost_RegisterDataHost_ParamsSpec.$,
        null,
        impl.registerDataHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AttributionHost_RegisterNavigationDataHost_ParamsSpec.$,
        null,
        impl.registerNavigationDataHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_ParamsSpec.$,
        null,
        impl.notifyNavigationWithBackgroundRegistrationsWillStart.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AttributionHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AttributionHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AttributionHostRemote}
   */
  static getRemote() {
    let remote = new AttributionHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AttributionHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AttributionHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AttributionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AttributionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerDataHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AttributionHost_RegisterDataHost_ParamsSpec.$,
        null,
        this.registerDataHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerNavigationDataHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AttributionHost_RegisterNavigationDataHost_ParamsSpec.$,
        null,
        this.registerNavigationDataHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyNavigationWithBackgroundRegistrationsWillStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_ParamsSpec.$,
        null,
        this.notifyNavigationWithBackgroundRegistrationsWillStart.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImpressionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AttributionHost_RegisterDataHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AttributionHost_RegisterNavigationDataHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ImpressionSpec.$,
    'Impression',
    [
      mojo.internal.StructField(
        'attributionSrcToken', 0,
        0,
        blink_mojom_AttributionSrcTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isEmptyAttributionSrcTag', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Impression {
  constructor() {
    /** @type { !blink_mojom_AttributionSrcToken } */
    this.attributionSrcToken;
    /** @type { !boolean } */
    this.isEmptyAttributionSrcTag;
  }
}



mojo.internal.Struct(
    AttributionHost_RegisterDataHost_ParamsSpec.$,
    'AttributionHost_RegisterDataHost_Params',
    [
      mojo.internal.StructField(
        'dataHost', 0,
        0,
        mojo.internal.InterfaceRequest(attributionReporting_mojom_DataHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'registrationEligibility', 4,
        0,
        attributionReporting_mojom_RegistrationEligibilitySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isForBackgroundRequests', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportingOrigins', 16,
        0,
        mojo.internal.Array(url_mojom_OriginSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AttributionHost_RegisterDataHost_Params {
  constructor() {
    /** @type { !attributionReporting_mojom_DataHostPendingReceiver } */
    this.dataHost;
    /** @type { !attributionReporting_mojom_RegistrationEligibility } */
    this.registrationEligibility;
    /** @type { !boolean } */
    this.isForBackgroundRequests;
    /** @type { !Array<!url_mojom_Origin> } */
    this.reportingOrigins;
  }
}



mojo.internal.Struct(
    AttributionHost_RegisterNavigationDataHost_ParamsSpec.$,
    'AttributionHost_RegisterNavigationDataHost_Params',
    [
      mojo.internal.StructField(
        'dataHost', 0,
        0,
        mojo.internal.InterfaceRequest(attributionReporting_mojom_DataHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'attributionSrcToken', 8,
        0,
        blink_mojom_AttributionSrcTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AttributionHost_RegisterNavigationDataHost_Params {
  constructor() {
    /** @type { !attributionReporting_mojom_DataHostPendingReceiver } */
    this.dataHost;
    /** @type { !blink_mojom_AttributionSrcToken } */
    this.attributionSrcToken;
  }
}



mojo.internal.Struct(
    AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_ParamsSpec.$,
    'AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params',
    [
      mojo.internal.StructField(
        'attributionSrcToken', 0,
        0,
        blink_mojom_AttributionSrcTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedRegistrations', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params {
  constructor() {
    /** @type { !blink_mojom_AttributionSrcToken } */
    this.attributionSrcToken;
    /** @type { !number } */
    this.expectedRegistrations;
  }
}

