// third_party/blink/public/mojom/conversions/conversions.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONVERSIONS_CONVERSIONS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONVERSIONS_CONVERSIONS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/conversions/conversions.mojom-shared-internal.h"
#include "components/attribution_reporting/data_host.mojom-shared.h"
#include "components/attribution_reporting/registration_eligibility.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/conversions/conversions.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ImpressionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ImpressionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::Impression_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::attribution_src_token(input)) in_attribution_src_token = Traits::attribution_src_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attribution_src_token)::BaseType> attribution_src_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AttributionSrcTokenDataView>(
      in_attribution_src_token,
      attribution_src_token_fragment);

    fragment->attribution_src_token.Set(
        attribution_src_token_fragment.is_null() ? nullptr : attribution_src_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->attribution_src_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null attribution_src_token in Impression struct");

    fragment->is_empty_attribution_src_tag = Traits::is_empty_attribution_src_tag(input);
  }

  static bool Deserialize(::blink::mojom::internal::Impression_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ImpressionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void ImpressionDataView::GetAttributionSrcTokenDataView(
    ::blink::mojom::AttributionSrcTokenDataView* output) {
  auto pointer = data_->attribution_src_token.Get();
  *output = ::blink::mojom::AttributionSrcTokenDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONVERSIONS_CONVERSIONS_MOJOM_SHARED_H_