// third_party/blink/public/mojom/content_index/content_index.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/content_index/content_index.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/content_index/content_index.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/content_index/content_index.mojom-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/bitmap.mojom.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class ContentIndexServiceProxy;

template <typename ImplRefTraits>
class ContentIndexServiceStub;

class ContentIndexServiceRequestValidator;
class ContentIndexServiceResponseValidator;


class BLINK_COMMON_EXPORT ContentIndexService
    : public ContentIndexServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ContentIndexService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ContentIndexServiceInterfaceBase;
  using Proxy_ = ContentIndexServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = ContentIndexServiceStub<ImplRefTraits>;

  using RequestValidator_ = ContentIndexServiceRequestValidator;
  using ResponseValidator_ = ContentIndexServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetIconSizesMinVersion = 0,
    kAddMinVersion = 0,
    kDeleteMinVersion = 0,
    kGetDescriptionsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetIconSizes_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Add_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Delete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDescriptions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  static constexpr int32_t kMaxIconResolution = 65536;
  virtual ~ContentIndexService() = default;

  using GetIconSizesCallback = base::OnceCallback<void(const std::vector<::gfx::Size>&)>;
  using GetIconSizesMojoCallback = base::OnceCallback<void(const std::vector<::gfx::Size>&)>;

  virtual void GetIconSizes(ContentCategory category, GetIconSizesCallback callback) = 0;

  using AddCallback = base::OnceCallback<void(ContentIndexError)>;
  using AddMojoCallback = base::OnceCallback<void(ContentIndexError)>;

  virtual void Add(int64_t service_worker_registration_id, ContentDescriptionPtr description, const std::vector<::SkBitmap>& icon, const ::GURL& launchUrl, AddCallback callback) = 0;

  using DeleteCallback = base::OnceCallback<void(ContentIndexError)>;
  using DeleteMojoCallback = base::OnceCallback<void(ContentIndexError)>;

  virtual void Delete(int64_t service_worker_registration_id, const std::string& id, DeleteCallback callback) = 0;

  using GetDescriptionsCallback = base::OnceCallback<void(ContentIndexError, std::vector<ContentDescriptionPtr>)>;
  using GetDescriptionsMojoCallback = base::OnceCallback<void(ContentIndexError, std::vector<ContentDescriptionPtr>)>;

  virtual void GetDescriptions(int64_t service_worker_registration_id, GetDescriptionsCallback callback) = 0;
};



class BLINK_COMMON_EXPORT ContentIndexServiceProxy
    : public ContentIndexService {
 public:
  using InterfaceType = ContentIndexService;

  explicit ContentIndexServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetIconSizes(ContentCategory category, GetIconSizesCallback callback) final;
  
  void Add(int64_t service_worker_registration_id, ContentDescriptionPtr description, const std::vector<::SkBitmap>& icon, const ::GURL& launchUrl, AddCallback callback) final;
  
  void Delete(int64_t service_worker_registration_id, const std::string& id, DeleteCallback callback) final;
  
  void GetDescriptions(int64_t service_worker_registration_id, GetDescriptionsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT ContentIndexServiceStubDispatch {
 public:
  static bool Accept(ContentIndexService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ContentIndexService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ContentIndexService>>
class ContentIndexServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ContentIndexServiceStub() = default;
  ~ContentIndexServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentIndexServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentIndexServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ContentIndexServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ContentIndexServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_COMMON_EXPORT ContentIconDefinition {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContentIconDefinition, T>::value>;
  using DataView = ContentIconDefinitionDataView;
  using Data_ = internal::ContentIconDefinition_Data;

  template <typename... Args>
  static ContentIconDefinitionPtr New(Args&&... args) {
    return ContentIconDefinitionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContentIconDefinitionPtr From(const U& u) {
    return mojo::TypeConverter<ContentIconDefinitionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContentIconDefinition>::Convert(*this);
  }


  ContentIconDefinition();

  ContentIconDefinition(
      const std::string& src,
      const std::optional<std::string>& sizes,
      const std::optional<std::string>& type);


  ~ContentIconDefinition();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContentIconDefinitionPtr>
  ContentIconDefinitionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContentIconDefinition::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ContentIconDefinition::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ContentIconDefinition::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentIconDefinition::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentIconDefinition::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContentIconDefinition::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContentIconDefinition_UnserializedMessageContext<
            UserType, ContentIconDefinition::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ContentIconDefinition::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ContentIconDefinition::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContentIconDefinition_UnserializedMessageContext<
            UserType, ContentIconDefinition::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContentIconDefinition::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string src;
  
  std::optional<std::string> sizes;
  
  std::optional<std::string> type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContentIconDefinition::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContentIconDefinition::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContentIconDefinition::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContentIconDefinition::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class BLINK_COMMON_EXPORT ContentDescription {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContentDescription, T>::value>;
  using DataView = ContentDescriptionDataView;
  using Data_ = internal::ContentDescription_Data;

  template <typename... Args>
  static ContentDescriptionPtr New(Args&&... args) {
    return ContentDescriptionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContentDescriptionPtr From(const U& u) {
    return mojo::TypeConverter<ContentDescriptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContentDescription>::Convert(*this);
  }


  ContentDescription();

  ContentDescription(
      const std::string& id,
      const std::string& title,
      const std::string& description,
      ContentCategory category,
      std::vector<ContentIconDefinitionPtr> icons,
      const std::string& launch_url);

ContentDescription(const ContentDescription&) = delete;
ContentDescription& operator=(const ContentDescription&) = delete;

  ~ContentDescription();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContentDescriptionPtr>
  ContentDescriptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContentDescription::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ContentDescription::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ContentDescription::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentDescription::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentDescription::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContentDescription::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContentDescription_UnserializedMessageContext<
            UserType, ContentDescription::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ContentDescription::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ContentDescription::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContentDescription_UnserializedMessageContext<
            UserType, ContentDescription::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContentDescription::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::string title;
  
  std::string description;
  
  ContentCategory category;
  
  std::vector<ContentIconDefinitionPtr> icons;
  
  std::string launch_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContentDescription::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContentDescription::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContentDescription::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContentDescription::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ContentIconDefinitionPtr ContentIconDefinition::Clone() const {
  return New(
      mojo::Clone(src),
      mojo::Clone(sizes),
      mojo::Clone(type)
  );
}

template <typename T, ContentIconDefinition::EnableIfSame<T>*>
bool ContentIconDefinition::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->src, other_struct.src))
    return false;
  if (!mojo::Equals(this->sizes, other_struct.sizes))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  return true;
}

template <typename T, ContentIconDefinition::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.src < rhs.src)
    return true;
  if (rhs.src < lhs.src)
    return false;
  if (lhs.sizes < rhs.sizes)
    return true;
  if (rhs.sizes < lhs.sizes)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  return false;
}
template <typename StructPtrType>
ContentDescriptionPtr ContentDescription::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(title),
      mojo::Clone(description),
      mojo::Clone(category),
      mojo::Clone(icons),
      mojo::Clone(launch_url)
  );
}

template <typename T, ContentDescription::EnableIfSame<T>*>
bool ContentDescription::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->category, other_struct.category))
    return false;
  if (!mojo::Equals(this->icons, other_struct.icons))
    return false;
  if (!mojo::Equals(this->launch_url, other_struct.launch_url))
    return false;
  return true;
}

template <typename T, ContentDescription::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.category < rhs.category)
    return true;
  if (rhs.category < lhs.category)
    return false;
  if (lhs.icons < rhs.icons)
    return true;
  if (rhs.icons < lhs.icons)
    return false;
  if (lhs.launch_url < rhs.launch_url)
    return true;
  if (rhs.launch_url < lhs.launch_url)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ContentIconDefinition::DataView,
                                         ::blink::mojom::ContentIconDefinitionPtr> {
  static bool IsNull(const ::blink::mojom::ContentIconDefinitionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ContentIconDefinitionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ContentIconDefinition::src)& src(
      const ::blink::mojom::ContentIconDefinitionPtr& input) {
    return input->src;
  }

  static const decltype(::blink::mojom::ContentIconDefinition::sizes)& sizes(
      const ::blink::mojom::ContentIconDefinitionPtr& input) {
    return input->sizes;
  }

  static const decltype(::blink::mojom::ContentIconDefinition::type)& type(
      const ::blink::mojom::ContentIconDefinitionPtr& input) {
    return input->type;
  }

  static bool Read(::blink::mojom::ContentIconDefinition::DataView input, ::blink::mojom::ContentIconDefinitionPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ContentDescription::DataView,
                                         ::blink::mojom::ContentDescriptionPtr> {
  static bool IsNull(const ::blink::mojom::ContentDescriptionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ContentDescriptionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ContentDescription::id)& id(
      const ::blink::mojom::ContentDescriptionPtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::ContentDescription::title)& title(
      const ::blink::mojom::ContentDescriptionPtr& input) {
    return input->title;
  }

  static const decltype(::blink::mojom::ContentDescription::description)& description(
      const ::blink::mojom::ContentDescriptionPtr& input) {
    return input->description;
  }

  static decltype(::blink::mojom::ContentDescription::category) category(
      const ::blink::mojom::ContentDescriptionPtr& input) {
    return input->category;
  }

  static const decltype(::blink::mojom::ContentDescription::icons)& icons(
      const ::blink::mojom::ContentDescriptionPtr& input) {
    return input->icons;
  }

  static const decltype(::blink::mojom::ContentDescription::launch_url)& launch_url(
      const ::blink::mojom::ContentDescriptionPtr& input) {
    return input->launch_url;
  }

  static bool Read(::blink::mojom::ContentDescription::DataView input, ::blink::mojom::ContentDescriptionPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_H_