// third_party/blink/public/mojom/content_index/content_index.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/content_index/content_index.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/content_index/content_index.mojom-params-data.h"
#include "third_party/blink/public/mojom/content_index/content_index.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/content_index/content_index.mojom-import-headers.h"
#include "third_party/blink/public/mojom/content_index/content_index.mojom-test-utils.h"


namespace blink::mojom {
ContentIconDefinition::ContentIconDefinition()
    : src(),
      sizes(),
      type() {}

ContentIconDefinition::ContentIconDefinition(
    const std::string& src_in,
    const std::optional<std::string>& sizes_in,
    const std::optional<std::string>& type_in)
    : src(std::move(src_in)),
      sizes(std::move(sizes_in)),
      type(std::move(type_in)) {}

ContentIconDefinition::~ContentIconDefinition() = default;

void ContentIconDefinition::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "src"), this->src,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sizes"), this->sizes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ContentIconDefinition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ContentDescription::ContentDescription()
    : id(),
      title(),
      description(),
      category(),
      icons(),
      launch_url() {}

ContentDescription::ContentDescription(
    const std::string& id_in,
    const std::string& title_in,
    const std::string& description_in,
    ContentCategory category_in,
    std::vector<ContentIconDefinitionPtr> icons_in,
    const std::string& launch_url_in)
    : id(std::move(id_in)),
      title(std::move(title_in)),
      description(std::move(description_in)),
      category(std::move(category_in)),
      icons(std::move(icons_in)),
      launch_url(std::move(launch_url_in)) {}

ContentDescription::~ContentDescription() = default;

void ContentDescription::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "category"), this->category,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ContentCategory>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icons"), this->icons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ContentIconDefinitionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "launch_url"), this->launch_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ContentDescription::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.
constexpr int32_t ContentIndexService::kMaxIconResolution;

ContentIndexService::IPCStableHashFunction ContentIndexService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ContentIndexService>(message.name())) {
    case messages::ContentIndexService::kGetIconSizes: {
      return &ContentIndexService::GetIconSizes_Sym::IPCStableHash;
    }
    case messages::ContentIndexService::kAdd: {
      return &ContentIndexService::Add_Sym::IPCStableHash;
    }
    case messages::ContentIndexService::kDelete: {
      return &ContentIndexService::Delete_Sym::IPCStableHash;
    }
    case messages::ContentIndexService::kGetDescriptions: {
      return &ContentIndexService::GetDescriptions_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ContentIndexService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ContentIndexService>(message.name())) {
      case messages::ContentIndexService::kGetIconSizes:
            return "Receive blink::mojom::ContentIndexService::GetIconSizes";
      case messages::ContentIndexService::kAdd:
            return "Receive blink::mojom::ContentIndexService::Add";
      case messages::ContentIndexService::kDelete:
            return "Receive blink::mojom::ContentIndexService::Delete";
      case messages::ContentIndexService::kGetDescriptions:
            return "Receive blink::mojom::ContentIndexService::GetDescriptions";
    }
  } else {
    switch (static_cast<messages::ContentIndexService>(message.name())) {
      case messages::ContentIndexService::kGetIconSizes:
            return "Receive reply blink::mojom::ContentIndexService::GetIconSizes";
      case messages::ContentIndexService::kAdd:
            return "Receive reply blink::mojom::ContentIndexService::Add";
      case messages::ContentIndexService::kDelete:
            return "Receive reply blink::mojom::ContentIndexService::Delete";
      case messages::ContentIndexService::kGetDescriptions:
            return "Receive reply blink::mojom::ContentIndexService::GetDescriptions";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ContentIndexService::GetIconSizes_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x05050c47;  // IPCStableHash for blink::mojom::ContentIndexService::GetIconSizes
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentIndexService::Add_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8d7f1a31;  // IPCStableHash for blink::mojom::ContentIndexService::Add
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentIndexService::Delete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa5606ca1;  // IPCStableHash for blink::mojom::ContentIndexService::Delete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentIndexService::GetDescriptions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc2f5e2b6;  // IPCStableHash for blink::mojom::ContentIndexService::GetDescriptions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ContentIndexService_GetIconSizes_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentIndexService_GetIconSizes_ForwardToCallback(
      ContentIndexService::GetIconSizesCallback callback
      ) : callback_(std::move(callback)) {
  }

  ContentIndexService_GetIconSizes_ForwardToCallback(const ContentIndexService_GetIconSizes_ForwardToCallback&) = delete;
  ContentIndexService_GetIconSizes_ForwardToCallback& operator=(const ContentIndexService_GetIconSizes_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ContentIndexService::GetIconSizesCallback callback_;
};

class ContentIndexService_Add_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentIndexService_Add_ForwardToCallback(
      ContentIndexService::AddCallback callback
      ) : callback_(std::move(callback)) {
  }

  ContentIndexService_Add_ForwardToCallback(const ContentIndexService_Add_ForwardToCallback&) = delete;
  ContentIndexService_Add_ForwardToCallback& operator=(const ContentIndexService_Add_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ContentIndexService::AddCallback callback_;
};

class ContentIndexService_Delete_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentIndexService_Delete_ForwardToCallback(
      ContentIndexService::DeleteCallback callback
      ) : callback_(std::move(callback)) {
  }

  ContentIndexService_Delete_ForwardToCallback(const ContentIndexService_Delete_ForwardToCallback&) = delete;
  ContentIndexService_Delete_ForwardToCallback& operator=(const ContentIndexService_Delete_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ContentIndexService::DeleteCallback callback_;
};

class ContentIndexService_GetDescriptions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentIndexService_GetDescriptions_ForwardToCallback(
      ContentIndexService::GetDescriptionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ContentIndexService_GetDescriptions_ForwardToCallback(const ContentIndexService_GetDescriptions_ForwardToCallback&) = delete;
  ContentIndexService_GetDescriptions_ForwardToCallback& operator=(const ContentIndexService_GetDescriptions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ContentIndexService::GetDescriptionsCallback callback_;
};

ContentIndexServiceProxy::ContentIndexServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContentIndexServiceProxy::GetIconSizes(
    ContentCategory in_category, GetIconSizesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ContentIndexService::GetIconSizes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("category"), in_category,
                        "<value of type ContentCategory>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentIndexService::kGetIconSizes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ContentIndexService_GetIconSizes_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ContentCategory>(
    in_category,
    &params->category);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("GetIconSizes");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentIndexService_GetIconSizes_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ContentIndexServiceProxy::Add(
    int64_t in_service_worker_registration_id, ContentDescriptionPtr in_description, const std::vector<::SkBitmap>& in_icon, const ::GURL& in_launchUrl, AddCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ContentIndexService::Add", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("description"), in_description,
                        "<value of type ContentDescriptionPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("icon"), in_icon,
                        "<value of type const std::vector<::SkBitmap>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("launchUrl"), in_launchUrl,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentIndexService::kAdd), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ContentIndexService_Add_Params_Data> params(
          message);
  params.Allocate();

  params->service_worker_registration_id = in_service_worker_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->description)::BaseType> description_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ContentDescriptionDataView>(
    in_description,
    description_fragment);

  params->description.Set(
      description_fragment.is_null() ? nullptr : description_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->description.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null description in ContentIndexService.Add request");
  mojo::internal::MessageFragment<
      typename decltype(params->icon)::BaseType>
      icon_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& icon_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::skia::mojom::BitmapN32DataView>>(
    in_icon,
    icon_fragment,
    &icon_validate_params);

  params->icon.Set(
      icon_fragment.is_null() ? nullptr : icon_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->icon.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null icon in ContentIndexService.Add request");
  mojo::internal::MessageFragment<
      typename decltype(params->launchUrl)::BaseType> launchUrl_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_launchUrl,
    launchUrl_fragment);

  params->launchUrl.Set(
      launchUrl_fragment.is_null() ? nullptr : launchUrl_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->launchUrl.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null launchUrl in ContentIndexService.Add request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("Add");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentIndexService_Add_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ContentIndexServiceProxy::Delete(
    int64_t in_service_worker_registration_id, const std::string& in_id, DeleteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ContentIndexService::Delete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentIndexService::kDelete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ContentIndexService_Delete_Params_Data> params(
          message);
  params.Allocate();

  params->service_worker_registration_id = in_service_worker_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in ContentIndexService.Delete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("Delete");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentIndexService_Delete_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ContentIndexServiceProxy::GetDescriptions(
    int64_t in_service_worker_registration_id, GetDescriptionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ContentIndexService::GetDescriptions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentIndexService::kGetDescriptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ContentIndexService_GetDescriptions_Params_Data> params(
          message);
  params.Allocate();

  params->service_worker_registration_id = in_service_worker_registration_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("GetDescriptions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentIndexService_GetDescriptions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ContentIndexService_GetIconSizes_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ContentIndexService::GetIconSizesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ContentIndexService_GetIconSizes_ProxyToResponder> proxy(
        new ContentIndexService_GetIconSizes_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ContentIndexService_GetIconSizes_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentIndexService_GetIconSizes_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ContentIndexService_GetIconSizes_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ContentIndexService::GetIconSizesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::gfx::Size>& in_icon_sizes);
};

bool ContentIndexService_GetIconSizes_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContentIndexService_GetIconSizes_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentIndexService_GetIconSizes_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ContentIndexService.0
  bool success = true;
  std::vector<::gfx::Size> p_icon_sizes{};
  ContentIndexService_GetIconSizes_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadIconSizes(&p_icon_sizes))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentIndexService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_icon_sizes));
  }
  return true;
}

void ContentIndexService_GetIconSizes_ProxyToResponder::Run(
    const std::vector<::gfx::Size>& in_icon_sizes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ContentIndexService::GetIconSizes", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("icon_sizes"), in_icon_sizes,
                        "<value of type const std::vector<::gfx::Size>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentIndexService::kGetIconSizes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ContentIndexService_GetIconSizes_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->icon_sizes)::BaseType>
      icon_sizes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& icon_sizes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
    in_icon_sizes,
    icon_sizes_fragment,
    &icon_sizes_validate_params);

  params->icon_sizes.Set(
      icon_sizes_fragment.is_null() ? nullptr : icon_sizes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->icon_sizes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null icon_sizes in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("GetIconSizes");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentIndexService_Add_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ContentIndexService::AddCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ContentIndexService_Add_ProxyToResponder> proxy(
        new ContentIndexService_Add_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ContentIndexService_Add_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentIndexService_Add_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ContentIndexService_Add_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ContentIndexService::AddCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ContentIndexError in_error);
};

bool ContentIndexService_Add_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContentIndexService_Add_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentIndexService_Add_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ContentIndexService.1
  bool success = true;
  ContentIndexError p_error{};
  ContentIndexService_Add_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentIndexService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void ContentIndexService_Add_ProxyToResponder::Run(
    ContentIndexError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ContentIndexService::Add", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ContentIndexError>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentIndexService::kAdd), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ContentIndexService_Add_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ContentIndexError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("Add");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentIndexService_Delete_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ContentIndexService::DeleteCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ContentIndexService_Delete_ProxyToResponder> proxy(
        new ContentIndexService_Delete_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ContentIndexService_Delete_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentIndexService_Delete_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ContentIndexService_Delete_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ContentIndexService::DeleteCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ContentIndexError in_error);
};

bool ContentIndexService_Delete_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContentIndexService_Delete_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentIndexService_Delete_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ContentIndexService.2
  bool success = true;
  ContentIndexError p_error{};
  ContentIndexService_Delete_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentIndexService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void ContentIndexService_Delete_ProxyToResponder::Run(
    ContentIndexError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ContentIndexService::Delete", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ContentIndexError>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentIndexService::kDelete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ContentIndexService_Delete_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ContentIndexError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("Delete");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentIndexService_GetDescriptions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ContentIndexService::GetDescriptionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ContentIndexService_GetDescriptions_ProxyToResponder> proxy(
        new ContentIndexService_GetDescriptions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ContentIndexService_GetDescriptions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentIndexService_GetDescriptions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ContentIndexService_GetDescriptions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ContentIndexService::GetDescriptionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ContentIndexError in_error, std::vector<ContentDescriptionPtr> in_descriptions);
};

bool ContentIndexService_GetDescriptions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContentIndexService_GetDescriptions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentIndexService_GetDescriptions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ContentIndexService.3
  bool success = true;
  ContentIndexError p_error{};
  std::vector<ContentDescriptionPtr> p_descriptions{};
  ContentIndexService_GetDescriptions_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadDescriptions(&p_descriptions))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentIndexService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_descriptions));
  }
  return true;
}

void ContentIndexService_GetDescriptions_ProxyToResponder::Run(
    ContentIndexError in_error, std::vector<ContentDescriptionPtr> in_descriptions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ContentIndexService::GetDescriptions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ContentIndexError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptions"), in_descriptions,
                        "<value of type std::vector<ContentDescriptionPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentIndexService::kGetDescriptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ContentIndexService_GetDescriptions_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ContentIndexError>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->descriptions)::BaseType>
      descriptions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& descriptions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ContentDescriptionDataView>>(
    in_descriptions,
    descriptions_fragment,
    &descriptions_validate_params);

  params->descriptions.Set(
      descriptions_fragment.is_null() ? nullptr : descriptions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptions in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("GetDescriptions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ContentIndexServiceStubDispatch::Accept(
    ContentIndexService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ContentIndexService>(message->header()->name)) {
    case messages::ContentIndexService::kGetIconSizes: {
      break;
    }
    case messages::ContentIndexService::kAdd: {
      break;
    }
    case messages::ContentIndexService::kDelete: {
      break;
    }
    case messages::ContentIndexService::kGetDescriptions: {
      break;
    }
  }
  return false;
}

// static
bool ContentIndexServiceStubDispatch::AcceptWithResponder(
    ContentIndexService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ContentIndexService>(message->header()->name)) {
    case messages::ContentIndexService::kGetIconSizes: {
      internal::ContentIndexService_GetIconSizes_Params_Data* params =
          reinterpret_cast<
              internal::ContentIndexService_GetIconSizes_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ContentIndexService.0
      bool success = true;
      ContentCategory p_category{};
      ContentIndexService_GetIconSizes_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCategory(&p_category))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentIndexService::Name_, 0, false);
        return false;
      }
      auto callback =
          ContentIndexService_GetIconSizes_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetIconSizes(        
        std::move(p_category), std::move(callback));
      return true;
    }
    case messages::ContentIndexService::kAdd: {
      internal::ContentIndexService_Add_Params_Data* params =
          reinterpret_cast<
              internal::ContentIndexService_Add_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ContentIndexService.1
      bool success = true;
      int64_t p_service_worker_registration_id{};
      ContentDescriptionPtr p_description{};
      std::vector<::SkBitmap> p_icon{};
      ::GURL p_launchUrl{};
      ContentIndexService_Add_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadDescription(&p_description))
        success = false;
      if (success && !input_data_view.ReadIcon(&p_icon))
        success = false;
      if (success && !input_data_view.ReadLaunchUrl(&p_launchUrl))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentIndexService::Name_, 1, false);
        return false;
      }
      auto callback =
          ContentIndexService_Add_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Add(        
        std::move(p_service_worker_registration_id), 
        std::move(p_description), 
        std::move(p_icon), 
        std::move(p_launchUrl), std::move(callback));
      return true;
    }
    case messages::ContentIndexService::kDelete: {
      internal::ContentIndexService_Delete_Params_Data* params =
          reinterpret_cast<
              internal::ContentIndexService_Delete_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ContentIndexService.2
      bool success = true;
      int64_t p_service_worker_registration_id{};
      std::string p_id{};
      ContentIndexService_Delete_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentIndexService::Name_, 2, false);
        return false;
      }
      auto callback =
          ContentIndexService_Delete_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Delete(        
        std::move(p_service_worker_registration_id), 
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::ContentIndexService::kGetDescriptions: {
      internal::ContentIndexService_GetDescriptions_Params_Data* params =
          reinterpret_cast<
              internal::ContentIndexService_GetDescriptions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ContentIndexService.3
      bool success = true;
      int64_t p_service_worker_registration_id{};
      ContentIndexService_GetDescriptions_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentIndexService::Name_, 3, false);
        return false;
      }
      auto callback =
          ContentIndexService_GetDescriptions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDescriptions(        
        std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kContentIndexServiceValidationInfo[] = {
    { &internal::ContentIndexService_GetIconSizes_Params_Data::Validate,
     &internal::ContentIndexService_GetIconSizes_ResponseParams_Data::Validate},
    { &internal::ContentIndexService_Add_Params_Data::Validate,
     &internal::ContentIndexService_Add_ResponseParams_Data::Validate},
    { &internal::ContentIndexService_Delete_Params_Data::Validate,
     &internal::ContentIndexService_Delete_ResponseParams_Data::Validate},
    { &internal::ContentIndexService_GetDescriptions_Params_Data::Validate,
     &internal::ContentIndexService_GetDescriptions_ResponseParams_Data::Validate},
};

bool ContentIndexServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::ContentIndexService::Name_,
    kContentIndexServiceValidationInfo);
}

bool ContentIndexServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::ContentIndexService::Name_,
    kContentIndexServiceValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::ContentIconDefinition::DataView, ::blink::mojom::ContentIconDefinitionPtr>::Read(
    ::blink::mojom::ContentIconDefinition::DataView input,
    ::blink::mojom::ContentIconDefinitionPtr* output) {
  bool success = true;
  ::blink::mojom::ContentIconDefinitionPtr result(::blink::mojom::ContentIconDefinition::New());
  
      if (success && !input.ReadSrc(&result->src))
        success = false;
      if (success && !input.ReadSizes(&result->sizes))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ContentDescription::DataView, ::blink::mojom::ContentDescriptionPtr>::Read(
    ::blink::mojom::ContentDescription::DataView input,
    ::blink::mojom::ContentDescriptionPtr* output) {
  bool success = true;
  ::blink::mojom::ContentDescriptionPtr result(::blink::mojom::ContentDescription::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadCategory(&result->category))
        success = false;
      if (success && !input.ReadIcons(&result->icons))
        success = false;
      if (success && !input.ReadLaunchUrl(&result->launch_url))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void ContentIndexServiceInterceptorForTesting::GetIconSizes(ContentCategory category, GetIconSizesCallback callback) {
  GetForwardingInterface()->GetIconSizes(
    std::move(category)
    , std::move(callback));
}
void ContentIndexServiceInterceptorForTesting::Add(int64_t service_worker_registration_id, ContentDescriptionPtr description, const std::vector<::SkBitmap>& icon, const ::GURL& launchUrl, AddCallback callback) {
  GetForwardingInterface()->Add(
    std::move(service_worker_registration_id)
    , 
    std::move(description)
    , 
    std::move(icon)
    , 
    std::move(launchUrl)
    , std::move(callback));
}
void ContentIndexServiceInterceptorForTesting::Delete(int64_t service_worker_registration_id, const std::string& id, DeleteCallback callback) {
  GetForwardingInterface()->Delete(
    std::move(service_worker_registration_id)
    , 
    std::move(id)
    , std::move(callback));
}
void ContentIndexServiceInterceptorForTesting::GetDescriptions(int64_t service_worker_registration_id, GetDescriptionsCallback callback) {
  GetForwardingInterface()->GetDescriptions(
    std::move(service_worker_registration_id)
    , std::move(callback));
}
ContentIndexServiceAsyncWaiter::ContentIndexServiceAsyncWaiter(
    ContentIndexService* proxy) : proxy_(proxy) {}

ContentIndexServiceAsyncWaiter::~ContentIndexServiceAsyncWaiter() = default;


void ContentIndexServiceAsyncWaiter::GetIconSizes(
    ContentCategory category, std::vector<::gfx::Size>* out_icon_sizes) {
  base::RunLoop loop;
  proxy_->GetIconSizes(
      std::move(category),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::gfx::Size>* out_icon_sizes
,
             const std::vector<::gfx::Size>& icon_sizes) {*out_icon_sizes = std::move(icon_sizes);
            loop->Quit();
          },
          &loop,
          out_icon_sizes));
  loop.Run();
}

std::vector<::gfx::Size> ContentIndexServiceAsyncWaiter::GetIconSizes(
    ContentCategory category) {
  std::vector<::gfx::Size> async_wait_result;
  GetIconSizes(std::move(category),&async_wait_result);
  return async_wait_result;
}

void ContentIndexServiceAsyncWaiter::Add(
    int64_t service_worker_registration_id, ContentDescriptionPtr description, const std::vector<::SkBitmap>& icon, const ::GURL& launchUrl, ContentIndexError* out_error) {
  base::RunLoop loop;
  proxy_->Add(
      std::move(service_worker_registration_id),
      std::move(description),
      std::move(icon),
      std::move(launchUrl),
      base::BindOnce(
          [](base::RunLoop* loop,
             ContentIndexError* out_error
,
             ContentIndexError error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

ContentIndexError ContentIndexServiceAsyncWaiter::Add(
    int64_t service_worker_registration_id, ContentDescriptionPtr description, const std::vector<::SkBitmap>& icon, const ::GURL& launchUrl) {
  ContentIndexError async_wait_result;
  Add(std::move(service_worker_registration_id),std::move(description),std::move(icon),std::move(launchUrl),&async_wait_result);
  return async_wait_result;
}

void ContentIndexServiceAsyncWaiter::Delete(
    int64_t service_worker_registration_id, const std::string& id, ContentIndexError* out_error) {
  base::RunLoop loop;
  proxy_->Delete(
      std::move(service_worker_registration_id),
      std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ContentIndexError* out_error
,
             ContentIndexError error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

ContentIndexError ContentIndexServiceAsyncWaiter::Delete(
    int64_t service_worker_registration_id, const std::string& id) {
  ContentIndexError async_wait_result;
  Delete(std::move(service_worker_registration_id),std::move(id),&async_wait_result);
  return async_wait_result;
}

void ContentIndexServiceAsyncWaiter::GetDescriptions(
    int64_t service_worker_registration_id, ContentIndexError* out_error, std::vector<ContentDescriptionPtr>* out_descriptions) {
  base::RunLoop loop;
  proxy_->GetDescriptions(
      std::move(service_worker_registration_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ContentIndexError* out_error
,
             std::vector<ContentDescriptionPtr>* out_descriptions
,
             ContentIndexError error,
             std::vector<ContentDescriptionPtr> descriptions) {*out_error = std::move(error);*out_descriptions = std::move(descriptions);
            loop->Quit();
          },
          &loop,
          out_error,
          out_descriptions));
  loop.Run();
}








}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif