// third_party/blink/public/mojom/content_extraction/script_tools.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/content_extraction/script_tools.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function ScriptToolAnnotations(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ScriptToolAnnotations.prototype.initDefaults_ = function() {
    this.readOnly = false;
  };
  ScriptToolAnnotations.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ScriptToolAnnotations.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ScriptToolAnnotations.encodedSize = codec.kStructHeaderSize + 8;

  ScriptToolAnnotations.decode = function(decoder) {
    var packed;
    var val = new ScriptToolAnnotations();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.readOnly = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ScriptToolAnnotations.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ScriptToolAnnotations.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.readOnly & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ScriptTool(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ScriptTool.prototype.initDefaults_ = function() {
    this.name = null;
    this.description = null;
    this.inputSchema = null;
    this.annotations = null;
  };
  ScriptTool.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ScriptTool.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ScriptTool.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ScriptTool.description
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ScriptTool.inputSchema
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ScriptTool.annotations
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, ScriptToolAnnotations, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ScriptTool.encodedSize = codec.kStructHeaderSize + 32;

  ScriptTool.decode = function(decoder) {
    var packed;
    var val = new ScriptTool();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.description =
        decoder.decodeStruct(codec.String);
    val.inputSchema =
        decoder.decodeStruct(codec.String);
    val.annotations =
        decoder.decodeStructPointer(ScriptToolAnnotations);
    return val;
  };

  ScriptTool.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ScriptTool.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.description);
    encoder.encodeStruct(codec.String, val.inputSchema);
    encoder.encodeStructPointer(ScriptToolAnnotations, val.annotations);
  };
  exports.ScriptToolAnnotations = ScriptToolAnnotations;
  exports.ScriptTool = ScriptTool;
})();