// third_party/blink/public/mojom/content_extraction/inner_text.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_INNER_TEXT_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_INNER_TEXT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/content_extraction/inner_text.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/content_extraction/inner_text.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::NodeLocationType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::NodeLocationType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NodeLocationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::NodeLocationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::NodeLocationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InnerTextFrameDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::InnerTextFrameDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::InnerTextFrame_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::token(input)) in_token = Traits::token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->token)::BaseType> token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
      in_token,
      token_fragment);

    fragment->token.Set(
        token_fragment.is_null() ? nullptr : token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in InnerTextFrame struct");

    decltype(Traits::segments(input)) in_segments = Traits::segments(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->segments)::BaseType>
        segments_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& segments_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::InnerTextSegmentDataView>>(
      in_segments,
      segments_fragment,
      &segments_validate_params);

    fragment->segments.Set(
        segments_fragment.is_null() ? nullptr : segments_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->segments.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null segments in InnerTextFrame struct");
  }

  static bool Deserialize(::blink::mojom::internal::InnerTextFrame_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::InnerTextFrameDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InnerTextParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::InnerTextParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::InnerTextParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->node_id_$flag = Traits::node_id(input).has_value();
    if (Traits::node_id(input).has_value()) {
      fragment->node_id_$value = Traits::node_id(input).value();
    }
    fragment->max_words_per_aggregate_passage_$flag = Traits::max_words_per_aggregate_passage(input).has_value();
    if (Traits::max_words_per_aggregate_passage(input).has_value()) {
      fragment->max_words_per_aggregate_passage_$value = Traits::max_words_per_aggregate_passage(input).value();
    }
    fragment->greedily_aggregate_sibling_nodes_$flag = Traits::greedily_aggregate_sibling_nodes(input).has_value();
    if (Traits::greedily_aggregate_sibling_nodes(input).has_value()) {
      fragment->greedily_aggregate_sibling_nodes_$value = Traits::greedily_aggregate_sibling_nodes(input).value();
    }

    fragment->max_passages = Traits::max_passages(input);
    fragment->min_words_per_passage_$flag = Traits::min_words_per_passage(input).has_value();
    if (Traits::min_words_per_passage(input).has_value()) {
      fragment->min_words_per_passage_$value = Traits::min_words_per_passage(input).value();
    }
  }

  static bool Deserialize(::blink::mojom::internal::InnerTextParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::InnerTextParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InnerTextSegmentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::InnerTextSegmentDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::InnerTextSegment_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::InnerTextSegmentDataView::Tag::kNodeLocation: {
    decltype(Traits::node_location(input))
    in_node_location = Traits::node_location(input);
        
mojo::internal::Serialize<::blink::mojom::NodeLocationType>(
  in_node_location,
  &fragment->data.f_node_location);
    break;
  }
  case ::blink::mojom::InnerTextSegmentDataView::Tag::kText: {
    decltype(Traits::text(input))
    in_text = Traits::text(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_text)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_text,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null text in InnerTextSegment union");
    fragment->data.f_text.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::InnerTextSegmentDataView::Tag::kFrame: {
    decltype(Traits::frame(input))
    in_frame = Traits::frame(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_frame)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::InnerTextFrameDataView>(
  in_frame,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null frame in InnerTextSegment union");
    fragment->data.f_frame.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::InnerTextSegment_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::InnerTextSegmentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void InnerTextFrameDataView::GetTokenDataView(
    ::blink::mojom::LocalFrameTokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = ::blink::mojom::LocalFrameTokenDataView(pointer, message_);
}
inline void InnerTextFrameDataView::GetSegmentsDataView(
    mojo::ArrayDataView<InnerTextSegmentDataView>* output) {
  auto pointer = data_->segments.Get();
  *output = mojo::ArrayDataView<InnerTextSegmentDataView>(pointer, message_);
}




inline void InnerTextSegmentDataView::GetTextDataView(
    mojo::StringDataView* output) const {
  CHECK(is_text());
  *output = mojo::StringDataView(data_->data.f_text.Get(), message_);
}
inline void InnerTextSegmentDataView::GetFrameDataView(
    InnerTextFrameDataView* output) const {
  CHECK(is_frame());
  *output = InnerTextFrameDataView(data_->data.f_frame.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::NodeLocationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::NodeLocationType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_INNER_TEXT_MOJOM_SHARED_H_