// third_party/blink/public/mojom/content_extraction/inner_text.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_INNER_TEXT_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_INNER_TEXT_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/content_extraction/inner_text.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"

#include "third_party/blink/public/mojom/content_extraction/inner_text.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::NodeLocationType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::InnerTextFrameDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::InnerTextFrameDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::InnerTextFrame_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::token(input)) in_token = Traits::token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->token)::BaseType> token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView, send_validation>(
        in_token,
        token_fragment);

      fragment->token.Set(
          token_fragment.is_null() ? nullptr : token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null token in InnerTextFrame struct");

      decltype(Traits::segments(input)) in_segments = Traits::segments(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->segments)::BaseType>
          segments_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& segments_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::InnerTextSegmentDataView>, send_validation>(
        in_segments,
        segments_fragment,
        &segments_validate_params);

      fragment->segments.Set(
          segments_fragment.is_null() ? nullptr : segments_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->segments.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null segments in InnerTextFrame struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::InnerTextParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::InnerTextParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::InnerTextParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
      fragment->node_id_$flag = Traits::node_id(input).has_value();
      if (Traits::node_id(input).has_value()) {
        fragment->node_id_$value = Traits::node_id(input).value();
      }
      fragment->max_words_per_aggregate_passage_$flag = Traits::max_words_per_aggregate_passage(input).has_value();
      if (Traits::max_words_per_aggregate_passage(input).has_value()) {
        fragment->max_words_per_aggregate_passage_$value = Traits::max_words_per_aggregate_passage(input).value();
      }
      fragment->greedily_aggregate_sibling_nodes_$flag = Traits::greedily_aggregate_sibling_nodes(input).has_value();
      if (Traits::greedily_aggregate_sibling_nodes(input).has_value()) {
        fragment->greedily_aggregate_sibling_nodes_$value = Traits::greedily_aggregate_sibling_nodes(input).value();
      }

      fragment->max_passages = Traits::max_passages(input);
      fragment->min_words_per_passage_$flag = Traits::min_words_per_passage(input).has_value();
      if (Traits::min_words_per_passage(input).has_value()) {
        fragment->min_words_per_passage_$value = Traits::min_words_per_passage(input).value();
      }
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::InnerTextSegmentDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::InnerTextSegmentDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::InnerTextSegment_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::InnerTextSegmentDataView::Tag::kNodeLocation: {
    decltype(Traits::node_location(input))
    in_node_location = Traits::node_location(input);
        
mojo::internal::Serialize<::blink::mojom::NodeLocationType, send_validation>(
  in_node_location,
  &fragment->data.f_node_location);
    break;
  }
  case ::blink::mojom::InnerTextSegmentDataView::Tag::kText: {
    decltype(Traits::text(input))
    in_text = Traits::text(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_text)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_text,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null text in InnerTextSegment union");
    fragment->data.f_text.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::InnerTextSegmentDataView::Tag::kFrame: {
    decltype(Traits::frame(input))
    in_frame = Traits::frame(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_frame)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::InnerTextFrameDataView, send_validation>(
  in_frame,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null frame in InnerTextSegment union");
    fragment->data.f_frame.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_INNER_TEXT_MOJOM_SEND_VALIDATION_H_