// third_party/blink/public/mojom/content_extraction/inner_html.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class InnerHtmlAgentPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.InnerHtmlAgent', scope);
  }
}

/** @interface */
export class InnerHtmlAgentInterface {
  
  /**
   * @return {!Promise<{
        innerHtml: !string,
   *  }>}
   */

  getInnerHtml() {}
}

/**
 * @implements { InnerHtmlAgentInterface }
 */
export class InnerHtmlAgentRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!InnerHtmlAgentPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          InnerHtmlAgentPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!InnerHtmlAgentPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        innerHtml: !string,
   *  }>}
   */

  getInnerHtml() {
    return this.proxy.sendMessage(
        0,
        InnerHtmlAgent_GetInnerHtml_ParamsSpec.$,
        InnerHtmlAgent_GetInnerHtml_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the InnerHtmlAgent
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class InnerHtmlAgentReceiver {
  /**
   * @param {!InnerHtmlAgentInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!InnerHtmlAgentRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        InnerHtmlAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InnerHtmlAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        InnerHtmlAgent_GetInnerHtml_ParamsSpec.$,
        InnerHtmlAgent_GetInnerHtml_ResponseParamsSpec.$,
        impl.getInnerHtml.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class InnerHtmlAgent {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.InnerHtmlAgent";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!InnerHtmlAgentRemote}
   */
  static getRemote() {
    let remote = new InnerHtmlAgentRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the InnerHtmlAgent
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class InnerHtmlAgentCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      InnerHtmlAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InnerHtmlAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInnerHtml =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        InnerHtmlAgent_GetInnerHtml_ParamsSpec.$,
        InnerHtmlAgent_GetInnerHtml_ResponseParamsSpec.$,
        this.getInnerHtml.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InnerHtmlAgent_GetInnerHtml_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InnerHtmlAgent_GetInnerHtml_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    InnerHtmlAgent_GetInnerHtml_ParamsSpec.$,
    'InnerHtmlAgent_GetInnerHtml_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class InnerHtmlAgent_GetInnerHtml_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    InnerHtmlAgent_GetInnerHtml_ResponseParamsSpec.$,
    'InnerHtmlAgent_GetInnerHtml_ResponseParams',
    [
      mojo.internal.StructField(
        'innerHtml', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InnerHtmlAgent_GetInnerHtml_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.innerHtml;
  }
}

