// third_party/blink/public/mojom/content_extraction/frame_metadata_observer_registry.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  MetaTag as blink_mojom_MetaTag,
  MetaTagSpec as blink_mojom_MetaTagSpec
} from './ai_page_content_metadata.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PaidContentMetadataObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PaidContentMetadataObserver', scope);
  }
}

/** @interface */
export class PaidContentMetadataObserverInterface {
  
  /**
   * @param { !boolean } hasPaidContent
   */

  onPaidContentMetadataChanged(hasPaidContent) {}
}

/**
 * @implements { PaidContentMetadataObserverInterface }
 */
export class PaidContentMetadataObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PaidContentMetadataObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PaidContentMetadataObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PaidContentMetadataObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } hasPaidContent
   */

  onPaidContentMetadataChanged(
      hasPaidContent) {
    this.proxy.sendMessage(
        0,
        PaidContentMetadataObserver_OnPaidContentMetadataChanged_ParamsSpec.$,
        null,
        [
          hasPaidContent
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PaidContentMetadataObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PaidContentMetadataObserverReceiver {
  /**
   * @param {!PaidContentMetadataObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PaidContentMetadataObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PaidContentMetadataObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PaidContentMetadataObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PaidContentMetadataObserver_OnPaidContentMetadataChanged_ParamsSpec.$,
        null,
        impl.onPaidContentMetadataChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PaidContentMetadataObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PaidContentMetadataObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PaidContentMetadataObserverRemote}
   */
  static getRemote() {
    let remote = new PaidContentMetadataObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PaidContentMetadataObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PaidContentMetadataObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PaidContentMetadataObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PaidContentMetadataObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPaidContentMetadataChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PaidContentMetadataObserver_OnPaidContentMetadataChanged_ParamsSpec.$,
        null,
        this.onPaidContentMetadataChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MetaTagsObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.MetaTagsObserver', scope);
  }
}

/** @interface */
export class MetaTagsObserverInterface {
  
  /**
   * @param { !Array<!blink_mojom_MetaTag> } metaTags
   */

  onMetaTagsChanged(metaTags) {}
}

/**
 * @implements { MetaTagsObserverInterface }
 */
export class MetaTagsObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MetaTagsObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MetaTagsObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MetaTagsObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!blink_mojom_MetaTag> } metaTags
   */

  onMetaTagsChanged(
      metaTags) {
    this.proxy.sendMessage(
        0,
        MetaTagsObserver_OnMetaTagsChanged_ParamsSpec.$,
        null,
        [
          metaTags
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MetaTagsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MetaTagsObserverReceiver {
  /**
   * @param {!MetaTagsObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MetaTagsObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MetaTagsObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MetaTagsObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MetaTagsObserver_OnMetaTagsChanged_ParamsSpec.$,
        null,
        impl.onMetaTagsChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MetaTagsObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MetaTagsObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MetaTagsObserverRemote}
   */
  static getRemote() {
    let remote = new MetaTagsObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MetaTagsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MetaTagsObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MetaTagsObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MetaTagsObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMetaTagsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MetaTagsObserver_OnMetaTagsChanged_ParamsSpec.$,
        null,
        this.onMetaTagsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FrameMetadataObserverRegistryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FrameMetadataObserverRegistry', scope);
  }
}

/** @interface */
export class FrameMetadataObserverRegistryInterface {
  
  /**
   * @param { !PaidContentMetadataObserverRemote } observer
   */

  addPaidContentMetadataObserver(observer) {}
  
  /**
   * @param { !Array<!string> } names
   * @param { !MetaTagsObserverRemote } observer
   */

  addMetaTagsObserver(names, observer) {}
}

/**
 * @implements { FrameMetadataObserverRegistryInterface }
 */
export class FrameMetadataObserverRegistryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FrameMetadataObserverRegistryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FrameMetadataObserverRegistryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FrameMetadataObserverRegistryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !PaidContentMetadataObserverRemote } observer
   */

  addPaidContentMetadataObserver(
      observer) {
    this.proxy.sendMessage(
        0,
        FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } names
   * @param { !MetaTagsObserverRemote } observer
   */

  addMetaTagsObserver(
      names,
      observer) {
    this.proxy.sendMessage(
        1,
        FrameMetadataObserverRegistry_AddMetaTagsObserver_ParamsSpec.$,
        null,
        [
          names,
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FrameMetadataObserverRegistry
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FrameMetadataObserverRegistryReceiver {
  /**
   * @param {!FrameMetadataObserverRegistryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FrameMetadataObserverRegistryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FrameMetadataObserverRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FrameMetadataObserverRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_ParamsSpec.$,
        null,
        impl.addPaidContentMetadataObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FrameMetadataObserverRegistry_AddMetaTagsObserver_ParamsSpec.$,
        null,
        impl.addMetaTagsObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FrameMetadataObserverRegistry {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FrameMetadataObserverRegistry";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FrameMetadataObserverRegistryRemote}
   */
  static getRemote() {
    let remote = new FrameMetadataObserverRegistryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FrameMetadataObserverRegistry
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FrameMetadataObserverRegistryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FrameMetadataObserverRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FrameMetadataObserverRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addPaidContentMetadataObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_ParamsSpec.$,
        null,
        this.addPaidContentMetadataObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addMetaTagsObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FrameMetadataObserverRegistry_AddMetaTagsObserver_ParamsSpec.$,
        null,
        this.addMetaTagsObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaidContentMetadataObserver_OnPaidContentMetadataChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MetaTagsObserver_OnMetaTagsChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameMetadataObserverRegistry_AddMetaTagsObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PaidContentMetadataObserver_OnPaidContentMetadataChanged_ParamsSpec.$,
    'PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params',
    [
      mojo.internal.StructField(
        'hasPaidContent', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.hasPaidContent;
  }
}



mojo.internal.Struct(
    MetaTagsObserver_OnMetaTagsChanged_ParamsSpec.$,
    'MetaTagsObserver_OnMetaTagsChanged_Params',
    [
      mojo.internal.StructField(
        'metaTags', 0,
        0,
        mojo.internal.Array(blink_mojom_MetaTagSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MetaTagsObserver_OnMetaTagsChanged_Params {
  constructor() {
    /** @type { !Array<!blink_mojom_MetaTag> } */
    this.metaTags;
  }
}



mojo.internal.Struct(
    FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_ParamsSpec.$,
    'FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(PaidContentMetadataObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params {
  constructor() {
    /** @type { !PaidContentMetadataObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    FrameMetadataObserverRegistry_AddMetaTagsObserver_ParamsSpec.$,
    'FrameMetadataObserverRegistry_AddMetaTagsObserver_Params',
    [
      mojo.internal.StructField(
        'names', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 8,
        0,
        mojo.internal.InterfaceProxy(MetaTagsObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FrameMetadataObserverRegistry_AddMetaTagsObserver_Params {
  constructor() {
    /** @type { !Array<!string> } */
    this.names;
    /** @type { !MetaTagsObserverRemote } */
    this.observer;
  }
}

