// third_party/blink/public/mojom/content_extraction/frame_metadata_observer_registry.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.MetaTag');






goog.provide('blink.mojom.PaidContentMetadataObserver');
goog.provide('blink.mojom.PaidContentMetadataObserverReceiver');
goog.provide('blink.mojom.PaidContentMetadataObserverCallbackRouter');
goog.provide('blink.mojom.PaidContentMetadataObserverInterface');
goog.provide('blink.mojom.PaidContentMetadataObserverRemote');
goog.provide('blink.mojom.PaidContentMetadataObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PaidContentMetadataObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PaidContentMetadataObserver.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.PaidContentMetadataObserverInterface = class {
  
  /**
   * @param { !boolean } hasPaidContent
   */

  onPaidContentMetadataChanged(hasPaidContent) {}
};

/**
 * @export
 * @implements { blink.mojom.PaidContentMetadataObserverInterface }
 */
blink.mojom.PaidContentMetadataObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PaidContentMetadataObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PaidContentMetadataObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PaidContentMetadataObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } hasPaidContent
   */

  onPaidContentMetadataChanged(
      hasPaidContent) {
    this.proxy.sendMessage(
        0,
        blink.mojom.PaidContentMetadataObserver_OnPaidContentMetadataChanged_ParamsSpec.$,
        null,
        [
          hasPaidContent
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PaidContentMetadataObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PaidContentMetadataObserverReceiver = class {
  /**
   * @param {!blink.mojom.PaidContentMetadataObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PaidContentMetadataObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PaidContentMetadataObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PaidContentMetadataObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PaidContentMetadataObserver_OnPaidContentMetadataChanged_ParamsSpec.$,
        null,
        impl.onPaidContentMetadataChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PaidContentMetadataObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PaidContentMetadataObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PaidContentMetadataObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PaidContentMetadataObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PaidContentMetadataObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PaidContentMetadataObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PaidContentMetadataObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PaidContentMetadataObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPaidContentMetadataChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PaidContentMetadataObserver_OnPaidContentMetadataChanged_ParamsSpec.$,
        null,
        this.onPaidContentMetadataChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.MetaTagsObserver');
goog.provide('blink.mojom.MetaTagsObserverReceiver');
goog.provide('blink.mojom.MetaTagsObserverCallbackRouter');
goog.provide('blink.mojom.MetaTagsObserverInterface');
goog.provide('blink.mojom.MetaTagsObserverRemote');
goog.provide('blink.mojom.MetaTagsObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.MetaTagsObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.MetaTagsObserver.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.MetaTagsObserverInterface = class {
  
  /**
   * @param { !Array<!blink.mojom.MetaTag> } metaTags
   */

  onMetaTagsChanged(metaTags) {}
};

/**
 * @export
 * @implements { blink.mojom.MetaTagsObserverInterface }
 */
blink.mojom.MetaTagsObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.MetaTagsObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.MetaTagsObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.MetaTagsObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!blink.mojom.MetaTag> } metaTags
   */

  onMetaTagsChanged(
      metaTags) {
    this.proxy.sendMessage(
        0,
        blink.mojom.MetaTagsObserver_OnMetaTagsChanged_ParamsSpec.$,
        null,
        [
          metaTags
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MetaTagsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.MetaTagsObserverReceiver = class {
  /**
   * @param {!blink.mojom.MetaTagsObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.MetaTagsObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.MetaTagsObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MetaTagsObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MetaTagsObserver_OnMetaTagsChanged_ParamsSpec.$,
        null,
        impl.onMetaTagsChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.MetaTagsObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MetaTagsObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.MetaTagsObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.MetaTagsObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MetaTagsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.MetaTagsObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.MetaTagsObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MetaTagsObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMetaTagsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MetaTagsObserver_OnMetaTagsChanged_ParamsSpec.$,
        null,
        this.onMetaTagsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.FrameMetadataObserverRegistry');
goog.provide('blink.mojom.FrameMetadataObserverRegistryReceiver');
goog.provide('blink.mojom.FrameMetadataObserverRegistryCallbackRouter');
goog.provide('blink.mojom.FrameMetadataObserverRegistryInterface');
goog.provide('blink.mojom.FrameMetadataObserverRegistryRemote');
goog.provide('blink.mojom.FrameMetadataObserverRegistryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FrameMetadataObserverRegistryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FrameMetadataObserverRegistry.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.FrameMetadataObserverRegistryInterface = class {
  
  /**
   * @param { !blink.mojom.PaidContentMetadataObserverRemote } observer
   */

  addPaidContentMetadataObserver(observer) {}
  
  /**
   * @param { !Array<!string> } names
   * @param { !blink.mojom.MetaTagsObserverRemote } observer
   */

  addMetaTagsObserver(names, observer) {}
};

/**
 * @export
 * @implements { blink.mojom.FrameMetadataObserverRegistryInterface }
 */
blink.mojom.FrameMetadataObserverRegistryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FrameMetadataObserverRegistryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FrameMetadataObserverRegistryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FrameMetadataObserverRegistryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.PaidContentMetadataObserverRemote } observer
   */

  addPaidContentMetadataObserver(
      observer) {
    this.proxy.sendMessage(
        0,
        blink.mojom.FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } names
   * @param { !blink.mojom.MetaTagsObserverRemote } observer
   */

  addMetaTagsObserver(
      names,
      observer) {
    this.proxy.sendMessage(
        1,
        blink.mojom.FrameMetadataObserverRegistry_AddMetaTagsObserver_ParamsSpec.$,
        null,
        [
          names,
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FrameMetadataObserverRegistry
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FrameMetadataObserverRegistryReceiver = class {
  /**
   * @param {!blink.mojom.FrameMetadataObserverRegistryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FrameMetadataObserverRegistryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FrameMetadataObserverRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FrameMetadataObserverRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_ParamsSpec.$,
        null,
        impl.addPaidContentMetadataObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FrameMetadataObserverRegistry_AddMetaTagsObserver_ParamsSpec.$,
        null,
        impl.addMetaTagsObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FrameMetadataObserverRegistry = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FrameMetadataObserverRegistry";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FrameMetadataObserverRegistryRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FrameMetadataObserverRegistryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FrameMetadataObserverRegistry
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FrameMetadataObserverRegistryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FrameMetadataObserverRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FrameMetadataObserverRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addPaidContentMetadataObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_ParamsSpec.$,
        null,
        this.addPaidContentMetadataObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addMetaTagsObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FrameMetadataObserverRegistry_AddMetaTagsObserver_ParamsSpec.$,
        null,
        this.addMetaTagsObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.PaidContentMetadataObserver_OnPaidContentMetadataChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PaidContentMetadataObserver_OnPaidContentMetadataChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MetaTagsObserver_OnMetaTagsChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MetaTagsObserver_OnMetaTagsChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameMetadataObserverRegistry_AddMetaTagsObserver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameMetadataObserverRegistry_AddMetaTagsObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.PaidContentMetadataObserver_OnPaidContentMetadataChanged_ParamsSpec.$,
    'PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params',
    [
      mojo.internal.StructField(
        'hasPaidContent', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params');

/** @record */
blink.mojom.PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.hasPaidContent;
  }
};



mojo.internal.Struct(
    blink.mojom.MetaTagsObserver_OnMetaTagsChanged_ParamsSpec.$,
    'MetaTagsObserver_OnMetaTagsChanged_Params',
    [
      mojo.internal.StructField(
        'metaTags', 0,
        0,
        mojo.internal.Array(blink.mojom.MetaTagSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.MetaTagsObserver_OnMetaTagsChanged_Params');

/** @record */
blink.mojom.MetaTagsObserver_OnMetaTagsChanged_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.MetaTag> } */
    this.metaTags;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_ParamsSpec.$,
    'FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.PaidContentMetadataObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params');

/** @record */
blink.mojom.FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params = class {
  constructor() {
    /** @export { !blink.mojom.PaidContentMetadataObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameMetadataObserverRegistry_AddMetaTagsObserver_ParamsSpec.$,
    'FrameMetadataObserverRegistry_AddMetaTagsObserver_Params',
    [
      mojo.internal.StructField(
        'names', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.MetaTagsObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FrameMetadataObserverRegistry_AddMetaTagsObserver_Params');

/** @record */
blink.mojom.FrameMetadataObserverRegistry_AddMetaTagsObserver_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.names;
    /** @export { !blink.mojom.MetaTagsObserverRemote } */
    this.observer;
  }
};

