// third_party/blink/public/mojom/content_extraction/ai_page_content_metadata.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_AI_PAGE_CONTENT_METADATA_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_AI_PAGE_CONTENT_METADATA_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/content_extraction/ai_page_content_metadata.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/content_extraction/ai_page_content_metadata.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/content_extraction/ai_page_content_metadata.mojom-blink-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {





class PLATFORM_EXPORT MetaTag {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MetaTag, T>::value>;
  using DataView = MetaTagDataView;
  using Data_ = internal::MetaTag_Data;

  template <typename... Args>
  static MetaTagPtr New(Args&&... args) {
    return MetaTagPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MetaTagPtr From(const U& u) {
    return mojo::TypeConverter<MetaTagPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MetaTag>::Convert(*this);
  }


  MetaTag();

  MetaTag(
      const ::blink::String& name,
      const ::blink::String& content);


  ~MetaTag();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MetaTagPtr>
  MetaTagPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MetaTag::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MetaTag::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MetaTag::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MetaTag::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MetaTag::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MetaTag::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MetaTag_UnserializedMessageContext<
            UserType, MetaTag::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MetaTag::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MetaTag::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MetaTag_UnserializedMessageContext<
            UserType, MetaTag::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MetaTag::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String name;
  
  ::blink::String content;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MetaTag::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MetaTag::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MetaTag::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MetaTag::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class PLATFORM_EXPORT FrameMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameMetadata, T>::value>;
  using DataView = FrameMetadataDataView;
  using Data_ = internal::FrameMetadata_Data;

  template <typename... Args>
  static FrameMetadataPtr New(Args&&... args) {
    return FrameMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameMetadataPtr From(const U& u) {
    return mojo::TypeConverter<FrameMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameMetadata>::Convert(*this);
  }


  FrameMetadata();

  FrameMetadata(
      const ::blink::KURL& url,
      ::blink::Vector<MetaTagPtr> meta_tags);

FrameMetadata(const FrameMetadata&) = delete;
FrameMetadata& operator=(const FrameMetadata&) = delete;

  ~FrameMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameMetadataPtr>
  FrameMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameMetadata::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameMetadata::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameMetadata_UnserializedMessageContext<
            UserType, FrameMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameMetadata_UnserializedMessageContext<
            UserType, FrameMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  ::blink::Vector<MetaTagPtr> meta_tags;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT PageMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageMetadata, T>::value>;
  using DataView = PageMetadataDataView;
  using Data_ = internal::PageMetadata_Data;

  template <typename... Args>
  static PageMetadataPtr New(Args&&... args) {
    return PageMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageMetadataPtr From(const U& u) {
    return mojo::TypeConverter<PageMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageMetadata>::Convert(*this);
  }


  PageMetadata();

  explicit PageMetadata(
      ::blink::Vector<FrameMetadataPtr> frame_metadata);

PageMetadata(const PageMetadata&) = delete;
PageMetadata& operator=(const PageMetadata&) = delete;

  ~PageMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageMetadataPtr>
  PageMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PageMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PageMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageMetadata::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageMetadata::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageMetadata_UnserializedMessageContext<
            UserType, PageMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PageMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PageMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageMetadata_UnserializedMessageContext<
            UserType, PageMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<FrameMetadataPtr> frame_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
MetaTagPtr MetaTag::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(content)
  );
}

template <typename T, MetaTag::EnableIfSame<T>*>
bool MetaTag::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->content, other_struct.content))
    return false;
  return true;
}

template <typename T, MetaTag::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.content < rhs.content)
    return true;
  if (rhs.content < lhs.content)
    return false;
  return false;
}
template <typename StructPtrType>
FrameMetadataPtr FrameMetadata::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(meta_tags)
  );
}

template <typename T, FrameMetadata::EnableIfSame<T>*>
bool FrameMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->meta_tags, other_struct.meta_tags))
    return false;
  return true;
}

template <typename T, FrameMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.meta_tags < rhs.meta_tags)
    return true;
  if (rhs.meta_tags < lhs.meta_tags)
    return false;
  return false;
}
template <typename StructPtrType>
PageMetadataPtr PageMetadata::Clone() const {
  return New(
      mojo::Clone(frame_metadata)
  );
}

template <typename T, PageMetadata::EnableIfSame<T>*>
bool PageMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_metadata, other_struct.frame_metadata))
    return false;
  return true;
}

template <typename T, PageMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_metadata < rhs.frame_metadata)
    return true;
  if (rhs.frame_metadata < lhs.frame_metadata)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::MetaTag::DataView,
                                         ::blink::mojom::blink::MetaTagPtr> {
  static bool IsNull(const ::blink::mojom::blink::MetaTagPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::MetaTagPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::MetaTag::name)& name(
      const ::blink::mojom::blink::MetaTagPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::MetaTag::content)& content(
      const ::blink::mojom::blink::MetaTagPtr& input) {
    return input->content;
  }

  static bool Read(::blink::mojom::blink::MetaTag::DataView input, ::blink::mojom::blink::MetaTagPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FrameMetadata::DataView,
                                         ::blink::mojom::blink::FrameMetadataPtr> {
  static bool IsNull(const ::blink::mojom::blink::FrameMetadataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FrameMetadataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::FrameMetadata::url)& url(
      const ::blink::mojom::blink::FrameMetadataPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::blink::FrameMetadata::meta_tags)& meta_tags(
      const ::blink::mojom::blink::FrameMetadataPtr& input) {
    return input->meta_tags;
  }

  static bool Read(::blink::mojom::blink::FrameMetadata::DataView input, ::blink::mojom::blink::FrameMetadataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PageMetadata::DataView,
                                         ::blink::mojom::blink::PageMetadataPtr> {
  static bool IsNull(const ::blink::mojom::blink::PageMetadataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PageMetadataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PageMetadata::frame_metadata)& frame_metadata(
      const ::blink::mojom::blink::PageMetadataPtr& input) {
    return input->frame_metadata;
  }

  static bool Read(::blink::mojom::blink::PageMetadata::DataView input, ::blink::mojom::blink::PageMetadataPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_AI_PAGE_CONTENT_METADATA_MOJOM_BLINK_H_