// third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_AI_PAGE_CONTENT_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_AI_PAGE_CONTENT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/forms/form_control_type.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "third_party/blink/public/mojom/content_extraction/script_tools.mojom-shared.h"


namespace blink::mojom {
class AIPageContentGeometryDataView;

class AIPageContentSelectionDataView;

class AIPageContentPageInteractionInfoDataView;

class AIPageContentFrameInteractionInfoDataView;

class AIPageContentNodeInteractionInfoDataView;

class AIPageContentScrollerInfoDataView;

class AIPageContentTextStyleDataView;

class AIPageContentTextInfoDataView;

class AIPageContentAnchorDataDataView;

class AIPageContentImageInfoDataView;

class AIPageContentSVGDataDataView;

class AIPageContentCanvasDataDataView;

class AIPageContentVideoDataDataView;

class AIPageContentMetaDataView;

class AIPageContentFrameDataDataView;

class RedactedFrameMetadataDataView;

class AIPageContentIframeDataDataView;

class AIPageContentTableDataDataView;

class AIPageContentTableRowDataDataView;

class AIPageContentFormDataDataView;

class AIPageContentSelectOptionDataView;

class AIPageContentFormControlDataDataView;

class AIPageContentAttributesDataView;

class AIPageContentNodeDataView;

class AIPageContentPopupDataView;

class AIPageContentDataView;

class AIPageContentOptionsDataView;

class AIPageContentIframeContentDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentGeometryDataView> {
  using Data = ::blink::mojom::internal::AIPageContentGeometry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentSelectionDataView> {
  using Data = ::blink::mojom::internal::AIPageContentSelection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentPageInteractionInfoDataView> {
  using Data = ::blink::mojom::internal::AIPageContentPageInteractionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentFrameInteractionInfoDataView> {
  using Data = ::blink::mojom::internal::AIPageContentFrameInteractionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentNodeInteractionInfoDataView> {
  using Data = ::blink::mojom::internal::AIPageContentNodeInteractionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentScrollerInfoDataView> {
  using Data = ::blink::mojom::internal::AIPageContentScrollerInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentTextStyleDataView> {
  using Data = ::blink::mojom::internal::AIPageContentTextStyle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentTextInfoDataView> {
  using Data = ::blink::mojom::internal::AIPageContentTextInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentAnchorDataDataView> {
  using Data = ::blink::mojom::internal::AIPageContentAnchorData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentImageInfoDataView> {
  using Data = ::blink::mojom::internal::AIPageContentImageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentSVGDataDataView> {
  using Data = ::blink::mojom::internal::AIPageContentSVGData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentCanvasDataDataView> {
  using Data = ::blink::mojom::internal::AIPageContentCanvasData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentVideoDataDataView> {
  using Data = ::blink::mojom::internal::AIPageContentVideoData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentMetaDataView> {
  using Data = ::blink::mojom::internal::AIPageContentMeta_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentFrameDataDataView> {
  using Data = ::blink::mojom::internal::AIPageContentFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::RedactedFrameMetadataDataView> {
  using Data = ::blink::mojom::internal::RedactedFrameMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentIframeDataDataView> {
  using Data = ::blink::mojom::internal::AIPageContentIframeData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentTableDataDataView> {
  using Data = ::blink::mojom::internal::AIPageContentTableData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentTableRowDataDataView> {
  using Data = ::blink::mojom::internal::AIPageContentTableRowData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentFormDataDataView> {
  using Data = ::blink::mojom::internal::AIPageContentFormData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentSelectOptionDataView> {
  using Data = ::blink::mojom::internal::AIPageContentSelectOption_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentFormControlDataDataView> {
  using Data = ::blink::mojom::internal::AIPageContentFormControlData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentAttributesDataView> {
  using Data = ::blink::mojom::internal::AIPageContentAttributes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentNodeDataView> {
  using Data = ::blink::mojom::internal::AIPageContentNode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentPopupDataView> {
  using Data = ::blink::mojom::internal::AIPageContentPopup_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentDataView> {
  using Data = ::blink::mojom::internal::AIPageContent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentOptionsDataView> {
  using Data = ::blink::mojom::internal::AIPageContentOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AIPageContentIframeContentDataView> {
  using Data = ::blink::mojom::internal::AIPageContentIframeContent_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class AIPageContentAttributeType : int32_t {
  
  kRoot = 0,
  
  kIframe = 1,
  
  kContainer = 2,
  
  kText = 3,
  
  kAnchor = 4,
  
  kParagraph = 5,
  
  kHeading = 6,
  
  kImage = 7,
  
  kSVG = 8,
  
  kCanvas = 9,
  
  kVideo = 10,
  
  kForm = 11,
  
  kFormControl = 12,
  
  kTable = 13,
  
  kTableRow = 14,
  
  kTableCell = 15,
  
  kOrderedList = 16,
  
  kUnorderedList = 17,
  
  kListItem = 18,
  kMinValue = 0,
  kMaxValue = 18,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AIPageContentAttributeType value);
inline bool IsKnownEnumValue(AIPageContentAttributeType value) {
  return internal::AIPageContentAttributeType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AIPageContentAnnotatedRole : int32_t {
  
  kHeader = 0,
  
  kNav = 1,
  
  kSearch = 2,
  
  kMain = 3,
  
  kArticle = 4,
  
  kSection = 5,
  
  kAside = 6,
  
  kFooter = 7,
  
  kContentHidden = 8,
  
  kPaidContent = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AIPageContentAnnotatedRole value);
inline bool IsKnownEnumValue(AIPageContentAnnotatedRole value) {
  return internal::AIPageContentAnnotatedRole_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AIPageContentClickabilityReason : int32_t {
  
  kClickableControl = 0,
  
  kClickEvents = 1,
  
  kMouseEvents = 2,
  
  kMouseClick = 3,
  
  kMouseHover = 4,
  
  kKeyEvents = 5,
  
  kEditable = 6,
  
  kCursorPointer = 7,
  
  kAriaRole = 8,
  
  kAriaHasPopup = 9,
  
  kAriaExpandedTrue = 10,
  
  kAriaExpandedFalse = 11,
  
  kTabIndex = 12,
  
  kAutocomplete = 13,
  
  kHoverPseudoClass = 14,
  kMinValue = 0,
  kMaxValue = 14,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AIPageContentClickabilityReason value);
inline bool IsKnownEnumValue(AIPageContentClickabilityReason value) {
  return internal::AIPageContentClickabilityReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AIPageContentTextSize : int32_t {
  
  kXS = 0,
  
  kS = 1,
  
  kM = 2,
  
  kL = 3,
  
  kXL = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AIPageContentTextSize value);
inline bool IsKnownEnumValue(AIPageContentTextSize value) {
  return internal::AIPageContentTextSize_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AIPageContentAnchorRel : int32_t {
  
  kRelationUnknown = 0,
  
  kRelationNoReferrer = 1,
  
  kRelationNoOpener = 2,
  
  kRelationOpener = 3,
  
  kRelationPrivacyPolicy = 4,
  
  kRelationTermsOfService = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AIPageContentAnchorRel value);
inline bool IsKnownEnumValue(AIPageContentAnchorRel value) {
  return internal::AIPageContentAnchorRel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AIPageContentTableRowType : int32_t {
  
  kHeader = 0,
  
  kBody = 1,
  
  kFooter = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AIPageContentTableRowType value);
inline bool IsKnownEnumValue(AIPageContentTableRowType value) {
  return internal::AIPageContentTableRowType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AIPageContentRedactionDecision : int32_t {
  
  kNoRedactionNecessary = 0,
  
  kUnredacted_EmptyPassword = 1,
  
  kRedacted_HasBeenPassword = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AIPageContentRedactionDecision value);
inline bool IsKnownEnumValue(AIPageContentRedactionDecision value) {
  return internal::AIPageContentRedactionDecision_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AIPageContentMode : int32_t {
  
  kDefault = 0,
  
  kActionableElements = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AIPageContentMode value);
inline bool IsKnownEnumValue(AIPageContentMode value) {
  return internal::AIPageContentMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RedactedFrameMetadata_Reason : int32_t {
  
  kCrossSite = 0,
  
  kCrossOrigin = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, RedactedFrameMetadata_Reason value);
inline bool IsKnownEnumValue(RedactedFrameMetadata_Reason value) {
  return internal::RedactedFrameMetadata_Reason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class AIPageContentAgentInterfaceBase {};

using AIPageContentAgentPtrDataView =
    mojo::InterfacePtrDataView<AIPageContentAgentInterfaceBase>;
using AIPageContentAgentRequestDataView =
    mojo::InterfaceRequestDataView<AIPageContentAgentInterfaceBase>;
using AIPageContentAgentAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AIPageContentAgentInterfaceBase>;
using AIPageContentAgentAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AIPageContentAgentInterfaceBase>;


class AIPageContentGeometryDataView {
 public:
  AIPageContentGeometryDataView() = default;

  AIPageContentGeometryDataView(
      internal::AIPageContentGeometry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOuterBoundingBoxDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOuterBoundingBox(UserType* output) {
    
    auto* pointer = data_->outer_bounding_box.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleBoundingBoxDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleBoundingBox(UserType* output) {
    
    auto* pointer = data_->visible_bounding_box.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetFragmentVisibleBoundingBoxesDataView(
      mojo::ArrayDataView<::gfx::mojom::RectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFragmentVisibleBoundingBoxes(UserType* output) {
    
    auto* pointer = data_->fragment_visible_bounding_boxes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentGeometry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentSelectionDataView {
 public:
  AIPageContentSelectionDataView() = default;

  AIPageContentSelectionDataView(
      internal::AIPageContentSelection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t start_dom_node_id() const {
    return data_->start_dom_node_id;
  }
  int32_t start_offset() const {
    return data_->start_offset;
  }
  int32_t end_dom_node_id() const {
    return data_->end_dom_node_id;
  }
  int32_t end_offset() const {
    return data_->end_offset;
  }
  inline void GetSelectedTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedText(UserType* output) {
    
    auto* pointer = data_->selected_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentSelection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentPageInteractionInfoDataView {
 public:
  AIPageContentPageInteractionInfoDataView() = default;

  AIPageContentPageInteractionInfoDataView(
      internal::AIPageContentPageInteractionInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  std::optional<int32_t> focused_dom_node_id() const {

    return data_->focused_dom_node_id_$flag
        ? std::make_optional(data_->focused_dom_node_id_$value)
        : std::nullopt;
  }
  std::optional<int32_t> accessibility_focused_dom_node_id() const {

    return data_->accessibility_focused_dom_node_id_$flag
        ? std::make_optional(data_->accessibility_focused_dom_node_id_$value)
        : std::nullopt;
  }
  inline void GetMousePositionDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMousePosition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::PointDataView, UserType>(),
    "Attempting to read the optional `mouse_position` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMousePosition` instead "
    "of `ReadMousePosition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mouse_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentPageInteractionInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentFrameInteractionInfoDataView {
 public:
  AIPageContentFrameInteractionInfoDataView() = default;

  AIPageContentFrameInteractionInfoDataView(
      internal::AIPageContentFrameInteractionInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSelectionDataView(
      AIPageContentSelectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelection(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentSelectionDataView, UserType>(),
    "Attempting to read the optional `selection` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSelection` instead "
    "of `ReadSelection if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->selection.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentSelectionDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentFrameInteractionInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentNodeInteractionInfoDataView {
 public:
  AIPageContentNodeInteractionInfoDataView() = default;

  AIPageContentNodeInteractionInfoDataView(
      internal::AIPageContentNodeInteractionInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScrollerInfoDataView(
      AIPageContentScrollerInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollerInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentScrollerInfoDataView, UserType>(),
    "Attempting to read the optional `scroller_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScrollerInfo` instead "
    "of `ReadScrollerInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->scroller_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentScrollerInfoDataView>(
        pointer, output, message_);
  }
  bool is_focusable() const {
    return data_->is_focusable;
  }
  bool is_clickable() const {
    return data_->is_clickable;
  }
  std::optional<int32_t> document_scoped_z_order() const {

    return data_->document_scoped_z_order_$flag
        ? std::make_optional(data_->document_scoped_z_order_$value)
        : std::nullopt;
  }
  inline void GetClickabilityReasonsDataView(
      mojo::ArrayDataView<AIPageContentClickabilityReason>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClickabilityReasons(UserType* output) {
    
    auto* pointer = data_->clickability_reasons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AIPageContentClickabilityReason>>(
        pointer, output, message_);
  }
  bool is_disabled() const {
    return data_->is_disabled;
  }
 private:
  internal::AIPageContentNodeInteractionInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentScrollerInfoDataView {
 public:
  AIPageContentScrollerInfoDataView() = default;

  AIPageContentScrollerInfoDataView(
      internal::AIPageContentScrollerInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScrollingBoundsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollingBounds(UserType* output) {
    
    auto* pointer = data_->scrolling_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleArea(UserType* output) {
    
    auto* pointer = data_->visible_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  bool user_scrollable_horizontal() const {
    return data_->user_scrollable_horizontal;
  }
  bool user_scrollable_vertical() const {
    return data_->user_scrollable_vertical;
  }
 private:
  internal::AIPageContentScrollerInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentTextStyleDataView {
 public:
  AIPageContentTextStyleDataView() = default;

  AIPageContentTextStyleDataView(
      internal::AIPageContentTextStyle_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadTextSize(UserType* output) const {
    auto data_value = data_->text_size;
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentTextSize>(
        data_value, output);
  }
  AIPageContentTextSize text_size() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AIPageContentTextSize>(data_->text_size));
  }
  bool has_emphasis() const {
    return data_->has_emphasis;
  }
  uint32_t color() const {
    return data_->color;
  }
 private:
  internal::AIPageContentTextStyle_Data* data_ = nullptr;
};


class AIPageContentTextInfoDataView {
 public:
  AIPageContentTextInfoDataView() = default;

  AIPageContentTextInfoDataView(
      internal::AIPageContentTextInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextContentDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextContent(UserType* output) {
    
    auto* pointer = data_->text_content.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextStyleDataView(
      AIPageContentTextStyleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextStyle(UserType* output) {
    
    auto* pointer = data_->text_style.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentTextStyleDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentTextInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentAnchorDataDataView {
 public:
  AIPageContentAnchorDataDataView() = default;

  AIPageContentAnchorDataDataView(
      internal::AIPageContentAnchorData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetRelDataView(
      mojo::ArrayDataView<AIPageContentAnchorRel>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRel(UserType* output) {
    
    auto* pointer = data_->rel.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AIPageContentAnchorRel>>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentAnchorData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentImageInfoDataView {
 public:
  AIPageContentImageInfoDataView() = default;

  AIPageContentImageInfoDataView(
      internal::AIPageContentImageInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageCaptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageCaption(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `image_caption` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImageCaption` instead "
    "of `ReadImageCaption if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->image_caption.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSourceOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `source_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSourceOrigin` instead "
    "of `ReadSourceOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->source_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentImageInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentSVGDataDataView {
 public:
  AIPageContentSVGDataDataView() = default;

  AIPageContentSVGDataDataView(
      internal::AIPageContentSVGData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInnerTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInnerText(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `inner_text` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInnerText` instead "
    "of `ReadInnerText if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->inner_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentSVGData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentCanvasDataDataView {
 public:
  AIPageContentCanvasDataDataView() = default;

  AIPageContentCanvasDataDataView(
      internal::AIPageContentCanvasData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLayoutSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayoutSize(UserType* output) {
    
    auto* pointer = data_->layout_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentCanvasData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentVideoDataDataView {
 public:
  AIPageContentVideoDataDataView() = default;

  AIPageContentVideoDataDataView(
      internal::AIPageContentVideoData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSourceOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `source_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSourceOrigin` instead "
    "of `ReadSourceOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->source_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentVideoData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentMetaDataView {
 public:
  AIPageContentMetaDataView() = default;

  AIPageContentMetaDataView(
      internal::AIPageContentMeta_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetContentDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContent(UserType* output) {
    
    auto* pointer = data_->content.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentMeta_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentFrameDataDataView {
 public:
  AIPageContentFrameDataDataView() = default;

  AIPageContentFrameDataDataView(
      internal::AIPageContentFrameData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameInteractionInfoDataView(
      AIPageContentFrameInteractionInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameInteractionInfo(UserType* output) {
    
    auto* pointer = data_->frame_interaction_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentFrameInteractionInfoDataView>(
        pointer, output, message_);
  }
  inline void GetMetaDataDataView(
      mojo::ArrayDataView<AIPageContentMetaDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetaData(UserType* output) {
    
    auto* pointer = data_->meta_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AIPageContentMetaDataView>>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `title` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTitle` instead "
    "of `ReadTitle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  std::optional<bool> contains_paid_content() const {

    return data_->contains_paid_content_$flag
        ? std::make_optional(!!data_->contains_paid_content_$value)
        : std::nullopt;
  }
  inline void GetScriptToolsDataView(
      mojo::ArrayDataView<::blink::mojom::ScriptToolDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScriptTools(UserType* output) {
    
    auto* pointer = data_->script_tools.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ScriptToolDataView>>(
        pointer, output, message_);
  }
  inline void GetPopupDataView(
      AIPageContentPopupDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPopup(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentPopupDataView, UserType>(),
    "Attempting to read the optional `popup` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPopup` instead "
    "of `ReadPopup if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->popup.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentPopupDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentFrameData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RedactedFrameMetadataDataView {
 public:
  RedactedFrameMetadataDataView() = default;

  RedactedFrameMetadataDataView(
      internal::RedactedFrameMetadata_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::blink::mojom::RedactedFrameMetadata_Reason>(
        data_value, output);
  }
  RedactedFrameMetadata_Reason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::RedactedFrameMetadata_Reason>(data_->reason));
  }
 private:
  internal::RedactedFrameMetadata_Data* data_ = nullptr;
};


class AIPageContentIframeDataDataView {
 public:
  AIPageContentIframeDataDataView() = default;

  AIPageContentIframeDataDataView(
      internal::AIPageContentIframeData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameToken(UserType* output) {
    
    auto* pointer = !data_->frame_token.is_null() ? &data_->frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetContentDataView(
      AIPageContentIframeContentDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContent(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentIframeContentDataView, UserType>(),
    "Attempting to read the optional `content` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContent` instead "
    "of `ReadContent if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->content.is_null() ? &data_->content : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentIframeContentDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentIframeData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentTableDataDataView {
 public:
  AIPageContentTableDataDataView() = default;

  AIPageContentTableDataDataView(
      internal::AIPageContentTableData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTableNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTableName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `table_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTableName` instead "
    "of `ReadTableName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->table_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentTableData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentTableRowDataDataView {
 public:
  AIPageContentTableRowDataDataView() = default;

  AIPageContentTableRowDataDataView(
      internal::AIPageContentTableRowData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadRowType(UserType* output) const {
    auto data_value = data_->row_type;
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentTableRowType>(
        data_value, output);
  }
  AIPageContentTableRowType row_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AIPageContentTableRowType>(data_->row_type));
  }
 private:
  internal::AIPageContentTableRowData_Data* data_ = nullptr;
};


class AIPageContentFormDataDataView {
 public:
  AIPageContentFormDataDataView() = default;

  AIPageContentFormDataDataView(
      internal::AIPageContentFormData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFormNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `form_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFormName` instead "
    "of `ReadFormName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->form_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetActionUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActionUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `action_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadActionUrl` instead "
    "of `ReadActionUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->action_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentFormData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentSelectOptionDataView {
 public:
  AIPageContentSelectOptionDataView() = default;

  AIPageContentSelectOptionDataView(
      internal::AIPageContentSelectOption_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadValue` instead "
    "of `ReadValue if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `text` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadText` instead "
    "of `ReadText if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_selected() const {
    return data_->is_selected;
  }
  bool disabled() const {
    return data_->disabled;
  }
 private:
  internal::AIPageContentSelectOption_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentFormControlDataDataView {
 public:
  AIPageContentFormControlDataDataView() = default;

  AIPageContentFormControlDataDataView(
      internal::AIPageContentFormControlData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadFormControlType(UserType* output) const {
    auto data_value = data_->form_control_type;
    return mojo::internal::Deserialize<::blink::mojom::FormControlType>(
        data_value, output);
  }
  ::blink::mojom::FormControlType form_control_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FormControlType>(data_->form_control_type));
  }
  inline void GetFieldNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFieldName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `field_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFieldName` instead "
    "of `ReadFieldName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->field_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFieldValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFieldValue(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `field_value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFieldValue` instead "
    "of `ReadFieldValue if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->field_value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSelectOptionsDataView(
      mojo::ArrayDataView<AIPageContentSelectOptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectOptions(UserType* output) {
    
    auto* pointer = data_->select_options.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AIPageContentSelectOptionDataView>>(
        pointer, output, message_);
  }
  inline void GetPlaceholderDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlaceholder(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `placeholder` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPlaceholder` instead "
    "of `ReadPlaceholder if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->placeholder.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_checked() const {
    return data_->is_checked;
  }
  bool is_required() const {
    return data_->is_required;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRedactionDecision(UserType* output) const {
    auto data_value = data_->redaction_decision;
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentRedactionDecision>(
        data_value, output);
  }
  AIPageContentRedactionDecision redaction_decision() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AIPageContentRedactionDecision>(data_->redaction_decision));
  }
 private:
  internal::AIPageContentFormControlData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentAttributesDataView {
 public:
  AIPageContentAttributesDataView() = default;

  AIPageContentAttributesDataView(
      internal::AIPageContentAttributes_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  std::optional<int32_t> dom_node_id() const {

    return data_->dom_node_id_$flag
        ? std::make_optional(data_->dom_node_id_$value)
        : std::nullopt;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAttributeType(UserType* output) const {
    auto data_value = data_->attribute_type;
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentAttributeType>(
        data_value, output);
  }
  AIPageContentAttributeType attribute_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AIPageContentAttributeType>(data_->attribute_type));
  }
  inline void GetGeometryDataView(
      AIPageContentGeometryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGeometry(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentGeometryDataView, UserType>(),
    "Attempting to read the optional `geometry` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGeometry` instead "
    "of `ReadGeometry if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->geometry.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentGeometryDataView>(
        pointer, output, message_);
  }
  inline void GetNodeInteractionInfoDataView(
      AIPageContentNodeInteractionInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNodeInteractionInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentNodeInteractionInfoDataView, UserType>(),
    "Attempting to read the optional `node_interaction_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNodeInteractionInfo` instead "
    "of `ReadNodeInteractionInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->node_interaction_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentNodeInteractionInfoDataView>(
        pointer, output, message_);
  }
  inline void GetTextInfoDataView(
      AIPageContentTextInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentTextInfoDataView, UserType>(),
    "Attempting to read the optional `text_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTextInfo` instead "
    "of `ReadTextInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->text_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentTextInfoDataView>(
        pointer, output, message_);
  }
  inline void GetImageInfoDataView(
      AIPageContentImageInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentImageInfoDataView, UserType>(),
    "Attempting to read the optional `image_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImageInfo` instead "
    "of `ReadImageInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->image_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentImageInfoDataView>(
        pointer, output, message_);
  }
  inline void GetSvgDataDataView(
      AIPageContentSVGDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSvgData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentSVGDataDataView, UserType>(),
    "Attempting to read the optional `svg_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSvgData` instead "
    "of `ReadSvgData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->svg_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentSVGDataDataView>(
        pointer, output, message_);
  }
  inline void GetCanvasDataDataView(
      AIPageContentCanvasDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCanvasData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentCanvasDataDataView, UserType>(),
    "Attempting to read the optional `canvas_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCanvasData` instead "
    "of `ReadCanvasData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->canvas_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentCanvasDataDataView>(
        pointer, output, message_);
  }
  inline void GetVideoDataDataView(
      AIPageContentVideoDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideoData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentVideoDataDataView, UserType>(),
    "Attempting to read the optional `video_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVideoData` instead "
    "of `ReadVideoData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->video_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentVideoDataDataView>(
        pointer, output, message_);
  }
  inline void GetAnchorDataDataView(
      AIPageContentAnchorDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnchorData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentAnchorDataDataView, UserType>(),
    "Attempting to read the optional `anchor_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAnchorData` instead "
    "of `ReadAnchorData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->anchor_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentAnchorDataDataView>(
        pointer, output, message_);
  }
  inline void GetFormDataDataView(
      AIPageContentFormDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentFormDataDataView, UserType>(),
    "Attempting to read the optional `form_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFormData` instead "
    "of `ReadFormData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->form_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentFormDataDataView>(
        pointer, output, message_);
  }
  inline void GetFormControlDataDataView(
      AIPageContentFormControlDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormControlData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentFormControlDataDataView, UserType>(),
    "Attempting to read the optional `form_control_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFormControlData` instead "
    "of `ReadFormControlData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->form_control_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentFormControlDataDataView>(
        pointer, output, message_);
  }
  inline void GetTableDataDataView(
      AIPageContentTableDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTableData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentTableDataDataView, UserType>(),
    "Attempting to read the optional `table_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTableData` instead "
    "of `ReadTableData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->table_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentTableDataDataView>(
        pointer, output, message_);
  }
  inline void GetIframeDataDataView(
      AIPageContentIframeDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIframeData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentIframeDataDataView, UserType>(),
    "Attempting to read the optional `iframe_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIframeData` instead "
    "of `ReadIframeData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->iframe_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentIframeDataDataView>(
        pointer, output, message_);
  }
  inline void GetTableRowDataDataView(
      AIPageContentTableRowDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTableRowData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentTableRowDataDataView, UserType>(),
    "Attempting to read the optional `table_row_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTableRowData` instead "
    "of `ReadTableRowData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->table_row_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentTableRowDataDataView>(
        pointer, output, message_);
  }
  inline void GetAnnotatedRolesDataView(
      mojo::ArrayDataView<AIPageContentAnnotatedRole>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnnotatedRoles(UserType* output) {
    
    auto* pointer = data_->annotated_roles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AIPageContentAnnotatedRole>>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `label` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLabel` instead "
    "of `ReadLabel if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAriaRole(UserType* output) const {
    if (!data_->aria_role_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::ax::mojom::Role>(
        data_->aria_role_$value, &output->emplace());
  }
  std::optional<::ax::mojom::Role> aria_role() const {
    if (!data_->aria_role_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::Role>(data_->aria_role_$value));
  }
  std::optional<int32_t> label_for_dom_node_id() const {

    return data_->label_for_dom_node_id_$flag
        ? std::make_optional(data_->label_for_dom_node_id_$value)
        : std::nullopt;
  }
  bool is_ad_related() const {
    return data_->is_ad_related;
  }
 private:
  internal::AIPageContentAttributes_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentNodeDataView {
 public:
  AIPageContentNodeDataView() = default;

  AIPageContentNodeDataView(
      internal::AIPageContentNode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetChildrenNodesDataView(
      mojo::ArrayDataView<AIPageContentNodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildrenNodes(UserType* output) {
    
    auto* pointer = data_->children_nodes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AIPageContentNodeDataView>>(
        pointer, output, message_);
  }
  inline void GetContentAttributesDataView(
      AIPageContentAttributesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentAttributes(UserType* output) {
    
    auto* pointer = data_->content_attributes.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentAttributesDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentNode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentPopupDataView {
 public:
  AIPageContentPopupDataView() = default;

  AIPageContentPopupDataView(
      internal::AIPageContentPopup_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRootNodeDataView(
      AIPageContentNodeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootNode(UserType* output) {
    
    auto* pointer = data_->root_node.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentNodeDataView>(
        pointer, output, message_);
  }
  int32_t opener_dom_node_id() const {
    return data_->opener_dom_node_id;
  }
  inline void GetVisibleBoundingBoxDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleBoundingBox(UserType* output) {
    
    auto* pointer = data_->visible_bounding_box.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentPopup_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentDataView {
 public:
  AIPageContentDataView() = default;

  AIPageContentDataView(
      internal::AIPageContent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRootNodeDataView(
      AIPageContentNodeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootNode(UserType* output) {
    
    auto* pointer = data_->root_node.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentNodeDataView>(
        pointer, output, message_);
  }
  inline void GetPageInteractionInfoDataView(
      AIPageContentPageInteractionInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageInteractionInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AIPageContentPageInteractionInfoDataView, UserType>(),
    "Attempting to read the optional `page_interaction_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPageInteractionInfo` instead "
    "of `ReadPageInteractionInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->page_interaction_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentPageInteractionInfoDataView>(
        pointer, output, message_);
  }
  inline void GetFrameDataDataView(
      AIPageContentFrameDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameData(UserType* output) {
    
    auto* pointer = data_->frame_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentFrameDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentOptionsDataView {
 public:
  AIPageContentOptionsDataView() = default;

  AIPageContentOptionsDataView(
      internal::AIPageContentOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentMode>(
        data_value, output);
  }
  AIPageContentMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AIPageContentMode>(data_->mode));
  }
  bool on_critical_path() const {
    return data_->on_critical_path;
  }
  int32_t max_meta_elements() const {
    return data_->max_meta_elements;
  }
  bool include_same_site_only() const {
    return data_->include_same_site_only;
  }
  inline void GetMainFrameViewRectInDipsDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainFrameViewRectInDips(UserType* output) {
    
    auto* pointer = data_->main_frame_view_rect_in_dips.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
 private:
  internal::AIPageContentOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AIPageContentIframeContentDataView {
 public:
  using Tag = internal::AIPageContentIframeContent_Data::AIPageContentIframeContent_Tag;

  AIPageContentIframeContentDataView() = default;

  AIPageContentIframeContentDataView(
      internal::AIPageContentIframeContent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_local_frame_data() const { return data_->tag == Tag::kLocalFrameData; }
  inline void GetLocalFrameDataDataView(
      AIPageContentFrameDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadLocalFrameData(UserType* output) const {
    
    CHECK(is_local_frame_data());
    return mojo::internal::Deserialize<::blink::mojom::AIPageContentFrameDataDataView>(
        data_->data.f_local_frame_data.Get(), output, message_);
  }
  bool is_redacted_frame_metadata() const { return data_->tag == Tag::kRedactedFrameMetadata; }
  inline void GetRedactedFrameMetadataDataView(
      RedactedFrameMetadataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRedactedFrameMetadata(UserType* output) const {
    
    CHECK(is_redacted_frame_metadata());
    return mojo::internal::Deserialize<::blink::mojom::RedactedFrameMetadataDataView>(
        data_->data.f_redacted_frame_metadata.Get(), output, message_);
  }

 private:
  internal::AIPageContentIframeContent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_AI_PAGE_CONTENT_MOJOM_DATA_VIEW_H_