// third_party/blink/public/mojom/compute_pressure/web_pressure_update.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_COMPUTE_PRESSURE_WEB_PRESSURE_UPDATE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_COMPUTE_PRESSURE_WEB_PRESSURE_UPDATE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/compute_pressure/web_pressure_update.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/compute_pressure/web_pressure_update.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/compute_pressure/web_pressure_update.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/device/public/mojom/pressure_update.mojom-forward.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT WebPressureUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebPressureUpdate, T>::value>;
  using DataView = WebPressureUpdateDataView;
  using Data_ = internal::WebPressureUpdate_Data;

  template <typename... Args>
  static WebPressureUpdatePtr New(Args&&... args) {
    return WebPressureUpdatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebPressureUpdatePtr From(const U& u) {
    return mojo::TypeConverter<WebPressureUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPressureUpdate>::Convert(*this);
  }


  WebPressureUpdate();

  WebPressureUpdate(
      ::device::mojom::PressureSource source,
      ::device::mojom::PressureState state,
      double own_contribution_estimate,
      ::base::TimeTicks timestamp);


  ~WebPressureUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebPressureUpdatePtr>
  WebPressureUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebPressureUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebPressureUpdate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebPressureUpdate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPressureUpdate::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPressureUpdate::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPressureUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebPressureUpdate_UnserializedMessageContext<
            UserType, WebPressureUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebPressureUpdate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebPressureUpdate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebPressureUpdate_UnserializedMessageContext<
            UserType, WebPressureUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebPressureUpdate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::mojom::PressureSource source;
  
  ::device::mojom::PressureState state;
  
  double own_contribution_estimate;
  
  ::base::TimeTicks timestamp;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebPressureUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebPressureUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebPressureUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebPressureUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WebPressureUpdatePtr WebPressureUpdate::Clone() const {
  return New(
      mojo::Clone(source),
      mojo::Clone(state),
      mojo::Clone(own_contribution_estimate),
      mojo::Clone(timestamp)
  );
}

template <typename T, WebPressureUpdate::EnableIfSame<T>*>
bool WebPressureUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->own_contribution_estimate, other_struct.own_contribution_estimate))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  return true;
}

template <typename T, WebPressureUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.source < rhs.source)
    return true;
  if (rhs.source < lhs.source)
    return false;
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  if (lhs.own_contribution_estimate < rhs.own_contribution_estimate)
    return true;
  if (rhs.own_contribution_estimate < lhs.own_contribution_estimate)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebPressureUpdate::DataView,
                                         ::blink::mojom::WebPressureUpdatePtr> {
  static bool IsNull(const ::blink::mojom::WebPressureUpdatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebPressureUpdatePtr* output) { output->reset(); }

  static decltype(::blink::mojom::WebPressureUpdate::source) source(
      const ::blink::mojom::WebPressureUpdatePtr& input) {
    return input->source;
  }

  static decltype(::blink::mojom::WebPressureUpdate::state) state(
      const ::blink::mojom::WebPressureUpdatePtr& input) {
    return input->state;
  }

  static decltype(::blink::mojom::WebPressureUpdate::own_contribution_estimate) own_contribution_estimate(
      const ::blink::mojom::WebPressureUpdatePtr& input) {
    return input->own_contribution_estimate;
  }

  static const decltype(::blink::mojom::WebPressureUpdate::timestamp)& timestamp(
      const ::blink::mojom::WebPressureUpdatePtr& input) {
    return input->timestamp;
  }

  static bool Read(::blink::mojom::WebPressureUpdate::DataView input, ::blink::mojom::WebPressureUpdatePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_COMPUTE_PRESSURE_WEB_PRESSURE_UPDATE_MOJOM_H_