// third_party/blink/public/mojom/compute_pressure/web_pressure_update.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_COMPUTE_PRESSURE_WEB_PRESSURE_UPDATE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_COMPUTE_PRESSURE_WEB_PRESSURE_UPDATE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/compute_pressure/web_pressure_update.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/device/public/mojom/pressure_update.mojom-shared.h"




#include "third_party/blink/public/mojom/compute_pressure/web_pressure_update.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPressureUpdateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPressureUpdateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPressureUpdate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::device::mojom::PressureSource>(
      Traits::source(input),
      &fragment->source);

    
    mojo::internal::Serialize<::device::mojom::PressureState>(
      Traits::state(input),
      &fragment->state);

    fragment->own_contribution_estimate = Traits::own_contribution_estimate(input);

    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_timestamp,
      timestamp_fragment);

    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->timestamp.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timestamp in WebPressureUpdate struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebPressureUpdate_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebPressureUpdateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void WebPressureUpdateDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_COMPUTE_PRESSURE_WEB_PRESSURE_UPDATE_MOJOM_SHARED_H_