// third_party/blink/public/mojom/compute_pressure/web_pressure_manager.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/compute_pressure/web_pressure_manager.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/compute_pressure/web_pressure_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/compute_pressure/web_pressure_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/compute_pressure/web_pressure_manager.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/compute_pressure/web_pressure_manager.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

WebPressureManager::IPCStableHashFunction WebPressureManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebPressureManager>(message.name())) {
    case messages::WebPressureManager::kAddClient: {
      return &WebPressureManager::AddClient_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebPressureManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebPressureManager>(message.name())) {
      case messages::WebPressureManager::kAddClient:
            return "Receive blink::mojom::WebPressureManager::AddClient";
    }
  } else {
    switch (static_cast<messages::WebPressureManager>(message.name())) {
      case messages::WebPressureManager::kAddClient:
            return "Receive reply blink::mojom::WebPressureManager::AddClient";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebPressureManager::AddClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0911fc46;  // IPCStableHash for blink::mojom::WebPressureManager::AddClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebPressureManager_AddClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebPressureManager_AddClient_ForwardToCallback(
      WebPressureManager::AddClientCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebPressureManager_AddClient_ForwardToCallback(const WebPressureManager_AddClient_ForwardToCallback&) = delete;
  WebPressureManager_AddClient_ForwardToCallback& operator=(const WebPressureManager_AddClient_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebPressureManager::AddClientCallback callback_;
};

WebPressureManagerProxy::WebPressureManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebPressureManagerProxy::AddClient(
    ::device::mojom::blink::PressureSource in_source, ::mojo::PendingAssociatedRemote<WebPressureClient> in_client, AddClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebPressureManager::AddClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::device::mojom::blink::PressureSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<WebPressureClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebPressureManager::kAddClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebPressureManager_AddClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::PressureSource>(
    in_source,
    &params->source);

  
  mojo::internal::Serialize<::blink::mojom::WebPressureClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in WebPressureManager.AddClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebPressureManager::Name_);
  message.set_method_name("AddClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebPressureManager_AddClient_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebPressureManager_AddClient_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebPressureManager::AddClientCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebPressureManager_AddClient_ProxyToResponder> proxy(
        new WebPressureManager_AddClient_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebPressureManager_AddClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebPressureManager_AddClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebPressureManager_AddClient_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebPressureManager::AddClientCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::device::mojom::blink::PressureManagerAddClientResult in_result);
};

bool WebPressureManager_AddClient_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebPressureManager_AddClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebPressureManager_AddClient_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebPressureManager.0
  bool success = true;
  ::device::mojom::blink::PressureManagerAddClientResult p_result{};
  WebPressureManager_AddClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebPressureManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebPressureManager_AddClient_ProxyToResponder::Run(
    ::device::mojom::blink::PressureManagerAddClientResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebPressureManager::AddClient", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::device::mojom::blink::PressureManagerAddClientResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebPressureManager::kAddClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebPressureManager_AddClient_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::PressureManagerAddClientResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebPressureManager::Name_);
  message.set_method_name("AddClient");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebPressureManagerStubDispatch::Accept(
    WebPressureManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebPressureManager>(message->header()->name)) {
    case messages::WebPressureManager::kAddClient: {
      break;
    }
  }
  return false;
}

// static
bool WebPressureManagerStubDispatch::AcceptWithResponder(
    WebPressureManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebPressureManager>(message->header()->name)) {
    case messages::WebPressureManager::kAddClient: {
      internal::WebPressureManager_AddClient_Params_Data* params =
          reinterpret_cast<
              internal::WebPressureManager_AddClient_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebPressureManager.0
      bool success = true;
      ::device::mojom::blink::PressureSource p_source{};
      ::mojo::PendingAssociatedRemote<WebPressureClient> p_client{};
      WebPressureManager_AddClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebPressureManager::Name_, 0, false);
        return false;
      }
      auto callback =
          WebPressureManager_AddClient_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddClient(        
        std::move(p_source), 
        std::move(p_client), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebPressureManagerValidationInfo[] = {
    { &internal::WebPressureManager_AddClient_Params_Data::Validate,
     &internal::WebPressureManager_AddClient_ResponseParams_Data::Validate},
};

bool WebPressureManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::WebPressureManager::Name_,
    kWebPressureManagerValidationInfo);
}

bool WebPressureManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::WebPressureManager::Name_,
    kWebPressureManagerValidationInfo);
}
// The declaration includes the definition on other builds.

WebPressureClient::IPCStableHashFunction WebPressureClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebPressureClient>(message.name())) {
    case messages::WebPressureClient::kOnPressureUpdated: {
      return &WebPressureClient::OnPressureUpdated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebPressureClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebPressureClient>(message.name())) {
      case messages::WebPressureClient::kOnPressureUpdated:
            return "Receive blink::mojom::WebPressureClient::OnPressureUpdated";
    }
  } else {
    switch (static_cast<messages::WebPressureClient>(message.name())) {
      case messages::WebPressureClient::kOnPressureUpdated:
            return "Receive reply blink::mojom::WebPressureClient::OnPressureUpdated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebPressureClient::OnPressureUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6d40631a;  // IPCStableHash for blink::mojom::WebPressureClient::OnPressureUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebPressureClientProxy::WebPressureClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebPressureClientProxy::OnPressureUpdated(
    ::blink::mojom::blink::WebPressureUpdatePtr in_update) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebPressureClient::OnPressureUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update"), in_update,
                        "<value of type ::blink::mojom::blink::WebPressureUpdatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebPressureClient::kOnPressureUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebPressureClient_OnPressureUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->update)::BaseType> update_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WebPressureUpdateDataView>(
    in_update,
    update_fragment);

  params->update.Set(
      update_fragment.is_null() ? nullptr : update_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->update.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null update in WebPressureClient.OnPressureUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebPressureClient::Name_);
  message.set_method_name("OnPressureUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebPressureClientStubDispatch::Accept(
    WebPressureClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebPressureClient>(message->header()->name)) {
    case messages::WebPressureClient::kOnPressureUpdated: {
      DCHECK(message->is_serialized());
      internal::WebPressureClient_OnPressureUpdated_Params_Data* params =
          reinterpret_cast<internal::WebPressureClient_OnPressureUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebPressureClient.0
      bool success = true;
      ::blink::mojom::blink::WebPressureUpdatePtr p_update{};
      WebPressureClient_OnPressureUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdate(&p_update))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebPressureClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPressureUpdated(        
        std::move(p_update));
      return true;
    }
  }
  return false;
}

// static
bool WebPressureClientStubDispatch::AcceptWithResponder(
    WebPressureClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebPressureClient>(message->header()->name)) {
    case messages::WebPressureClient::kOnPressureUpdated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebPressureClientValidationInfo[] = {
    { &internal::WebPressureClient_OnPressureUpdated_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebPressureClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::WebPressureClient::Name_,
    kWebPressureClientValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void WebPressureManagerInterceptorForTesting::AddClient(::device::mojom::blink::PressureSource source, ::mojo::PendingAssociatedRemote<WebPressureClient> client, AddClientCallback callback) {
  GetForwardingInterface()->AddClient(
    std::move(source)
    , 
    std::move(client)
    , std::move(callback));
}
WebPressureManagerAsyncWaiter::WebPressureManagerAsyncWaiter(
    WebPressureManager* proxy) : proxy_(proxy) {}

WebPressureManagerAsyncWaiter::~WebPressureManagerAsyncWaiter() = default;


void WebPressureManagerAsyncWaiter::AddClient(
    ::device::mojom::blink::PressureSource source, ::mojo::PendingAssociatedRemote<WebPressureClient> client, ::device::mojom::blink::PressureManagerAddClientResult* out_result) {
  base::RunLoop loop;
  proxy_->AddClient(
      std::move(source),
      std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::device::mojom::blink::PressureManagerAddClientResult* out_result
,
             ::device::mojom::blink::PressureManagerAddClientResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::device::mojom::blink::PressureManagerAddClientResult WebPressureManagerAsyncWaiter::AddClient(
    ::device::mojom::blink::PressureSource source, ::mojo::PendingAssociatedRemote<WebPressureClient> client) {
  ::device::mojom::blink::PressureManagerAddClientResult async_wait_result;
  AddClient(std::move(source),std::move(client),&async_wait_result);
  return async_wait_result;
}




void WebPressureClientInterceptorForTesting::OnPressureUpdated(::blink::mojom::blink::WebPressureUpdatePtr update) {
  GetForwardingInterface()->OnPressureUpdated(
    std::move(update)
    );
}
WebPressureClientAsyncWaiter::WebPressureClientAsyncWaiter(
    WebPressureClient* proxy) : proxy_(proxy) {}

WebPressureClientAsyncWaiter::~WebPressureClientAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif