// third_party/blink/public/mojom/clipboard/clipboard.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* ClipboardFormatToStringHelper(ClipboardFormat value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ClipboardFormat::kPlaintext:
      return "kPlaintext";
    case ClipboardFormat::kHtml:
      return "kHtml";
    case ClipboardFormat::kSmartPaste:
      return "kSmartPaste";
    case ClipboardFormat::kBookmark:
      return "kBookmark";
    default:
      return nullptr;
  }
}

std::string ClipboardFormatToString(ClipboardFormat value) {
  const char *str = ClipboardFormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ClipboardFormat value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ClipboardFormat value) {
  return os << ClipboardFormatToString(value);
}

NOINLINE static const char* ClipboardBufferToStringHelper(ClipboardBuffer value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ClipboardBuffer::kStandard:
      return "kStandard";
    case ClipboardBuffer::kSelection:
      return "kSelection";
    default:
      return nullptr;
  }
}

std::string ClipboardBufferToString(ClipboardBuffer value) {
  const char *str = ClipboardBufferToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ClipboardBuffer value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ClipboardBuffer value) {
  return os << ClipboardBufferToString(value);
}

NOINLINE static const char* PlatformClipboardPermissionStateToStringHelper(PlatformClipboardPermissionState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PlatformClipboardPermissionState::kAllow:
      return "kAllow";
    case PlatformClipboardPermissionState::kAsk:
      return "kAsk";
    case PlatformClipboardPermissionState::kDeny:
      return "kDeny";
    default:
      return nullptr;
  }
}

std::string PlatformClipboardPermissionStateToString(PlatformClipboardPermissionState value) {
  const char *str = PlatformClipboardPermissionStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PlatformClipboardPermissionState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PlatformClipboardPermissionState value) {
  return os << PlatformClipboardPermissionStateToString(value);
}

namespace internal {


// static
bool ClipboardFiles_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardFiles_Data* object =
      static_cast<const ClipboardFiles_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->files, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->files, validation_context,
                                         &files_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& file_system_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->file_system_id, validation_context,
                                         &file_system_id_validate_params)) {
    return false;
  }

  return true;
}

ClipboardFiles_Data::ClipboardFiles_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardListener_OnClipboardDataChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardListener_OnClipboardDataChanged_Params_Data* object =
      static_cast<const ClipboardListener_OnClipboardDataChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->types, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& types_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->types, validation_context,
                                         &types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->change_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->change_id, validation_context))
    return false;

  return true;
}

ClipboardListener_OnClipboardDataChanged_Params_Data::ClipboardListener_OnClipboardDataChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_GetSequenceNumber_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_GetSequenceNumber_Params_Data* object =
      static_cast<const ClipboardHost_GetSequenceNumber_Params_Data*>(data);


  if (!::blink::mojom::internal::ClipboardBuffer_Data
        ::Validate(object->buffer, validation_context))
    return false;

  return true;
}

ClipboardHost_GetSequenceNumber_Params_Data::ClipboardHost_GetSequenceNumber_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_GetSequenceNumber_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_GetSequenceNumber_ResponseParams_Data* object =
      static_cast<const ClipboardHost_GetSequenceNumber_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ClipboardHost_GetSequenceNumber_ResponseParams_Data::ClipboardHost_GetSequenceNumber_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_IsFormatAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_IsFormatAvailable_Params_Data* object =
      static_cast<const ClipboardHost_IsFormatAvailable_Params_Data*>(data);


  if (!::blink::mojom::internal::ClipboardFormat_Data
        ::Validate(object->format, validation_context))
    return false;


  if (!::blink::mojom::internal::ClipboardBuffer_Data
        ::Validate(object->buffer, validation_context))
    return false;

  return true;
}

ClipboardHost_IsFormatAvailable_Params_Data::ClipboardHost_IsFormatAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_IsFormatAvailable_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_IsFormatAvailable_ResponseParams_Data* object =
      static_cast<const ClipboardHost_IsFormatAvailable_ResponseParams_Data*>(data);

  return true;
}

ClipboardHost_IsFormatAvailable_ResponseParams_Data::ClipboardHost_IsFormatAvailable_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadAvailableTypes_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadAvailableTypes_Params_Data* object =
      static_cast<const ClipboardHost_ReadAvailableTypes_Params_Data*>(data);


  if (!::blink::mojom::internal::ClipboardBuffer_Data
        ::Validate(object->buffer, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadAvailableTypes_Params_Data::ClipboardHost_ReadAvailableTypes_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadAvailableTypes_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadAvailableTypes_ResponseParams_Data* object =
      static_cast<const ClipboardHost_ReadAvailableTypes_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->types, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& types_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->types, validation_context,
                                         &types_validate_params)) {
    return false;
  }

  return true;
}

ClipboardHost_ReadAvailableTypes_ResponseParams_Data::ClipboardHost_ReadAvailableTypes_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadText_Params_Data* object =
      static_cast<const ClipboardHost_ReadText_Params_Data*>(data);


  if (!::blink::mojom::internal::ClipboardBuffer_Data
        ::Validate(object->buffer, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadText_Params_Data::ClipboardHost_ReadText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadText_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadText_ResponseParams_Data* object =
      static_cast<const ClipboardHost_ReadText_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadText_ResponseParams_Data::ClipboardHost_ReadText_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadHtml_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadHtml_Params_Data* object =
      static_cast<const ClipboardHost_ReadHtml_Params_Data*>(data);


  if (!::blink::mojom::internal::ClipboardBuffer_Data
        ::Validate(object->buffer, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadHtml_Params_Data::ClipboardHost_ReadHtml_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadHtml_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadHtml_ResponseParams_Data* object =
      static_cast<const ClipboardHost_ReadHtml_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->markup, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->markup, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadHtml_ResponseParams_Data::ClipboardHost_ReadHtml_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadSvg_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadSvg_Params_Data* object =
      static_cast<const ClipboardHost_ReadSvg_Params_Data*>(data);


  if (!::blink::mojom::internal::ClipboardBuffer_Data
        ::Validate(object->buffer, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadSvg_Params_Data::ClipboardHost_ReadSvg_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadSvg_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadSvg_ResponseParams_Data* object =
      static_cast<const ClipboardHost_ReadSvg_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadSvg_ResponseParams_Data::ClipboardHost_ReadSvg_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadRtf_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadRtf_Params_Data* object =
      static_cast<const ClipboardHost_ReadRtf_Params_Data*>(data);


  if (!::blink::mojom::internal::ClipboardBuffer_Data
        ::Validate(object->buffer, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadRtf_Params_Data::ClipboardHost_ReadRtf_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadRtf_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadRtf_ResponseParams_Data* object =
      static_cast<const ClipboardHost_ReadRtf_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadRtf_ResponseParams_Data::ClipboardHost_ReadRtf_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadPng_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadPng_Params_Data* object =
      static_cast<const ClipboardHost_ReadPng_Params_Data*>(data);


  if (!::blink::mojom::internal::ClipboardBuffer_Data
        ::Validate(object->buffer, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadPng_Params_Data::ClipboardHost_ReadPng_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadPng_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadPng_ResponseParams_Data* object =
      static_cast<const ClipboardHost_ReadPng_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->png, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->png, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadPng_ResponseParams_Data::ClipboardHost_ReadPng_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadFiles_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadFiles_Params_Data* object =
      static_cast<const ClipboardHost_ReadFiles_Params_Data*>(data);


  if (!::blink::mojom::internal::ClipboardBuffer_Data
        ::Validate(object->buffer, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadFiles_Params_Data::ClipboardHost_ReadFiles_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadFiles_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadFiles_ResponseParams_Data* object =
      static_cast<const ClipboardHost_ReadFiles_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadFiles_ResponseParams_Data::ClipboardHost_ReadFiles_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadDataTransferCustomData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadDataTransferCustomData_Params_Data* object =
      static_cast<const ClipboardHost_ReadDataTransferCustomData_Params_Data*>(data);


  if (!::blink::mojom::internal::ClipboardBuffer_Data
        ::Validate(object->buffer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->type, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->type, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadDataTransferCustomData_Params_Data::ClipboardHost_ReadDataTransferCustomData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadDataTransferCustomData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadDataTransferCustomData_ResponseParams_Data* object =
      static_cast<const ClipboardHost_ReadDataTransferCustomData_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadDataTransferCustomData_ResponseParams_Data::ClipboardHost_ReadDataTransferCustomData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadAvailableCustomAndStandardFormats_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadAvailableCustomAndStandardFormats_Params_Data* object =
      static_cast<const ClipboardHost_ReadAvailableCustomAndStandardFormats_Params_Data*>(data);

  return true;
}

ClipboardHost_ReadAvailableCustomAndStandardFormats_Params_Data::ClipboardHost_ReadAvailableCustomAndStandardFormats_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams_Data* object =
      static_cast<const ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->format_types, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& format_types_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->format_types, validation_context,
                                         &format_types_validate_params)) {
    return false;
  }

  return true;
}

ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams_Data::ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadUnsanitizedCustomFormat_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadUnsanitizedCustomFormat_Params_Data* object =
      static_cast<const ClipboardHost_ReadUnsanitizedCustomFormat_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->format, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->format, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadUnsanitizedCustomFormat_Params_Data::ClipboardHost_ReadUnsanitizedCustomFormat_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams_Data* object =
      static_cast<const ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams_Data::ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_WriteText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_WriteText_Params_Data* object =
      static_cast<const ClipboardHost_WriteText_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  return true;
}

ClipboardHost_WriteText_Params_Data::ClipboardHost_WriteText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_WriteHtml_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_WriteHtml_Params_Data* object =
      static_cast<const ClipboardHost_WriteHtml_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->markup, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->markup, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

ClipboardHost_WriteHtml_Params_Data::ClipboardHost_WriteHtml_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_WriteSvg_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_WriteSvg_Params_Data* object =
      static_cast<const ClipboardHost_WriteSvg_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->markup, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->markup, validation_context))
    return false;

  return true;
}

ClipboardHost_WriteSvg_Params_Data::ClipboardHost_WriteSvg_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_WriteSmartPasteMarker_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_WriteSmartPasteMarker_Params_Data* object =
      static_cast<const ClipboardHost_WriteSmartPasteMarker_Params_Data*>(data);

  return true;
}

ClipboardHost_WriteSmartPasteMarker_Params_Data::ClipboardHost_WriteSmartPasteMarker_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_WriteDataTransferCustomData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_WriteDataTransferCustomData_Params_Data* object =
      static_cast<const ClipboardHost_WriteDataTransferCustomData_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

ClipboardHost_WriteDataTransferCustomData_Params_Data::ClipboardHost_WriteDataTransferCustomData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_WriteBookmark_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_WriteBookmark_Params_Data* object =
      static_cast<const ClipboardHost_WriteBookmark_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  return true;
}

ClipboardHost_WriteBookmark_Params_Data::ClipboardHost_WriteBookmark_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_WriteImage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_WriteImage_Params_Data* object =
      static_cast<const ClipboardHost_WriteImage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  return true;
}

ClipboardHost_WriteImage_Params_Data::ClipboardHost_WriteImage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_WriteUnsanitizedCustomFormat_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_WriteUnsanitizedCustomFormat_Params_Data* object =
      static_cast<const ClipboardHost_WriteUnsanitizedCustomFormat_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->format, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->format, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

ClipboardHost_WriteUnsanitizedCustomFormat_Params_Data::ClipboardHost_WriteUnsanitizedCustomFormat_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_CommitWrite_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_CommitWrite_Params_Data* object =
      static_cast<const ClipboardHost_CommitWrite_Params_Data*>(data);

  return true;
}

ClipboardHost_CommitWrite_Params_Data::ClipboardHost_CommitWrite_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_BeginCopyWithCompletion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_BeginCopyWithCompletion_Params_Data* object =
      static_cast<const ClipboardHost_BeginCopyWithCompletion_Params_Data*>(data);

  return true;
}

ClipboardHost_BeginCopyWithCompletion_Params_Data::ClipboardHost_BeginCopyWithCompletion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_EndCopyWithCompletion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_EndCopyWithCompletion_Params_Data* object =
      static_cast<const ClipboardHost_EndCopyWithCompletion_Params_Data*>(data);

  return true;
}

ClipboardHost_EndCopyWithCompletion_Params_Data::ClipboardHost_EndCopyWithCompletion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_EndCopyWithCompletion_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_EndCopyWithCompletion_ResponseParams_Data* object =
      static_cast<const ClipboardHost_EndCopyWithCompletion_ResponseParams_Data*>(data);

  return true;
}

ClipboardHost_EndCopyWithCompletion_ResponseParams_Data::ClipboardHost_EndCopyWithCompletion_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_BeginPasteWithCompletion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_BeginPasteWithCompletion_Params_Data* object =
      static_cast<const ClipboardHost_BeginPasteWithCompletion_Params_Data*>(data);

  return true;
}

ClipboardHost_BeginPasteWithCompletion_Params_Data::ClipboardHost_BeginPasteWithCompletion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_EndPasteWithCompletion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_EndPasteWithCompletion_Params_Data* object =
      static_cast<const ClipboardHost_EndPasteWithCompletion_Params_Data*>(data);

  return true;
}

ClipboardHost_EndPasteWithCompletion_Params_Data::ClipboardHost_EndPasteWithCompletion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_EndPasteWithCompletion_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_EndPasteWithCompletion_ResponseParams_Data* object =
      static_cast<const ClipboardHost_EndPasteWithCompletion_ResponseParams_Data*>(data);

  return true;
}

ClipboardHost_EndPasteWithCompletion_ResponseParams_Data::ClipboardHost_EndPasteWithCompletion_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_WriteStringToFindPboard_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_WriteStringToFindPboard_Params_Data* object =
      static_cast<const ClipboardHost_WriteStringToFindPboard_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  return true;
}

ClipboardHost_WriteStringToFindPboard_Params_Data::ClipboardHost_WriteStringToFindPboard_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_GetPlatformPermissionState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_GetPlatformPermissionState_Params_Data* object =
      static_cast<const ClipboardHost_GetPlatformPermissionState_Params_Data*>(data);

  return true;
}

ClipboardHost_GetPlatformPermissionState_Params_Data::ClipboardHost_GetPlatformPermissionState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_GetPlatformPermissionState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_GetPlatformPermissionState_ResponseParams_Data* object =
      static_cast<const ClipboardHost_GetPlatformPermissionState_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::PlatformClipboardPermissionState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

ClipboardHost_GetPlatformPermissionState_ResponseParams_Data::ClipboardHost_GetPlatformPermissionState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardHost_RegisterClipboardListener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardHost_RegisterClipboardListener_Params_Data* object =
      static_cast<const ClipboardHost_RegisterClipboardListener_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ClipboardHost_RegisterClipboardListener_Params_Data::ClipboardHost_RegisterClipboardListener_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ClipboardFormat>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ClipboardFormat value) {
  return std::move(context).WriteString(::blink::mojom::ClipboardFormatToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ClipboardBuffer>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ClipboardBuffer value) {
  return std::move(context).WriteString(::blink::mojom::ClipboardBufferToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PlatformClipboardPermissionState>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::PlatformClipboardPermissionState value) {
  return std::move(context).WriteString(::blink::mojom::PlatformClipboardPermissionStateToString(value));
}

} // namespace perfetto