// third_party/blink/public/mojom/clipboard/clipboard.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/big_string.mojom-shared.h"
#include "mojo/public/mojom/base/int128.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class ClipboardFilesDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ClipboardFilesDataView> {
  using Data = ::blink::mojom::internal::ClipboardFiles_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class ClipboardFormat : int32_t {
  
  kPlaintext = 0,
  
  kHtml = 1,
  
  kSmartPaste = 2,
  
  kBookmark = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ClipboardFormat value);
inline bool IsKnownEnumValue(ClipboardFormat value) {
  return internal::ClipboardFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ClipboardBuffer : int32_t {
  
  kStandard = 0,
  
  kSelection = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ClipboardBuffer value);
inline bool IsKnownEnumValue(ClipboardBuffer value) {
  return internal::ClipboardBuffer_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PlatformClipboardPermissionState : int32_t {
  
  kAllow = 0,
  
  kAsk = 1,
  
  kDeny = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PlatformClipboardPermissionState value);
inline bool IsKnownEnumValue(PlatformClipboardPermissionState value) {
  return internal::PlatformClipboardPermissionState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ClipboardListenerInterfaceBase {};

using ClipboardListenerPtrDataView =
    mojo::InterfacePtrDataView<ClipboardListenerInterfaceBase>;
using ClipboardListenerRequestDataView =
    mojo::InterfaceRequestDataView<ClipboardListenerInterfaceBase>;
using ClipboardListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ClipboardListenerInterfaceBase>;
using ClipboardListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ClipboardListenerInterfaceBase>;
class ClipboardHostInterfaceBase {};

using ClipboardHostPtrDataView =
    mojo::InterfacePtrDataView<ClipboardHostInterfaceBase>;
using ClipboardHostRequestDataView =
    mojo::InterfaceRequestDataView<ClipboardHostInterfaceBase>;
using ClipboardHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ClipboardHostInterfaceBase>;
using ClipboardHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ClipboardHostInterfaceBase>;


class ClipboardFilesDataView {
 public:
  ClipboardFilesDataView() = default;

  ClipboardFilesDataView(
      internal::ClipboardFiles_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilesDataView(
      mojo::ArrayDataView<::blink::mojom::DataTransferFileDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFiles(UserType* output) {
    
    auto* pointer = data_->files.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::DataTransferFileDataView>>(
        pointer, output, message_);
  }
  inline void GetFileSystemIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileSystemId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `file_system_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFileSystemId` instead "
    "of `ReadFileSystemId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_system_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ClipboardFiles_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_DATA_VIEW_H_