// third_party/blink/public/mojom/choosers/popup_menu.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  TextDirection as mojoBase_mojom_TextDirection,
  TextDirectionSpec as mojoBase_mojom_TextDirectionSpec
} from '../../../../../mojo/public/mojom/base/text_direction.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PopupMenuClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PopupMenuClient', scope);
  }
}

/** @interface */
export class PopupMenuClientInterface {
  
  /**
   * @param { !Array<!number> } indices
   */

  didAcceptIndices(indices) {}
  
  /**
   */

  didCancel() {}
}

/**
 * @implements { PopupMenuClientInterface }
 */
export class PopupMenuClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PopupMenuClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PopupMenuClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PopupMenuClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } indices
   */

  didAcceptIndices(
      indices) {
    this.proxy.sendMessage(
        0,
        PopupMenuClient_DidAcceptIndices_ParamsSpec.$,
        null,
        [
          indices
        ],
        false);
  }

  
  /**
   */

  didCancel() {
    this.proxy.sendMessage(
        1,
        PopupMenuClient_DidCancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PopupMenuClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PopupMenuClientReceiver {
  /**
   * @param {!PopupMenuClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PopupMenuClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PopupMenuClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PopupMenuClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PopupMenuClient_DidAcceptIndices_ParamsSpec.$,
        null,
        impl.didAcceptIndices.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PopupMenuClient_DidCancel_ParamsSpec.$,
        null,
        impl.didCancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PopupMenuClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PopupMenuClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PopupMenuClientRemote}
   */
  static getRemote() {
    let remote = new PopupMenuClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PopupMenuClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PopupMenuClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PopupMenuClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PopupMenuClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didAcceptIndices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PopupMenuClient_DidAcceptIndices_ParamsSpec.$,
        null,
        this.didAcceptIndices.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didCancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PopupMenuClient_DidCancel_ParamsSpec.$,
        null,
        this.didCancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MenuItemSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PopupMenuClient_DidAcceptIndices_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PopupMenuClient_DidCancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };



/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MenuItem_TypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MenuItem_Type = {
  
  kOption: 0,
  kCheckableOption: 1,
  kGroup: 2,
  kSeparator: 3,
  kSubMenu: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};


mojo.internal.Struct(
    MenuItemSpec.$,
    'MenuItem',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'toolTip', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 16,
        0,
        MenuItem_TypeSpec.$,
        MenuItem_Type.kOption,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'action', 20,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textDirection', 24,
        0,
        mojoBase_mojom_TextDirectionSpec.$,
        mojoBase_mojom_TextDirection.LEFT_TO_RIGHT,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasTextDirectionOverride', 28,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enabled', 28,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'checked', 28,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class MenuItem {
  constructor() {
    /** @type { (string|undefined) } */
    this.label;
    /** @type { (string|undefined) } */
    this.toolTip;
    /** @type { !MenuItem_Type } */
    this.type;
    /** @type { !number } */
    this.action;
    /** @type { !mojoBase_mojom_TextDirection } */
    this.textDirection;
    /** @type { !boolean } */
    this.hasTextDirectionOverride;
    /** @type { !boolean } */
    this.enabled;
    /** @type { !boolean } */
    this.checked;
  }
}



mojo.internal.Struct(
    PopupMenuClient_DidAcceptIndices_ParamsSpec.$,
    'PopupMenuClient_DidAcceptIndices_Params',
    [
      mojo.internal.StructField(
        'indices', 0,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PopupMenuClient_DidAcceptIndices_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.indices;
  }
}



mojo.internal.Struct(
    PopupMenuClient_DidCancel_ParamsSpec.$,
    'PopupMenuClient_DidCancel_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PopupMenuClient_DidCancel_Params {
  constructor() {
  }
}

