// third_party/blink/public/mojom/choosers/popup_menu.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_POPUP_MENU_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_POPUP_MENU_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-shared-internal.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::MenuItem_Type>
    : public mojo::internal::EnumHashImpl<::blink::mojom::MenuItem_Type> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MenuItem_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::MenuItem_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::MenuItem_Type>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MenuItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MenuItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MenuItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    decltype(Traits::tool_tip(input)) in_tool_tip = Traits::tool_tip(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tool_tip)::BaseType> tool_tip_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_tool_tip,
      tool_tip_fragment);

    fragment->tool_tip.Set(
        tool_tip_fragment.is_null() ? nullptr : tool_tip_fragment.data());

    
    mojo::internal::Serialize<::blink::mojom::MenuItem_Type>(
      Traits::type(input),
      &fragment->type);

    fragment->action = Traits::action(input);

    
    mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
      Traits::text_direction(input),
      &fragment->text_direction);

    fragment->has_text_direction_override = Traits::has_text_direction_override(input);

    fragment->enabled = Traits::enabled(input);

    fragment->checked = Traits::checked(input);
  }

  static bool Deserialize(::blink::mojom::internal::MenuItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MenuItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void MenuItemDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MenuItemDataView::GetToolTipDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->tool_tip.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::MenuItem_Type> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::MenuItem_Type value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_POPUP_MENU_MOJOM_SHARED_H_